/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.workspace.BridgeInitializer;
import com.intellij.platform.backend.workspace.BuilderSnapshot;
import com.intellij.platform.backend.workspace.StorageReplacement;
import com.intellij.platform.backend.workspace.WorkspaceModelCache;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelPreUpdateHandler;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.backend.workspace.WorkspaceModelUnloadedStorageChangeListener;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.diagnostic.telemetry.helpers.Milliseconds;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityStorageKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.impl.ConsistencyCheckerKt;
import com.intellij.platform.workspace.storage.impl.VersionedEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.query.Diff;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.query.CollectionQuery;
import com.intellij.platform.workspace.storage.query.StorageQuery;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexImpl;
import com.intellij.workspaceModel.ide.impl.EntityTracingLogger;
import com.intellij.workspaceModel.ide.impl.IdeVirtualFileUrlManagerImpl;
import com.intellij.workspaceModel.ide.impl.WorkspaceMetricsKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelImplKt;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelInitialTestContent;
import com.intellij.workspaceModel.ide.impl.WorkspaceModelMessageDeliveryListener;
import com.intellij.workspaceModel.ide.impl.reactive.WmReactive;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 l2\u00020\u0001:\u0001lB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u00106\u001a\u00020\tH\u0016J\u0018\u00107\u001a\u0002082\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u000209H\u0017J\u0006\u0010:\u001a\u000208J'\u0010;\u001a\u0002082\u000b\u0010<\u001a\u000701\u00a2\u0006\u0002\b=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002080?J*\u0010@\u001a\u0002082\u0006\u0010<\u001a\u0002012\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002080?H\u0096@\u00a2\u0006\u0002\u0010AJ)\u0010B\u001a\u0002082\u000b\u0010<\u001a\u000701\u00a2\u0006\u0002\b=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002080?H\u0007J\b\u0010C\u001a\u000208H\u0002J)\u0010H\u001a\u0002082\u000b\u0010<\u001a\u000701\u00a2\u0006\u0002\b=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002080?H\u0016J\u0006\u0010I\u001a\u00020JJ\u0006\u0010K\u001a\u00020JJ\u001b\u0010L\u001a\u00020\u000f2\u000b\u0010<\u001a\u000701\u00a2\u0006\u0002\b=2\u0006\u0010M\u001a\u00020NJ\u0016\u0010O\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020N2\u0006\u0010Q\u001a\u00020NJ(\u0010R\u001a\b\u0012\u0004\u0012\u0002HS0E\"\u0004\b\u0000\u0010S2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HS0UH\u0096@\u00a2\u0006\u0002\u0010VJ(\u0010W\u001a\b\u0012\u0004\u0012\u0002HS0E\"\u0004\b\u0000\u0010S2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HS0XH\u0096@\u00a2\u0006\u0002\u0010YJ.\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HS0[0E\"\u0004\b\u0000\u0010S2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HS0XH\u0096@\u00a2\u0006\u0002\u0010YJ2\u0010\\\u001a\u0002082 \u0010]\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030_\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030a0`0^2\u0006\u0010b\u001a\u000209H\u0002J\u0010\u0010c\u001a\u0002082\u0006\u0010]\u001a\u00020\u001eH\u0002J\u0010\u0010d\u001a\u0002082\u0006\u0010]\u001a\u00020\u001eH\u0002J\u0010\u0010e\u001a\u0002082\u0006\u0010]\u001a\u00020\u001eH\u0002J\u0018\u0010f\u001a\u0002082\u0006\u0010g\u001a\u00020h2\u0006\u0010b\u001a\u000209H\u0002J\u0016\u0010i\u001a\u0002082\f\u0010j\u001a\b\u0012\u0004\u0012\u0002080kH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010-\u001a\u00020\u000f@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0012\"\u0004\b/\u0010\u0014R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010(R\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001e0EX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010G\u00a8\u0006m"}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl;", "Lcom/intellij/platform/backend/workspace/impl/WorkspaceModelInternal;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;)V", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "coroutineScope", "value", "", "loadedFromCache", "getLoadedFromCache", "()Z", "setLoadedFromCache", "(Z)V", "reactive", "Lcom/intellij/workspaceModel/ide/impl/reactive/WmReactive;", "entityStorage", "Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl;", "getEntityStorage", "()Lcom/intellij/platform/workspace/storage/impl/VersionedEntityStorageImpl;", "unloadedEntitiesStorage", "updatesFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "virtualFileManager", "getVirtualFileManager", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "currentSnapshot", "getCurrentSnapshot", "()Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "entityTracer", "Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "getEntityTracer", "()Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "userWarningLoggingLevel", "getUserWarningLoggingLevel", "setUserWarningLoggingLevel", "updateModelMethodName", "", "updateModelSilentMethodName", "onChangedMethodName", "currentSnapshotOfUnloadedEntities", "getCurrentSnapshotOfUnloadedEntities", "getVirtualFileUrlManager", "prepareModel", "", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "ignoreCache", "updateProjectModel", "description", "Lorg/jetbrains/annotations/NonNls;", "updater", "Lkotlin/Function1;", "update", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateProjectModelSilent", "checkRecursiveUpdate", "eventLog", "Lkotlinx/coroutines/flow/Flow;", "getEventLog", "()Lkotlinx/coroutines/flow/Flow;", "updateUnloadedEntities", "getBuilderSnapshot", "Lcom/intellij/platform/backend/workspace/BuilderSnapshot;", "getUnloadBuilderSnapshot", "replaceWorkspaceModel", "replacement", "Lcom/intellij/platform/backend/workspace/StorageReplacement;", "replaceProjectModel", "mainStorageReplacement", "unloadStorageReplacement", "flowOfQuery", "T", "query", "Lcom/intellij/platform/workspace/storage/query/StorageQuery;", "(Lcom/intellij/platform/workspace/storage/query/StorageQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flowOfNewElements", "Lcom/intellij/platform/workspace/storage/query/CollectionQuery;", "(Lcom/intellij/platform/workspace/storage/query/CollectionQuery;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "flowOfDiff", "Lcom/intellij/platform/workspace/storage/impl/query/Diff;", "initializeBridges", "change", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "builder", "onBeforeChanged", "onChanged", "onUnloadedEntitiesChanged", "startPreUpdateHandlers", "before", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "logErrorOnEventHandling", "action", "Lkotlin/Function0;", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWorkspaceModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceModelImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,620:1\n60#2,5:621\n60#2,5:648\n60#2,5:653\n60#2,5:667\n13#2:715\n1#3:626\n29#4,3:627\n29#4,2:630\n29#4,3:632\n29#4,3:635\n29#4,3:638\n29#4,3:641\n29#4,3:644\n31#4:647\n29#4,2:658\n29#4,3:660\n29#4,3:663\n31#4:666\n29#4,3:674\n29#4,3:678\n29#4,3:683\n29#4,3:689\n29#4,3:695\n29#4,3:701\n29#4,3:707\n44#5,2:672\n46#5:677\n44#5,2:681\n46#5:686\n44#5,2:687\n46#5:692\n44#5,2:693\n46#5:698\n44#5,2:699\n46#5:704\n44#5,2:705\n46#5:710\n1869#6,2:711\n58#7:713\n58#7:714\n*S KotlinDebug\n*F\n+ 1 WorkspaceModelImpl.kt\ncom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl\n*L\n107#1:621,5\n227#1:648,5\n230#1:653,5\n290#1:667,5\n519#1:715\n126#1:627,3\n183#1:630,2\n186#1:632,3\n189#1:635,3\n194#1:638,3\n198#1:641,3\n203#1:644,3\n183#1:647\n259#1:658,2\n262#1:660,3\n270#1:663,3\n259#1:666\n297#1:674,3\n357#1:678,3\n386#1:683,3\n403#1:689,3\n424#1:695,3\n442#1:701,3\n461#1:707,3\n297#1:672,2\n297#1:677\n386#1:681,2\n386#1:686\n403#1:687,2\n403#1:692\n424#1:693,2\n424#1:698\n442#1:699,2\n442#1:704\n461#1:705,2\n461#1:710\n485#1:711,2\n454#1:713\n471#1:714\n*E\n"})
public class WorkspaceModelImpl
implements WorkspaceModelInternal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean loadedFromCache;
    @NotNull
    private final WmReactive reactive;
    @NotNull
    private final VersionedEntityStorageImpl entityStorage;
    @NotNull
    private final VersionedEntityStorageImpl unloadedEntitiesStorage;
    @NotNull
    private final MutableSharedFlow<VersionedStorageChange> updatesFlow;
    @NotNull
    private final ModificationTracker modificationTracker;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private final EntityTracingLogger entityTracer;
    private boolean userWarningLoggingLevel;
    @NotNull
    private final String updateModelMethodName;
    @NotNull
    private final String updateModelSilentMethodName;
    @NotNull
    private final String onChangedMethodName;
    @NotNull
    private final Flow<VersionedStorageChange> eventLog;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final ExtensionPointName<WorkspaceModelPreUpdateHandler> PRE_UPDATE_HANDLERS;
    private static final int PRE_UPDATE_LOOP_BLOCK = 100;
    @NotNull
    private static final AtomicLong loadingTotalTimeMs;
    @NotNull
    private static final AtomicLong loadingFromCacheTimeMs;
    @NotNull
    private static final AtomicLong updatesCounter;
    @NotNull
    private static final AtomicLong updateTimePreciseMs;
    @NotNull
    private static final AtomicLong preHandlersTimeMs;
    @NotNull
    private static final AtomicLong collectChangesTimeMs;
    @NotNull
    private static final AtomicLong initializingTimeMs;
    @NotNull
    private static final AtomicLong toSnapshotTimeMs;
    @NotNull
    private static final AtomicLong totalUpdatesTimeMs;
    @NotNull
    private static final AtomicLong checkRecursiveUpdateTimeMs;
    @NotNull
    private static final AtomicLong updateUnloadedEntitiesTimeMs;
    @NotNull
    private static final AtomicLong replaceProjectModelTimeMs;
    @NotNull
    private static final AtomicLong fullReplaceProjectModelTimeMs;
    @NotNull
    private static final AtomicLong initializeBridgesTimeMs;
    @NotNull
    private static final AtomicLong onBeforeChangedTimeMs;
    @NotNull
    private static final AtomicLong onChangedTimeMs;

    public final boolean getLoadedFromCache() {
        return this.loadedFromCache;
    }

    protected final void setLoadedFromCache(boolean bl) {
        this.loadedFromCache = bl;
    }

    @NotNull
    public final VersionedEntityStorageImpl getEntityStorage() {
        return this.entityStorage;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    @NotNull
    public final VirtualFileUrlManager getVirtualFileManager() {
        return this.virtualFileManager;
    }

    @NotNull
    public ImmutableEntityStorage getCurrentSnapshot() {
        return this.entityStorage.getCurrent();
    }

    @NotNull
    public final EntityTracingLogger getEntityTracer() {
        return this.entityTracer;
    }

    public final boolean getUserWarningLoggingLevel() {
        return this.userWarningLoggingLevel;
    }

    @TestOnly
    public final void setUserWarningLoggingLevel(boolean bl) {
        this.userWarningLoggingLevel = bl;
    }

    public WorkspaceModelImpl(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull ImmutableEntityStorage storage, @NotNull VirtualFileUrlManager virtualFileUrlManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        this.reactive = new WmReactive(this);
        this.updatesFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.modificationTracker = () -> WorkspaceModelImpl.modificationTracker$lambda$0(this);
        this.entityTracer = new EntityTracingLogger();
        this.updateModelMethodName = "updateProjectModel";
        this.updateModelSilentMethodName = "updateProjectModelSilent";
        this.onChangedMethodName = "onChanged";
        this.eventLog = (Flow)FlowKt.asSharedFlow(this.updatesFlow);
        this.project = project;
        this.coroutineScope = cs;
        this.virtualFileManager = virtualFileUrlManager;
        this.entityStorage = new VersionedEntityStorageImpl(storage);
        this.unloadedEntitiesStorage = new VersionedEntityStorageImpl(ImmutableEntityStorage.Companion.empty());
        this.loadedFromCache = true;
    }

    public WorkspaceModelImpl(@NotNull Project project, @NotNull CoroutineScope cs) {
        Pair pair;
        WorkspaceModelCache workspaceModelCache;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.reactive = new WmReactive(this);
        this.updatesFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.modificationTracker = () -> WorkspaceModelImpl.modificationTracker$lambda$0(this);
        this.entityTracer = new EntityTracingLogger();
        this.updateModelMethodName = "updateProjectModel";
        this.updateModelSilentMethodName = "updateProjectModelSilent";
        this.onChangedMethodName = "onChanged";
        this.eventLog = (Flow)FlowKt.asSharedFlow(this.updatesFlow);
        this.project = project;
        this.coroutineScope = cs;
        this.virtualFileManager = (VirtualFileUrlManager)new IdeVirtualFileUrlManagerImpl(WorkspaceModelImplKt.access$isProjectCaseSensitive(project));
        Logger $this$debug_u24default$iv = log;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Loading workspace model", e$iv);
        }
        long start2 = Milliseconds.Companion.now-30wF-Ic();
        if (Registry.Companion.is("ide.workspace.model.assertions.on.long.listeners", true)) {
            MessageBus messageBus = project.getMessageBus();
            Intrinsics.checkNotNull((Object)messageBus, (String)"null cannot be cast to non-null type com.intellij.util.messages.impl.MessageBusImpl");
            ((MessageBusImpl)messageBus).addMessageDeliveryListener((MessageDeliveryListener)WorkspaceModelMessageDeliveryListener.INSTANCE);
        }
        ImmutableEntityStorage initialContent = WorkspaceModelInitialTestContent.INSTANCE.pop$intellij_platform_projectModel_impl();
        WorkspaceModelCache workspaceModelCache2 = WorkspaceModelCache.Companion.getInstance(project);
        if (workspaceModelCache2 != null) {
            WorkspaceModelCache workspaceModelCache3;
            WorkspaceModelCache $this$_init__u24lambda_u241 = workspaceModelCache3 = workspaceModelCache2;
            boolean bl = false;
            $this$_init__u24lambda_u241.setVirtualFileUrlManager(this.virtualFileManager);
            workspaceModelCache = workspaceModelCache3;
        } else {
            workspaceModelCache = null;
        }
        WorkspaceModelCache cache = workspaceModelCache;
        if (initialContent != null) {
            this.loadedFromCache = initialContent != ImmutableEntityStorage.Companion.empty();
            pair = TuplesKt.to((Object)EntityStorageKt.toBuilder((ImmutableEntityStorage)initialContent), (Object)ImmutableEntityStorage.Companion.empty());
        } else if (cache != null) {
            MutableEntityStorage mutableEntityStorage;
            Activity activity = StartUpMeasurer.startActivity((String)"cache loading");
            Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"startActivity(...)");
            Activity activity2 = activity;
            long cacheLoadingStart = Milliseconds.Companion.now-30wF-Ic();
            MutableEntityStorage previousStorage = null;
            MutableEntityStorage previousStorageForUnloaded = null;
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            previousStorage = cache.loadCache();
            MutableEntityStorage mutableEntityStorage2 = cache.loadUnloadedEntitiesCache();
            if (mutableEntityStorage2 == null || (mutableEntityStorage2 = mutableEntityStorage2.toSnapshot()) == null) {
                mutableEntityStorage2 = ImmutableEntityStorage.Companion.empty();
            }
            previousStorageForUnloaded = mutableEntityStorage2;
            long loadingCacheTime = System.currentTimeMillis() - start$iv;
            if (previousStorage == null) {
                mutableEntityStorage = MutableEntityStorage.Companion.create();
            } else {
                log.info("Load workspace model from cache in " + loadingCacheTime + " ms");
                this.loadedFromCache = true;
                this.entityTracer.printInfoAboutTracedEntity((EntityStorage)previousStorage, "cache");
                mutableEntityStorage = previousStorage;
            }
            MutableEntityStorage storage = mutableEntityStorage;
            MillisecondsMeasurer.addElapsedTime-w65uvNE((AtomicLong)loadingFromCacheTimeMs, (long)cacheLoadingStart);
            activity2.end();
            pair = TuplesKt.to((Object)storage, (Object)previousStorageForUnloaded);
        } else {
            pair = TuplesKt.to((Object)MutableEntityStorage.Companion.create(), (Object)ImmutableEntityStorage.Companion.empty());
        }
        Pair pair2 = pair;
        MutableEntityStorage projectEntities = (MutableEntityStorage)pair2.component1();
        ImmutableEntityStorage unloadedEntities = (ImmutableEntityStorage)pair2.component2();
        this.prepareModel(project, projectEntities);
        this.entityStorage = new VersionedEntityStorageImpl(projectEntities.toSnapshot());
        this.unloadedEntitiesStorage = new VersionedEntityStorageImpl(unloadedEntities);
        this.entityTracer.subscribe(project, cs);
        MillisecondsMeasurer.addElapsedTime-w65uvNE((AtomicLong)loadingTotalTimeMs, (long)start2);
    }

    @NotNull
    public ImmutableEntityStorage getCurrentSnapshotOfUnloadedEntities() {
        return this.unloadedEntitiesStorage.getCurrent();
    }

    @NotNull
    public VirtualFileUrlManager getVirtualFileUrlManager() {
        return this.virtualFileManager;
    }

    @ApiStatus.Internal
    public void prepareModel(@NotNull Project project, @NotNull MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
    }

    public final void ignoreCache() {
        this.loadedFromCache = false;
    }

    public final synchronized void updateProjectModel(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        ThreadingAssertions.assertWriteAccess();
        this.checkRecursiveUpdate();
        Ref.LongRef updateTimeMillis = new Ref.LongRef();
        Ref.LongRef preHandlersTimeMillis = new Ref.LongRef();
        Ref.LongRef collectChangesTimeMillis = new Ref.LongRef();
        Ref.LongRef initializingTimeMillis = new Ref.LongRef();
        Ref.LongRef toSnapshotTimeMillis = new Ref.LongRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ImmutableEntityStorage before = this.entityStorage.getCurrent();
        MutableEntityStorage builder = MutableEntityStorage.Companion.from(before);
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        Ref.LongRef longRef = updateTimeMillis;
        boolean bl2 = false;
        updater.invoke((Object)builder);
        longRef.element = System.currentTimeMillis() - start$iv2;
        $i$f$measureTimeMillis2 = false;
        start$iv2 = System.currentTimeMillis();
        longRef = preHandlersTimeMillis;
        boolean bl3 = false;
        this.startPreUpdateHandlers((EntityStorage)before, builder);
        longRef.element = System.currentTimeMillis() - start$iv2;
        Map changes = null;
        boolean $i$f$measureTimeMillis3 = false;
        long start$iv3 = System.currentTimeMillis();
        longRef = collectChangesTimeMillis;
        boolean bl4 = false;
        Intrinsics.checkNotNull((Object)builder, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        changes = ((MutableEntityStorageInstrumentation)builder).collectChanges();
        longRef.element = System.currentTimeMillis() - start$iv3;
        Set symbolicEntityIdsChanges = ((MutableEntityStorageInstrumentation)builder).collectSymbolicEntityIdsChanges();
        boolean $i$f$measureTimeMillis4 = false;
        long start$iv4 = System.currentTimeMillis();
        longRef = initializingTimeMillis;
        boolean bl5 = false;
        this.initializeBridges(changes, builder);
        longRef.element = System.currentTimeMillis() - start$iv4;
        ImmutableEntityStorage newStorage = null;
        boolean $i$f$measureTimeMillis5 = false;
        long start$iv5 = System.currentTimeMillis();
        longRef = toSnapshotTimeMillis;
        boolean bl6 = false;
        newStorage = builder.toSnapshot();
        longRef.element = System.currentTimeMillis() - start$iv5;
        if (Registry.Companion.is("ide.workspace.model.assertions.on.update", false)) {
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)before));
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)newStorage));
        }
        this.entityStorage.replace(newStorage, changes, symbolicEntityIdsChanges, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        long $this$updateProjectModel_u24lambda_u241 = $i$f$measureTimeMillis = System.currentTimeMillis() - start$iv;
        boolean bl7 = false;
        updateTimePreciseMs.addAndGet(updateTimeMillis.element);
        preHandlersTimeMs.addAndGet(preHandlersTimeMillis.element);
        collectChangesTimeMs.addAndGet(collectChangesTimeMillis.element);
        initializingTimeMs.addAndGet(initializingTimeMillis.element);
        toSnapshotTimeMs.addAndGet(toSnapshotTimeMillis.element);
        totalUpdatesTimeMs.addAndGet($this$updateProjectModel_u24lambda_u241);
        updatesCounter.incrementAndGet();
        long generalTime2 = $i$f$measureTimeMillis;
        log.info("Project model updated to version " + this.entityStorage.getPointer().getVersion() + " in " + generalTime2 + " ms: " + description);
        if (generalTime2 > 1000L) {
            log.info("Project model update details: Updater code: " + updateTimeMillis.element + " ms, Pre handlers: " + preHandlersTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms");
            log.info("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms");
        } else {
            Logger logger;
            Logger $this$debug_u24default$iv = log;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl8 = false;
                logger.debug("Project model update details: Updater code: " + updateTimeMillis.element + " ms, Pre handlers: " + preHandlersTimeMillis.element + " ms, Collect changes: " + collectChangesTimeMillis.element + " ms", e$iv);
            }
            $this$debug_u24default$iv = log;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl9 = false;
                logger.debug("Bridge initialization: " + initializingTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " ms", e$iv);
            }
        }
    }

    @Nullable
    public Object update(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater, @NotNull Continuation<? super Unit> $completion) {
        return WorkspaceModelImpl.update$suspendImpl(this, description, updater, $completion);
    }

    static /* synthetic */ Object update$suspendImpl(WorkspaceModelImpl $this, String description, Function1<? super MutableEntityStorage, Unit> updater, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.edtWriteAction(() -> WorkspaceModelImpl.update$lambda$0($this, description, updater), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @ApiStatus.Obsolete
    public final synchronized void updateProjectModelSilent(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        this.checkRecursiveUpdate();
        ImmutableEntityStorage newStorage = null;
        Ref.LongRef updateTimeMillis = new Ref.LongRef();
        Ref.LongRef toSnapshotTimeMillis = new Ref.LongRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ImmutableEntityStorage before = this.entityStorage.getCurrent();
        MutableEntityStorage mutableEntityStorage = MutableEntityStorage.Companion.from(this.entityStorage.getCurrent());
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        MutableEntityStorageInstrumentation builder = (MutableEntityStorageInstrumentation)mutableEntityStorage;
        boolean $i$f$measureTimeMillis2 = false;
        long start$iv2 = System.currentTimeMillis();
        Ref.LongRef longRef = updateTimeMillis;
        boolean bl2 = false;
        updater.invoke((Object)builder);
        longRef.element = System.currentTimeMillis() - start$iv2;
        Map changes = builder.collectChanges();
        boolean $i$f$measureTimeMillis3 = false;
        long start$iv3 = System.currentTimeMillis();
        longRef = toSnapshotTimeMillis;
        boolean bl3 = false;
        newStorage = builder.toSnapshot();
        longRef.element = System.currentTimeMillis() - start$iv3;
        if (Registry.Companion.is("ide.workspace.model.assertions.on.update", false)) {
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)before));
            ConsistencyCheckerKt.assertConsistency((EntityStorage)((EntityStorage)newStorage));
        }
        this.entityStorage.replace(newStorage, changes, builder.collectSymbolicEntityIdsChanges(), WorkspaceModelImpl::updateProjectModelSilent$lambda$0$2, WorkspaceModelImpl::updateProjectModelSilent$lambda$0$3);
        long $this$updateProjectModelSilent_u24lambda_u241 = $i$f$measureTimeMillis = System.currentTimeMillis() - start$iv;
        boolean bl4 = false;
        updateTimePreciseMs.addAndGet(updateTimeMillis.element);
        toSnapshotTimeMs.addAndGet(toSnapshotTimeMillis.element);
        totalUpdatesTimeMs.addAndGet($this$updateProjectModelSilent_u24lambda_u241);
        updatesCounter.incrementAndGet();
        long generalTime2 = $i$f$measureTimeMillis;
        log.debug("Project model updated silently to version " + this.entityStorage.getPointer().getVersion() + " in " + generalTime2 + " ms: " + description);
        if (generalTime2 > 1000L) {
            log.info("Project model update details: Updater code: " + updateTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " m");
        } else {
            Logger $this$debug_u24default$iv = log;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl5 = false;
                logger.debug("Project model update details: Updater code: " + updateTimeMillis.element + " ms, To snapshot: " + toSnapshotTimeMillis.element + " m", e$iv);
            }
        }
    }

    private final void checkRecursiveUpdate() {
        AtomicLong atomicLong = checkRecursiveUpdateTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator stackStraceIterator = ArrayIteratorKt.iterator((Object[])new RuntimeException().getStackTrace());
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl4 = false;
            stackStraceIterator.next();
        }
        while (stackStraceIterator.hasNext()) {
            StackTraceElement frame = (StackTraceElement)stackStraceIterator.next();
            if ((Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.updateModelMethodName) || Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.updateModelSilentMethodName)) && Intrinsics.areEqual((Object)frame.getClassName(), (Object)Reflection.getOrCreateKotlinClass(WorkspaceModelImpl.class).getQualifiedName())) {
                log.error("Trying to update project model twice from the same version. Maybe recursive call of 'updateProjectModel'?");
                continue;
            }
            if (!Intrinsics.areEqual((Object)frame.getMethodName(), (Object)this.onChangedMethodName) || !Intrinsics.areEqual((Object)frame.getClassName(), (Object)Reflection.getOrCreateKotlinClass(WorkspaceModelImpl.class).getQualifiedName())) continue;
            break;
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @NotNull
    public Flow<VersionedStorageChange> getEventLog() {
        return this.eventLog;
    }

    public void updateUnloadedEntities(@NotNull String description, @NotNull Function1<? super MutableEntityStorage, Unit> updater) {
        long l;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        ThreadingAssertions.assertWriteAccess();
        if (this.project.isDisposed()) {
            return;
        }
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ImmutableEntityStorage before = this.getCurrentSnapshotOfUnloadedEntities();
        MutableEntityStorage mutableEntityStorage = MutableEntityStorage.Companion.from(before);
        Intrinsics.checkNotNull((Object)mutableEntityStorage, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation");
        MutableEntityStorageInstrumentation builder = (MutableEntityStorageInstrumentation)mutableEntityStorage;
        updater.invoke((Object)builder);
        this.startPreUpdateHandlers((EntityStorage)before, (MutableEntityStorage)builder);
        Map changes = builder.collectChanges();
        ImmutableEntityStorage newStorage = builder.toSnapshot();
        this.unloadedEntitiesStorage.replace(newStorage, changes, builder.collectSymbolicEntityIdsChanges(), WorkspaceModelImpl::updateUnloadedEntities$lambda$0$0, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onUnloadedEntitiesChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        long $this$updateUnloadedEntities_u24lambda_u241 = l = System.currentTimeMillis() - start$iv;
        boolean bl2 = false;
        updateUnloadedEntitiesTimeMs.addAndGet($this$updateUnloadedEntities_u24lambda_u241);
        long time2 = l;
        log.info("Unloaded entity storage updated in " + time2 + " ms: " + description);
    }

    @NotNull
    public final BuilderSnapshot getBuilderSnapshot() {
        VersionedEntityStorageImpl.Current current = this.entityStorage.getPointer();
        return new BuilderSnapshot(current.getVersion(), current.getStorage());
    }

    @NotNull
    public final BuilderSnapshot getUnloadBuilderSnapshot() {
        VersionedEntityStorageImpl.Current current = this.unloadedEntitiesStorage.getPointer();
        return new BuilderSnapshot(current.getVersion(), current.getStorage());
    }

    public final synchronized boolean replaceWorkspaceModel(@NotNull String description, @NotNull StorageReplacement replacement) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        ThreadingAssertions.assertWriteAccess();
        if (this.entityStorage.getVersion() != replacement.getVersion()) {
            return false;
        }
        AtomicLong atomicLong = replaceProjectModelTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        MutableEntityStorage builder = replacement.getBuilder();
        this.initializeBridges(replacement.getChanges(), builder);
        this.entityStorage.replace(builder.toSnapshot(), replacement.getChanges(), replacement.getSymbolicEntityIdChanges(), (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        log.info("Project model updated to version " + this.entityStorage.getPointer().getVersion() + ": " + description);
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return true;
    }

    public final synchronized boolean replaceProjectModel(@NotNull StorageReplacement mainStorageReplacement, @NotNull StorageReplacement unloadStorageReplacement) {
        Intrinsics.checkNotNullParameter((Object)mainStorageReplacement, (String)"mainStorageReplacement");
        Intrinsics.checkNotNullParameter((Object)unloadStorageReplacement, (String)"unloadStorageReplacement");
        ThreadingAssertions.assertWriteAccess();
        if (this.entityStorage.getVersion() != mainStorageReplacement.getVersion() || this.unloadedEntitiesStorage.getVersion() != unloadStorageReplacement.getVersion()) {
            return false;
        }
        AtomicLong atomicLong = fullReplaceProjectModelTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        MutableEntityStorage builder = mainStorageReplacement.getBuilder();
        this.initializeBridges(mainStorageReplacement.getChanges(), builder);
        this.entityStorage.replace(builder.toSnapshot(), mainStorageReplacement.getChanges(), mainStorageReplacement.getSymbolicEntityIdChanges(), (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onBeforeChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        }, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        MutableEntityStorage unloadBuilder = unloadStorageReplacement.getBuilder();
        this.unloadedEntitiesStorage.replace(unloadBuilder.toSnapshot(), unloadStorageReplacement.getChanges(), unloadStorageReplacement.getSymbolicEntityIdChanges(), WorkspaceModelImpl::replaceProjectModel$lambda$0$0, (Function1)new Function1<VersionedStorageChange, Unit>((Object)this){

            public final void invoke(VersionedStorageChange p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                WorkspaceModelImpl.access$onUnloadedEntitiesChanged((WorkspaceModelImpl)this.receiver, p0);
            }
        });
        log.info("Project model updated to version " + this.entityStorage.getPointer().getVersion());
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return true;
    }

    @Nullable
    public <T> Object flowOfQuery(@NotNull StorageQuery<T> query, @NotNull Continuation<? super Flow<? extends T>> $completion) {
        return this.reactive.flowOfQuery(query, $completion);
    }

    @Nullable
    public <T> Object flowOfNewElements(@NotNull CollectionQuery<T> query, @NotNull Continuation<? super Flow<? extends T>> $completion) {
        return this.reactive.flowOfNewElements(query, $completion);
    }

    @Nullable
    public <T> Object flowOfDiff(@NotNull CollectionQuery<T> query, @NotNull Continuation<? super Flow<? extends Diff<T>>> $completion) {
        return this.reactive.flowOfDiff(query, $completion);
    }

    private final void initializeBridges(Map<Class<?>, ? extends List<? extends EntityChange<?>>> change, MutableEntityStorage builder) {
        if (this.project.isDisposed()) {
            return;
        }
        AtomicLong atomicLong = initializeBridgesTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        for (BridgeInitializer bridgeInitializer : WorkspaceModelImplKt.access$getEP_NAME$p().getExtensionList()) {
            this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.initializeBridges$lambda$0$0(bridgeInitializer, this, change, builder)));
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final void onBeforeChanged(VersionedStorageChange change) {
        ThreadingAssertions.assertWriteAccess();
        if (this.project.isDisposed()) {
            return;
        }
        AtomicLong atomicLong = onBeforeChangedTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.onBeforeChanged$lambda$0$0(this, change)));
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final void onChanged(VersionedStorageChange change) {
        ThreadingAssertions.assertWriteAccess();
        if (this.project.isDisposed()) {
            return;
        }
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.onChanged$lambda$0(this, change)));
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, change, null){
            int label;
            final /* synthetic */ WorkspaceModelImpl this$0;
            final /* synthetic */ VersionedStorageChange $change;
            {
                this.this$0 = $receiver;
                this.$change = $change;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = WorkspaceModelImpl.access$getUpdatesFlow$p(this.this$0).emit((Object)this.$change, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        AtomicLong atomicLong = onChangedTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.onChanged$lambda$1$0(this, change)));
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final void onUnloadedEntitiesChanged(VersionedStorageChange change) {
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.onUnloadedEntitiesChanged$lambda$0(this, change)));
        this.logErrorOnEventHandling((Function0<Unit>)((Function0)() -> WorkspaceModelImpl.onUnloadedEntitiesChanged$lambda$1(this, change)));
    }

    private final void startPreUpdateHandlers(EntityStorage before, MutableEntityStorage builder) {
        boolean startUpdateLoop = false;
        startUpdateLoop = true;
        int updatesStarted = 0;
        while (startUpdateLoop && updatesStarted < 100) {
            ++updatesStarted;
            startUpdateLoop = false;
            Iterable $this$forEach$iv = PRE_UPDATE_HANDLERS.getExtensionsIfPointIsRegistered();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorkspaceModelPreUpdateHandler it = (WorkspaceModelPreUpdateHandler)element$iv;
                boolean bl = false;
                startUpdateLoop |= it.update(before, builder);
            }
        }
        if (updatesStarted >= 100) {
            log.error("Loop workspace model updating");
        }
    }

    private final void logErrorOnEventHandling(Function0<Unit> action) {
        try {
            action.invoke();
        }
        catch (Throwable e) {
            if (e instanceof AlreadyDisposedException) {
                throw e;
            }
            if (e instanceof ControlFlowException) {
                throw e;
            }
            String message = "Exception at Workspace Model event handling";
            if (this.userWarningLoggingLevel) {
                log.warn(message, e);
            }
            log.error(message, e);
        }
    }

    private static final long modificationTracker$lambda$0(WorkspaceModelImpl this$0) {
        return this$0.entityStorage.getVersion();
    }

    private static final Unit update$lambda$0(WorkspaceModelImpl this$0, String $description, Function1 $updater) {
        this$0.updateProjectModel($description, (Function1<? super MutableEntityStorage, Unit>)$updater);
        return Unit.INSTANCE;
    }

    private static final Unit updateProjectModelSilent$lambda$0$2(VersionedStorageChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit updateProjectModelSilent$lambda$0$3(VersionedStorageChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit updateUnloadedEntities$lambda$0$0(VersionedStorageChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit replaceProjectModel$lambda$0$0(VersionedStorageChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit initializeBridges$lambda$0$0(BridgeInitializer $bridgeInitializer, WorkspaceModelImpl this$0, Map $change, MutableEntityStorage $builder) {
        if ($bridgeInitializer.isEnabled()) {
            $bridgeInitializer.initializeBridges(this$0.project, $change, $builder);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onBeforeChanged$lambda$0$0(WorkspaceModelImpl this$0, VersionedStorageChange $change) {
        ((WorkspaceModelChangeListener)this$0.project.getMessageBus().syncPublisher(WorkspaceModelTopics.CHANGED)).beforeChanged($change);
        return Unit.INSTANCE;
    }

    private static final Unit onChanged$lambda$0(WorkspaceModelImpl this$0, VersionedStorageChange $change) {
        block0: {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this$0.project;
            boolean $i$f$serviceIfCreated = false;
            Object object = $this$serviceIfCreated$iv.getServiceIfCreated(WorkspaceFileIndex.class);
            Object object2 = object instanceof WorkspaceFileIndexImpl ? (WorkspaceFileIndexImpl)object : null;
            if (object2 == null || (object2 = ((WorkspaceFileIndexImpl)object2).getIndexData()) == null) break block0;
            object2.onEntitiesChanged($change, EntityStorageKind.MAIN);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onChanged$lambda$1$0(WorkspaceModelImpl this$0, VersionedStorageChange $change) {
        ((WorkspaceModelChangeListener)this$0.project.getMessageBus().syncPublisher(WorkspaceModelTopics.CHANGED)).changed($change);
        return Unit.INSTANCE;
    }

    private static final Unit onUnloadedEntitiesChanged$lambda$0(WorkspaceModelImpl this$0, VersionedStorageChange $change) {
        block0: {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)this$0.project;
            boolean $i$f$serviceIfCreated = false;
            Object object = $this$serviceIfCreated$iv.getServiceIfCreated(WorkspaceFileIndex.class);
            Object object2 = object instanceof WorkspaceFileIndexImpl ? (WorkspaceFileIndexImpl)object : null;
            if (object2 == null || (object2 = ((WorkspaceFileIndexImpl)object2).getIndexData()) == null) break block0;
            object2.onEntitiesChanged($change, EntityStorageKind.UNLOADED);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onUnloadedEntitiesChanged$lambda$1(WorkspaceModelImpl this$0, VersionedStorageChange $change) {
        ((WorkspaceModelUnloadedStorageChangeListener)this$0.project.getMessageBus().syncPublisher(WorkspaceModelTopics.UNLOADED_ENTITIES_CHANGED)).changed($change);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableSharedFlow access$getUpdatesFlow$p(WorkspaceModelImpl $this) {
        return $this.updatesFlow;
    }

    public static final /* synthetic */ void access$onBeforeChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onBeforeChanged(change);
    }

    public static final /* synthetic */ void access$onChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onChanged(change);
    }

    public static final /* synthetic */ void access$onUnloadedEntitiesChanged(WorkspaceModelImpl $this, VersionedStorageChange change) {
        $this.onUnloadedEntitiesChanged(change);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceModelImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        PRE_UPDATE_HANDLERS = new ExtensionPointName("com.intellij.workspaceModel.preUpdateHandler");
        loadingTotalTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        loadingFromCacheTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        updatesCounter = new AtomicLong();
        updateTimePreciseMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        preHandlersTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        collectChangesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        initializingTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        toSnapshotTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        totalUpdatesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        checkRecursiveUpdateTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        updateUnloadedEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        replaceProjectModelTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        fullReplaceProjectModelTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        initializeBridgesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        onBeforeChangedTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        onChangedTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);
        Meter meter = WorkspaceMetricsKt.getWorkspaceModelMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        WorkspaceModelImpl.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0014\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0016\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u0019\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u001b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u001c\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u001d\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\""}, d2={"Lcom/intellij/workspaceModel/ide/impl/WorkspaceModelImpl$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "PRE_UPDATE_HANDLERS", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelPreUpdateHandler;", "PRE_UPDATE_LOOP_BLOCK", "", "loadingTotalTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "loadingFromCacheTimeMs", "updatesCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "updateTimePreciseMs", "preHandlersTimeMs", "collectChangesTimeMs", "initializingTimeMs", "toSnapshotTimeMs", "totalUpdatesTimeMs", "checkRecursiveUpdateTimeMs", "updateUnloadedEntitiesTimeMs", "replaceProjectModelTimeMs", "fullReplaceProjectModelTimeMs", "initializeBridgesTimeMs", "onBeforeChangedTimeMs", "onChangedTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadingTotalCounter = meter.counterBuilder("workspaceModel.loading.total.ms").buildObserver();
            ObservableLongMeasurement loadingFromCacheCounter = meter.counterBuilder("workspaceModel.loading.from.cache.ms").buildObserver();
            ObservableLongMeasurement updatesTimesCounter = meter.counterBuilder("workspaceModel.updates.count").buildObserver();
            ObservableLongMeasurement updateTimePreciseCounter = meter.counterBuilder("workspaceModel.updates.precise.ms").buildObserver();
            ObservableLongMeasurement preHandlersTimeCounter = meter.counterBuilder("workspaceModel.pre.handlers.ms").buildObserver();
            ObservableLongMeasurement collectChangesTimeCounter = meter.counterBuilder("workspaceModel.collect.changes.ms").buildObserver();
            ObservableLongMeasurement initializingTimeCounter = meter.counterBuilder("workspaceModel.initializing.ms").buildObserver();
            ObservableLongMeasurement toSnapshotTimeCounter = meter.counterBuilder("workspaceModel.to.snapshot.ms").buildObserver();
            ObservableLongMeasurement totalUpdatesTimeCounter = meter.counterBuilder("workspaceModel.updates.ms").buildObserver();
            ObservableLongMeasurement checkRecursiveUpdateTimeCounter = meter.counterBuilder("workspaceModel.check.recursive.update.ms").buildObserver();
            ObservableLongMeasurement updateUnloadedEntitiesTimeCounter = meter.counterBuilder("workspaceModel.update.unloaded.entities.ms").buildObserver();
            ObservableLongMeasurement replaceProjectModelTimeCounter = meter.counterBuilder("workspaceModel.replace.project.model.ms").buildObserver();
            ObservableLongMeasurement fullReplaceProjectModelTimeCounter = meter.counterBuilder("workspaceModel.full.replace.project.model.ms").buildObserver();
            ObservableLongMeasurement initializeBridgesTimeCounter = meter.counterBuilder("workspaceModel.init.bridges.ms").buildObserver();
            ObservableLongMeasurement onBeforeChangedTimeCounter = meter.counterBuilder("workspaceModel.on.before.changed.ms").buildObserver();
            ObservableLongMeasurement onChangedTimeCounter = meter.counterBuilder("workspaceModel.on.changed.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{loadingFromCacheCounter, updatesTimesCounter, updateTimePreciseCounter, preHandlersTimeCounter, collectChangesTimeCounter, initializingTimeCounter, toSnapshotTimeCounter, totalUpdatesTimeCounter, checkRecursiveUpdateTimeCounter, updateUnloadedEntitiesTimeCounter, replaceProjectModelTimeCounter, fullReplaceProjectModelTimeCounter, initializeBridgesTimeCounter, onBeforeChangedTimeCounter, onChangedTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadingTotalCounter, loadingFromCacheCounter, updatesTimesCounter, updateTimePreciseCounter, preHandlersTimeCounter, collectChangesTimeCounter, initializingTimeCounter, toSnapshotTimeCounter, totalUpdatesTimeCounter, checkRecursiveUpdateTimeCounter, updateUnloadedEntitiesTimeCounter, replaceProjectModelTimeCounter, fullReplaceProjectModelTimeCounter, initializeBridgesTimeCounter, onBeforeChangedTimeCounter, onChangedTimeCounter), (ObservableMeasurement)loadingTotalCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadingTotalCounter, ObservableLongMeasurement $loadingFromCacheCounter, ObservableLongMeasurement $updatesTimesCounter, ObservableLongMeasurement $updateTimePreciseCounter, ObservableLongMeasurement $preHandlersTimeCounter, ObservableLongMeasurement $collectChangesTimeCounter, ObservableLongMeasurement $initializingTimeCounter, ObservableLongMeasurement $toSnapshotTimeCounter, ObservableLongMeasurement $totalUpdatesTimeCounter, ObservableLongMeasurement $checkRecursiveUpdateTimeCounter, ObservableLongMeasurement $updateUnloadedEntitiesTimeCounter, ObservableLongMeasurement $replaceProjectModelTimeCounter, ObservableLongMeasurement $fullReplaceProjectModelTimeCounter, ObservableLongMeasurement $initializeBridgesTimeCounter, ObservableLongMeasurement $onBeforeChangedTimeCounter, ObservableLongMeasurement $onChangedTimeCounter) {
            $loadingTotalCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadingTotalTimeMs));
            $loadingFromCacheCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadingFromCacheTimeMs));
            $updatesTimesCounter.record(updatesCounter.get());
            $updateTimePreciseCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)updateTimePreciseMs));
            $preHandlersTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)preHandlersTimeMs));
            $collectChangesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)collectChangesTimeMs));
            $initializingTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)initializingTimeMs));
            $toSnapshotTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)toSnapshotTimeMs));
            $totalUpdatesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)totalUpdatesTimeMs));
            $checkRecursiveUpdateTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)checkRecursiveUpdateTimeMs));
            $updateUnloadedEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)updateUnloadedEntitiesTimeMs));
            $replaceProjectModelTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)replaceProjectModelTimeMs));
            $fullReplaceProjectModelTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)fullReplaceProjectModelTimeMs));
            $initializeBridgesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)initializeBridgesTimeMs));
            $onBeforeChangedTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)onBeforeChangedTimeMs));
            $onChangedTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)onChangedTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

