/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public class PathMacroManager
implements PathMacroSubstitutor {
    private PathMacrosImpl pathMacros;
    private ReplacePathToMacroMap replacePathToMacroMap;
    private long pathMacrosModificationCount;

    @NotNull
    public static PathMacroManager getInstance(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            PathMacroManager.$$$reportNull$$$0(0);
        }
        if (componentManager instanceof Module) {
            Module module = (Module)componentManager;
            return new ModulePathMacroManager(module, PathMacros.getInstance());
        }
        PathMacroManager pathMacroManager = (PathMacroManager)componentManager.getService(PathMacroManager.class);
        if (pathMacroManager == null) {
            PathMacroManager.$$$reportNull$$$0(1);
        }
        return pathMacroManager;
    }

    @NotNull
    public static PathMacroManager getInstance(@NotNull Module module) {
        if (module == null) {
            PathMacroManager.$$$reportNull$$$0(2);
        }
        return new ModulePathMacroManager(module, PathMacros.getInstance());
    }

    public PathMacroManager(@Nullable PathMacros pathMacros) {
        this.pathMacros = (PathMacrosImpl)pathMacros;
    }

    @NotNull
    private static CompositePathMacroFilter createFilter() {
        CompositePathMacroFilter compositePathMacroFilter = (CompositePathMacroFilter)((Object)PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.computeIfAbsent(PathMacroManager.class, () -> new CompositePathMacroFilter(PathMacrosCollector.MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList())));
        if (compositePathMacroFilter == null) {
            PathMacroManager.$$$reportNull$$$0(3);
        }
        return compositePathMacroFilter;
    }

    @NotNull
    public PathMacroFilter getMacroFilter() {
        return PathMacroManager.createFilter();
    }

    @ApiStatus.Internal
    public static void addFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String macroName, @SystemIndependent @Nullable String path) {
        if (result == null) {
            PathMacroManager.$$$reportNull$$$0(4);
        }
        if (macroName == null) {
            PathMacroManager.$$$reportNull$$$0(5);
        }
        if (path != null) {
            PathMacroManager.doAddFileHierarchyReplacements(result, Strings.trimEnd((String)path, (String)"/"), "$" + macroName + "$");
        }
    }

    private static void doAddFileHierarchyReplacements(@NotNull ExpandMacroToPathMap result, @NotNull String path, @NotNull String macro) {
        String parentPath;
        if (result == null) {
            PathMacroManager.$$$reportNull$$$0(6);
        }
        if (path == null) {
            PathMacroManager.$$$reportNull$$$0(7);
        }
        if (macro == null) {
            PathMacroManager.$$$reportNull$$$0(8);
        }
        if (!(parentPath = PathUtilRt.getParentPath((String)path)).isEmpty()) {
            PathMacroManager.doAddFileHierarchyReplacements(result, parentPath, macro + "/..");
        }
        result.put(macro, path);
    }

    @ApiStatus.Internal
    protected static void addFileHierarchyReplacements(ReplacePathToMacroMap result, String macroName, @Nullable String path, @Nullable String stopAt) {
        if (path == null) {
            return;
        }
        String macro = "$" + macroName + "$";
        path = Strings.trimEnd((String)FileUtilRt.toSystemIndependentName((String)path), (String)"/");
        boolean overwrite = true;
        while (Strings.isNotEmpty((String)path) && path.contains("/") && !"/".equals(path)) {
            result.addReplacement(path, macro, overwrite);
            if (path.equals(stopAt)) break;
            macro = macro + "/..";
            path = OSAgnosticPathUtil.getParent((String)path);
            overwrite = false;
        }
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = new ExpandMacroToPathMap();
        this.getPathMacros().addMacroExpands(result);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
        }
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            PathMacroManager.$$$reportNull$$$0(9);
        }
        return expandMacroToPathMap;
    }

    @NotNull
    public final synchronized ReplacePathToMacroMap getReplacePathMap() {
        long pathMacrosModificationCount = this.getPathMacros().getModificationCount();
        if (this.replacePathToMacroMap != null && pathMacrosModificationCount == this.pathMacrosModificationCount) {
            ReplacePathToMacroMap replacePathToMacroMap = this.replacePathToMacroMap;
            if (replacePathToMacroMap == null) {
                PathMacroManager.$$$reportNull$$$0(10);
            }
            return replacePathToMacroMap;
        }
        this.replacePathToMacroMap = this.computeReplacePathMap();
        this.pathMacrosModificationCount = pathMacrosModificationCount;
        ReplacePathToMacroMap replacePathToMacroMap = this.replacePathToMacroMap;
        if (replacePathToMacroMap == null) {
            PathMacroManager.$$$reportNull$$$0(11);
        }
        return replacePathToMacroMap;
    }

    @NotNull
    protected ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result = new ReplacePathToMacroMap();
        this.getPathMacros().addMacroReplacements(result);
        for (Map.Entry entry : PathMacroUtil.getGlobalSystemMacros().entrySet()) {
            result.addMacroReplacement((String)entry.getValue(), (String)entry.getKey());
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            PathMacroManager.$$$reportNull$$$0(12);
        }
        return replacePathToMacroMap;
    }

    @ApiStatus.Internal
    protected void resetCachedReplacePathMap() {
        this.replacePathToMacroMap = null;
    }

    @Override
    @Contract(value="null -> null; !null -> !null")
    public String expandPath(@Nullable String text) {
        if (Strings.isEmpty((String)text)) {
            return text;
        }
        return this.getExpandMacroMap().substitute(text, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Override
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public String collapsePath(@Nullable String text, boolean recursively) {
        if (Strings.isEmpty((String)text)) {
            return text;
        }
        return this.getReplacePathMap().substitute(text, SystemInfoRt.isFileSystemCaseSensitive, recursively).toString();
    }

    @Override
    public void expandPaths(@NotNull Element element) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(13);
        }
        this.getExpandMacroMap().substitute(element, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Override
    public void collapsePaths(@NotNull Element element, boolean recursively) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(14);
        }
        PathMacroManager.collapsePaths(element, recursively, this.getReplacePathMap());
    }

    public static void collapsePaths(@NotNull Element element, boolean recursively, @NotNull ReplacePathToMacroMap map) {
        if (element == null) {
            PathMacroManager.$$$reportNull$$$0(15);
        }
        if (map == null) {
            PathMacroManager.$$$reportNull$$$0(16);
        }
        map.substitute(element, SystemInfoRt.isFileSystemCaseSensitive, recursively, PathMacroManager.createFilter());
    }

    @NotNull
    private PathMacrosImpl getPathMacros() {
        if (this.pathMacros == null) {
            this.pathMacros = PathMacrosImpl.getInstanceEx();
        }
        PathMacrosImpl pathMacrosImpl = this.pathMacros;
        if (pathMacrosImpl == null) {
            PathMacroManager.$$$reportNull$$$0(17);
        }
        return pathMacrosImpl;
    }

    protected static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        return path1 != null && path2 != null && FileUtil.pathsEqual((String)FileUtilRt.toSystemIndependentName((String)path1), (String)FileUtilRt.toSystemIndependentName((String)path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 9, 10, 11, 12, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/PathMacroManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/PathMacroManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacePathMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileHierarchyReplacements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddFileHierarchyReplacements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 9, 10, 11, 12, 17 -> new IllegalStateException(string);
        };
    }
}

