/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectWidePathMacroContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

public final class ModulePathMacroManager
extends PathMacroManager {
    private final @NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer;
    @NotNull
    private final @NotNull Supplier<@NotNull @SystemIndependent String> myModuleDirPointer;

    public ModulePathMacroManager(@NotNull Module module, @NotNull PathMacros globalPathMacros) {
        if (module == null) {
            ModulePathMacroManager.$$$reportNull$$$0(0);
        }
        if (globalPathMacros == null) {
            ModulePathMacroManager.$$$reportNull$$$0(1);
        }
        super(globalPathMacros);
        this.projectFilePathPointer = () -> ((Project)module.getProject()).getProjectFilePath();
        this.myModuleDirPointer = () -> ((Module)module).getModuleFilePath();
    }

    @NonInjectable
    @ApiStatus.Internal
    public ModulePathMacroManager(@NotNull PathMacros globalPathMacros, @NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull @NotNull Supplier<@NotNull @SystemIndependent String> moduleDirPointer) {
        if (globalPathMacros == null) {
            ModulePathMacroManager.$$$reportNull$$$0(2);
        }
        if (projectFilePathPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(3);
        }
        if (moduleDirPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(4);
        }
        super(globalPathMacros);
        this.projectFilePathPointer = projectFilePathPointer;
        this.myModuleDirPointer = moduleDirPointer;
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap() {
        ExpandMacroToPathMap result = super.getExpandMacroMap();
        ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModuleDirPointer.get()));
        String projectFile = this.projectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result.addMacroExpand(entry.getKey(), entry.getValue());
            }
        }
        ExpandMacroToPathMap expandMacroToPathMap = result;
        if (expandMacroToPathMap == null) {
            ModulePathMacroManager.$$$reportNull$$$0(5);
        }
        return expandMacroToPathMap;
    }

    @Override
    @NotNull
    public ReplacePathToMacroMap computeReplacePathMap() {
        ReplacePathToMacroMap result = super.computeReplacePathMap();
        ModulePathMacroManager.addFileHierarchyReplacements(result, "MODULE_DIR", PathMacroUtil.getModuleDir((String)this.myModuleDirPointer.get()), PathMacroUtil.getUserHomePath());
        String projectFile = this.projectFilePathPointer.get();
        if (projectFile != null) {
            for (Map.Entry<String, String> entry : ProjectWidePathMacroContributor.getAllMacros(projectFile).entrySet()) {
                result.addMacroReplacement(entry.getValue(), entry.getKey());
            }
        }
        ReplacePathToMacroMap replacePathToMacroMap = result;
        if (replacePathToMacroMap == null) {
            ModulePathMacroManager.$$$reportNull$$$0(6);
        }
        return replacePathToMacroMap;
    }

    @ApiStatus.Internal
    public void onImlFileMoved() {
        this.resetCachedReplacePathMap();
    }

    public static ModulePathMacroManager createInstance(@NotNull Supplier<@Nullable @SystemIndependent String> projectFilePathPointer, @NotNull @NotNull Supplier<@NotNull @SystemIndependent String> moduleDirPointer) {
        if (projectFilePathPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(7);
        }
        if (moduleDirPointer == null) {
            ModulePathMacroManager.$$$reportNull$$$0(8);
        }
        return new ModulePathMacroManager(PathMacros.getInstance(), projectFilePathPointer, moduleDirPointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalPathMacros";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilePathPointer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirPointer";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/components/impl/ModulePathMacroManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/components/impl/ModulePathMacroManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandMacroMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeReplacePathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

