/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.ProjectFileIndexImpl;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileIndex;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleRelatedRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexEx;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleFileIndexImpl
extends FileIndexBase
implements ModuleFileIndex {
    @NotNull
    private final Module myModule;

    public ModuleFileIndexImpl(@NotNull Module module) {
        if (module == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
    }

    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter) {
        Pair rootsPair;
        if (processor == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(1);
        }
        if ((rootsPair = (Pair)ReadAction.nonBlocking(() -> {
            Project project = this.myModule.getProject();
            if (project.isDisposed()) {
                return null;
            }
            WorkspaceFileIndexEx index = (WorkspaceFileIndexEx)WorkspaceFileIndex.getInstance(project);
            HashSet recursiveRoots = new HashSet();
            SmartList nonRecursiveRoots = new SmartList();
            index.visitFileSets(new WorkspaceFileSetVisitor(){
                private int visitedCount = 0;
                final /* synthetic */ Collection val$nonRecursiveRoots;
                final /* synthetic */ Collection val$recursiveRoots;
                {
                    this.val$nonRecursiveRoots = collection;
                    this.val$recursiveRoots = collection2;
                }

                @Override
                public void visitIncludedRoot(@NotNull WorkspaceFileSet fileSet, @NotNull @NotNull EntityPointer<? extends @NotNull WorkspaceEntity> entityPointer) {
                    if (fileSet == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (entityPointer == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ++this.visitedCount;
                    if (this.visitedCount % 100 == 0) {
                        ProgressManager.checkCanceled();
                    }
                    if (!(fileSet instanceof WorkspaceFileSetWithCustomData) || !ModuleFileIndexImpl.this.isInContent((WorkspaceFileSetWithCustomData)fileSet)) {
                        return;
                    }
                    VirtualFile root = fileSet.getRoot();
                    if (fileSet instanceof WorkspaceFileSetImpl && !((WorkspaceFileSetImpl)fileSet).getRecursive()) {
                        this.val$nonRecursiveRoots.add(fileSet.getRoot());
                    } else {
                        this.val$recursiveRoots.add(root);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "fileSet";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "entityPointer";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$1";
                    objectArray[2] = "visitIncludedRoot";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            List filteredRecursiveRoots = ContainerUtil.filter(recursiveRoots, root -> !this.isNestedRootOfModuleContent((VirtualFile)root));
            return new Pair((Object)filteredRecursiveRoots, (Object)nonRecursiveRoots);
        }).executeSynchronously()) == null) {
            return false;
        }
        return this.iterateProvidedRootsOfContent(processor, filter, (Collection)rootsPair.getFirst(), (Collection)rootsPair.getSecond());
    }

    private boolean isNestedRootOfModuleContent(@NotNull VirtualFile root) {
        VirtualFile parent;
        if (root == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(2);
        }
        if ((parent = root.getParent()) == null) {
            return false;
        }
        WorkspaceFileInternalInfo fileInfo = this.myWorkspaceFileIndex.getFileInfo(parent, false, true, true, false, false, false);
        return fileInfo.findFileSet(this::hasRecursiveRootFromModuleContent) != null;
    }

    private boolean hasRecursiveRootFromModuleContent(@NotNull WorkspaceFileSetWithCustomData<?> fileSet) {
        if (fileSet == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(3);
        }
        if (!fileSet.getRecursive()) {
            return false;
        }
        return this.isInContent(fileSet);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(4);
        }
        WorkspaceFileSetWithCustomData<ModuleRelatedRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleRelatedRootData.class);
        return this.isFromThisModule(fileSet);
    }

    private boolean isFromThisModule(@Nullable WorkspaceFileSetWithCustomData<? extends ModuleRelatedRootData> fileSet) {
        return fileSet != null && fileSet.getData().getModule().equals((Object)this.myModule);
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(5);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class)) != null && this.isFromThisModule(fileSet);
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(6);
        }
        return ModuleFileIndexImpl.findAllOrderEntriesWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(fileOrDir));
    }

    public OrderEntry getOrderEntryForFile(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(7);
        }
        return ModuleFileIndexImpl.findOrderEntryWithOwnerModule(this.myModule, this.myDirectoryIndex.getOrderEntries(fileOrDir));
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(8);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class)) != null && this.isFromThisModule(fileSet) && fileSet.getKind() == WorkspaceFileKind.TEST_CONTENT;
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (fileOrDir == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(9);
        }
        if (rootTypes == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(10);
        }
        return this.isFromThisModule(fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class)) && ProjectFileIndexImpl.isSourceRootOfType(fileSet, rootTypes);
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myModule.isDisposed();
    }

    @Nullable
    public static OrderEntry findOrderEntryWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> orderEntries) {
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(11);
        }
        if (orderEntries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(12);
        }
        if (orderEntries.size() < 10) {
            for (OrderEntry orderEntry : orderEntries) {
                if (orderEntry.getOwnerModule() != ownerModule) continue;
                return orderEntry;
            }
            return null;
        }
        int index = Collections.binarySearch(orderEntries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        return index < 0 ? null : orderEntries.get(index);
    }

    @NotNull
    private static List<OrderEntry> findAllOrderEntriesWithOwnerModule(@NotNull Module ownerModule, @NotNull List<? extends OrderEntry> entries) {
        int lastIndex;
        if (ownerModule == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(13);
        }
        if (entries == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(14);
        }
        if (entries.isEmpty()) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (entries.size() == 1) {
            OrderEntry entry = entries.get(0);
            ArrayList<OrderEntry> arrayList = entry.getOwnerModule() == ownerModule ? new ArrayList<OrderEntry>(entries) : Collections.emptyList();
            if (arrayList == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        int index = Collections.binarySearch(entries, new FakeOrderEntry(ownerModule), RootIndex.BY_OWNER_MODULE);
        if (index < 0) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                ModuleFileIndexImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        int firstIndex = index;
        while (firstIndex - 1 >= 0 && entries.get(firstIndex - 1).getOwnerModule() == ownerModule) {
            --firstIndex;
        }
        for (lastIndex = index + 1; lastIndex < entries.size() && entries.get(lastIndex).getOwnerModule() == ownerModule; ++lastIndex) {
        }
        return new ArrayList<OrderEntry>(entries.subList(firstIndex, lastIndex));
    }

    @Override
    protected boolean isInContent(@NotNull WorkspaceFileSetWithCustomData<?> fileSet) {
        ModuleRelatedRootData data;
        Object obj;
        if (fileSet == null) {
            ModuleFileIndexImpl.$$$reportNull$$$0(18);
        }
        return (obj = fileSet.getData()) instanceof ModuleRelatedRootData && this.myModule.equals((Object)(data = (ModuleRelatedRootData)obj).getModule());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerModule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isNestedRootOfModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasRecursiveRootFromModuleContent";
                break;
            }
            case 4: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOrderEntryWithOwnerModule";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAllOrderEntriesWithOwnerModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static class FakeOrderEntry
    implements OrderEntry {
        private final Module myOwnerModule;

        FakeOrderEntry(@NotNull Module ownerModule) {
            if (ownerModule == null) {
                FakeOrderEntry.$$$reportNull$$$0(0);
            }
            this.myOwnerModule = ownerModule;
        }

        public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
            if (type == null) {
                FakeOrderEntry.$$$reportNull$$$0(1);
            }
            throw new IncorrectOperationException();
        }

        @NotNull
        public String getPresentableName() {
            throw new IncorrectOperationException();
        }

        public boolean isValid() {
            throw new IncorrectOperationException();
        }

        @NotNull
        public Module getOwnerModule() {
            Module module = this.myOwnerModule;
            if (module == null) {
                FakeOrderEntry.$$$reportNull$$$0(2);
            }
            return module;
        }

        public <R> R accept(@NotNull RootPolicy<R> policy, @Nullable R initialValue) {
            if (policy == null) {
                FakeOrderEntry.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public int compareTo(@NotNull OrderEntry o) {
            if (o == null) {
                FakeOrderEntry.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public boolean isSynthetic() {
            throw new IncorrectOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ownerModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleFileIndexImpl$FakeOrderEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

