/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.JavaSyntheticLibrary;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.RootFileValidityChecker;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.Function;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.DummyWorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ExcludedFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.JvmPackageRootDataInternal;
import com.intellij.workspaceModel.core.fileIndex.impl.LibraryRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.LibrarySourceRootFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingFileSetKind;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.NonIncrementalMarker;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.SyntheticLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Jn\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u00112J\u0010\u0013\u001aF\u0012\u0004\u0012\u00020\u0015\u00128\u00126\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0016j\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019`\u001b0\u0014j\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070 H\u0002J\u0014\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120#H\u0002J/\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\b\u0010&\u001a\u0004\u0018\u0001H%2\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "allRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "excludedUrls", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "upToDate", "", "lock", "updateIfNeeded", "", "fileSets", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSetsByPackagePrefix", "Ljava/util/HashMap;", "", "Ljava/util/LinkedHashMap;", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileSetImpl;", "Lkotlin/collections/LinkedHashMap;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/PackagePrefixStorage;", "nonExistingFilesRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "computeCustomExcludedRoots", "Lkotlin/Pair;", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "computeFileSets", "", "checkNotNull", "T", "result", "methodName", "library", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "(Ljava/lang/Object;Ljava/lang/String;Lcom/intellij/openapi/roots/SyntheticLibrary;)Ljava/lang/Object;", "resetCache", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonIncrementalContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n1869#2,2:207\n1869#2,2:209\n1869#2,2:211\n1869#2:215\n1460#2,5:223\n1869#2:228\n1869#2,2:229\n1870#2:231\n1870#2:236\n1869#2:237\n1869#2,2:238\n1869#2,2:240\n1870#2:242\n1869#2,2:243\n216#3,2:213\n13805#4,2:216\n11887#4:218\n13805#4:219\n13806#4:221\n11888#4:222\n13805#4:232\n13805#4,2:233\n13806#4:235\n1#5:220\n13#6:245\n*S KotlinDebug\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors\n*L\n58#1:207,2\n62#1:209,2\n70#1:211,2\n96#1:215\n110#1:223,5\n111#1:228\n112#1:229,2\n111#1:231\n96#1:236\n142#1:237\n162#1:238,2\n167#1:240,2\n142#1:242\n150#1:243,2\n73#1:213,2\n97#1:216,2\n109#1:218\n109#1:219\n109#1:221\n109#1:222\n122#1:232\n123#1:233,2\n122#1:235\n109#1:220\n197#1:245\n*E\n"})
public final class NonIncrementalContributors {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Set<? extends VirtualFile> allRoots;
    @NotNull
    private Set<? extends VirtualFileUrl> excludedUrls;
    private volatile boolean upToDate;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Logger LOG;

    public NonIncrementalContributors(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.allRoots = SetsKt.emptySet();
        this.excludedUrls = SetsKt.emptySet();
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateIfNeeded(@NotNull Map<VirtualFile, StoredFileSetCollection> fileSets, @NotNull HashMap<String, LinkedHashMap<EntityPointer<WorkspaceEntity>, List<WorkspaceFileSetImpl>>> fileSetsByPackagePrefix, @NotNull NonExistingWorkspaceRootsRegistry nonExistingFilesRegistry) {
        Intrinsics.checkNotNullParameter(fileSets, (String)"fileSets");
        Intrinsics.checkNotNullParameter(fileSetsByPackagePrefix, (String)"fileSetsByPackagePrefix");
        Intrinsics.checkNotNullParameter((Object)nonExistingFilesRegistry, (String)"nonExistingFilesRegistry");
        if (!this.upToDate) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Pair<Object2IntMap<VirtualFile>, Set<VirtualFileUrl>> pair = this.computeCustomExcludedRoots();
            Object2IntMap newExcludedRoots = (Object2IntMap)pair.component1();
            Set newExcludedUrls = (Set)pair.component2();
            Map<VirtualFile, StoredFileSetCollection> newFileSets = this.computeFileSets();
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (!this.upToDate) {
                    Object element$iv;
                    Iterable $this$forEach$iv = this.allRoots;
                    boolean $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        VirtualFile file = (VirtualFile)element$iv2;
                        boolean bl2 = false;
                        WorkspaceFileSetsKt.removeValueIf(fileSets, file, (Function1<? super StoredFileSet, Boolean>)((Function1)NonIncrementalContributors::updateIfNeeded$lambda$0$0$0));
                        WorkspaceFileSetsKt.removeByPrefixAndPointer(fileSetsByPackagePrefix, "", (EntityPointer<? extends WorkspaceEntity>)((EntityPointer)NonIncrementalMarker.INSTANCE));
                    }
                    $this$forEach$iv = this.excludedUrls;
                    $i$f$forEach = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        VirtualFileUrl it = (VirtualFileUrl)element$iv2;
                        boolean bl3 = false;
                        nonExistingFilesRegistry.unregisterUrl(it, (EntityPointer<? extends WorkspaceEntity>)((EntityPointer)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN);
                    }
                    HashSet<VirtualFile> newRoots = new HashSet<VirtualFile>();
                    Object2IntMaps.fastForEach((Object2IntMap)newExcludedRoots, arg_0 -> NonIncrementalContributors.updateIfNeeded$lambda$0$3(arg_0 -> NonIncrementalContributors.updateIfNeeded$lambda$0$2(fileSets, newRoots, arg_0), arg_0));
                    Object $this$forEach$iv2 = newExcludedUrls;
                    boolean $i$f$forEach2 = false;
                    Iterator<Object> iterator = $this$forEach$iv2.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        VirtualFileUrl it = (VirtualFileUrl)element$iv;
                        boolean bl4 = false;
                        nonExistingFilesRegistry.registerUrl(it, (EntityPointer<? extends WorkspaceEntity>)((EntityPointer)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN, NonExistingFileSetKind.EXCLUDED_FROM_CONTENT);
                    }
                    $this$forEach$iv2 = newFileSets;
                    $i$f$forEach2 = false;
                    iterator = $this$forEach$iv2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Object object2 = element$iv = (Map.Entry)iterator.next();
                        boolean bl5 = false;
                        VirtualFile root = (VirtualFile)object2.getKey();
                        StoredFileSetCollection sets = (StoredFileSetCollection)object2.getValue();
                        sets.forEach((Function1<? super StoredFileSet, Unit>)((Function1)arg_0 -> NonIncrementalContributors.updateIfNeeded$lambda$0$5$0(fileSets, root, fileSetsByPackagePrefix, arg_0)));
                        newRoots.add(root);
                    }
                    this.allRoots = newRoots;
                    this.excludedUrls = newExcludedUrls;
                    this.upToDate = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Object2IntMap<VirtualFile>, Set<VirtualFileUrl>> computeCustomExcludedRoots() {
        VirtualFileUrlManager virtualFileUrlManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
        Object2IntOpenHashMap excludedFiles = new Object2IntOpenHashMap();
        HashSet<VirtualFileUrl> excludedUrls = new HashSet<VirtualFileUrl>();
        Iterable $this$forEach$iv = DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DirectoryIndexExcludePolicy policy = (DirectoryIndexExcludePolicy)element$iv;
            boolean bl = false;
            String[] stringArray = policy.getExcludeUrlsForProject();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getExcludeUrlsForProject(...)");
            Object[] $this$forEach$iv2 = stringArray;
            boolean $i$f$forEach2 = false;
            for (Object object : $this$forEach$iv2) {
                String url = (String)object;
                boolean bl2 = false;
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file != null) {
                    if (!RootFileValidityChecker.ensureValid(file, this.project, policy)) continue;
                    excludedFiles.put((Object)file, 31);
                    continue;
                }
                Intrinsics.checkNotNull((Object)url);
                excludedUrls.add(virtualFileUrlManager.getOrCreateFromUrl(url));
            }
            if (policy.getExcludeSdkRootsStrategy() != null) {
                void $this$flatMapTo$iv;
                boolean bl3 = false;
                Module[] moduleArray = ModuleManager.Companion.getInstance(this.project).getModules();
                Iterable<Sdk> destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                Module[] $this$forEach$iv$iv = moduleArray;
                boolean $i$f$forEach3 = false;
                int n = $this$forEach$iv$iv.length;
                for (int i = 0; i < n; ++i) {
                    Sdk it$iv;
                    Module element$iv$iv;
                    Module element$iv3 = element$iv$iv = $this$forEach$iv$iv[i];
                    boolean bl4 = false;
                    Module it = element$iv3;
                    boolean bl5 = false;
                    if (ModuleRootManager.getInstance((Module)it).getSdk() == null) continue;
                    boolean bl6 = false;
                    destination$iv.add(it$iv);
                }
                HashSet sdks = (HashSet)destination$iv;
                destination$iv = sdks;
                Collection destination$iv2 = new HashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv4 : $this$flatMapTo$iv) {
                    Sdk it = (Sdk)element$iv4;
                    boolean bl7 = false;
                    VirtualFile[] virtualFileArray = it.getRootProvider().getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                    Iterable list$iv = ArraysKt.asList((Object[])virtualFileArray);
                    CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
                }
                HashSet hashSet = (HashSet)destination$iv2;
                Iterable $this$forEach$iv3 = sdks;
                boolean $i$f$forEach4 = false;
                for (Object element$iv5 : $this$forEach$iv3) {
                    Function<Sdk, List<VirtualFile>> strategy;
                    Sdk sdk = (Sdk)element$iv5;
                    boolean bl8 = false;
                    Object object = strategy.fun((Object)sdk);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun(...)");
                    Iterable $this$forEach$iv4 = (Iterable)object;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv6 : $this$forEach$iv4) {
                        VirtualFile correctedRoot;
                        VirtualFile root = (VirtualFile)element$iv6;
                        boolean bl9 = false;
                        if (hashSet.contains(root) || (correctedRoot = RootFileValidityChecker.correctRoot(root, sdk, policy)) == null) continue;
                        excludedFiles.put((Object)correctedRoot, 6 | excludedFiles.getInt((Object)correctedRoot));
                    }
                }
            }
            Module[] $this$forEach$iv3 = ModuleManager.Companion.getInstance(this.project).getModules();
            boolean $i$f$forEach3 = false;
            int n = $this$forEach$iv3.length;
            for (int i = 0; i < n; ++i) {
                Module module;
                Module module2 = module = $this$forEach$iv3[i];
                boolean bl10 = false;
                VirtualFilePointer[] virtualFilePointerArray = policy.getExcludeRootsForModule((ModuleRootModel)ModuleRootManager.getInstance((Module)module2));
                Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointerArray, (String)"getExcludeRootsForModule(...)");
                Object[] $this$forEach$iv5 = virtualFilePointerArray;
                boolean $i$f$forEach6 = false;
                for (Object element$iv7 : $this$forEach$iv5) {
                    VirtualFilePointer pointer = (VirtualFilePointer)element$iv7;
                    boolean bl11 = false;
                    VirtualFile file = pointer.getFile();
                    if (file != null) {
                        VirtualFile correctedRoot = RootFileValidityChecker.correctRoot(file, module2, policy);
                        if (correctedRoot == null) continue;
                        excludedFiles.put((Object)correctedRoot, 1 | excludedFiles.getInt((Object)correctedRoot));
                        continue;
                    }
                    String string = pointer.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                    excludedUrls.add(virtualFileUrlManager.getOrCreateFromUrl(string));
                }
            }
        }
        return TuplesKt.to((Object)excludedFiles, excludedUrls);
    }

    private final Map<VirtualFile, StoredFileSetCollection> computeFileSets() {
        HashMap<VirtualFile, StoredFileSetCollection> result = new HashMap<VirtualFile, StoredFileSetCollection>();
        Iterable $this$forEach$iv = AdditionalLibraryRootsProvider.EP_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdditionalLibraryRootsProvider provider = (AdditionalLibraryRootsProvider)element$iv;
            boolean bl = false;
            for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(this.project)) {
                Condition condition;
                if (library == null) {
                    PluginException.logPluginError((Logger)LOG, (String)("The result of AdditionalLibraryRootsProvider.getAdditionalProjectLibraries on " + provider.getClass() + " includes 'null' item"), null, provider.getClass());
                    continue;
                }
                Collection collection = this.checkNotNull(library.getSourceRoots(), "getSourceRoots()", library);
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                Collection sourceRoots = collection;
                NonIncrementalContributors.computeFileSets$lambda$0$registerRoots(library, provider, result, sourceRoots, WorkspaceFileKind.EXTERNAL_SOURCE, library instanceof JavaSyntheticLibrary ? (ModuleOrLibrarySourceRootData)new LibrarySourceRootFileSetData(null) : (ModuleOrLibrarySourceRootData)SyntheticLibrarySourceRootData.INSTANCE);
                Collection collection2 = this.checkNotNull(library.getBinaryRoots(), "getBinaryRoots()", library);
                if (collection2 == null) {
                    collection2 = CollectionsKt.emptyList();
                }
                Collection binaryRoots = collection2;
                NonIncrementalContributors.computeFileSets$lambda$0$registerRoots(library, provider, result, binaryRoots, WorkspaceFileKind.EXTERNAL, library instanceof JavaSyntheticLibrary ? (WorkspaceFileSetData)new LibraryRootFileSetData(null) : (WorkspaceFileSetData)DummyWorkspaceFileSetData.INSTANCE);
                Set set = this.checkNotNull(library.getExcludedRoots(), "getExcludedRoots()", library);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set excludedRoots = set;
                Iterable $this$forEach$iv2 = excludedRoots;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    VirtualFile it = (VirtualFile)element$iv2;
                    boolean bl2 = false;
                    Map map = result;
                    Intrinsics.checkNotNull((Object)it);
                    WorkspaceFileSetsKt.putValue(map, it, new ExcludedFileSet.ByFileKind(6, NonIncrementalMarker.INSTANCE, null, 4, null));
                }
                if (library.getUnitedExcludeCondition() == null) continue;
                boolean bl3 = false;
                Function1 predicate = arg_0 -> NonIncrementalContributors.computeFileSets$lambda$0$2$0(condition, arg_0);
                Collection collection3 = library.getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getSourceRoots(...)");
                Collection collection4 = library.getBinaryRoots();
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getBinaryRoots(...)");
                Iterable $this$forEach$iv3 = CollectionsKt.plus((Collection)collection3, (Iterable)collection4);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    VirtualFile root = (VirtualFile)element$iv3;
                    boolean bl4 = false;
                    Map map = result;
                    Intrinsics.checkNotNull((Object)root);
                    WorkspaceFileSetsKt.putValue(map, root, new ExcludedFileSet.ByCondition(root, (Function1<? super VirtualFile, Boolean>)predicate, (EntityPointer<? extends WorkspaceEntity>)((EntityPointer)NonIncrementalMarker.INSTANCE), EntityStorageKind.MAIN));
                }
            }
        }
        return result;
    }

    private final <T> T checkNotNull(T result, String methodName, SyntheticLibrary library) {
        if (result == null) {
            PluginException.logPluginError((Logger)LOG, (String)("Contract violation: SyntheticLibrary::" + methodName + " is marked as '@NotNull', but its implementation in " + library + " returned 'null'"), null, library.getClass());
        }
        return result;
    }

    @RequiresWriteLock
    public final void resetCache() {
        this.upToDate = false;
    }

    private static final boolean updateIfNeeded$lambda$0$0$0(StoredFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        return fileSet.getEntityPointer() == NonIncrementalMarker.INSTANCE;
    }

    private static final Unit updateIfNeeded$lambda$0$2(Map $fileSets, HashSet $newRoots, Object2IntMap.Entry it) {
        Object object = it.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-key>(...)");
        WorkspaceFileSetsKt.putValue($fileSets, object, new ExcludedFileSet.ByFileKind(it.getIntValue(), NonIncrementalMarker.INSTANCE, null, 4, null));
        $newRoots.add(it.getKey());
        return Unit.INSTANCE;
    }

    private static final void updateIfNeeded$lambda$0$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateIfNeeded$lambda$0$5$0(Map $fileSets, VirtualFile $root, HashMap $fileSetsByPackagePrefix, StoredFileSet set) {
        WorkspaceFileSetImpl fileSet;
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        WorkspaceFileSetsKt.putValue($fileSets, $root, set);
        WorkspaceFileSetImpl workspaceFileSetImpl = fileSet = set instanceof WorkspaceFileSetImpl ? (WorkspaceFileSetImpl)set : null;
        if (fileSet != null && fileSet.getData() instanceof JvmPackageRootDataInternal) {
            WorkspaceFileSetsKt.addFileSet($fileSetsByPackagePrefix, "", fileSet);
        }
        return Unit.INSTANCE;
    }

    private static final void computeFileSets$lambda$0$registerRoots(SyntheticLibrary library, AdditionalLibraryRootsProvider $provider, HashMap<VirtualFile, StoredFileSetCollection> result, Collection<? extends VirtualFile> files, WorkspaceFileKind kind, WorkspaceFileSetData fileSetData) {
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it;
            VirtualFile root = (VirtualFile)element$iv;
            boolean bl = false;
            if (RootFileValidityChecker.correctRoot(root, library, $provider) == null) continue;
            boolean bl2 = false;
            WorkspaceFileSetsKt.putValue((Map)result, it, new WorkspaceFileSetImpl(it, kind, NonIncrementalMarker.INSTANCE, EntityStorageKind.MAIN, fileSetData, false, 32, null));
        }
    }

    private static final boolean computeFileSets$lambda$0$2$0(Condition $condition, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return $condition.value((Object)file);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NonIncrementalContributors.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion;", "", "<init>", "()V", "isFromAdditionalLibraryRootsProvider", "", "fileSet", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSet;", "isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl", "isPlaceholderReference", "entityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nNonIncrementalContributors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,206:1\n19#2:207\n*S KotlinDebug\n*F\n+ 1 NonIncrementalContributors.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/NonIncrementalContributors$Companion\n*L\n190#1:207\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isFromAdditionalLibraryRootsProvider$intellij_platform_projectModel_impl(@NotNull WorkspaceFileSet fileSet) {
            Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
            WorkspaceFileSet $this$asSafely$iv = fileSet;
            boolean $i$f$asSafely = false;
            WorkspaceFileSet workspaceFileSet = $this$asSafely$iv;
            if (!(workspaceFileSet instanceof WorkspaceFileSetImpl)) {
                workspaceFileSet = null;
            }
            WorkspaceFileSetImpl workspaceFileSetImpl = (WorkspaceFileSetImpl)workspaceFileSet;
            return (workspaceFileSetImpl != null ? workspaceFileSetImpl.getEntityPointer() : null) instanceof NonIncrementalMarker;
        }

        public final boolean isPlaceholderReference(@NotNull EntityPointer<? extends WorkspaceEntity> entityPointer) {
            Intrinsics.checkNotNullParameter(entityPointer, (String)"entityPointer");
            return entityPointer instanceof NonIncrementalMarker;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

