/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.core.fileIndex.impl.EntityChangeStorage;
import com.intellij.workspaceModel.core.fileIndex.impl.NonExistingWorkspaceRootsRegistry;
import com.intellij.workspaceModel.core.fileIndex.impl.VfsChangeApplier;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileIndexData;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplier;", "entityChanges", "Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;", "indexData", "Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;", "nonExistingRootsRegistry", "Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/workspaceModel/core/fileIndex/impl/EntityChangeStorage;Lcom/intellij/workspaceModel/core/fileIndex/impl/WorkspaceFileIndexData;Lcom/intellij/workspaceModel/core/fileIndex/impl/NonExistingWorkspaceRootsRegistry;Lcom/intellij/openapi/project/Project;)V", "beforeVfsChange", "", "afterVfsChange", "entitiesToReindex", "", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getEntitiesToReindex", "()Ljava/util/Set;", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nNonExistingWorkspaceRootsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1869#2,2:292\n1869#2,2:294\n*S KotlinDebug\n*F\n+ 1 NonExistingWorkspaceRootsRegistry.kt\ncom/intellij/workspaceModel/core/fileIndex/impl/VfsChangeApplierImpl\n*L\n194#1:292,2\n203#1:294,2\n*E\n"})
final class VfsChangeApplierImpl
implements VfsChangeApplier {
    @NotNull
    private final EntityChangeStorage entityChanges;
    @NotNull
    private final WorkspaceFileIndexData indexData;
    @NotNull
    private final NonExistingWorkspaceRootsRegistry nonExistingRootsRegistry;
    @NotNull
    private final Project project;

    public VfsChangeApplierImpl(@NotNull EntityChangeStorage entityChanges, @NotNull WorkspaceFileIndexData indexData, @NotNull NonExistingWorkspaceRootsRegistry nonExistingRootsRegistry, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entityChanges, (String)"entityChanges");
        Intrinsics.checkNotNullParameter((Object)indexData, (String)"indexData");
        Intrinsics.checkNotNullParameter((Object)nonExistingRootsRegistry, (String)"nonExistingRootsRegistry");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.entityChanges = entityChanges;
        this.indexData = indexData;
        this.nonExistingRootsRegistry = nonExistingRootsRegistry;
        this.project = project;
    }

    public void beforeVfsChange() {
        this.indexData.markDirty((Collection<? extends EntityPointer<? extends WorkspaceEntity>>)this.entityChanges.getAffectedEntities(), (Collection<? extends VirtualFile>)this.entityChanges.getFilesToInvalidate());
    }

    public void afterVfsChange() {
        Set<EntityPointer<WorkspaceEntity>> affectedEntities = this.entityChanges.getAffectedEntities();
        this.indexData.markDirty((Collection<? extends EntityPointer<? extends WorkspaceEntity>>)affectedEntities, (Collection<? extends VirtualFile>)this.entityChanges.getFilesToInvalidate());
        Iterable $this$forEach$iv = this.entityChanges.getUrlsToCleanUp();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFileUrl it = (VirtualFileUrl)element$iv;
            boolean bl = false;
            this.nonExistingRootsRegistry.removeUrl(it);
        }
        this.indexData.updateDirtyEntities();
        if (!((Collection)affectedEntities).isEmpty()) {
            ImmutableEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
            Iterable $this$forEach$iv2 = affectedEntities;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                LibraryEntity libraryEntity;
                EntityPointer entityRef = (EntityPointer)element$iv;
                boolean bl = false;
                Object object = entityRef.resolve((EntityStorage)entityStorage);
                LibraryEntity libraryEntity2 = object instanceof LibraryEntity ? (LibraryEntity)object : null;
                if (libraryEntity2 == null || !((libraryEntity = libraryEntity2).getTableId() instanceof LibraryTableId.GlobalLibraryTableId)) continue;
                object = ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)entityStorage).getDataByEntity((WorkspaceEntity)libraryEntity);
                LibraryBridgeImpl libraryBridgeImpl = object instanceof LibraryBridgeImpl ? (LibraryBridgeImpl)object : null;
                if (libraryBridgeImpl != null) {
                    libraryBridgeImpl.fireRootSetChanged$intellij_platform_projectModel_impl();
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<EntityPointer<WorkspaceEntity>> getEntitiesToReindex() {
        return this.entityChanges.getEntitiesToReindex();
    }
}

