/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedEntityStorage;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.LegacyProjectModelListenersBridgeKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleDependencyIndexImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleManagerBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleRootListenerBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleDependencyIndex;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J2\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010 \u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/LegacyProjectModelListenersBridge;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "project", "Lcom/intellij/openapi/project/Project;", "moduleModificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "moduleRootListenerBridge", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleRootListenerBridge;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/SimpleModificationTracker;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/ModuleRootListenerBridge;)V", "beforeCalled", "", "beforeChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "changed", "postProcessModules", "oldModuleNames", "", "Lcom/intellij/openapi/module/Module;", "", "processModuleChange", "change", "Lcom/intellij/platform/workspace/storage/EntityChange;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "removeUnloadedModuleWithId", "moduleId", "Lcom/intellij/platform/workspace/jps/entities/ModuleId;", "processModuleLibraryChange", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "fireModuleAddedInWriteAction", "module", "Lcom/intellij/openapi/module/impl/ModuleEx;", "fireEventAndDisposeModule", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "fireBeforeModuleRemoved", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nLegacyProjectModelListenersBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyProjectModelListenersBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LegacyProjectModelListenersBridge\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n67#2,4:215\n60#2,5:219\n67#2,4:224\n67#2,4:228\n*S KotlinDebug\n*F\n+ 1 LegacyProjectModelListenersBridge.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LegacyProjectModelListenersBridge\n*L\n48#1:215,4\n55#1:219,5\n66#1:224,4\n93#1:228,4\n*E\n"})
public final class LegacyProjectModelListenersBridge
implements WorkspaceModelChangeListener {
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker moduleModificationTracker;
    @NotNull
    private final ModuleRootListenerBridge moduleRootListenerBridge;
    private boolean beforeCalled;

    public LegacyProjectModelListenersBridge(@NotNull Project project, @NotNull SimpleModificationTracker moduleModificationTracker, @NotNull ModuleRootListenerBridge moduleRootListenerBridge) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleModificationTracker, (String)"moduleModificationTracker");
        Intrinsics.checkNotNullParameter((Object)moduleRootListenerBridge, (String)"moduleRootListenerBridge");
        this.project = project;
        this.moduleModificationTracker = moduleModificationTracker;
        this.moduleRootListenerBridge = moduleRootListenerBridge;
    }

    public void beforeChanged(@NotNull VersionedStorageChange event) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger $this$trace$iv = LegacyProjectModelListenersBridgeKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Get before changed event");
        }
        this.beforeCalled = true;
        this.moduleRootListenerBridge.fireBeforeRootsChanged(this.project, event);
        ExternalEntityMapping<ModuleBridge> moduleMap = ModuleManagerBridgeImpl.Companion.getModuleMap((EntityStorage)event.getStorageBefore());
        for (EntityChange change : event.getChanges(ModuleEntity.class)) {
            if (!(change instanceof EntityChange.Removed)) continue;
            ModuleBridge module = (ModuleBridge)moduleMap.getDataByEntity(((EntityChange.Removed)change).getOldEntity());
            Logger $this$debug_u24default$iv = LegacyProjectModelListenersBridgeKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Fire 'beforeModuleRemoved' event for module " + ((ModuleEntity)((EntityChange.Removed)change).getOldEntity()).getName() + ", module = " + module, e$iv);
            }
            if (module == null) continue;
            this.fireBeforeModuleRemoved(module);
        }
    }

    public void changed(@NotNull VersionedStorageChange event) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.beforeCalled) {
            return;
        }
        this.beforeCalled = false;
        Logger $this$trace$iv = LegacyProjectModelListenersBridgeKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Get changed event");
        }
        List<EntityChange<LibraryEntity>> moduleLibraryChanges = ModuleManagerBridgeImpl.Companion.filterModuleLibraryChanges(event.getChanges(LibraryEntity.class));
        List changes = event.getChanges(ModuleEntity.class);
        if (!((Collection)changes).isEmpty() || !((Collection)moduleLibraryChanges).isEmpty()) {
            LegacyProjectModelListenersBridgeKt.access$getLOG$p().debug("Process changed modules and facets");
            this.moduleModificationTracker.incModificationCount();
            for (EntityChange<LibraryEntity> entityChange : moduleLibraryChanges) {
                EntityChange<LibraryEntity> entityChange2 = entityChange;
                if (entityChange2 instanceof EntityChange.Removed) {
                    this.processModuleLibraryChange(entityChange, event);
                    continue;
                }
                if (entityChange2 instanceof EntityChange.Replaced) {
                    this.processModuleLibraryChange(entityChange, event);
                    continue;
                }
                if (entityChange2 instanceof EntityChange.Added) continue;
                throw new NoWhenBranchMatchedException();
            }
            Map oldModuleNames = new LinkedHashMap();
            for (EntityChange entityChange : changes) {
                this.processModuleChange((EntityChange<ModuleEntity>)entityChange, oldModuleNames, event);
            }
            for (EntityChange<LibraryEntity> entityChange : moduleLibraryChanges) {
                if (!(entityChange instanceof EntityChange.Added)) continue;
                this.processModuleLibraryChange(entityChange, event);
            }
            this.postProcessModules(oldModuleNames);
            this.moduleModificationTracker.incModificationCount();
        }
        ModuleDependencyIndex moduleDependencyIndex = ModuleDependencyIndex.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)moduleDependencyIndex, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleDependencyIndexImpl");
        ((ModuleDependencyIndexImpl)moduleDependencyIndex).workspaceModelChanged(event);
        Logger $this$trace$iv2 = LegacyProjectModelListenersBridgeKt.access$getLOG$p();
        boolean bl = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl2 = false;
            logger.trace("fire roots changed for moduleRootListenerBridge");
        }
        this.moduleRootListenerBridge.fireRootsChanged(this.project, event);
    }

    private final void postProcessModules(Map<Module, String> oldModuleNames) {
        if (!oldModuleNames.isEmpty()) {
            MessageBus messageBus = this.project.getMessageBus();
            Topic topic = ModuleListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((ModuleListener)messageBus.syncPublisher(topic)).modulesRenamed(this.project, CollectionsKt.toList((Iterable)oldModuleNames.keySet()), arg_0 -> LegacyProjectModelListenersBridge.postProcessModules$lambda$1(arg_0 -> LegacyProjectModelListenersBridge.postProcessModules$lambda$0(oldModuleNames, arg_0), arg_0));
        }
    }

    private final void processModuleChange(EntityChange<ModuleEntity> change, Map<Module, String> oldModuleNames, VersionedStorageChange event) {
        EntityChange<ModuleEntity> entityChange = change;
        if (entityChange instanceof EntityChange.Removed) {
            ModuleBridge module = ModuleEntityUtils.findModule((ModuleEntity)((EntityChange.Removed)change).getOldEntity(), (EntityStorage)event.getStorageBefore());
            if (module != null) {
                this.fireEventAndDisposeModule(module);
            }
        } else if (entityChange instanceof EntityChange.Added) {
            this.removeUnloadedModuleWithId(((ModuleEntity)((EntityChange.Added)change).getNewEntity()).getSymbolicId());
            ModuleBridge alreadyCreatedModule = ModuleEntityUtils.findModule((ModuleEntity)((EntityChange.Added)change).getNewEntity(), (EntityStorage)event.getStorageAfter());
            if (alreadyCreatedModule == null) {
                throw new IllegalStateException("Module bridge should already be created".toString());
            }
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
            Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
            alreadyCreatedModule.setEntityStorage((VersionedEntityStorage)((WorkspaceModelInternal)workspaceModel).getEntityStorage());
            alreadyCreatedModule.setDiff(null);
            ModuleBridge module = alreadyCreatedModule;
            if (this.project.isOpen()) {
                this.fireModuleAddedInWriteAction(module);
            }
        } else if (entityChange instanceof EntityChange.Replaced) {
            ModuleId newId;
            ModuleId oldId = ((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()).getSymbolicId();
            if (!Intrinsics.areEqual((Object)oldId, (Object)(newId = ((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getSymbolicId()))) {
                this.removeUnloadedModuleWithId(newId);
                ModuleBridge module = ModuleEntityUtils.findModule((ModuleEntity)((EntityChange.Replaced)change).getOldEntity(), (EntityStorage)event.getStorageBefore());
                if (module != null) {
                    module.rename(newId.getName(), ModuleManagerBridgeImpl.Companion.getModuleVirtualFileUrl((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()), true);
                    oldModuleNames.put(module, oldId.getName());
                }
            } else if (!Intrinsics.areEqual((Object)ModuleManagerBridgeImpl.Companion.getImlFileDirectory((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()), (Object)ModuleManagerBridgeImpl.Companion.getImlFileDirectory((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()))) {
                ModuleBridge module = ModuleEntityUtils.findModule((ModuleEntity)((EntityChange.Replaced)change).getNewEntity(), (EntityStorage)event.getStorageBefore());
                VirtualFileUrl imlFilePath = ModuleManagerBridgeImpl.Companion.getModuleVirtualFileUrl((ModuleEntity)((EntityChange.Replaced)change).getNewEntity());
                if (module != null && imlFilePath != null) {
                    module.onImlFileMoved(imlFilePath);
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void removeUnloadedModuleWithId(ModuleId moduleId) {
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
        Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
        ModuleEntity unloadedEntity = (ModuleEntity)((WorkspaceModelInternal)workspaceModel).getCurrentSnapshotOfUnloadedEntities().resolve((SymbolicEntityId)moduleId);
        if (unloadedEntity != null) {
            WorkspaceModel workspaceModel2 = WorkspaceModel.Companion.getInstance(this.project);
            Intrinsics.checkNotNull((Object)workspaceModel2, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
            ((WorkspaceModelInternal)workspaceModel2).updateUnloadedEntities("Remove module '" + moduleId.getName() + "' from unloaded storage because a module with same name is added", arg_0 -> LegacyProjectModelListenersBridge.removeUnloadedModuleWithId$lambda$0(unloadedEntity, arg_0));
        }
    }

    private final void processModuleLibraryChange(EntityChange<LibraryEntity> change, VersionedStorageChange event) {
        EntityChange<LibraryEntity> entityChange = change;
        if (entityChange instanceof EntityChange.Removed) {
            LibraryBridge library = (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)event.getStorageBefore()).getDataByEntity(((EntityChange.Removed)change).getOldEntity());
            if (library != null) {
                LibraryBridgeImpl.Companion.disposeLibrary((Library)library);
            }
        } else if (entityChange instanceof EntityChange.Replaced) {
            LibraryId idBefore = ((LibraryEntity)((EntityChange.Replaced)change).getOldEntity()).getSymbolicId();
            LibraryId idAfter = ((LibraryEntity)((EntityChange.Replaced)change).getNewEntity()).getSymbolicId();
            LibraryBridgeImpl newLibrary = (LibraryBridgeImpl)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)event.getStorageAfter()).getDataByEntity(((EntityChange.Replaced)change).getNewEntity());
            if (newLibrary != null) {
                newLibrary.clearTargetBuilder();
                if (!Intrinsics.areEqual((Object)idBefore, (Object)idAfter)) {
                    newLibrary.setEntityId(idAfter);
                }
            }
        } else if (entityChange instanceof EntityChange.Added) {
            LibraryBridge library = (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap((EntityStorage)event.getStorageAfter()).getDataByEntity(((EntityChange.Added)change).getNewEntity());
            if (library != null) {
                LibraryBridgeImpl libraryBridgeImpl = (LibraryBridgeImpl)library;
                WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(this.project);
                Intrinsics.checkNotNull((Object)workspaceModel, (String)"null cannot be cast to non-null type com.intellij.platform.backend.workspace.impl.WorkspaceModelInternal");
                libraryBridgeImpl.setEntityStorage((VersionedEntityStorage)((WorkspaceModelInternal)workspaceModel).getEntityStorage());
                ((LibraryBridgeImpl)library).clearTargetBuilder();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void fireModuleAddedInWriteAction(ModuleEx module) {
        ApplicationManager.getApplication().runWriteAction(() -> LegacyProjectModelListenersBridge.fireModuleAddedInWriteAction$lambda$0(module, this));
    }

    private final void fireEventAndDisposeModule(ModuleBridge module) {
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ModuleListener)messageBus.syncPublisher(topic)).moduleRemoved(this.project, (Module)module);
        Disposer.dispose((Disposable)((Disposable)module));
    }

    private final void fireBeforeModuleRemoved(ModuleBridge module) {
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ModuleListener)messageBus.syncPublisher(topic)).beforeModuleRemoved(this.project, (Module)module);
    }

    private static final String postProcessModules$lambda$0(Map $oldModuleNames, Module module) {
        return (String)$oldModuleNames.get(module);
    }

    private static final String postProcessModules$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit removeUnloadedModuleWithId$lambda$0(ModuleEntity $unloadedEntity, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.removeEntity((WorkspaceEntity)$unloadedEntity);
        return Unit.INSTANCE;
    }

    private static final void fireModuleAddedInWriteAction$lambda$0(ModuleEx $module, LegacyProjectModelListenersBridge this$0) {
        if (!$module.isLoaded()) {
            $module.markAsLoaded();
            MessageBus messageBus = this$0.project.getMessageBus();
            Topic topic = ModuleListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((ModuleListener)messageBus.syncPublisher(topic)).modulesAdded(this$0.project, CollectionsKt.listOf((Object)$module));
        }
    }
}

