/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.module;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.MultiSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u0006\u0010\u0011\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker;", "", "<init>", "()V", "libraryLevels", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/MultiSet;", "", "dependencyWithLibraryLevelAdded", "", "libraryLevel", "occurrences", "", "dependencyWithLibraryLevelRemoved", "isNotUsed", "", "getLibraryLevels", "", "clear", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLibraryLevelsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryLevelsTracker.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n13#2:104\n*S KotlinDebug\n*F\n+ 1 LibraryLevelsTracker.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker\n*L\n48#1:104\n*E\n"})
public final class LibraryLevelsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiSet<String> libraryLevels = new MultiSet();
    @NotNull
    private static final Logger LOG;

    public final void dependencyWithLibraryLevelAdded(@NotNull String libraryLevel, int occurrences) {
        Intrinsics.checkNotNullParameter((Object)libraryLevel, (String)"libraryLevel");
        this.libraryLevels.add(libraryLevel, occurrences);
    }

    public final void dependencyWithLibraryLevelRemoved(@NotNull String libraryLevel, int occurrences) {
        Intrinsics.checkNotNullParameter((Object)libraryLevel, (String)"libraryLevel");
        int prevValue = this.libraryLevels.remove(libraryLevel, occurrences);
        if (prevValue <= 0) {
            LOG.error("Unexpected value in library tracker: " + prevValue + " for " + libraryLevel + ". Tried to add " + occurrences + " occurrences");
        }
    }

    public final boolean isNotUsed(@NotNull String libraryLevel) {
        Intrinsics.checkNotNullParameter((Object)libraryLevel, (String)"libraryLevel");
        return !this.libraryLevels.contains(libraryLevel);
    }

    @NotNull
    public final Set<String> getLibraryLevels() {
        return (Set)this.libraryLevels.items();
    }

    public final void clear() {
        this.libraryLevels.clear();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LibraryLevelsTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfInitialized", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    @SourceDebugExtension(value={"SMAP\nLibraryLevelsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryLevelsTracker.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,103:1\n30#2,2:104\n58#2:106\n*S KotlinDebug\n*F\n+ 1 LibraryLevelsTracker.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/module/LibraryLevelsTracker$Companion\n*L\n46#1:104,2\n47#1:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryLevelsTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LibraryLevelsTracker> serviceClass$iv = LibraryLevelsTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LibraryLevelsTracker)object;
        }

        @Nullable
        public final LibraryLevelsTracker getInstanceIfInitialized(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (LibraryLevelsTracker)$this$serviceIfCreated$iv.getServiceIfCreated(LibraryLevelsTracker.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

