/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.sdk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelMachine;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntityBuilder;
import com.intellij.platform.workspace.jps.entities.SdkEntityModifications;
import com.intellij.platform.workspace.jps.entities.SdkId;
import com.intellij.platform.workspace.jps.entities.SdkRoot;
import com.intellij.platform.workspace.jps.entities.SdkRootTypeId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.InternalEnvironmentName;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModelKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImplKt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkModificatorBridgeImplKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001f\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020\u0012H\u0017J\b\u0010,\u001a\u00020\u0012H\u0016J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020\u0014H\u0016J\u0012\u0010/\u001a\u0002002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/sdk/SdkModificatorBridgeImpl;", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "originalEntity", "Lcom/intellij/platform/workspace/jps/entities/SdkEntityBuilder;", "originalSdk", "Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;", "originalSdkDelegate", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/sdk/SdkBridgeImpl;", "environmentName", "Lcom/intellij/platform/workspace/storage/InternalEnvironmentName;", "<init>", "(Lcom/intellij/platform/workspace/jps/entities/SdkEntityBuilder;Lcom/intellij/openapi/projectRoots/impl/ProjectJdkImpl;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/sdk/SdkBridgeImpl;Lcom/intellij/platform/workspace/storage/InternalEnvironmentName;)V", "isCommitted", "", "additionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "modifiedSdkEntity", "setType", "", "name", "", "setType$intellij_platform_projectModel_impl", "getName", "setName", "getHomePath", "setHomePath", "path", "getVersionString", "setVersionString", "versionString", "getSdkAdditionalData", "setSdkAdditionalData", "getRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "(Lcom/intellij/openapi/roots/OrderRootType;)[Lcom/intellij/openapi/vfs/VirtualFile;", "addRoot", "root", "removeRoot", "removeRoots", "removeAllRoots", "commitChanges", "applyChangesWithoutWriteAction", "isWritable", "toString", "getMachine", "Lcom/intellij/platform/eel/EelMachine;", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nSdkModificatorBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkModificatorBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/sdk/SdkModificatorBridgeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n1617#2,9:197\n1869#2:206\n1870#2:208\n1626#2:209\n1#3:207\n37#4,2:210\n23#5:212\n23#5:213\n*S KotlinDebug\n*F\n+ 1 SdkModificatorBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/sdk/SdkModificatorBridgeImpl\n*L\n91#1:194\n91#1:195,2\n92#1:197,9\n92#1:206\n92#1:208\n92#1:209\n92#1:207\n93#1:210,2\n120#1:212\n121#1:213\n*E\n"})
public final class SdkModificatorBridgeImpl
implements SdkModificator {
    @NotNull
    private final SdkEntityBuilder originalEntity;
    @NotNull
    private final ProjectJdkImpl originalSdk;
    @NotNull
    private final SdkBridgeImpl originalSdkDelegate;
    private boolean isCommitted;
    @Nullable
    private SdkAdditionalData additionalData;
    @NotNull
    private final SdkEntityBuilder modifiedSdkEntity;

    public SdkModificatorBridgeImpl(@NotNull SdkEntityBuilder originalEntity, @NotNull ProjectJdkImpl originalSdk, @NotNull SdkBridgeImpl originalSdkDelegate, @NotNull InternalEnvironmentName environmentName) {
        Intrinsics.checkNotNullParameter((Object)originalEntity, (String)"originalEntity");
        Intrinsics.checkNotNullParameter((Object)originalSdk, (String)"originalSdk");
        Intrinsics.checkNotNullParameter((Object)originalSdkDelegate, (String)"originalSdkDelegate");
        Intrinsics.checkNotNullParameter((Object)environmentName, (String)"environmentName");
        this.originalEntity = originalEntity;
        this.originalSdk = originalSdk;
        this.originalSdkDelegate = originalSdkDelegate;
        this.modifiedSdkEntity = SdkBridgeImpl.Companion.createEmptySdkEntity$default(SdkBridgeImpl.Companion, "", "", null, null, environmentName, 12, null);
        SdkBridgeImplKt.applyChangesFrom(this.modifiedSdkEntity, this.originalEntity);
        if (((CharSequence)this.modifiedSdkEntity.getAdditionalData()).length() > 0) {
            Element element = JDOMUtil.load((CharSequence)this.modifiedSdkEntity.getAdditionalData());
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element additionalDataElement = element;
            this.additionalData = this.originalSdkDelegate.getSdkType().loadAdditionalData((Sdk)this.originalSdkDelegate, additionalDataElement);
        }
    }

    public final void setType$intellij_platform_projectModel_impl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.modifiedSdkEntity.setType(name);
    }

    @NotNull
    public String getName() {
        return this.modifiedSdkEntity.getName();
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.modifiedSdkEntity.setName(name);
    }

    @Nullable
    public String getHomePath() {
        VirtualFileUrl virtualFileUrl = this.modifiedSdkEntity.getHomePath();
        return virtualFileUrl != null ? virtualFileUrl.getUrl() : null;
    }

    public void setHomePath(@Nullable String path) {
        if (path != null) {
            EelMachine descriptor = this.getMachine(path);
            VirtualFileUrlManager globalInstance = GlobalWorkspaceModel.Companion.getInstance(descriptor).getVirtualFileUrlManager();
            this.modifiedSdkEntity.setHomePath(globalInstance.getOrCreateFromUrl(path));
            this.modifiedSdkEntity.setEntitySource(SdkBridgeImpl.Companion.createEntitySourceForSdk(GlobalWorkspaceModelKt.getInternalEnvironmentName(descriptor)));
        } else {
            this.modifiedSdkEntity.setHomePath(null);
        }
    }

    @Nullable
    public String getVersionString() {
        return this.modifiedSdkEntity.getVersion();
    }

    public void setVersionString(@Nullable String versionString) {
        this.modifiedSdkEntity.setVersion(versionString);
    }

    @Nullable
    public SdkAdditionalData getSdkAdditionalData() {
        return this.additionalData;
    }

    public void setSdkAdditionalData(@Nullable SdkAdditionalData additionalData) {
        this.additionalData = additionalData;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        Iterable $this$filter$iv = this.modifiedSdkEntity.getRoots();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SdkRoot it = (SdkRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)SdkBridgeImplKt.getCustomName(rootType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SdkRoot it = (SdkRoot)element$iv$iv;
            boolean bl2 = false;
            if (VirtualFileUrls.getVirtualFile((VirtualFileUrl)it.getUrl()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new VirtualFile[0]);
    }

    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        VirtualFileUrlManager virtualFileUrlManager = GlobalWorkspaceModel.Companion.getInstance((EelMachine)LocalEelMachine.INSTANCE).getVirtualFileUrlManager();
        List list = this.modifiedSdkEntity.getRoots();
        String string = root.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        VirtualFileUrl virtualFileUrl = virtualFileUrlManager.getOrCreateFromUrl(string);
        Object v = SdkModificatorBridgeImplKt.access$getRootTypes$p().get(SdkBridgeImplKt.getCustomName(rootType));
        Intrinsics.checkNotNull(v);
        list.add(new SdkRoot(virtualFileUrl, (SdkRootTypeId)v));
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List roots = this.modifiedSdkEntity.getRoots();
        roots.removeIf(arg_0 -> SdkModificatorBridgeImpl.removeRoot$lambda$1(arg_0 -> SdkModificatorBridgeImpl.removeRoot$lambda$0(root, rootType, arg_0), arg_0));
    }

    public void removeRoots(@NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        List roots = this.modifiedSdkEntity.getRoots();
        roots.removeIf(arg_0 -> SdkModificatorBridgeImpl.removeRoots$lambda$1(arg_0 -> SdkModificatorBridgeImpl.removeRoots$lambda$0(rootType, arg_0), arg_0));
    }

    public void removeAllRoots() {
        this.modifiedSdkEntity.setRoots((List)new ArrayList());
    }

    @RequiresWriteLock
    public void commitChanges() {
        SdkEntity existingEntity;
        String string;
        ThreadingAssertions.assertWriteAccess();
        SdkModificatorBridgeImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(SdkModificatorBridgeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        if (logger.isTraceEnabled()) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(SdkModificatorBridgeImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.trace(new Throwable("Committing changes for SDK"));
        }
        if (this.isCommitted) {
            throw new IllegalStateException("Modification already completed".toString());
        }
        VirtualFileUrl virtualFileUrl = this.modifiedSdkEntity.getHomePath();
        EelMachine descriptor = this.getMachine(virtualFileUrl != null ? virtualFileUrl.toString() : null);
        GlobalWorkspaceModel globalWorkspaceModel = GlobalWorkspaceModel.Companion.getInstance(descriptor);
        if (this.additionalData != null) {
            Element additionalDataElement = new Element("additional");
            SdkTypeId sdkTypeId = SdkBridgeImplKt.getSdkType(this.modifiedSdkEntity);
            SdkAdditionalData sdkAdditionalData = this.additionalData;
            Intrinsics.checkNotNull((Object)sdkAdditionalData);
            sdkTypeId.saveAdditionalData(sdkAdditionalData, additionalDataElement);
            String string2 = JDOMUtil.write((Element)additionalDataElement);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "";
        }
        this.modifiedSdkEntity.setAdditionalData(string);
        WorkspaceEntity workspaceEntity = SdkBridgeImpl.Companion.getSdkMap((EntityStorage)globalWorkspaceModel.getCurrentSnapshot()).getFirstEntity((Object)this.originalSdk);
        SdkEntity sdkEntity = existingEntity = workspaceEntity instanceof SdkEntity ? (SdkEntity)workspaceEntity : null;
        if (sdkEntity != null) {
            SdkEntity entity = sdkEntity;
            boolean bl = false;
            globalWorkspaceModel.updateModel("Modifying SDK " + new SdkId(this.originalEntity.getName(), this.originalEntity.getType()), (Function1<? super MutableEntityStorage, Unit>)((Function1)arg_0 -> SdkModificatorBridgeImpl.commitChanges$lambda$0$0(entity, this, arg_0)));
        }
        this.originalSdkDelegate.applyChangesFrom$intellij_platform_projectModel_impl(this.modifiedSdkEntity);
        if (existingEntity != null) {
            this.originalSdkDelegate.fireRootSetChanged();
        } else {
            Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
            if (ArraysKt.toList((Object[])sdkArray).contains(this.originalSdk)) {
                this.originalSdkDelegate.fireRootSetChanged();
            }
        }
        this.isCommitted = true;
    }

    public void applyChangesWithoutWriteAction() {
        String string;
        if (this.isCommitted) {
            throw new IllegalStateException("Modification already completed".toString());
        }
        if (this.additionalData != null) {
            Element additionalDataElement = new Element("additional");
            SdkTypeId sdkTypeId = SdkBridgeImplKt.getSdkType(this.modifiedSdkEntity);
            SdkAdditionalData sdkAdditionalData = this.additionalData;
            Intrinsics.checkNotNull((Object)sdkAdditionalData);
            sdkTypeId.saveAdditionalData(sdkAdditionalData, additionalDataElement);
            String string2 = JDOMUtil.write((Element)additionalDataElement);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "";
        }
        this.modifiedSdkEntity.setAdditionalData(string);
        this.originalSdkDelegate.applyChangesFrom$intellij_platform_projectModel_impl(this.modifiedSdkEntity);
        this.isCommitted = true;
    }

    public boolean isWritable() {
        return !this.isCommitted;
    }

    @NotNull
    public String toString() {
        return this.getName() + " Version:" + this.getVersionString() + " Path:(" + this.getHomePath() + ")";
    }

    private final EelMachine getMachine(String path) {
        EelMachine eelMachine;
        if (path == null) {
            return (EelMachine)LocalEelMachine.INSTANCE;
        }
        try {
            Path path2 = Path.of(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            eelMachine = EelProviderUtil.getEelDescriptor((Path)path2).getMachine();
        }
        catch (InvalidPathException invalidPathException) {
            eelMachine = (EelMachine)LocalEelMachine.INSTANCE;
        }
        return eelMachine;
    }

    private static final boolean removeRoot$lambda$0(VirtualFile $root, OrderRootType $rootType, SdkRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getUrl().getUrl(), (Object)$root.getUrl()) && Intrinsics.areEqual((Object)it.getType().getName(), (Object)SdkBridgeImplKt.getCustomName($rootType));
    }

    private static final boolean removeRoot$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeRoots$lambda$0(OrderRootType $rootType, SdkRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType().getName(), (Object)SdkBridgeImplKt.getCustomName($rootType));
    }

    private static final boolean removeRoots$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit commitChanges$lambda$0$0(SdkEntity $entity, SdkModificatorBridgeImpl this$0, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SdkEntityModifications.modifySdkEntity((MutableEntityStorage)it, (SdkEntity)$entity, arg_0 -> SdkModificatorBridgeImpl.commitChanges$lambda$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit commitChanges$lambda$0$0$0(SdkModificatorBridgeImpl this$0, SdkEntityBuilder $this$modifySdkEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifySdkEntity, (String)"$this$modifySdkEntity");
        SdkBridgeImplKt.applyChangesFrom($this$modifySdkEntity, this$0.modifiedSdkEntity);
        return Unit.INSTANCE;
    }
}

