/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacroContributor;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.DISABLED, useSaveThreshold=ThreeState.NO, usePathMacroManager=false)}, reportStatistic=false, useLoadedStateAsExisting=false, category=SettingsCategory.SYSTEM, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 52\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u00020\u0004:\u00015B\u0011\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0015H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u000bH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0016J\u001a\u0010)\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u000b2\b\u0010*\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010+\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u000b2\b\u0010*\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010,\u001a\u00020\u0018H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0003H\u0016J\u000e\u00101\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000202J\u000e\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000204R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000f\u001a.\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b0\u0013\u00a2\u0006\u0002\b\u00120\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/application/options/PathMacrosImpl;", "Lcom/intellij/openapi/application/PathMacros;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/util/ModificationTracker;", "loadContributors", "", "<init>", "(Z)V", "legacyMacros", "", "", "macros", "modificationStamp", "Ljava/util/concurrent/atomic/AtomicLong;", "ignoredMacros", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getUserMacroNames", "", "getUserMacros", "removeToolMacroNames", "", "result", "getSystemMacroNames", "getIgnoredMacroNames", "", "setIgnoredMacroNames", "names", "addIgnoredMacro", "getModificationCount", "", "isIgnoredMacroName", "macro", "getAllMacroNames", "getValue", "name", "removeAllMacros", "getLegacyMacroNames", "setMacro", "value", "doSetMacro", "userMacroModified", "getState", "noStateLoaded", "loadState", "element", "addMacroReplacements", "Lcom/intellij/application/options/ReplacePathToMacroMap;", "addMacroExpands", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPathMacrosImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathMacrosImpl.kt\ncom/intellij/application/options/PathMacrosImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,245:1\n13#2:246\n*S KotlinDebug\n*F\n+ 1 PathMacrosImpl.kt\ncom/intellij/application/options/PathMacrosImpl\n*L\n50#1:246\n*E\n"})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element>,
ModificationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean loadContributors;
    @NotNull
    private volatile Map<String, String> legacyMacros;
    @NotNull
    private volatile Map<String, String> macros;
    @NotNull
    private final AtomicLong modificationStamp;
    @NotNull
    private final List<String> ignoredMacros;
    @NotNull
    private static final ExtensionPointName<PathMacroContributor> EP_NAME = new ExtensionPointName("com.intellij.pathMacroContributor");
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final String MAVEN_REPOSITORY = "MAVEN_REPOSITORY";
    @NotNull
    private static final Set<String> SYSTEM_MACROS;

    public PathMacrosImpl(boolean loadContributors) {
        this.loadContributors = loadContributors;
        Map map = Map.of();
        Intrinsics.checkNotNullExpressionValue(map, (String)"of(...)");
        this.legacyMacros = map;
        Map map2 = Map.of();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"of(...)");
        this.macros = map2;
        this.modificationStamp = new AtomicLong();
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.ignoredMacros = list;
    }

    public /* synthetic */ PathMacrosImpl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public Set<String> getUserMacroNames() {
        return this.macros.keySet();
    }

    @NotNull
    public Map<String, String> getUserMacros() {
        return this.macros;
    }

    public void removeToolMacroNames(@NotNull Set<String> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    @NotNull
    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    @NotNull
    public Collection<String> getIgnoredMacroNames() {
        return this.ignoredMacros;
    }

    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.ignoredMacros.clear();
        this.ignoredMacros.addAll(names);
        this.modificationStamp.incrementAndGet();
    }

    public void addIgnoredMacro(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        for (String name : names) {
            if (this.ignoredMacros.contains(name)) continue;
            this.ignoredMacros.add(name);
        }
    }

    public long getModificationCount() {
        return this.modificationStamp.get();
    }

    public boolean isIgnoredMacroName(@NotNull String macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        return this.ignoredMacros.contains(macro);
    }

    @NotNull
    public Set<String> getAllMacroNames() {
        HashSet result = new HashSet(this.getUserMacroNames().size() + this.getSystemMacroNames().size());
        result.addAll(this.getUserMacroNames());
        result.addAll(this.getSystemMacroNames());
        return result;
    }

    @Nullable
    public String getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.macros.get(name);
    }

    public void removeAllMacros() {
        if (!this.macros.isEmpty()) {
            this.macros = MapsKt.emptyMap();
            this.userMacroModified();
        }
    }

    @NotNull
    public Collection<String> getLegacyMacroNames() {
        return this.legacyMacros.keySet();
    }

    public void setMacro(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.doSetMacro(name, value);
    }

    private final boolean doSetMacro(String name, String value) {
        Map map;
        Map macros = this.macros;
        CharSequence charSequence = value;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            if (!macros.containsKey(name)) {
                return false;
            }
            macros = new LinkedHashMap<String, String>(macros);
            v0 = (String)((LinkedHashMap)macros).remove(name);
        } else {
            if (Intrinsics.areEqual((Object)macros.get(name), (Object)value)) {
                return false;
            }
            macros = new LinkedHashMap(macros);
            v0 = ((LinkedHashMap)macros).put(name, value);
        }
        if (((LinkedHashMap)macros).isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            Map map2 = Collections.unmodifiableMap(macros);
            map = map2;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        }
        this.macros = map;
        this.userMacroModified();
        return true;
    }

    private final void userMacroModified() {
        this.modificationStamp.incrementAndGet();
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Element macro = new Element("macro");
            macro.setAttribute("name", key);
            macro.setAttribute("value", value);
            element.addContent(macro);
        }
        for (String macro : this.ignoredMacros) {
            Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
            macroElement.setAttribute("name", macro);
            element.addContent(macroElement);
        }
        LOG.info("Saved path macros: " + this.macros);
        return element;
    }

    public void noStateLoaded() {
        if (!this.loadContributors) {
            return;
        }
        this.loadState(new Element("state"));
        this.modificationStamp.incrementAndGet();
    }

    public void loadState(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LinkedHashMap<String, String> newMacros = new LinkedHashMap<String, String>();
        HashMap<String, String> newLegacyMacros = new HashMap<String, String>(this.legacyMacros);
        EP_NAME.forEachExtensionSafe(arg_0 -> PathMacrosImpl.loadState$lambda$1(arg_0 -> PathMacrosImpl.loadState$lambda$0(newMacros, newLegacyMacros, arg_0), arg_0));
        for (Object macro : element.getChildren("macro")) {
            String value;
            String name;
            if (macro.getAttributeValue("name") == null || macro.getAttributeValue("value") == null || SYSTEM_MACROS.contains(name)) continue;
            Character c = StringsKt.lastOrNull((CharSequence)value);
            char c2 = '/';
            if (c != null && c.charValue() == c2) {
                value = StringsKt.dropLast((String)value, (int)1);
            }
            newMacros.put(name, value);
        }
        List newIgnoredMacros = new ArrayList();
        for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
            String ignoredName = macroElement.getAttributeValue("name");
            CharSequence charSequence = ignoredName;
            if (charSequence == null || charSequence.length() == 0) continue;
            newIgnoredMacros.add(ignoredName);
        }
        LinkedHashMap forcedMacros = new LinkedHashMap();
        EP_NAME.forEachExtensionSafe(arg_0 -> PathMacrosImpl.loadState$lambda$3(arg_0 -> PathMacrosImpl.loadState$lambda$2(forcedMacros, arg_0), arg_0));
        for (Map.Entry forcedMacro : ((Map)forcedMacros).entrySet()) {
            if (Intrinsics.areEqual(newMacros.get(forcedMacro.getKey()), forcedMacro.getValue())) continue;
            this.modificationStamp.incrementAndGet();
            break;
        }
        newMacros.putAll(forcedMacros);
        Map map = newMacros.isEmpty() ? Map.of() : Collections.unmodifiableMap((Map)newMacros);
        Intrinsics.checkNotNull((Object)map);
        this.macros = map;
        map = newLegacyMacros.isEmpty() ? Map.of() : Collections.unmodifiableMap((Map)newLegacyMacros);
        Intrinsics.checkNotNull(map);
        this.legacyMacros = map;
        this.ignoredMacros.clear();
        this.ignoredMacros.addAll(newIgnoredMacros);
        LOG.info("Loaded path macros: " + this.macros);
    }

    public final void addMacroReplacements(@NotNull ReplacePathToMacroMap result) {
        Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            result.addMacroReplacement(value, name);
        }
    }

    public final void addMacroExpands(@NotNull ExpandMacroToPathMap result) {
        String value;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            String name = entry.getKey();
            value = entry.getValue();
            result.addMacroExpand(name, value);
        }
        for (Map.Entry<String, String> entry : this.legacyMacros.entrySet()) {
            String key = entry.getKey();
            value = entry.getValue();
            result.addMacroExpand(key, value);
        }
    }

    private static final Unit loadState$lambda$0(LinkedHashMap $newMacros, HashMap $newLegacyMacros, PathMacroContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        contributor.registerPathMacros((Map)$newMacros, (Map)$newLegacyMacros);
        return Unit.INSTANCE;
    }

    private static final void loadState$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit loadState$lambda$2(LinkedHashMap $forcedMacros, PathMacroContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        contributor.forceRegisterPathMacros((Map)$forcedMacros);
        return Unit.INSTANCE;
    }

    private static final void loadState$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public PathMacrosImpl() {
        this(false, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final PathMacrosImpl getInstanceEx() {
        return Companion.getInstanceEx();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PathMacrosImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Set<String> set = Set.of("APPLICATION_HOME_DIR", "APPLICATION_PLUGINS_DIR", "PROJECT_DIR", "MODULE_WORKING_DIR", "MODULE_DIR", "USER_HOME");
        Intrinsics.checkNotNullExpressionValue(set, (String)"of(...)");
        SYSTEM_MACROS = set;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u00a8\u0006\u0012"}, d2={"Lcom/intellij/application/options/PathMacrosImpl$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/application/PathMacroContributor;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "IGNORED_MACRO_ELEMENT", "", "MAVEN_REPOSITORY", "getMAVEN_REPOSITORY$annotations", "SYSTEM_MACROS", "", "getSYSTEM_MACROS$annotations", "getInstanceEx", "Lcom/intellij/application/options/PathMacrosImpl;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="to be removed")
        public static /* synthetic */ void getMAVEN_REPOSITORY$annotations() {
        }

        private static /* synthetic */ void getSYSTEM_MACROS$annotations() {
        }

        @JvmStatic
        @NotNull
        public final PathMacrosImpl getInstanceEx() {
            PathMacros pathMacros = PathMacros.getInstance();
            Intrinsics.checkNotNull((Object)pathMacros, (String)"null cannot be cast to non-null type com.intellij.application.options.PathMacrosImpl");
            return (PathMacrosImpl)pathMacros;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

