/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroProtocolHolder;
import com.intellij.application.options.PathMacrosImpl;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.CompositePathMacroFilter;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/application/options/PathMacrosCollector;", "Lcom/intellij/openapi/components/PathMacroMap;", "<init>", "()V", "matcher", "Ljava/util/regex/Matcher;", "kotlin.jvm.PlatformType", "macroMap", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "substituteRecursively", "", "text", "caseSensitive", "", "substitute", "hashCode", "", "equals", "other", "", "Companion", "intellij.platform.projectModel.impl"})
public final class PathMacrosCollector
extends PathMacroMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Matcher matcher = MACRO_PATTERN.matcher("");
    @NotNull
    private final LinkedHashMap<String, String> macroMap = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final ExtensionPointName<PathMacroFilter> MACRO_FILTER_EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.pathMacroFilter");
    @JvmField
    @NotNull
    public static final Pattern MACRO_PATTERN;

    private PathMacrosCollector() {
    }

    @NotNull
    public CharSequence substituteRecursively(@NotNull String text, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return text;
        }
        this.matcher.reset(text);
        while (this.matcher.find()) {
            this.macroMap.put(this.matcher.group(1), null);
        }
        return text;
    }

    @NotNull
    public String substitute(@NotNull String text, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() == 0) {
            return text;
        }
        int startPos = -1;
        if (text.charAt(0) == '$') {
            startPos = 0;
        } else {
            for (String protocol : PathMacroProtocolHolder.getProtocols()) {
                if (text.length() <= protocol.length() + 4 || !StringsKt.startsWith$default((String)text, (String)protocol, (boolean)false, (int)2, null) || text.charAt(protocol.length()) != ':') continue;
                startPos = protocol.length() + 1;
                if (text.charAt(startPos) == '/') {
                    ++startPos;
                }
                if (text.charAt(startPos) != '/') continue;
                ++startPos;
            }
        }
        if (startPos < 0) {
            return text;
        }
        this.matcher.reset(text).region(startPos, text.length());
        if (this.matcher.lookingAt()) {
            this.macroMap.put(this.matcher.group(1), null);
        }
        return text;
    }

    public int hashCode() {
        return this.macroMap.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathMacrosCollector)) {
            return false;
        }
        return Intrinsics.areEqual(this.macroMap, ((PathMacrosCollector)((Object)other)).macroMap);
    }

    public /* synthetic */ PathMacrosCollector(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Pattern pattern = Pattern.compile("\\$([\\w\\-.]+?)\\$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        MACRO_PATTERN = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/application/options/PathMacrosCollector$Companion;", "", "<init>", "()V", "MACRO_FILTER_EXTENSION_POINT_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/application/PathMacroFilter;", "MACRO_PATTERN", "Ljava/util/regex/Pattern;", "getMacroNames", "", "", "element", "Lorg/jdom/Element;", "root", "filter", "pathMacrosGetter", "Lkotlin/Function0;", "Lcom/intellij/application/options/PathMacrosImpl;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getMacroNames(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return com.intellij.application.options.PathMacrosCollector$Companion.getMacroNames$default(this, element, new CompositePathMacroFilter(MACRO_FILTER_EXTENSION_POINT_NAME.getExtensionList()), null, 4, null);
        }

        @ApiStatus.Internal
        @NotNull
        public final Set<String> getMacroNames(@NotNull Element root, @Nullable PathMacroFilter filter, @NotNull Function0<? extends PathMacrosImpl> pathMacrosGetter) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(pathMacrosGetter, (String)"pathMacrosGetter");
            PathMacrosCollector collector = new PathMacrosCollector(null);
            collector.substitute(root, true, false, filter);
            Set set = collector.macroMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Set preResult = set;
            if (preResult.isEmpty()) {
                return SetsKt.emptySet();
            }
            PathMacrosImpl pathMacros = (PathMacrosImpl)((Object)pathMacrosGetter.invoke());
            HashSet result = new HashSet(preResult);
            result.removeAll((Collection)pathMacros.getSystemMacroNames());
            result.removeAll(pathMacros.getLegacyMacroNames());
            pathMacros.removeToolMacroNames(result);
            for (String string : pathMacros.getIgnoredMacroNames()) {
                result.remove(string);
            }
            return result;
        }

        public static /* synthetic */ Set getMacroNames$default(Companion companion, Element element, PathMacroFilter pathMacroFilter, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                function0 = Companion::getMacroNames$lambda$0;
            }
            return companion.getMacroNames(element, pathMacroFilter, (Function0<? extends PathMacrosImpl>)function0);
        }

        private static final PathMacrosImpl getMacroNames$lambda$0() {
            return PathMacrosImpl.Companion.getInstanceEx();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

