/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.roots.impl.FileSet2RootDescriptor;
import com.intellij.openapi.roots.impl.RootDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileKind;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSet;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleContentOrSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleOrLibrarySourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleRelatedRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.UnloadedModuleContentRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileInternalInfo;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetImpl;
import com.intellij.workspaceModel.ide.legacyBridge.SourceRootTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance(ProjectFileIndexImpl.class);
    private final Project myProject;

    public ProjectFileIndexImpl(@NotNull Project project) {
        if (project == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProject = project;
    }

    public boolean iterateContent(@NotNull ContentIterator processor, @Nullable VirtualFileFilter filter) {
        if (processor == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(1);
        }
        Pair rootsPair = (Pair)ReadAction.compute(() -> {
            LinkedHashSet allRecursiveRoots = new LinkedHashSet();
            ArrayList allNonRecursiveRoots = new ArrayList();
            ArrayList allRecursiveNonIndexableRoots = new ArrayList();
            this.myWorkspaceFileIndex.visitFileSets((fileSet, entityPointer) -> {
                ProgressManager.checkCanceled();
                if (fileSet.getKind().isContent()) {
                    VirtualFile root = fileSet.getRoot();
                    if (fileSet instanceof WorkspaceFileSetImpl && !((WorkspaceFileSetImpl)fileSet).getRecursive()) {
                        allNonRecursiveRoots.add(root);
                    } else if (fileSet.getKind().isIndexable()) {
                        allRecursiveRoots.add(root);
                    } else {
                        allRecursiveNonIndexableRoots.add(NewVirtualFile.asCacheAvoiding((VirtualFile)root));
                    }
                }
            });
            allRecursiveRoots.addAll(allRecursiveNonIndexableRoots);
            List recursiveRoots = ContainerUtil.filter(allRecursiveRoots, root -> root.getParent() == null || this.myWorkspaceFileIndex.getContentFileSetRoot(root.getParent(), false) == null);
            return new Pair((Object)recursiveRoots, allNonRecursiveRoots);
        });
        return this.iterateProvidedRootsOfContent(processor, filter, (Collection)rootsPair.getFirst(), (Collection)rootsPair.getSecond());
    }

    public boolean isExcluded(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo info;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(2);
        }
        return (info = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, true, true)) == WorkspaceFileInternalInfo.NonWorkspace.IGNORED || info == WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED;
    }

    @NotNull
    public @NotNull Collection<@NotNull LibraryEntity> findContainingLibraries(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(3);
        }
        Collection<LibraryEntity> collection = this.myWorkspaceFileIndex.findContainingEntities(fileOrDir, LibraryEntity.class, true, false, false, true, true, false);
        if (collection == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull SdkEntity> findContainingSdks(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(5);
        }
        Collection<SdkEntity> collection = this.myWorkspaceFileIndex.findContainingEntities(fileOrDir, SdkEntity.class, true, false, false, true, true, false);
        if (collection == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo info;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(7);
        }
        return (info = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, true, true)) == WorkspaceFileInternalInfo.NonWorkspace.IGNORED;
    }

    public boolean isInProject(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(8);
        }
        return this.myWorkspaceFileIndex.findFileSet(file, true, true, true, true, true, false) != null;
    }

    public boolean isInProjectOrExcluded(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo info;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(9);
        }
        return (info = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, true, false)) == WorkspaceFileInternalInfo.NonWorkspace.EXCLUDED || !(info instanceof WorkspaceFileInternalInfo.NonWorkspace);
    }

    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(10);
        }
        return this.getModuleForFile(file, true);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        WorkspaceFileSetWithCustomData<ModuleRelatedRootData> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(11);
        }
        if ((fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, honorExclusion, true, true, false, false, false, ModuleRelatedRootData.class)) == null) {
            return null;
        }
        return fileSet.getData().getModule();
    }

    @NotNull
    public Set<Module> getModulesForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(12);
        }
        List<WorkspaceFileSetWithCustomData<ModuleRelatedRootData>> fileSet = this.myWorkspaceFileIndex.findFileSetsWithCustomData(file, honorExclusion, true, true, false, false, false, ModuleRelatedRootData.class);
        Set set = ContainerUtil.map2LinkedSet(fileSet, s -> ((ModuleRelatedRootData)s.getData()).getModule());
        if (set == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(14);
        }
        List<OrderEntry> list = this.myDirectoryIndex.getOrderEntries(file);
        if (list == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file) {
        WorkspaceFileSet fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(16);
        }
        if ((fileSet = this.myWorkspaceFileIndex.findFileSet(file, true, false, false, true, false, false)) == null) {
            return null;
        }
        return fileSet.getRoot();
    }

    @Nullable
    public JpsModuleSourceRootType<?> getContainingSourceRootType(@NotNull VirtualFile file) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(17);
        }
        if ((fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, true, true, true, false, false, false, ModuleSourceRootData.class)) == null) {
            return null;
        }
        return SourceRootTypeRegistry.getInstance().findTypeById(fileSet.getData().getRootTypeId());
    }

    public boolean isInGeneratedSources(@NotNull VirtualFile file) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(18);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, true, true, true, false, false, false, ModuleSourceRootData.class)) != null && fileSet.getData().getForGeneratedSources();
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        WorkspaceFileSetWithCustomData<ModuleOrLibrarySourceRootData> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(19);
        }
        if ((fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, true, true, true, false, true, false, ModuleOrLibrarySourceRootData.class)) == null) {
            return null;
        }
        return fileSet.getRoot();
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(20);
        }
        return this.getContentRootForFile(file, true);
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        WorkspaceFileSetWithCustomData<ModuleContentOrSourceRootData> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(21);
        }
        if ((fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, honorExclusion, true, true, false, false, false, ModuleContentOrSourceRootData.class)) == null) {
            WorkspaceFileSetWithCustomData<UnloadedModuleContentRootData> unloadedFileSet;
            if (!honorExclusion && (unloadedFileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(file, false, true, true, false, false, false, UnloadedModuleContentRootData.class)) != null) {
                return unloadedFileSet.getRoot();
            }
            return null;
        }
        VirtualFile contentRoot = fileSet.getData().getCustomContentRoot();
        if (contentRoot != null) {
            return contentRoot;
        }
        return fileSet.getRoot();
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(22);
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myWorkspaceFileIndex.getPackageName(dir);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(23);
        }
        if (file.isDirectory()) {
            return false;
        }
        WorkspaceFileSet fileSet = this.myWorkspaceFileIndex.findFileSet(file, true, false, false, true, false, false);
        return fileSet != null;
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<ModuleOrLibrarySourceRootData> fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(24);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, true, false, ModuleOrLibrarySourceRootData.class)) != null;
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSet fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(25);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, false, true, false, false)) != null;
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSet fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(26);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, false, false, true, false)) != null;
    }

    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSet fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(27);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSet(fileOrDir, true, false, false, true, true, false)) != null;
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(28);
        }
        return this.myWorkspaceFileIndex.isInContent(fileOrDir);
    }

    @Nullable
    public VirtualFile getModuleSourceOrLibraryClassesRoot(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo info;
        WorkspaceFileSetWithCustomData<?> fileSet;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(29);
        }
        return (fileSet = (info = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, false, false)).findFileSet(it -> {
            WorkspaceFileKind kind = it.getKind();
            return kind.isContent() && it.getData() instanceof ModuleOrLibrarySourceRootData || kind == WorkspaceFileKind.EXTERNAL;
        })) != null ? fileSet.getRoot() : null;
    }

    @NotNull
    public Collection<RootDescriptor> getModuleSourceOrLibraryClassesRoots(@NotNull VirtualFile file) {
        WorkspaceFileInternalInfo info;
        List<WorkspaceFileSetWithCustomData<?>> fileSets;
        if (file == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(30);
        }
        if ((fileSets = (info = this.myWorkspaceFileIndex.getFileInfo(file, true, true, true, true, false, false)).findFileSets(it -> {
            WorkspaceFileKind kind = it.getKind();
            return kind.isContent() && it.getData() instanceof ModuleOrLibrarySourceRootData || kind == WorkspaceFileKind.EXTERNAL;
        })).isEmpty()) {
            List<RootDescriptor> list = Collections.emptyList();
            if (list == null) {
                ProjectFileIndexImpl.$$$reportNull$$$0(31);
            }
            return list;
        }
        SmartList result = new SmartList();
        ImmutableEntityStorage snapshot = WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot();
        for (WorkspaceFileSetWithCustomData<?> set : fileSets) {
            RootDescriptor descriptor = FileSet2RootDescriptor.findFileSetDescriptor(set, snapshot);
            if (descriptor == null) continue;
            result.add((Object)descriptor);
        }
        if (result.size() != 1) {
            return new LinkedHashSet<RootDescriptor>((Collection<RootDescriptor>)result);
        }
        SmartList smartList = result;
        if (smartList == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(32);
        }
        return smartList;
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(33);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class)) != null;
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(34);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class)) != null && fileSet.getKind() == WorkspaceFileKind.TEST_CONTENT;
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(35);
        }
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(36);
        }
        WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, true, true, true, false, false, false, ModuleSourceRootData.class);
        return ProjectFileIndexImpl.isSourceRootOfType(fileSet, rootTypes);
    }

    static boolean isSourceRootOfType(@Nullable WorkspaceFileSetWithCustomData<ModuleSourceRootData> fileSet, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(37);
        }
        if (fileSet == null) {
            return false;
        }
        JpsModuleSourceRootType type = SourceRootTypeRegistry.getInstance().findTypeById(fileSet.getData().getRootTypeId());
        return type != null && rootTypes.contains(type);
    }

    @Nullable
    public String getUnloadedModuleNameForFile(@NotNull VirtualFile fileOrDir) {
        WorkspaceFileSetWithCustomData<UnloadedModuleContentRootData> fileSet;
        if (fileOrDir == null) {
            ProjectFileIndexImpl.$$$reportNull$$$0(38);
        }
        return (fileSet = this.myWorkspaceFileIndex.findFileSetWithCustomData(fileOrDir, false, true, true, false, false, false, UnloadedModuleContentRootData.class)) != null ? fileSet.getData().getModuleName() : null;
    }

    @Override
    protected boolean isScopeDisposed() {
        return this.myProject.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 13, 15, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectFileIndexImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findContainingLibraries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findContainingSdks";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesForFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntriesForFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceOrLibraryClassesRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterateContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingLibraries";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 31: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findContainingSdks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnderIgnored";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectOrExcluded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntriesForFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassRootForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContainingSourceRootType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInGeneratedSources";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootForFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootForFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameByDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isLibraryClassFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInSource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraryClasses";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceOrLibraryClassesRoot";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceOrLibraryClassesRoots";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInSourceContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isInTestSourceContent";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSourceRootOfType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isSourceRootOfType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleNameForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 13, 15, 31, 32 -> new IllegalStateException(string);
        };
    }
}

