/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.core.fileIndex.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.storage.EntityPointer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.workspaceModel.core.fileIndex.EntityStorageKind;
import com.intellij.workspaceModel.core.fileIndex.impl.FileTypeAssocTableUtil;
import com.intellij.workspaceModel.core.fileIndex.impl.MultipleStoredWorkspaceFileSets;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSetCollection;
import com.intellij.workspaceModel.core.fileIndex.impl.WorkspaceFileSetsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0003\u0005\u0006\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0016\u0082\u0001\u0003\b\t\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSet;", "add", "Lcom/intellij/workspaceModel/core/fileIndex/impl/StoredFileSetCollection;", "fileSet", "ByFileKind", "ByPattern", "ByCondition", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByCondition;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByFileKind;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByPattern;", "intellij.platform.projectModel.impl"})
public sealed interface ExcludedFileSet
extends StoredFileSet {
    @Override
    @NotNull
    default public StoredFileSetCollection add(@NotNull StoredFileSet fileSet) {
        Intrinsics.checkNotNullParameter((Object)fileSet, (String)"fileSet");
        Object[] objectArray = new StoredFileSet[]{this, fileSet};
        return new MultipleStoredWorkspaceFileSets(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByCondition;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "condition", "Lkotlin/Function1;", "", "entityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;Lcom/intellij/platform/workspace/storage/EntityPointer;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getCondition", "()Lkotlin/jvm/functions/Function1;", "getEntityPointer", "()Lcom/intellij/platform/workspace/storage/EntityPointer;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "isExcluded", "file", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "toString", "", "intellij.platform.projectModel.impl"})
    public static final class ByCondition
    implements ExcludedFileSet {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Function1<VirtualFile, Boolean> condition;
        @NotNull
        private final EntityPointer<WorkspaceEntity> entityPointer;
        @NotNull
        private final EntityStorageKind entityStorageKind;

        public ByCondition(@NotNull VirtualFile root, @NotNull Function1<? super VirtualFile, Boolean> condition, @NotNull EntityPointer<? extends WorkspaceEntity> entityPointer, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            Intrinsics.checkNotNullParameter(entityPointer, (String)"entityPointer");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.root = root;
            this.condition = condition;
            this.entityPointer = entityPointer;
            this.entityStorageKind = entityStorageKind;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final Function1<VirtualFile, Boolean> getCondition() {
            return this.condition;
        }

        @Override
        @NotNull
        public EntityPointer<WorkspaceEntity> getEntityPointer() {
            return this.entityPointer;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        private final boolean isExcluded(VirtualFile file) {
            VirtualFile current = file;
            while (!Intrinsics.areEqual((Object)current, (Object)this.root)) {
                if (((Boolean)this.condition.invoke((Object)current)).booleanValue()) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"getParent(...)");
            }
            return (Boolean)this.condition.invoke((Object)this.root);
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project, boolean honorExclusion, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            int withExclusion = honorExclusion && this.isExcluded(file) ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, 31) : currentMasks;
            return withExclusion | 2;
        }

        @Override
        @NotNull
        public String toString() {
            return "ExcludedFileSet.ByCondition{root=" + this.root + "}";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByFileKind;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "mask", "", "entityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "<init>", "(ILcom/intellij/platform/workspace/storage/EntityPointer;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getMask", "()I", "getEntityPointer", "()Lcom/intellij/platform/workspace/storage/EntityPointer;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "computeMasks", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "", "intellij.platform.projectModel.impl"})
    public static final class ByFileKind
    implements ExcludedFileSet {
        private final int mask;
        @NotNull
        private final EntityPointer<WorkspaceEntity> entityPointer;
        @NotNull
        private final EntityStorageKind entityStorageKind;

        public ByFileKind(int mask, @NotNull EntityPointer<? extends WorkspaceEntity> entityPointer, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter(entityPointer, (String)"entityPointer");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.mask = mask;
            this.entityPointer = entityPointer;
            this.entityStorageKind = entityStorageKind;
        }

        public /* synthetic */ ByFileKind(int n, EntityPointer entityPointer, EntityStorageKind entityStorageKind, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                entityStorageKind = EntityStorageKind.MAIN;
            }
            this(n, (EntityPointer<? extends WorkspaceEntity>)entityPointer, entityStorageKind);
        }

        public final int getMask() {
            return this.mask;
        }

        @Override
        @NotNull
        public EntityPointer<WorkspaceEntity> getEntityPointer() {
            return this.entityPointer;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project, boolean honorExclusion, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            int withExclusion = honorExclusion ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, this.mask) : currentMasks;
            return withExclusion | 2;
        }

        @Override
        @NotNull
        public String toString() {
            return "ExcludedFileSet.ByFileKind{mask=" + this.mask + "}";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet$ByPattern;", "Lcom/intellij/workspaceModel/core/fileIndex/impl/ExcludedFileSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "patterns", "", "", "entityPointer", "Lcom/intellij/platform/workspace/storage/EntityPointer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityStorageKind", "Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/intellij/platform/workspace/storage/EntityPointer;Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getEntityPointer", "()Lcom/intellij/platform/workspace/storage/EntityPointer;", "getEntityStorageKind", "()Lcom/intellij/workspaceModel/core/fileIndex/EntityStorageKind;", "table", "Lcom/intellij/openapi/fileTypes/impl/FileTypeAssocTable;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTable", "()Lcom/intellij/openapi/fileTypes/impl/FileTypeAssocTable;", "isExcluded", "file", "computeMasks", "", "currentMasks", "project", "Lcom/intellij/openapi/project/Project;", "honorExclusion", "toString", "intellij.platform.projectModel.impl"})
    public static final class ByPattern
    implements ExcludedFileSet {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final EntityPointer<WorkspaceEntity> entityPointer;
        @NotNull
        private final EntityStorageKind entityStorageKind;
        @NotNull
        private final FileTypeAssocTable<Boolean> table;

        public ByPattern(@NotNull VirtualFile root, @NotNull List<String> patterns, @NotNull EntityPointer<? extends WorkspaceEntity> entityPointer, @NotNull EntityStorageKind entityStorageKind) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
            Intrinsics.checkNotNullParameter(entityPointer, (String)"entityPointer");
            Intrinsics.checkNotNullParameter((Object)((Object)entityStorageKind), (String)"entityStorageKind");
            this.root = root;
            this.entityPointer = entityPointer;
            this.entityStorageKind = entityStorageKind;
            FileTypeAssocTable fileTypeAssocTable = FileTypeAssocTableUtil.newScalableFileTypeAssocTable();
            Intrinsics.checkNotNullExpressionValue(fileTypeAssocTable, (String)"newScalableFileTypeAssocTable(...)");
            this.table = fileTypeAssocTable;
            for (String pattern : patterns) {
                this.table.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(pattern), (Object)true);
            }
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @Override
        @NotNull
        public EntityPointer<WorkspaceEntity> getEntityPointer() {
            return this.entityPointer;
        }

        @Override
        @NotNull
        public EntityStorageKind getEntityStorageKind() {
            return this.entityStorageKind;
        }

        @NotNull
        public final FileTypeAssocTable<Boolean> getTable() {
            return this.table;
        }

        private final boolean isExcluded(VirtualFile file) {
            VirtualFile current = file;
            while (!Intrinsics.areEqual((Object)current, (Object)this.root)) {
                if (this.table.findAssociatedFileType(current.getNameSequence()) != null) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)current.getParent(), (String)"getParent(...)");
            }
            return false;
        }

        @Override
        public int computeMasks(int currentMasks, @NotNull Project project, boolean honorExclusion, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            int withExclusion = honorExclusion && this.isExcluded(file) ? WorkspaceFileSetsKt.access$unsetAcceptedKinds(currentMasks, 31) : currentMasks;
            return withExclusion | 2;
        }

        @Override
        @NotNull
        public String toString() {
            return "ExcludedFileSet.ByPattern{root=" + this.root + ", patterns=" + this.table + "}";
        }
    }
}

