/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.project.ProjectStoreOwner;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"getJpsProjectConfigLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "intellij.platform.projectModel.impl"})
public final class JpsProjectConfigLocationUtilKt {
    @ApiStatus.Internal
    @Nullable
    public static final JpsProjectConfigLocation getJpsProjectConfigLocation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JpsProjectConfigLocationUtilKt.getJpsProjectConfigLocation(project, WorkspaceModel.Companion.getInstance(project).getVirtualFileUrlManager());
    }

    @ApiStatus.Internal
    @Nullable
    public static final JpsProjectConfigLocation getJpsProjectConfigLocation(@NotNull Project project, @NotNull VirtualFileUrlManager virtualFileUrlManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        if (!(project instanceof ProjectStoreOwner)) {
            return null;
        }
        ProjectStoreDescriptor storeDescriptor = ((ProjectStoreOwner)project).getComponentStore().getStoreDescriptor();
        Path dotIdea = storeDescriptor.getDotIdea();
        if (dotIdea == null) {
            String string = VfsUtilCore.pathToUrl((String)PathsKt.getInvariantSeparatorsPathString((Path)storeDescriptor.getPresentableUrl()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
            String projectFileUrl = string;
            VirtualFileUrl iprFile = virtualFileUrlManager.getOrCreateFromUrl(projectFileUrl);
            VirtualFileUrl virtualFileUrl = iprFile.getParent();
            Intrinsics.checkNotNull((Object)virtualFileUrl);
            return (JpsProjectConfigLocation)new JpsProjectConfigLocation.FileBased(iprFile, virtualFileUrl);
        }
        VirtualFileUrl ideaFolder = VirtualFileUrlImplKt.toVirtualFileUrl((Path)dotIdea, (VirtualFileUrlManager)virtualFileUrlManager);
        String string = VfsUtilCore.pathToUrl((String)PathsKt.getInvariantSeparatorsPathString((Path)storeDescriptor.getHistoricalProjectBasePath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathToUrl(...)");
        String baseUrl = string;
        return (JpsProjectConfigLocation)new JpsProjectConfigLocation.DirectoryBased(virtualFileUrlManager.getOrCreateFromUrl(baseUrl), ideaFolder);
    }
}

