/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.FacetEntityTypeId;
import com.intellij.platform.workspace.jps.entities.FacetId;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger;", "", "<init>", "()V", "entityToTrace", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "subscribe", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "printInfoAboutTracedEntity", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "storageDescription", "", "printInfo", "action", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Companion", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEntityTracingLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityTracingLogger.kt\ncom/intellij/workspaceModel/ide/impl/EntityTracingLogger\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n13#2:71\n*S KotlinDebug\n*F\n+ 1 EntityTracingLogger.kt\ncom/intellij/workspaceModel/ide/impl/EntityTracingLogger\n*L\n61#1:71\n*E\n"})
public final class EntityTracingLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final SymbolicEntityId<WorkspaceEntityWithSymbolicId> entityToTrace;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public EntityTracingLogger() {
        SymbolicEntityId symbolicEntityId;
        EntityTracingLogger entityTracingLogger = this;
        String string = System.getProperty("idea.workspace.model.track.entity.id");
        if (string != null) {
            SymbolicEntityId symbolicEntityId2;
            void it;
            String string2 = string;
            EntityTracingLogger entityTracingLogger2 = entityTracingLogger;
            boolean bl = false;
            char[] cArray = new char[]{'/'};
            List tokens = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            switch (tokens.size()) {
                case 3: {
                    String moduleName = (String)tokens.get(0);
                    String facetTypeId = (String)tokens.get(1);
                    String facetName = (String)tokens.get(2);
                    symbolicEntityId2 = (SymbolicEntityId)new FacetId(facetName, new FacetEntityTypeId(facetTypeId), new ModuleId(moduleName));
                    break;
                }
                case 1: {
                    symbolicEntityId2 = (SymbolicEntityId)new ModuleId((String)CollectionsKt.first((List)tokens));
                    break;
                }
                default: {
                    symbolicEntityId2 = null;
                }
            }
            symbolicEntityId = symbolicEntityId2;
            entityTracingLogger = entityTracingLogger2;
        } else {
            symbolicEntityId = null;
        }
        entityTracingLogger.entityToTrace = symbolicEntityId;
    }

    public final void subscribe(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        if (this.entityToTrace != null) {
            BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, this, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ EntityTracingLogger this$0;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = WorkspaceModel.Companion.getInstance(this.$project).getEventLog().collect(new FlowCollector(this.this$0){
                                final /* synthetic */ EntityTracingLogger this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object emit(VersionedStorageChange event, Continuation<? super Unit> $completion) {
                                    void $this$forEach$iv;
                                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.VersionedStorageChangeInternal");
                                    Sequence sequence = ((VersionedStorageChangeInternal)event).getAllChanges();
                                    EntityTracingLogger entityTracingLogger = this.this$0;
                                    boolean $i$f$forEach = false;
                                    for (E element$iv : $this$forEach$iv) {
                                        EntityChange it = (EntityChange)element$iv;
                                        boolean bl = false;
                                        EntityChange entityChange = it;
                                        if (entityChange instanceof EntityChange.Added) {
                                            EntityTracingLogger.access$printInfo(entityTracingLogger, "added", ((EntityChange.Added)it).getNewEntity());
                                            continue;
                                        }
                                        if (entityChange instanceof EntityChange.Removed) {
                                            EntityTracingLogger.access$printInfo(entityTracingLogger, "removed", ((EntityChange.Removed)it).getOldEntity());
                                            continue;
                                        }
                                        if (entityChange instanceof EntityChange.Replaced) {
                                            EntityTracingLogger.access$printInfo(entityTracingLogger, "replaced from", ((EntityChange.Replaced)it).getOldEntity());
                                            EntityTracingLogger.access$printInfo(entityTracingLogger, "replaced to", ((EntityChange.Replaced)it).getNewEntity());
                                            continue;
                                        }
                                        throw new NoWhenBranchMatchedException();
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void printInfoAboutTracedEntity(@NotNull EntityStorage storage, @NotNull String storageDescription) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)storageDescription, (String)"storageDescription");
        if (this.entityToTrace != null) {
            WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = storage.resolve(this.entityToTrace);
            LOG.info("Traced entity from " + storageDescription + ": " + (workspaceEntityWithSymbolicId != null ? EntityTracingLogger.Companion.toDebugString((WorkspaceEntity)workspaceEntityWithSymbolicId) : null));
        }
    }

    private final void printInfo(String action, WorkspaceEntity entity) {
        WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId = entity instanceof WorkspaceEntityWithSymbolicId ? (WorkspaceEntityWithSymbolicId)entity : null;
        if (Intrinsics.areEqual((Object)(workspaceEntityWithSymbolicId != null ? workspaceEntityWithSymbolicId.getSymbolicId() : null), this.entityToTrace)) {
            LOG.info(action + ": " + EntityTracingLogger.Companion.toDebugString(entity), new Throwable());
        }
    }

    public static final /* synthetic */ void access$printInfo(EntityTracingLogger $this, String action, WorkspaceEntity entity) {
        $this.printInfo(action, entity);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EntityTracingLogger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/workspaceModel/ide/impl/EntityTracingLogger$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "toDebugString", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final String toDebugString(WorkspaceEntity $this$toDebugString) {
            WorkspaceEntity workspaceEntity = $this$toDebugString;
            return workspaceEntity instanceof FacetEntity ? "Facet: " + ((FacetEntity)$this$toDebugString).getConfigurationXmlTag() : (workspaceEntity instanceof ModuleEntity ? "Module " + ((ModuleEntity)$this$toDebugString).getName() : $this$toDebugString.getClass().getSimpleName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

