/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.module.impl.ModulePointerImpl;
import com.intellij.openapi.module.impl.ModuleRenamingHistoryState;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="ModuleRenamingHistory", storages={@Storage(value="modules.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u001a\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0014J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\"H\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\rH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\rH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u0010\u001aJ\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n \u0012*#\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n0\u0014\u00a2\u0006\u0002\b\u00130\u0011\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/module/impl/ModulePointerManagerImpl;", "Lcom/intellij/openapi/module/ModulePointerManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/module/impl/ModuleRenamingHistoryState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "unresolved", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/openapi/module/impl/ModulePointerImpl;", "pointers", "Lcom/intellij/openapi/module/Module;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "oldToNewName", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getState", "loadState", "", "state", "setRenamingScheme", "renamingScheme", "updateUnresolvedPointers", "oldName", "newName", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "modulesAppears", "modules", "", "registerPointer", "module", "pointer", "unregisterPointer", "create", "Lcom/intellij/openapi/module/ModulePointer;", "moduleName", "intellij.platform.projectModel.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nModulePointerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModulePointerManagerImpl.kt\ncom/intellij/openapi/module/impl/ModulePointerManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1869#2,2:177\n1869#2,2:179\n1869#2,2:181\n1869#2,2:183\n1869#2,2:186\n295#2,2:188\n1#3:185\n*S KotlinDebug\n*F\n+ 1 ModulePointerManagerImpl.kt\ncom/intellij/openapi/module/impl/ModulePointerManagerImpl\n*L\n72#1:177,2\n86#1:179,2\n102#1:181,2\n117#1:183,2\n137#1:186,2\n165#1:188,2\n*E\n"})
public final class ModulePointerManagerImpl
extends ModulePointerManager
implements PersistentStateComponent<ModuleRenamingHistoryState> {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<String, ModulePointerImpl> unresolved;
    @NotNull
    private final MultiMap<Module, ModulePointerImpl> pointers;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Map<String, String> oldToNewName;

    public ModulePointerManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.unresolved = new MultiMap();
        this.pointers = new MultiMap();
        this.lock = new ReentrantReadWriteLock();
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSmallMemoryFootprintMap(...)");
        this.oldToNewName = map;
        SimpleMessageBusConnection simpleMessageBusConnection = this.project.getMessageBus().simpleConnect();
        Topic topic = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ModuleListener(){

            public void beforeModuleRemoved(Project project, Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                this.unregisterPointer(module);
            }

            public void modulesAdded(Project project, List<? extends Module> modules) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                this.modulesAppears(modules);
            }

            /*
             * WARNING - void declaration
             */
            public void modulesRenamed(Project project, List<? extends Module> modules, Function<? super Module, String> oldNameProvider) {
                void $this$associateByTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                this.modulesAppears(modules);
                Iterable $this$associateBy$iv = modules;
                boolean bl = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    Module module = (Module)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl2 = false;
                    Module it = (Module)element$iv$iv;
                    String string = (String)oldNameProvider.fun((Object)it);
                    boolean bl22 = false;
                    String string2 = it.getName();
                    map.put(string, string2);
                }
                Map renamedOldToNew = destination$iv$iv;
                for (Map.Entry entry : oldToNewName.entrySet()) {
                    String newValue = (String)renamedOldToNew.get(entry.getValue());
                    if (newValue == null) continue;
                    entry.setValue(newValue);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModuleRenamingHistoryState getState() {
        ModuleRenamingHistoryState moduleRenamingHistoryState;
        ModuleRenamingHistoryState $this$getState_u24lambda_u240 = moduleRenamingHistoryState = new ModuleRenamingHistoryState();
        boolean bl = false;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            $this$getState_u24lambda_u240.oldToNewName.putAll(this.oldToNewName);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return moduleRenamingHistoryState;
    }

    public void loadState(@NotNull ModuleRenamingHistoryState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.setRenamingScheme((Map<String, String>)state.oldToNewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRenamingScheme(@NotNull Map<String, String> renamingScheme) {
        Intrinsics.checkNotNullParameter(renamingScheme, (String)"renamingScheme");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.oldToNewName.clear();
            this.oldToNewName.putAll(renamingScheme);
            ModuleManager moduleManager = ModuleManager.Companion.getInstance(this.project);
            Iterable $this$forEach$iv = renamingScheme.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                String oldName = (String)entry.getKey();
                String newName = (String)entry.getValue();
                Module oldModule = moduleManager.findModuleByName(oldName);
                if (oldModule != null) {
                    this.unregisterPointer(oldModule);
                }
                this.updateUnresolvedPointers(oldName, newName, moduleManager);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void updateUnresolvedPointers(String oldName, String newName, ModuleManager moduleManager) {
        block2: {
            Collection pointers;
            Collection collection = pointers = this.unresolved.remove((Object)oldName);
            if (collection == null) break block2;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModulePointerImpl pointer = (ModulePointerImpl)element$iv;
                boolean bl = false;
                pointer.renameUnresolved$intellij_platform_projectModel_impl(newName);
                Module module = moduleManager.findModuleByName(newName);
                if (module != null) {
                    pointer.moduleAdded$intellij_platform_projectModel_impl(module);
                    Intrinsics.checkNotNull((Object)pointer);
                    this.registerPointer(module, pointer);
                    continue;
                }
                this.unresolved.putValue((Object)newName, (Object)pointer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modulesAppears(List<? extends Module> modules) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            for (Module module : modules) {
                Collection collection = this.unresolved.remove((Object)module.getName());
                if (collection == null) continue;
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    boolean bl2 = false;
                    it.moduleAdded$intellij_platform_projectModel_impl(module);
                    Intrinsics.checkNotNull((Object)it);
                    this.registerPointer(module, it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private final void registerPointer(Module module, ModulePointerImpl pointer) {
        this.pointers.putValue((Object)module, (Object)pointer);
        Disposer.register((Disposable)((Disposable)module), () -> ModulePointerManagerImpl.registerPointer$lambda$0(this, module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unregisterPointer(Module module) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Unit unit;
            boolean bl = false;
            Collection collection = this.pointers.remove((Object)module);
            if (collection != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ModulePointerImpl it = (ModulePointerImpl)element$iv;
                    boolean bl2 = false;
                    it.moduleRemoved$intellij_platform_projectModel_impl(module);
                    this.unresolved.putValue((Object)it.getModuleName(), (Object)it);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ModulePointer create(@NotNull Module module) {
        ModulePointer modulePointer;
        ModulePointerImpl modulePointerImpl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Serializable serializable = this.lock.readLock();
        ((ReentrantReadWriteLock.ReadLock)serializable).lock();
        try {
            boolean bl = false;
            Collection collection = this.pointers.get((Object)module);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            object = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
            modulePointerImpl = object;
        }
        finally {
            ((ReentrantReadWriteLock.ReadLock)serializable).unlock();
        }
        if (modulePointerImpl != null) {
            modulePointer = modulePointerImpl;
        } else {
            ModulePointerImpl modulePointerImpl2;
            serializable = this.lock;
            object = ((ReentrantReadWriteLock)serializable).readLock();
            int n = ((ReentrantReadWriteLock)serializable).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)serializable).getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                ((ReentrantReadWriteLock.ReadLock)object).unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)serializable).writeLock();
            writeLock.lock();
            try {
                ModulePointerImpl modulePointerImpl3;
                boolean bl = false;
                Collection collection = this.pointers.get((Object)module);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                ModulePointerImpl modulePointerImpl4 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
                if (modulePointerImpl4 != null) {
                    ModulePointerImpl it = modulePointerImpl4;
                    boolean bl2 = false;
                    ModulePointer modulePointer2 = it;
                    return modulePointer2;
                }
                Collection pointers = this.unresolved.remove((Object)module.getName());
                Collection collection2 = pointers;
                if (collection2 == null || collection2.isEmpty()) {
                    ModulePointerImpl pointer = new ModulePointerImpl(module, this.lock);
                    this.registerPointer(module, pointer);
                    modulePointerImpl3 = pointer;
                } else {
                    Iterable $this$forEach$iv = pointers;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ModulePointerImpl it = (ModulePointerImpl)element$iv;
                        boolean bl3 = false;
                        it.moduleAdded$intellij_platform_projectModel_impl(module);
                        Intrinsics.checkNotNull((Object)it);
                        this.registerPointer(module, it);
                    }
                    modulePointerImpl3 = (ModulePointerImpl)CollectionsKt.first((Iterable)pointers);
                }
                ModulePointerImpl modulePointerImpl5 = modulePointerImpl3;
                modulePointerImpl2 = modulePointerImpl5;
            }
            finally {
                for (int it = 0; it < n; ++it) {
                    ((ReentrantReadWriteLock.ReadLock)object).lock();
                }
                writeLock.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)modulePointerImpl2, (String)"write(...)");
            modulePointer = modulePointerImpl2;
        }
        return modulePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ModulePointer create(@NotNull String moduleName) {
        Module module;
        String $i$a$-read-ModulePointerManagerImpl$create$newName$22;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Module module2 = ModuleManager.Companion.getInstance(this.project).findModuleByName(moduleName);
        if (module2 != null) {
            Module it = module2;
            return this.create(it);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean $i$a$-read-ModulePointerManagerImpl$create$newName$22 = false;
            $i$a$-read-ModulePointerManagerImpl$create$newName$22 = this.oldToNewName.get(moduleName);
        }
        finally {
            readLock.unlock();
        }
        String newName = $i$a$-read-ModulePointerManagerImpl$create$newName$22;
        if (newName != null && (module = ModuleManager.Companion.getInstance(this.project).findModuleByName(newName)) != null) {
            Module it = module;
            return this.create(it);
        }
        readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Collection collection = this.unresolved.get((Object)moduleName);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            ModulePointerImpl modulePointerImpl = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection);
            if (modulePointerImpl == null) {
                ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
                ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock2.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    Object v5;
                    block23: {
                        boolean bl2 = false;
                        Collection collection2 = this.unresolved.get((Object)moduleName);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                        ModulePointerImpl modulePointerImpl2 = (ModulePointerImpl)CollectionsKt.firstOrNull((Iterable)collection2);
                        if (modulePointerImpl2 != null) {
                            ModulePointerImpl it = modulePointerImpl2;
                            boolean bl3 = false;
                            ModulePointer modulePointer = it;
                            ModulePointer modulePointer2 = modulePointer;
                            return modulePointer2;
                        }
                        Set set = this.pointers.keySet();
                        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
                        Iterable $this$firstOrNull$iv = set;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Module it = (Module)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)moduleName)) continue;
                            v5 = element$iv;
                            break block23;
                        }
                        v5 = null;
                    }
                    Module module3 = v5;
                    if (module3 != null) {
                        Module it = module3;
                        boolean bl5 = false;
                        ModulePointer modulePointer = this.create(it);
                        ModulePointer modulePointer3 = modulePointer;
                        return modulePointer3;
                    }
                    ModulePointerImpl pointer = new ModulePointerImpl(moduleName, this.lock);
                    this.unresolved.putValue((Object)moduleName, (Object)pointer);
                    ModulePointerImpl modulePointerImpl3 = pointer;
                    modulePointerImpl = modulePointerImpl3;
                }
                finally {
                    int it = 0;
                    while (true) {
                        if (it >= n) {
                            writeLock.unlock();
                        }
                        readLock2.lock();
                        ++it;
                    }
                }
            }
            ModulePointerImpl modulePointerImpl4 = modulePointerImpl;
            return modulePointerImpl4;
        }
        finally {
            readLock.unlock();
        }
    }

    private static final void registerPointer$lambda$0(ModulePointerManagerImpl this$0, Module $module) {
        this$0.unregisterPointer($module);
    }
}

