/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntityBuilder;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import com.intellij.platform.workspace.jps.entities.Library_extensionsKt;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.impl.GlobalWorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeModifiableBase;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryOrigin;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryStateSnapshot;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryModifiableModelBridge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 x2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001xB;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 H\u0016J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010#J\n\u0010$\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\u000e\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'H\u0016J\u0013\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\u001aH\u0016\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\"H\u0016J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\"H\u0016J\b\u0010/\u001a\u00020-H\u0016J\b\u00100\u001a\u00020-H\u0016J!\u00104\u001a\u00020-2\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020-06\u00a2\u0006\u0002\b8H\u0002J\u0010\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;H\u0016J\u001e\u0010<\u001a\u00020-2\b\u0010=\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010?\u001a\u00020\u000eH\u0016J\u0014\u0010@\u001a\u00020\u000e*\u00020A2\u0006\u0010B\u001a\u00020AH\u0002J\u0014\u0010@\u001a\u00020\u000e*\u00020C2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020-2\u0006\u0010+\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u000eH\u0016J \u0010D\u001a\u00020-2\u0006\u0010+\u001a\u00020\"2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010D\u001a\u00020-2\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020\u000eH\u0016J \u0010D\u001a\u00020-2\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010G\u001a\u00020-2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010H\u001a\u00020-2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010I\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020-2\u0006\u0010+\u001a\u00020\"H\u0016J\u0018\u0010N\u001a\u00020-2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010N\u001a\u00020-2\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010O\u001a\u00020-2\f\u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010'H\u0016J\u0016\u0010Q\u001a\u00020-2\f\u0010R\u001a\b\u0012\u0002\b\u0003\u0018\u00010 H\u0016J\b\u0010S\u001a\u00020-H\u0016J\b\u0010T\u001a\u00020-H\u0016J\u001e\u0010U\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0XH\u0002J\u0018\u0010Z\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010[\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\"H\u0016J\b\u0010]\u001a\u00020-H\u0016J\b\u0010^\u001a\u00020\u000eH\u0016J\b\u0010_\u001a\u00020\"H\u0016J\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\"0a2\u0006\u0010R\u001a\u00020\u001dH\u0016J\u0013\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0002\u0010cJ\n\u0010d\u001a\u0004\u0018\u00010eH\u0016J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0016J\u0018\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0016J\n\u0010m\u001a\u0004\u0018\u00010;H\u0016J\b\u0010n\u001a\u00020oH\u0016J\b\u0010p\u001a\u00020LH\u0016J\b\u0010q\u001a\u00020rH\u0016J\b\u0010s\u001a\u00020\u0003H\u0016J\u0012\u0010t\u001a\u00020g2\b\u0010u\u001a\u0004\u0018\u00010vH\u0016J\u0012\u0010w\u001a\u00020g2\b\u0010u\u001a\u0004\u0018\u00010vH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u00101\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u000e\u0010\\\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl;", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/LegacyBridgeModifiableBase;", "Lcom/intellij/workspaceModel/ide/legacyBridge/LibraryModifiableModelBridge;", "Lcom/intellij/openapi/roots/RootProvider;", "originalLibrary", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;", "originalLibrarySnapshot", "Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;", "diff", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "targetBuilder", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "cacheStorageResult", "", "<init>", "(Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryBridgeImpl;Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/platform/workspace/storage/MutableEntityStorage;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;Z)V", "entityId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "reloadKind", "currentLibraryValue", "Lcom/intellij/platform/workspace/storage/CachedValue;", "currentLibrary", "getCurrentLibrary", "()Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryStateSnapshot;", "getFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "(Lcom/intellij/openapi/roots/OrderRootType;)[Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getUrls", "", "(Lcom/intellij/openapi/roots/OrderRootType;)[Ljava/lang/String;", "getName", "getPresentableName", "getProperties", "Lcom/intellij/openapi/roots/libraries/LibraryProperties;", "getExcludedRootUrls", "()[Ljava/lang/String;", "isJarDirectory", "url", "setName", "", "name", "commit", "prepareForCommit", "libraryId", "getLibraryId", "()Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "update", "updater", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntityBuilder;", "Lkotlin/ExtensionFunctionType;", "setExternalSource", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "updateProperties", "libraryType", "propertiesXmlTag", "isChanged", "hasEqualProperties", "Lcom/intellij/platform/workspace/jps/entities/LibraryEntity;", "another", "Lcom/intellij/platform/workspace/jps/entities/LibraryPropertiesEntity;", "addJarDirectory", "recursive", "file", "moveRootUp", "moveRootDown", "isValid", "hasSameContent", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "addExcludedRoot", "addRoot", "setProperties", "properties", "setKind", "type", "forgetKind", "restoreKind", "isUnderRoots", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "roots", "", "Lcom/intellij/platform/workspace/jps/entities/LibraryRoot;", "removeRoot", "removeExcludedRoot", "disposed", "dispose", "isDisposed", "toString", "getInvalidRootUrls", "", "getExcludedRoots", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getModule", "Lcom/intellij/openapi/module/Module;", "addRootSetChangedListener", "", "listener", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "removeRootSetChangedListener", "getExternalSource", "getModifiableModel", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx$ModifiableModelEx;", "getSource", "getTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "getRootProvider", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "Companion", "intellij.platform.projectModel.impl"})
@SourceDebugExtension(value={"SMAP\nLibraryModifiableModelBridgeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryModifiableModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,424:1\n1563#2:425\n1634#2,3:426\n827#2:429\n855#2,2:430\n1869#2,2:432\n360#2,7:435\n388#2,7:442\n360#2,7:449\n360#2,7:456\n1563#2:463\n1634#2,3:464\n1#3:434\n13#4:467\n*S KotlinDebug\n*F\n+ 1 LibraryModifiableModelBridgeImpl.kt\ncom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl\n*L\n341#1:425\n341#1:426,3\n355#1:429\n355#1:430,2\n355#1:432,2\n221#1:435,7\n223#1:442,7\n238#1:449,7\n240#1:456,7\n269#1:463\n269#1:464,3\n421#1:467\n*E\n"})
public final class LibraryModifiableModelBridgeImpl
extends LegacyBridgeModifiableBase
implements LibraryModifiableModelBridge,
RootProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LibraryBridgeImpl originalLibrary;
    @NotNull
    private final LibraryStateSnapshot originalLibrarySnapshot;
    @Nullable
    private final MutableEntityStorage targetBuilder;
    @NotNull
    private final VirtualFileUrlManager virtualFileManager;
    @NotNull
    private LibraryId entityId;
    private boolean reloadKind;
    @NotNull
    private final CachedValue<LibraryStateSnapshot> currentLibraryValue;
    private boolean disposed;
    @NotNull
    private static final Logger LOG;

    public LibraryModifiableModelBridgeImpl(@NotNull LibraryBridgeImpl originalLibrary, @NotNull LibraryStateSnapshot originalLibrarySnapshot, @NotNull MutableEntityStorage diff, @Nullable MutableEntityStorage targetBuilder, @NotNull VirtualFileUrlManager virtualFileManager, boolean cacheStorageResult) {
        Intrinsics.checkNotNullParameter((Object)originalLibrary, (String)"originalLibrary");
        Intrinsics.checkNotNullParameter((Object)originalLibrarySnapshot, (String)"originalLibrarySnapshot");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        super(diff, cacheStorageResult);
        this.originalLibrary = originalLibrary;
        this.originalLibrarySnapshot = originalLibrarySnapshot;
        this.targetBuilder = targetBuilder;
        this.virtualFileManager = virtualFileManager;
        this.entityId = this.originalLibrarySnapshot.getLibraryEntity().getSymbolicId();
        this.currentLibraryValue = new CachedValue(arg_0 -> LibraryModifiableModelBridgeImpl.currentLibraryValue$lambda$0(this, arg_0));
    }

    public /* synthetic */ LibraryModifiableModelBridgeImpl(LibraryBridgeImpl libraryBridgeImpl, LibraryStateSnapshot libraryStateSnapshot, MutableEntityStorage mutableEntityStorage, MutableEntityStorage mutableEntityStorage2, VirtualFileUrlManager virtualFileUrlManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        this(libraryBridgeImpl, libraryStateSnapshot, mutableEntityStorage, mutableEntityStorage2, virtualFileUrlManager, bl);
    }

    private final LibraryStateSnapshot getCurrentLibrary() {
        return (LibraryStateSnapshot)this.getEntityStorageOnDiff().cachedValue(this.currentLibraryValue);
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().getFiles(rootType);
    }

    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.getCurrentLibrary().getKind();
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().getUrls(rootType);
    }

    @Nullable
    public String getName() {
        return this.getCurrentLibrary().getName();
    }

    @NotNull
    public String getPresentableName() {
        return LibraryBridgeImpl.Companion.getPresentableName$intellij_platform_projectModel_impl(this);
    }

    @Nullable
    public LibraryProperties<?> getProperties() {
        return this.getCurrentLibrary().getProperties();
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        return this.getCurrentLibrary().getExcludedRootUrls();
    }

    public boolean isJarDirectory(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getCurrentLibrary().isJarDirectory(url);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().isJarDirectory(url, rootType);
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertModelIsLive();
        LibraryEntity entity = this.getCurrentLibrary().getLibraryEntity();
        if (Intrinsics.areEqual((Object)entity.getName(), (Object)name)) {
            return;
        }
        if (this.getCurrentLibrary().getLibraryTable().getLibraryByName(name) != null) {
            throw new IllegalStateException(("Library named " + name + " already exists").toString());
        }
        this.entityId = LibraryId.copy$default((LibraryId)entity.getSymbolicId(), (String)name, null, (int)2, null);
        LibraryEntityModifications.modifyLibraryEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)entity, arg_0 -> LibraryModifiableModelBridgeImpl.setName$lambda$0(name, arg_0));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !Intrinsics.areEqual((Object)this.getCurrentLibrary().getName(), (Object)name)) {
            throw new IllegalStateException(("setName: expected library name " + name + ", but got " + this.getCurrentLibrary().getName() + ". Original name: " + this.originalLibrarySnapshot.getName()).toString());
        }
    }

    public void commit() {
        this.assertModelIsLive();
        this.setModelIsCommittedOrDisposed(true);
        if (this.reloadKind) {
            this.originalLibrary.cleanCachedValue$intellij_platform_projectModel_impl();
        }
        if (this.isChanged()) {
            if (this.targetBuilder != null) {
                if (this.targetBuilder != this.getDiff()) {
                    this.targetBuilder.applyChangesFrom(this.getDiff());
                }
            } else {
                LibraryOrigin o = this.originalLibrary.getOrigin();
                if (o instanceof LibraryOrigin.OfProject) {
                    WorkspaceModel.Companion.getInstance(((LibraryOrigin.OfProject)o).getProject()).updateProjectModel("Library model commit", arg_0 -> LibraryModifiableModelBridgeImpl.commit$lambda$0(this, arg_0));
                } else if (o instanceof LibraryOrigin.OfMachine) {
                    GlobalWorkspaceModel.Companion.getInstance(((LibraryOrigin.OfMachine)o).getEelMachine()).updateModel("Library model commit", (Function1<? super MutableEntityStorage, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.commit$lambda$1(this, arg_0)));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.originalLibrary.setEntityId(this.entityId);
            this.originalLibrary.fireRootSetChanged$intellij_platform_projectModel_impl();
        }
    }

    @Override
    public void prepareForCommit() {
        this.assertModelIsLive();
        this.setModelIsCommittedOrDisposed(true);
        if (this.reloadKind) {
            this.originalLibrary.cleanCachedValue$intellij_platform_projectModel_impl();
        }
        if (this.isChanged()) {
            this.originalLibrary.setEntityId(this.entityId);
        }
    }

    @Override
    @NotNull
    public LibraryId getLibraryId() {
        return this.entityId;
    }

    private final void update(Function1<? super LibraryEntityBuilder, Unit> updater) {
        LibraryEntityModifications.modifyLibraryEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)this.getCurrentLibrary().getLibraryEntity(), updater);
    }

    public void setExternalSource(@NotNull ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)externalSource, (String)"externalSource");
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.setExternalSource$lambda$0(externalSource, this, arg_0)));
    }

    private final void updateProperties(String libraryType, String propertiesXmlTag) {
        LibraryEntity entity = this.getCurrentLibrary().getLibraryEntity();
        LibraryPropertiesEntity properties = Library_extensionsKt.getLibraryProperties((LibraryEntity)entity);
        if (libraryType == null) {
            if (properties != null) {
                this.getDiff().removeEntity((WorkspaceEntity)properties);
            }
            v0 = Unit.INSTANCE;
        } else {
            v0 = properties == null ? LibraryEntityModifications.modifyLibraryEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)this.getCurrentLibrary().getLibraryEntity(), arg_0 -> LibraryModifiableModelBridgeImpl.updateProperties$lambda$0(entity, propertiesXmlTag, arg_0)) : LibraryPropertiesEntityModifications.modifyLibraryPropertiesEntity((MutableEntityStorage)this.getDiff(), (LibraryPropertiesEntity)properties, arg_0 -> LibraryModifiableModelBridgeImpl.updateProperties$lambda$1(propertiesXmlTag, arg_0));
        }
        LibraryEntityModifications.modifyLibraryEntity((MutableEntityStorage)this.getDiff(), (LibraryEntity)entity, arg_0 -> LibraryModifiableModelBridgeImpl.updateProperties$lambda$2(libraryType, arg_0));
    }

    static /* synthetic */ void updateProperties$default(LibraryModifiableModelBridgeImpl libraryModifiableModelBridgeImpl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        libraryModifiableModelBridgeImpl.updateProperties(string, string2);
    }

    public boolean isChanged() {
        if (!this.hasEqualProperties(this.originalLibrarySnapshot.getLibraryEntity(), this.getCurrentLibrary().getLibraryEntity())) {
            return true;
        }
        LibraryPropertiesEntity p1 = Library_extensionsKt.getLibraryProperties((LibraryEntity)this.originalLibrarySnapshot.getLibraryEntity());
        LibraryPropertiesEntity p2 = Library_extensionsKt.getLibraryProperties((LibraryEntity)this.getCurrentLibrary().getLibraryEntity());
        return !(p1 == null && p2 == null || p1 != null && p2 != null && this.hasEqualProperties(p1, p2));
    }

    private final boolean hasEqualProperties(LibraryEntity $this$hasEqualProperties, LibraryEntity another) {
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getTableId(), (Object)another.getTableId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getTypeId(), (Object)another.getTypeId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getName(), (Object)another.getName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)$this$hasEqualProperties.getRoots(), (Object)another.getRoots())) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$hasEqualProperties.getExcludedRoots(), (Object)another.getExcludedRoots());
    }

    private final boolean hasEqualProperties(LibraryPropertiesEntity $this$hasEqualProperties, LibraryPropertiesEntity another) {
        return Intrinsics.areEqual((Object)$this$hasEqualProperties.getPropertiesXmlTag(), (Object)another.getPropertiesXmlTag());
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        OrderRootType orderRootType = OrderRootType.CLASSES;
        Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"CLASSES");
        this.addJarDirectory(url, recursive, orderRootType);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        LibraryRootTypeId rootTypeId = LibraryBridgeImpl.Companion.toLibraryRootType(rootType);
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        LibraryRoot.InclusionOptions inclusionOptions = recursive ? LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT_RECURSIVELY : LibraryRoot.InclusionOptions.ARCHIVES_UNDER_ROOT;
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.addJarDirectory$lambda$0(virtualFileUrl, rootTypeId, inclusionOptions, arg_0)));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied()) {
            LibraryStateSnapshot libraryStateSnapshot = this.getCurrentLibrary();
            String string = virtualFileUrl.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            if (!libraryStateSnapshot.isJarDirectory(string, rootType)) {
                throw new IllegalStateException(("addJarDirectory: expected jarDirectory exists for url '" + virtualFileUrl.getUrl() + "'").toString());
            }
        }
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        this.addJarDirectory(string, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        this.addJarDirectory(string, recursive, rootType);
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.moveRootUp$lambda$0(virtualFileUrl, rootType, arg_0)));
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.moveRootDown$lambda$0(virtualFileUrl, rootType, arg_0)));
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        return this.getCurrentLibrary().isValid(url, rootType);
    }

    public boolean hasSameContent(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (this == library) {
            return true;
        }
        if (!(library instanceof LibraryBridgeImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((LibraryBridgeImpl)library).getName())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getKind(), ((LibraryBridgeImpl)library).getKind())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getProperties(), ((LibraryBridgeImpl)library).getProperties())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getCurrentLibrary().getLibraryEntity().getRoots(), (Object)((LibraryBridgeImpl)library).getLibrarySnapshot$intellij_platform_projectModel_impl().getLibraryEntity().getRoots())) {
            return false;
        }
        return Arrays.equals(this.getExcludedRoots(), ((LibraryBridgeImpl)library).getExcludedRoots());
    }

    public void addExcludedRoot(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.addExcludedRoot$lambda$0(virtualFileUrl, arg_0)));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !ArraysKt.contains((Object[])this.getCurrentLibrary().getExcludedRootUrls(), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("addExcludedRoot: expected excluded urls contain url '" + virtualFileUrl.getUrl() + "'").toString());
        }
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        LibraryRoot root = new LibraryRoot(virtualFileUrl, LibraryBridgeImpl.Companion.toLibraryRootType(rootType), null, 4, null);
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.addRoot$lambda$0(root, arg_0)));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("addRoot: expected urls for root type '" + rootType.name() + "' contain url '" + virtualFileUrl.getUrl() + "'").toString());
        }
    }

    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        this.addRoot(string, rootType);
    }

    public void setProperties(@Nullable LibraryProperties<?> properties) {
        this.assertModelIsLive();
        if (Intrinsics.areEqual(this.getCurrentLibrary().getProperties(), properties)) {
            return;
        }
        PersistentLibraryKind<?> kind = this.getCurrentLibrary().getKind();
        if (kind == null) {
            if (properties != null && !(properties instanceof DummyLibraryProperties)) {
                LOG.error("Setting properties with null kind is unsupported");
            }
            return;
        }
        this.updateProperties(kind.getKindId(), LegacyBridgeModifiableBase.Companion.serializeComponentAsString("properties", (PersistentStateComponent)properties));
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && !Intrinsics.areEqual(this.getCurrentLibrary().getProperties(), properties)) {
            throw new IllegalStateException("setProperties: properties are not equal after changing".toString());
        }
    }

    public void setKind(@Nullable PersistentLibraryKind<?> type) {
        this.assertModelIsLive();
        if (Intrinsics.areEqual(this.getKind(), type)) {
            return;
        }
        PersistentLibraryKind<?> persistentLibraryKind = type;
        LibraryModifiableModelBridgeImpl.updateProperties$default(this, persistentLibraryKind != null ? persistentLibraryKind.getKindId() : null, null, 2, null);
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied()) {
            PersistentLibraryKind<?> persistentLibraryKind2 = this.getCurrentLibrary().getKind();
            PersistentLibraryKind<?> persistentLibraryKind3 = type;
            if (!Intrinsics.areEqual((Object)(persistentLibraryKind2 != null ? persistentLibraryKind2.getKindId() : null), (Object)(persistentLibraryKind3 != null ? persistentLibraryKind3.getKindId() : null))) {
                PersistentLibraryKind<?> persistentLibraryKind4 = type;
                PersistentLibraryKind<?> persistentLibraryKind5 = this.getCurrentLibrary().getKind();
                PersistentLibraryKind<?> persistentLibraryKind6 = this.originalLibrarySnapshot.getKind();
                String string = "setKind: expected kindId " + (persistentLibraryKind4 != null ? persistentLibraryKind4.getKindId() : null) + ", but got " + (persistentLibraryKind5 != null ? persistentLibraryKind5.getKindId() : null) + ". Original kind: " + (persistentLibraryKind6 != null ? persistentLibraryKind6.getKindId() : null);
                throw new IllegalStateException(string.toString());
            }
        }
    }

    public void forgetKind() {
        this.reloadKind = true;
    }

    public void restoreKind() {
        this.reloadKind = true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUnderRoots(VirtualFileUrl url, Collection<LibraryRoot> roots) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = roots;
        String string = url.getUrl();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LibraryRoot libraryRoot = (LibraryRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl().getUrl());
        }
        return VfsUtilCore.isUnder((String)string, (Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        void $this$forEach$iv;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)rootType, (String)"rootType");
        this.assertModelIsLive();
        VirtualFileUrl virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
        if (!ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            return false;
        }
        this.update((Function1<? super LibraryEntityBuilder, Unit>)((Function1)arg_0 -> LibraryModifiableModelBridgeImpl.removeRoot$lambda$0(virtualFileUrl, rootType, arg_0)));
        LibraryEntity libraryEntity = this.getCurrentLibrary().getLibraryEntity();
        Iterable $this$filterNot$iv = libraryEntity.getExcludedRoots();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv$iv;
            boolean bl = false;
            if (this.isUnderRoots(it.getUrl(), libraryEntity.getRoots())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExcludeUrlEntity it = (ExcludeUrlEntity)element$iv;
            boolean bl = false;
            this.getDiff().removeEntity((WorkspaceEntity)it);
        }
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && ArraysKt.contains((Object[])this.getCurrentLibrary().getUrls(rootType), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("removeRoot: removed url '" + virtualFileUrl.getUrl() + "' type '" + rootType.name() + "' still exists after removing").toString());
        }
        return true;
    }

    public boolean removeExcludedRoot(@NotNull String url) {
        Object v0;
        VirtualFileUrl virtualFileUrl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.assertModelIsLive();
            virtualFileUrl = this.virtualFileManager.getOrCreateFromUrl(url);
            Iterable iterable = this.getCurrentLibrary().getLibraryEntity().getExcludedRoots();
            for (Object t : iterable) {
                ExcludeUrlEntity it = (ExcludeUrlEntity)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)virtualFileUrl)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        ExcludeUrlEntity excludeUrlEntity = v0;
        if (excludeUrlEntity == null) {
            return false;
        }
        this.getDiff().removeEntity((WorkspaceEntity)excludeUrlEntity);
        if (LegacyBridgeModifiableBase.Companion.getAssertChangesApplied() && ArraysKt.contains((Object[])this.getCurrentLibrary().getExcludedRootUrls(), (Object)virtualFileUrl.getUrl())) {
            throw new IllegalStateException(("removeRoot: removed excluded url '" + virtualFileUrl.getUrl() + "' still exists after removing").toString());
        }
        return true;
    }

    public void dispose() {
        this.setModelIsCommittedOrDisposed(true);
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @NotNull
    public String toString() {
        return "Library '" + this.getName() + "', roots: " + this.getCurrentLibrary().getLibraryEntity().getRoots();
    }

    @NotNull
    public List<String> getInvalidRootUrls(@NotNull OrderRootType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getCurrentLibrary().getInvalidRootUrls(type);
    }

    @NotNull
    public VirtualFile[] getExcludedRoots() {
        return this.getCurrentLibrary().getExcludedRoots();
    }

    @Nullable
    public Module getModule() {
        return this.getCurrentLibrary().getModule();
    }

    @NotNull
    public Void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.originalLibrarySnapshot.getExternalSource();
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Library getSource() {
        return (Library)this.originalLibrary;
    }

    @NotNull
    public LibraryTable getTable() {
        return this.originalLibrarySnapshot.getLibraryTable();
    }

    @NotNull
    public RootProvider getRootProvider() {
        return this;
    }

    @NotNull
    public Void readExternal(@Nullable Element element) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void writeExternal(@Nullable Element element) {
        throw new UnsupportedOperationException();
    }

    private static final LibraryStateSnapshot currentLibraryValue$lambda$0(LibraryModifiableModelBridgeImpl this$0, EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        LibraryEntity libraryEntity = (LibraryEntity)storage.resolve((SymbolicEntityId)this$0.entityId);
        if (libraryEntity == null) {
            throw new IllegalStateException(("Can't resolve library via " + this$0.entityId).toString());
        }
        LibraryStateSnapshot newLibrary = new LibraryStateSnapshot(libraryEntity, storage, this$0.originalLibrarySnapshot.getLibraryTable());
        return newLibrary;
    }

    private static final Unit setName$lambda$0(String $name, LibraryEntityBuilder $this$modifyLibraryEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        $this$modifyLibraryEntity.setName($name);
        return Unit.INSTANCE;
    }

    private static final Unit commit$lambda$0(LibraryModifiableModelBridgeImpl this$0, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.applyChangesFrom(this$0.getDiff());
        return Unit.INSTANCE;
    }

    private static final Unit commit$lambda$1(LibraryModifiableModelBridgeImpl this$0, MutableEntityStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.applyChangesFrom(this$0.getDiff());
        return Unit.INSTANCE;
    }

    private static final Unit setExternalSource$lambda$0(ProjectModelExternalSource $externalSource, LibraryModifiableModelBridgeImpl this$0, LibraryEntityBuilder $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        EntitySource currentEntitySource = $this$update.getEntitySource();
        if (currentEntitySource instanceof JpsFileEntitySource) {
            JpsFileEntitySource jpsFileEntitySource = (JpsFileEntitySource)currentEntitySource;
            String string = $externalSource.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            LibraryOrigin libraryOrigin = this$0.originalLibrary.getOrigin();
            Intrinsics.checkNotNull((Object)libraryOrigin, (String)"null cannot be cast to non-null type com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryOrigin.OfProject");
            $this$update.setEntitySource((EntitySource)new JpsImportedEntitySource(jpsFileEntitySource, string, ProjectUtilCore.isExternalStorageEnabled((Project)((LibraryOrigin.OfProject)libraryOrigin).getProject())));
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateProperties$lambda$0(LibraryEntity $entity, String $propertiesXmlTag, LibraryEntityBuilder $this$modifyLibraryEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        LibraryEntityModifications.setLibraryProperties((LibraryEntityBuilder)$this$modifyLibraryEntity, (LibraryPropertiesEntityBuilder)LibraryPropertiesEntityModifications.createLibraryPropertiesEntity((EntitySource)$entity.getEntitySource(), arg_0 -> LibraryModifiableModelBridgeImpl.updateProperties$lambda$0$0($propertiesXmlTag, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit updateProperties$lambda$0$0(String $propertiesXmlTag, LibraryPropertiesEntityBuilder $this$LibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$LibraryPropertiesEntity, (String)"$this$LibraryPropertiesEntity");
        if ($propertiesXmlTag != null) {
            $this$LibraryPropertiesEntity.setPropertiesXmlTag($propertiesXmlTag);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateProperties$lambda$1(String $propertiesXmlTag, LibraryPropertiesEntityBuilder $this$modifyLibraryPropertiesEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryPropertiesEntity, (String)"$this$modifyLibraryPropertiesEntity");
        if ($propertiesXmlTag != null) {
            $this$modifyLibraryPropertiesEntity.setPropertiesXmlTag($propertiesXmlTag);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateProperties$lambda$2(String $libraryType, LibraryEntityBuilder $this$modifyLibraryEntity) {
        LibraryTypeId libraryTypeId;
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        LibraryEntityBuilder libraryEntityBuilder = $this$modifyLibraryEntity;
        String string = $libraryType;
        if (string != null) {
            String string2 = string;
            LibraryEntityBuilder libraryEntityBuilder2 = libraryEntityBuilder;
            boolean bl = false;
            libraryTypeId = new LibraryTypeId($libraryType);
            libraryEntityBuilder = libraryEntityBuilder2;
        } else {
            libraryTypeId = null;
        }
        libraryEntityBuilder.setTypeId(libraryTypeId);
        return Unit.INSTANCE;
    }

    private static final Unit addJarDirectory$lambda$0(VirtualFileUrl $virtualFileUrl, LibraryRootTypeId $rootTypeId, LibraryRoot.InclusionOptions $inclusionOptions, LibraryEntityBuilder $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.getRoots().add(new LibraryRoot($virtualFileUrl, $rootTypeId, $inclusionOptions));
        return Unit.INSTANCE;
    }

    private static final Unit moveRootUp$lambda$0(VirtualFileUrl $virtualFileUrl, OrderRootType $rootType, LibraryEntityBuilder $this$update) {
        int prevRootIndex;
        int index;
        block6: {
            int n;
            block5: {
                int n2;
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                List $this$indexOfFirst$iv = $this$update.getRoots();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    LibraryRoot it = (LibraryRoot)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getUrl(), (Object)$virtualFileUrl)) {
                        n2 = index$iv;
                        break block5;
                    }
                    ++index$iv;
                }
                n2 = index = -1;
            }
            if (index <= 0) {
                return Unit.INSTANCE;
            }
            List $this$indexOfLast$iv = $this$update.getRoots().subList(0, index);
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                LibraryRoot it = (LibraryRoot)iterator$iv.previous();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType().getName(), (Object)$rootType.name())) continue;
                n = iterator$iv.nextIndex();
                break block6;
            }
            n = prevRootIndex = -1;
        }
        if (prevRootIndex < 0) {
            return Unit.INSTANCE;
        }
        List mutable = CollectionsKt.toMutableList((Collection)$this$update.getRoots());
        ContainerUtil.swapElements((List)mutable, (int)prevRootIndex, (int)index);
        $this$update.setRoots(mutable);
        return Unit.INSTANCE;
    }

    private static final Unit moveRootDown$lambda$0(VirtualFileUrl $virtualFileUrl, OrderRootType $rootType, LibraryEntityBuilder $this$update) {
        int nextRootOffset;
        int index;
        block7: {
            int n;
            block6: {
                int n2;
                Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
                List $this$indexOfFirst$iv = $this$update.getRoots();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    LibraryRoot it = (LibraryRoot)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getUrl(), (Object)$virtualFileUrl)) {
                        n2 = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n2 = index = -1;
            }
            if (index < 0 || index + 1 >= $this$update.getRoots().size()) {
                return Unit.INSTANCE;
            }
            List $this$indexOfFirst$iv = $this$update.getRoots().subList(index + 1, $this$update.getRoots().size());
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                LibraryRoot it = (LibraryRoot)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getType().getName(), (Object)$rootType.name())) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = nextRootOffset = -1;
        }
        if (nextRootOffset < 0) {
            return Unit.INSTANCE;
        }
        List mutable = CollectionsKt.toMutableList((Collection)$this$update.getRoots());
        ContainerUtil.swapElements((List)mutable, (int)(index + nextRootOffset + 1), (int)index);
        $this$update.setRoots(mutable);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addExcludedRoot$lambda$0(VirtualFileUrl $virtualFileUrl, LibraryEntityBuilder $this$update) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        Iterable $this$map$iv = $this$update.getExcludedRoots();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExcludeUrlEntityBuilder excludeUrlEntityBuilder = (ExcludeUrlEntityBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        if (!((List)destination$iv$iv).contains($virtualFileUrl)) {
            $this$update.setExcludedRoots(CollectionsKt.plus((Collection)$this$update.getExcludedRoots(), (Object)ExcludeUrlEntityModifications.createExcludeUrlEntity$default((VirtualFileUrl)$virtualFileUrl, (EntitySource)$this$update.getEntitySource(), null, (int)4, null)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addRoot$lambda$0(LibraryRoot $root, LibraryEntityBuilder $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.getRoots().add($root);
        return Unit.INSTANCE;
    }

    private static final Unit removeRoot$lambda$0(VirtualFileUrl $virtualFileUrl, OrderRootType $rootType, LibraryEntityBuilder $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        $this$update.getRoots().removeIf(arg_0 -> LibraryModifiableModelBridgeImpl.removeRoot$lambda$0$1(arg_0 -> LibraryModifiableModelBridgeImpl.removeRoot$lambda$0$0($virtualFileUrl, $rootType, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean removeRoot$lambda$0$0(VirtualFileUrl $virtualFileUrl, OrderRootType $rootType, LibraryRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getUrl(), (Object)$virtualFileUrl) && Intrinsics.areEqual((Object)it.getType().getName(), (Object)$rootType.name());
    }

    private static final boolean removeRoot$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LibraryModifiableModelBridgeImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/library/LibraryModifiableModelBridgeImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

