/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.project.ProjectId;
import com.intellij.platform.project.ProjectIdsStorage;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0003H\u0007\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0003*\u00020\u0005H\u0007\u001a\f\u0010\u000b\u001a\u00020\u0003*\u00020\u0005H\u0007\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\u0005*\u00020\u0003H\u0007\u001a\f\u0010\r\u001a\u00020\u0005*\u00020\u0003H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "registerNewProjectId", "Lcom/intellij/platform/project/ProjectId;", "project", "Lcom/intellij/openapi/project/Project;", "unregisterProjectId", "", "setNewProjectId", "newProjectId", "projectIdOrNull", "projectId", "findProjectOrNull", "findProject", "intellij.platform.project"})
@SourceDebugExtension(value={"SMAP\nProjectId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectId.kt\ncom/intellij/platform/project/ProjectIdKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n57#2:174\n35#2,2:175\n*S KotlinDebug\n*F\n+ 1 ProjectId.kt\ncom/intellij/platform/project/ProjectIdKt\n*L\n12#1:174\n12#1:175,2\n*E\n"})
public final class ProjectIdKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    @Nullable
    public static final ProjectId registerNewProjectId(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectIdsStorage.Companion.getInstance().registerProject(project);
    }

    @ApiStatus.Internal
    public static final void unregisterProjectId(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectIdsStorage.Companion.getInstance().unregisterProject(project);
    }

    @ApiStatus.Internal
    public static final void setNewProjectId(@NotNull Project project, @NotNull ProjectId newProjectId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newProjectId, (String)"newProjectId");
        ProjectIdsStorage.Companion.getInstance().setProjectId(project, newProjectId);
    }

    @ApiStatus.Experimental
    @Nullable
    public static final ProjectId projectIdOrNull(@NotNull Project $this$projectIdOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$projectIdOrNull, (String)"<this>");
        return ProjectIdsStorage.Companion.getInstance().getProjectId($this$projectIdOrNull);
    }

    @ApiStatus.Experimental
    @NotNull
    public static final ProjectId projectId(@NotNull Project $this$projectId) {
        Intrinsics.checkNotNullParameter((Object)$this$projectId, (String)"<this>");
        ProjectId projectId = ProjectIdKt.projectIdOrNull($this$projectId);
        if (projectId == null) {
            throw new IllegalStateException(("Project ID is not set for " + $this$projectId).toString());
        }
        return projectId;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final Project findProjectOrNull(@NotNull ProjectId $this$findProjectOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$findProjectOrNull, (String)"<this>");
        Project project = ProjectIdsStorage.Companion.getInstance().findProject($this$findProjectOrNull);
        if (project == null) {
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            LOG.debug("Project is not found for " + $this$findProjectOrNull + ". Opened projects: " + ArraysKt.joinToString$default((Object[])projectArray, null, null, null, (int)0, null, ProjectIdKt::findProjectOrNull$lambda$0, (int)31, null));
        }
        return project;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Project findProject(@NotNull ProjectId $this$findProject) {
        Intrinsics.checkNotNullParameter((Object)$this$findProject, (String)"<this>");
        Project project = ProjectIdKt.findProjectOrNull($this$findProject);
        if (project == null) {
            ProjectId $this$findProject_u24lambda_u240 = $this$findProject;
            boolean bl = false;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            LOG.error("Project is not found for " + $this$findProject_u24lambda_u240 + ". Opened projects: " + ArraysKt.joinToString$default((Object[])projectArray, null, null, null, (int)0, null, ProjectIdKt::findProject$lambda$0$0, (int)31, null));
            throw new IllegalStateException(("Project is not found for " + $this$findProject_u24lambda_u240).toString());
        }
        return project;
    }

    private static final CharSequence findProjectOrNull$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectIdKt.projectId(it).toString();
    }

    private static final CharSequence findProject$lambda$0$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectIdKt.projectId(it).toString();
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

