/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.rd.util;

import com.intellij.codeWithMe.ClientIdContextElementPrecursor;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.threading.coroutines.RdCoroutineScope;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\tR\u001c\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\f\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\f\u001a\u0004\b\u0015\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/rd/util/RdCoroutineHost;", "Lcom/jetbrains/rd/util/threading/coroutines/RdCoroutineScope;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "defaultContext", "Lkotlin/coroutines/CoroutineContext;", "getDefaultContext", "()Lkotlin/coroutines/CoroutineContext;", "uiDispatcher", "getUiDispatcher$annotations", "()V", "getUiDispatcher", "uiDispatcherWithInlining", "Lkotlinx/coroutines/CoroutineDispatcher;", "getUiDispatcherWithInlining$annotations", "getUiDispatcherWithInlining", "()Lkotlinx/coroutines/CoroutineDispatcher;", "uiDispatcherAnyModality", "getUiDispatcherAnyModality$annotations", "getUiDispatcherAnyModality", "onException", "", "throwable", "", "Companion", "ScopeHolder", "intellij.platform.rd.community"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRdCoroutineHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdCoroutineHost.kt\ncom/intellij/openapi/rd/util/RdCoroutineHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,79:1\n13#2:80\n13#2:83\n30#3,2:81\n*S KotlinDebug\n*F\n+ 1 RdCoroutineHost.kt\ncom/intellij/openapi/rd/util/RdCoroutineHost\n*L\n73#1:80\n25#1:83\n22#1:81,2\n*E\n"})
public final class RdCoroutineHost
extends RdCoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext defaultContext;
    @NotNull
    private final CoroutineDispatcher uiDispatcherWithInlining;
    @NotNull
    private static final Lazy<RdCoroutineHost> instance$delegate = LazyKt.lazy(RdCoroutineHost::instance_delegate$lambda$0);
    @NotNull
    private static final ExecutorCoroutineDispatcher processIODispatcher;

    public RdCoroutineHost(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.defaultContext = coroutineScope.getCoroutineContext();
        this.uiDispatcherWithInlining = new CoroutineDispatcher(){

            public void dispatch(CoroutineContext context, Runnable block) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                ApplicationManager.getApplication().invokeLater(block, ModalityState.defaultModalityState());
            }

            public boolean isDispatchNeeded(CoroutineContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Application application = ApplicationManager.getApplication();
                if (!application.isDispatchThread() || !application.isWriteIntentLockAcquired()) {
                    return true;
                }
                ModalityState modalityState = ModalityState.current();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
                ModalityState modality = modalityState;
                TransactionGuard transactionGuard = TransactionGuard.getInstance();
                return transactionGuard.isWriteSafeModality(modality) && !transactionGuard.isWritingAllowed();
            }
        };
    }

    @NotNull
    protected CoroutineContext getDefaultContext() {
        return this.defaultContext;
    }

    @NotNull
    public final CoroutineContext getUiDispatcher() {
        return CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
    }

    @Deprecated(message="Use Dispatchers.EDT", replaceWith=@ReplaceWith(expression="Dispatchers.EDT", imports={"kotlinx.coroutines.Dispatchers", "com.intellij.openapi.application.EDT"}))
    public static /* synthetic */ void getUiDispatcher$annotations() {
    }

    @NotNull
    public final CoroutineDispatcher getUiDispatcherWithInlining() {
        return this.uiDispatcherWithInlining;
    }

    @Deprecated(message="This is a deprecated dispatcher used before Dispatchers.EDT. Please switch to the Dispatchers.EDT")
    public static /* synthetic */ void getUiDispatcherWithInlining$annotations() {
    }

    @NotNull
    public final CoroutineContext getUiDispatcherAnyModality() {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        return coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
    }

    @Deprecated(message="Dispatchers.EDT + ModalityState.any().asContextElement()", replaceWith=@ReplaceWith(expression="Dispatchers.EDT + ModalityState.any().asContextElement()", imports={"kotlinx.coroutines.Dispatchers", "com.intellij.openapi.application.EDT", "com.intellij.openapi.application.ModalityState", "com.intellij.openapi.application.asContextElement"}))
    public static /* synthetic */ void getUiDispatcherAnyModality$annotations() {
    }

    public void onException(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (!(throwable instanceof CancellationException)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RdCoroutineHost.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unhandled coroutine throwable", throwable);
        }
    }

    private static final RdCoroutineHost instance_delegate$lambda$0() {
        RdCoroutineHost rdCoroutineHost;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<ScopeHolder> serviceClass$iv = ScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ScopeHolder scope = (ScopeHolder)object;
        ClientIdContextElementPrecursor precursor = (ClientIdContextElementPrecursor)scope.scope.getCoroutineContext().get((CoroutineContext.Key)ClientIdContextElementPrecursor.INSTANCE);
        if (precursor == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RdCoroutineHost.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("ClientIdContextElementPrecursor is missing inside scope for RdCoroutineHost. It's required for automatic `ClientId` propagation for `lifetime.coroutineScope.launch {}`");
        }
        RdCoroutineHost $this$instance_delegate_u24lambda_u240_u240 = rdCoroutineHost = new RdCoroutineHost(scope.scope);
        boolean bl = false;
        RdCoroutineScope.Companion.override((RdCoroutineScope)$this$instance_delegate_u24lambda_u240_u240);
        return rdCoroutineHost;
    }

    static {
        ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"INSTANCE");
        processIODispatcher = ExecutorsKt.from((ExecutorService)executorService);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR!\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/rd/util/RdCoroutineHost$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/openapi/rd/util/RdCoroutineHost;", "getInstance$annotations", "getInstance", "()Lcom/intellij/openapi/rd/util/RdCoroutineHost;", "instance$delegate", "Lkotlin/Lazy;", "init", "", "processIODispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "getProcessIODispatcher$annotations", "getProcessIODispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "intellij.platform.rd.community"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RdCoroutineHost getInstance() {
            Lazy lazy = instance$delegate;
            return (RdCoroutineHost)((Object)lazy.getValue());
        }

        public static /* synthetic */ void getInstance$annotations() {
        }

        public final void init() {
            this.getInstance();
        }

        @NotNull
        public final ExecutorCoroutineDispatcher getProcessIODispatcher() {
            return processIODispatcher;
        }

        @Deprecated(message="Use Dispatchers.IO or another dispatcher appropriate for your purposes")
        public static /* synthetic */ void getProcessIODispatcher$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/rd/util/RdCoroutineHost$ScopeHolder;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "intellij.platform.rd.community"})
    private static final class ScopeHolder {
        @JvmField
        @NotNull
        public final CoroutineScope scope;

        public ScopeHolder(@NotNull CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

