/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.ide.actions.FqnUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import com.intellij.refactoring.rename.RenameUsagesCollector;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtilBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenameUtil {
    private static final Logger LOG = Logger.getInstance(RenameUtil.class);

    private RenameUtil() {
    }

    public static UsageInfo @NotNull [] findUsages(@NotNull PsiElement element, String newName, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(0);
        }
        return RenameUtil.findUsages(element, newName, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), searchInStringsAndComments, searchForTextOccurrences, allRenames);
    }

    public static UsageInfo @NotNull [] findUsages(@NotNull PsiElement element, String newName, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(2);
        }
        List<UsageInfo> result = Collections.synchronizedList(new ArrayList());
        RenamePsiElementProcessorBase elementProcessor = RenamePsiElementProcessorBase.forPsiElement(element);
        RenameUtil.processUsages(element, elementProcessor, newName, searchScope, true, searchInStringsAndComments, searchForTextOccurrences, (Processor<? super UsageInfo>)((Processor)info -> {
            result.add((UsageInfo)info);
            return true;
        }));
        elementProcessor.findCollisions(element, newName, allRenames, result);
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RenameUtil.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    public static boolean hasNonCodeUsages(@NotNull PsiElement element, String newName, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchForTextOccurrences) {
        RenamePsiElementProcessorBase elementProcessor;
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(5);
        }
        return !RenameUtil.processUsages(element, elementProcessor = RenamePsiElementProcessorBase.forPsiElement(element), newName, searchScope, false, searchInStringsAndComments, searchForTextOccurrences, (Processor<? super UsageInfo>)((Processor)info -> false));
    }

    private static boolean processUsages(@NotNull PsiElement element, @NotNull RenamePsiElementProcessorBase elementProcessor, String newName, @NotNull SearchScope searchScope, boolean searchInCode, boolean searchInStringsAndComments, boolean searchForTextOccurrences, @NotNull Processor<? super UsageInfo> processor) {
        String stringToReplace;
        NonCodeUsageInfoFactory factory;
        String stringToSearch;
        SearchScope useScope;
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(6);
        }
        if (elementProcessor == null) {
            RenameUtil.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            RenameUtil.$$$reportNull$$$0(9);
        }
        if (!((useScope = PsiSearchHelper.getInstance((Project)element.getProject()).getUseScope(element)) instanceof LocalSearchScope)) {
            useScope = searchScope.intersectWith(useScope);
        }
        if (searchInCode) {
            Collection<PsiReference> refs = elementProcessor.findReferences(element, useScope, searchInStringsAndComments);
            for (PsiReference ref : refs) {
                if (ref == null) {
                    LOG.error("null reference from processor " + String.valueOf(elementProcessor));
                    continue;
                }
                PsiElement referenceElement = ref.getElement();
                if (processor.process((Object)elementProcessor.createUsageInfo(element, ref, referenceElement))) continue;
                return false;
            }
        }
        PsiElement searchForInComments = elementProcessor.getElementToSearchInStringsAndComments(element);
        if (searchInStringsAndComments && searchForInComments != null && !(stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS)).isEmpty() && !TextOccurrencesUtilBase.processUsagesInStringsAndComments(processor, (PsiElement)searchForInComments, (SearchScope)searchScope, (String)stringToSearch, (UsageInfoFactory)(factory = new NonCodeUsageInfoFactory(searchForInComments, stringToReplace = RenameUtil.getStringToReplace(element, newName, false, elementProcessor))))) {
            return false;
        }
        if (searchForTextOccurrences && searchForInComments != null) {
            stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
            if (!stringToSearch.isEmpty() && !RenameUtil.processTextOccurrences(searchForInComments, searchScope, stringToSearch, stringToReplace = RenameUtil.getStringToReplace(element, newName, true, elementProcessor), processor)) {
                return false;
            }
            Pair<String, String> additionalStringToSearch = elementProcessor.getTextOccurrenceSearchStrings(searchForInComments, newName);
            if (additionalStringToSearch != null && !((String)additionalStringToSearch.first).isEmpty() && !RenameUtil.processTextOccurrences(searchForInComments, searchScope, (String)additionalStringToSearch.first, (String)additionalStringToSearch.second, processor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processTextOccurrences(final @NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, final String stringToReplace, @NotNull Processor<? super UsageInfo> processor) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(11);
        }
        if (stringToSearch == null) {
            RenameUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            RenameUtil.$$$reportNull$$$0(13);
        }
        UsageInfoFactory factory = new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                TextRange textRange;
                if (usage == null) {
                    1.$$$reportNull$$$0(0);
                }
                int start = (textRange = usage.getTextRange()) == null ? 0 : textRange.getStartOffset();
                return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)element, (String)stringToReplace);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/rename/RenameUtil$1", "createUsageInfo"));
            }
        };
        if (searchScope instanceof GlobalSearchScope) {
            return FindUsagesHelper.processTextOccurrences((PsiElement)element, (String)stringToSearch, (GlobalSearchScope)((GlobalSearchScope)searchScope), (UsageInfoFactory)factory, processor);
        }
        return true;
    }

    public static void buildPackagePrefixChangedMessage(VirtualFile[] virtualFiles, StringBuffer message, String qualifiedName) {
        if (virtualFiles.length > 0) {
            message.append(RefactoringBundle.message("package.occurs.in.package.prefixes.of.the.following.source.folders.n", qualifiedName));
            for (VirtualFile virtualFile : virtualFiles) {
                message.append(virtualFile.getPresentableUrl()).append("\n");
            }
            message.append(RefactoringBundle.message("these.package.prefixes.will.be.changed"));
        }
    }

    private static String getStringToReplace(PsiElement element, String newName, boolean nonJava, RenamePsiElementProcessorBase theProcessor) {
        String result;
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (element instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)element).getMetaData()) != null) {
            return metaData.getName();
        }
        if (theProcessor != null && (result = theProcessor.getQualifiedNameAfterRename(element, newName, nonJava)) != null) {
            return result;
        }
        if (element instanceof PsiNamedElement) {
            return newName;
        }
        LOG.error("Unknown element type : " + String.valueOf(element));
        return null;
    }

    public static void checkRename(PsiElement element, String newName) throws IncorrectOperationException {
        if (element instanceof PsiCheckedRenameElement) {
            ((PsiCheckedRenameElement)element).checkSetName(newName);
        }
    }

    @ApiStatus.Internal
    public static void registerUndoableRename(final PsiElement element, final @Nullable RefactoringElementListener listener) {
        String fqn;
        String string = fqn = element instanceof PsiFile ? ((PsiFile)element).getVirtualFile().getPath() : FqnUtil.elementToFqn(element, null);
        if (fqn != null) {
            BasicUndoableAction action = new BasicUndoableAction(){

                public void undo() {
                    if (listener instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)listener).undoElementMovedOrRenamed(element, fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)element.getProject()).undoableActionPerformed((UndoableAction)action);
        }
    }

    public static void doRename(PsiElement element, String newName, UsageInfo[] usages, Project project, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        RenameUtil.registerUndoableRename(element, listener);
        RenamePsiElementProcessorBase processor = RenamePsiElementProcessorBase.forPsiElement(element);
        processor.renameElement(element, newName, usages, listener);
    }

    public static void showErrorMessage(IncorrectOperationException e, PsiElement element, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException((Throwable)e);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String helpID = RenamePsiElementProcessorBase.forPsiElement(element).getHelpID(element);
            String message = e.getMessage();
            if (StringUtil.isEmpty((String)message)) {
                message = RefactoringBundle.message("rename.not.supported");
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("rename.title"), message, helpID, project);
        });
    }

    public static void doRenameGenericNamedElement(@NotNull PsiElement namedElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        if (namedElement == null) {
            RenameUtil.$$$reportNull$$$0(14);
        }
        HashSet<Class> reportedClasses = new HashSet<Class>();
        for (UsageInfo usage : usages) {
            PsiReference reference = usage.getReference();
            if (reference == null || !reportedClasses.add(reference.getClass())) continue;
            RenameUsagesCollector.referenceProcessed.log(namedElement.getProject(), (Object)reference.getClass());
        }
        RenameUtilBase.doRenameGenericNamedElement((PsiElement)namedElement, (String)newName, (UsageInfo[])usages, (RefactoringElementListener)listener);
    }

    public static void rename(UsageInfo info, String newName) throws IncorrectOperationException {
        RenameUtilBase.rename((UsageInfo)info, (String)newName);
    }

    @Nullable
    public static List<UnresolvableCollisionUsageInfo> removeConflictUsages(Set<UsageInfo> usages) {
        ArrayList<UnresolvableCollisionUsageInfo> result = new ArrayList<UnresolvableCollisionUsageInfo>();
        Iterator<UsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
            result.add((UnresolvableCollisionUsageInfo)usageInfo);
            iterator.remove();
        }
        return result.isEmpty() ? null : result;
    }

    public static void addConflictDescriptions(UsageInfo[] usages, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof UnresolvableCollisionUsageInfo)) continue;
            conflicts.putValue((Object)usage.getElement(), (Object)((UnresolvableCollisionUsageInfo)usage).getDescription());
        }
    }

    public static void renameNonCodeUsages(@NotNull Project project, NonCodeUsageInfo @NotNull [] usages) {
        if (project == null) {
            RenameUtil.$$$reportNull$$$0(15);
        }
        if (usages == null) {
            RenameUtil.$$$reportNull$$$0(16);
        }
        Map docsToOffsetsMap = CollectionFactory.createSmallMemoryFootprintMap();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        for (NonCodeUsageInfo usage : usages) {
            Segment segment;
            ProperTextRange rangeInElement;
            PsiElement element = usage.getElement();
            if (element == null || (element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)element, (boolean)true)) == null || (rangeInElement = usage.getRangeInElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            Document document = containingFile.getViewProvider().getDocument();
            if (document != null) {
                psiDocumentManager.commitDocument(document);
            }
            LOG.assertTrue((segment = usage.getSegment()) != null);
            TextRange replaceRange = TextRange.create((Segment)segment);
            if (document instanceof DocumentWindow) {
                DocumentWindow documentWindow = (DocumentWindow)document;
                replaceRange = documentWindow.injectedToHost(replaceRange);
                document = documentWindow.getDelegate();
            }
            int fileOffset = replaceRange.getStartOffset();
            Int2ObjectMap offsetMap = (Int2ObjectMap)docsToOffsetsMap.get(document);
            if (offsetMap == null) {
                offsetMap = new Int2ObjectOpenHashMap();
                docsToOffsetsMap.put(document, offsetMap);
            }
            UsageOffset substitution = new UsageOffset(fileOffset, fileOffset + rangeInElement.getLength(), usage.newText);
            UsageOffset duplicate = (UsageOffset)offsetMap.get(fileOffset);
            if (duplicate != null) {
                if (duplicate.equals(substitution)) continue;
                LOG.warn("ATTENTION! Unequal renaming in the same place in the document, possibly due to injection (read more in CPP-17316):\n      document: " + String.valueOf(document) + "\n       element: " + String.valueOf(element) + "\n  first rename: " + substitution.newText + "(" + substitution.startOffset + ", " + substitution.endOffset + ")\n second rename: " + duplicate.newText + "(" + duplicate.startOffset + ", " + duplicate.endOffset + ")");
                continue;
            }
            offsetMap.put(fileOffset, (Object)substitution);
        }
        for (Document document : docsToOffsetsMap.keySet()) {
            Map offsetMap = (Map)docsToOffsetsMap.get(document);
            LOG.assertTrue(offsetMap != null, (Object)document);
            Object[] offsets = offsetMap.values().toArray(new UsageOffset[0]);
            Arrays.sort(offsets);
            for (int i = offsets.length - 1; i >= 0; --i) {
                Object usageOffset = offsets[i];
                document.replaceString(((UsageOffset)usageOffset).startOffset, ((UsageOffset)usageOffset).endOffset, (CharSequence)((UsageOffset)usageOffset).newText);
            }
            psiDocumentManager.commitDocument(document);
        }
    }

    public static boolean isValidName(@Nullable Project project, @NotNull PsiElement psiElement, @Nullable String newName) {
        Language fileLanguage;
        if (psiElement == null) {
            RenameUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)newName)) {
            return false;
        }
        Condition<String> inputValidator = RenameInputValidatorRegistry.getInputValidator(psiElement);
        if (inputValidator != null) {
            return inputValidator.value((Object)newName);
        }
        if (psiElement instanceof PsiFile || psiElement instanceof PsiDirectory) {
            return newName.indexOf(92) < 0 && newName.indexOf(47) < 0;
        }
        if (psiElement instanceof PomTargetPsiElement) {
            return !StringUtil.isEmptyOrSpaces((String)newName);
        }
        PsiFile file = psiElement.getContainingFile();
        Language elementLanguage = psiElement.getLanguage();
        Language language = fileLanguage = file == null ? null : file.getLanguage();
        Language language2 = fileLanguage == null ? elementLanguage : (fileLanguage.isKindOf(elementLanguage) ? fileLanguage : elementLanguage);
        return LanguageNamesValidation.isIdentifier((Language)language2, (String)newName.trim(), (Project)project);
    }

    public static void assertNonCompileElement(PsiElement element) {
        LOG.assertTrue(!(element instanceof PsiCompiledElement), (Object)element);
    }

    @NotNull
    public static String getUsageViewType(@NotNull PsiElement element) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(18);
        }
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        if (string == null) {
            RenameUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementProcessor";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageViewType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasNonCodeUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processTextOccurrences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doRenameGenericNamedElement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameNonCodeUsages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUsageViewType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 19 -> new IllegalStateException(string);
        };
    }

    private record UsageOffset(int startOffset, int endOffset, String newText) implements Comparable<UsageOffset>
    {
        @Override
        public int compareTo(@NotNull UsageOffset o) {
            if (o == null) {
                UsageOffset.$$$reportNull$$$0(0);
            }
            return this.startOffset - o.startOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/refactoring/rename/RenameUtil$UsageOffset", "compareTo"));
        }
    }
}

