/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonRefactoringUtil {
    private CommonRefactoringUtil() {
    }

    public static void showErrorMessage(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage String message, @NonNls @Nullable String helpId, @NotNull Project project) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        IdeUiService.getInstance().showRefactoringMessageDialog(title, message, helpId, "OptionPane.errorIcon", false, project);
    }

    public static void sortDepthFirstRightLeftOrder(UsageInfo[] usages) {
        Arrays.sort(usages, (usage1, usage2) -> {
            PsiElement element2;
            PsiElement element1 = usage1.getElement();
            if (element1 == (element2 = usage2.getElement())) {
                return 0;
            }
            if (element1 == null) {
                return 1;
            }
            if (element2 == null) {
                return -1;
            }
            return element2.getTextRange().getStartOffset() - element1.getTextRange().getStartOffset();
        });
    }

    public static void showErrorHint(@NotNull Project project, @Nullable Editor editor, @NlsContexts.DialogMessage @NotNull String message, @NlsContexts.DialogTitle @NotNull String title, @Nullable String helpId) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (message == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (title == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RefactoringErrorHintException(message);
        }
        boolean noRootPane = editor == null || editor.getComponent().getRootPane() == null;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (noRootPane) {
                CommonRefactoringUtil.showErrorMessage(title, message, helpId, project);
            } else {
                IdeUiService.getInstance().showErrorHint(editor, message);
            }
        });
    }

    @NlsSafe
    public static String htmlEmphasize(@NotNull @Nls String text) {
        if (text == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.htmlEmphasize((String)text);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(5);
        }
        return (file = element.getContainingFile().getVirtualFile()) != null && !ReadonlyStatusHandler.getInstance((Project)element.getProject()).ensureFilesWritable(Collections.singletonList(file)).hasReadonlyFiles();
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(7);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(element, project, RefactoringBundle.message("refactoring.cannot.be.performed"));
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, PsiElement ... elements) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(9);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Arrays.asList(elements), RefactoringBundle.message("refactoring.cannot.be.performed"), true);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(11);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), elements, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @NotNull Project project, @NotNull String messagePrefix) {
        if (element == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (messagePrefix == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(14);
        }
        return element.isWritable() || CommonRefactoringUtil.checkReadOnlyStatus(project, Collections.emptySet(), Collections.singleton(element), messagePrefix, true);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(16);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), false);
    }

    public static boolean checkReadOnlyStatusRecursively(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(17);
        }
        if (elements == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(18);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, elements, Collections.emptySet(), RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    public static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (recursive == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (flat == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(21);
        }
        return CommonRefactoringUtil.checkReadOnlyStatus(project, recursive, flat, RefactoringBundle.message("refactoring.cannot.be.performed"), notifyOnFail);
    }

    private static boolean checkReadOnlyStatus(@NotNull Project project, @NotNull Collection<? extends PsiElement> recursive, @NotNull Collection<? extends PsiElement> flat, @NotNull String messagePrefix, boolean notifyOnFail) {
        if (project == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (recursive == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(23);
        }
        if (flat == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (messagePrefix == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(25);
        }
        HashSet readonly = new HashSet();
        HashSet failed = new HashSet();
        boolean seenNonWritablePsiFilesWithoutVirtualFile = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (Boolean)ReadAction.compute(() -> CommonRefactoringUtil.checkReadOnlyStatus(flat, false, readonly, failed) || CommonRefactoringUtil.checkReadOnlyStatus(recursive, true, readonly, failed)), RefactoringBundle.message("progress.title.collect.read.only.files"), false, project);
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(readonly);
        ContainerUtil.addAll(failed, (Object[])status.getReadonlyFiles());
        if (notifyOnFail && (!failed.isEmpty() || seenNonWritablePsiFilesWithoutVirtualFile && readonly.isEmpty())) {
            @NlsSafe StringBuilder message = new StringBuilder(messagePrefix).append('\n');
            int i = 0;
            for (VirtualFile virtualFile : failed) {
                String subj = RefactoringBundle.message(virtualFile.isDirectory() ? "directory.description" : "file.description", virtualFile.getPresentableUrl());
                if (virtualFile.getFileSystem().isReadOnly()) {
                    message.append(RefactoringBundle.message("0.is.located.in.a.jar.file", subj)).append('\n');
                } else {
                    message.append(RefactoringBundle.message("0.is.read.only", subj)).append('\n');
                }
                if (i++ <= 20) continue;
                message.append("...\n");
                break;
            }
            CommonRefactoringUtil.showErrorMessage(RefactoringBundle.message("error.title"), message.toString(), null, project);
            return false;
        }
        return failed.isEmpty();
    }

    private static boolean checkReadOnlyStatus(Collection<? extends PsiElement> elements, boolean recursively, Collection<? super VirtualFile> readonly, Collection<? super VirtualFile> failed) {
        boolean seenNonWritablePsiFilesWithoutVirtualFile = false;
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)psiElement;
                VirtualFile vFile = dir.getVirtualFile();
                if (vFile.getFileSystem().isReadOnly()) {
                    failed.add((VirtualFile)vFile);
                    continue;
                }
                if (recursively) {
                    CommonRefactoringUtil.collectReadOnlyFiles(vFile, readonly);
                    continue;
                }
                readonly.add((VirtualFile)vFile);
                continue;
            }
            if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                for (PsiDirectory directory : directories = ((PsiDirectoryContainer)psiElement).getDirectories()) {
                    VirtualFile virtualFile = directory.getVirtualFile();
                    if (recursively) {
                        if (virtualFile.getFileSystem().isReadOnly()) {
                            failed.add((VirtualFile)virtualFile);
                            continue;
                        }
                        CommonRefactoringUtil.collectReadOnlyFiles(virtualFile, readonly);
                        continue;
                    }
                    if (virtualFile.getFileSystem().isReadOnly()) {
                        failed.add((VirtualFile)virtualFile);
                        continue;
                    }
                    readonly.add((VirtualFile)virtualFile);
                }
                continue;
            }
            PsiFile file = psiElement.getContainingFile();
            if (file == null) {
                if (psiElement.isWritable()) continue;
                seenNonWritablePsiFilesWithoutVirtualFile = true;
                continue;
            }
            VirtualFile vFile = file.getVirtualFile();
            if (vFile != null) {
                readonly.add((VirtualFile)vFile);
                continue;
            }
            if (psiElement.isWritable()) continue;
            seenNonWritablePsiFilesWithoutVirtualFile = true;
        }
        return seenNonWritablePsiFilesWithoutVirtualFile;
    }

    public static void collectReadOnlyFiles(@NotNull VirtualFile vFile, final @NotNull Collection<? super VirtualFile> list) {
        if (vFile == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (list == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(27);
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean ignored = fileTypeManager.isFileIgnored(file);
                if (!file.isWritable() && !ignored) {
                    list.add(file);
                }
                return !ignored;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/util/CommonRefactoringUtil$1", "visitFile"));
            }
        });
    }

    public static boolean isAncestor(@NotNull PsiElement resolved, @NotNull Collection<? extends PsiElement> scopes) {
        if (resolved == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(28);
        }
        if (scopes == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(29);
        }
        for (PsiElement psiElement : scopes) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)resolved, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static int fixCaretOffset(@NotNull Editor editor) {
        if (editor == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(30);
        }
        int caret = editor.getCaretModel().getOffset();
        if (editor.getSelectionModel().hasSelection() && caret == editor.getSelectionModel().getSelectionEnd()) {
            return Math.max(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd() - 1);
        }
        return caret;
    }

    public static <T extends PsiElement> List<T> findElementsFromCaretsAndSelections(@NotNull Editor editor, @NotNull PsiFile file, @Nullable Class<?> stopAt, @NotNull Predicate<? super PsiElement> accept) {
        if (editor == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(31);
        }
        if (file == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (accept == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(33);
        }
        SmartList elements = new SmartList();
        block0: for (Caret caret : editor.getCaretModel().getAllCarets()) {
            PsiElement element;
            PsiElement end;
            TextRange selectionRange = caret.getSelectionRange();
            PsiElement start = file.findElementAt(selectionRange.getStartOffset());
            if (start == null || (end = file.findElementAt(selectionRange.getEndOffset())) == null || (element = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end)) == null) continue;
            int size = elements.size();
            PsiTreeUtil.processElements((PsiElement)element, arg_0 -> CommonRefactoringUtil.lambda$findElementsFromCaretsAndSelections$4(accept, selectionRange, (List)elements, arg_0));
            if (size < elements.size()) continue;
            while (!(element == null || element instanceof PsiFile || stopAt != null && stopAt.isInstance(element))) {
                if (accept.test((PsiElement)element)) {
                    elements.add(element);
                    continue block0;
                }
                element = element.getParent();
            }
        }
        return elements;
    }

    public static PsiElement getElementAtCaret(@NotNull Editor editor, PsiFile file) {
        int offset;
        PsiElement element;
        if (editor == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(34);
        }
        if ((element = file.findElementAt(offset = CommonRefactoringUtil.fixCaretOffset(editor))) == null && offset == file.getTextLength()) {
            element = file.findElementAt(offset - 1);
        }
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(element.getTextRange().getStartOffset() - 1);
        }
        return element;
    }

    public static PsiElement @NotNull [] getPsiElementArray(@NotNull DataContext dataContext) {
        PsiElement element;
        PsiElement[] psiElements;
        if (dataContext == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(35);
        }
        if (((psiElements = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) == null || psiElements.length == 0) && (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null) {
            psiElements = new PsiElement[]{element};
        }
        PsiElement[] psiElementArray = psiElements != null ? psiElements : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            CommonRefactoringUtil.$$$reportNull$$$0(36);
        }
        return psiElementArray;
    }

    private static /* synthetic */ boolean lambda$findElementsFromCaretsAndSelections$4(Predicate accept, TextRange selectionRange, List elements, PsiElement e) {
        TextRange range;
        if (accept.test(e) && selectionRange.intersects(range = e.getTextRange())) {
            elements.add(e);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messagePrefix";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accept";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/CommonRefactoringUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/CommonRefactoringUtil";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkReadOnlyStatus";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkReadOnlyStatusRecursively";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectReadOnlyFiles";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fixCaretOffset";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findElementsFromCaretsAndSelections";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtCaret";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementArray";
                break;
            }
            case 36: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 36 -> new IllegalStateException(string);
        };
    }

    public static class RefactoringErrorHintException
    extends RuntimeException {
        public RefactoringErrorHintException(String message) {
            super(message);
        }
    }
}

