/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class RenameInputValidatorRegistry {
    private RenameInputValidatorRegistry() {
    }

    @Nullable
    public static Condition<String> getInputValidator(PsiElement element) {
        ArrayList<Pair> validators = new ArrayList<Pair>();
        for (RenameInputValidator validator : RenameInputValidator.EP_NAME.getExtensionList()) {
            ProcessingContext context = new ProcessingContext();
            if (!validator.getPattern().accepts((Object)element, context)) continue;
            validators.add(Pair.pair((Object)validator, (Object)context));
        }
        return validators.isEmpty() ? null : newName -> ContainerUtil.and((Iterable)validators, p -> ((RenameInputValidator)p.first).isInputValid((String)newName, element, (ProcessingContext)p.second));
    }

    public static @Nullable Function<String, @NlsContexts.DialogMessage String> getInputErrorValidator(PsiElement element) {
        ArrayList<RenameInputValidatorEx> validators = new ArrayList<RenameInputValidatorEx>();
        for (RenameInputValidator validator : RenameInputValidator.EP_NAME.getExtensionList()) {
            if (!(validator instanceof RenameInputValidatorEx) || !validator.getPattern().accepts((Object)element, new ProcessingContext())) continue;
            validators.add((RenameInputValidatorEx)validator);
        }
        if (validators.isEmpty()) {
            return null;
        }
        Project project = element.getProject();
        return newName -> validators.stream().map(v -> v.getErrorMessage((String)newName, project)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

