/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.ide.actions.VirtualFileQualifiedNameProvider;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FqnUtil {
    @Nullable
    public static String getQualifiedNameFromProviders(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        return (String)DumbService.getInstance((Project)element.getProject()).computeWithAlternativeResolveEnabled(() -> QualifiedNameProviderUtil.getQualifiedName(element));
    }

    @Nullable
    public static String elementToFqn(@Nullable PsiElement element, @Nullable Editor editor) {
        PsiReference reference;
        String result = FqnUtil.getQualifiedNameFromProviders(element);
        if (result != null) {
            return result;
        }
        if (editor != null && (reference = TargetElementUtilBase.findReference((Editor)editor, (int)editor.getCaretModel().getOffset())) != null && (result = FqnUtil.getQualifiedNameFromProviders(reference.resolve())) != null) {
            return result;
        }
        if (element instanceof PsiFile) {
            return FileUtil.toSystemIndependentName((String)FqnUtil.getFileFqn((PsiFile)element));
        }
        if (element instanceof PsiDirectory) {
            return FileUtil.toSystemIndependentName((String)FqnUtil.getVirtualFileFqn(((PsiDirectory)element).getVirtualFile(), element.getProject()));
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getFileFqn(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null ? file.getName() : FqnUtil.getVirtualFileFqn(virtualFile, file.getProject());
    }

    @NotNull
    public static String getVirtualFileFqn(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        String scratchRelativePath;
        VirtualFile scratchRootVirtualFile;
        String relativePath;
        if (virtualFile == null) {
            FqnUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FqnUtil.$$$reportNull$$$0(1);
        }
        for (VirtualFileQualifiedNameProvider provider : VirtualFileQualifiedNameProvider.EP_NAME.getExtensionList()) {
            String qualifiedName = provider.getQualifiedName(project, virtualFile);
            if (qualifiedName == null) continue;
            String string = qualifiedName;
            if (string == null) {
                FqnUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        VirtualFile baseDirectory = BaseProjectDirectories.getInstance((Project)project).getBaseDirectoryFor(virtualFile);
        if (baseDirectory != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)baseDirectory)) != null) {
            String string = relativePath;
            if (string == null) {
                FqnUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        RootType rootType = RootType.forFile((VirtualFile)virtualFile);
        if (rootType != null && (scratchRootVirtualFile = VfsUtil.findFileByIoFile((File)new File(ScratchFileService.getInstance().getRootPath(rootType)), (boolean)false)) != null && (scratchRelativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)scratchRootVirtualFile)) != null) {
            String string = scratchRelativePath;
            if (string == null) {
                FqnUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = virtualFile.getPath();
        if (string == null) {
            FqnUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/FqnUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/FqnUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFileFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileFqn";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

