/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.CallerClassLoaderProvider;
import com.intellij.remoteServer.agent.impl.util.UrlCollector;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.InvocationHandler;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class RemoteAgentProxyFactoryBase
implements RemoteAgentProxyFactory {
    private final CallerClassLoaderProvider myCallerClassLoaderProvider;

    public RemoteAgentProxyFactoryBase(CallerClassLoaderProvider callerClassLoaderProvider) {
        this.myCallerClassLoaderProvider = callerClassLoaderProvider;
    }

    public <T> T createProxy(List<Path> libraries, Class<T> agentInterface, String agentClassName) throws Exception {
        ClassLoader callerClassLoader = this.myCallerClassLoaderProvider.getCallerClassLoader(agentInterface);
        ClassLoader agentClassLoader = this.createAgentClassLoader(libraries);
        Object agentImpl = agentClassLoader.loadClass(agentClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return (T)ReflectionUtil.proxy(agentInterface, (InvocationHandler)this.createInvocationHandler(agentImpl, agentClassLoader, callerClassLoader));
    }

    protected ClassLoader createAgentClassLoader(List<Path> libraries) throws Exception {
        return this.createAgentClassLoader(new UrlCollector().collect(libraries));
    }

    protected abstract ClassLoader createAgentClassLoader(URL[] var1) throws Exception;

    protected abstract InvocationHandler createInvocationHandler(Object var1, ClassLoader var2, ClassLoader var3);
}

