/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.agent.RemoteAgent;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.RemoteAgentProxyFactory;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.remoteServer.agent.impl.RemoteAgentReflectiveThreadProxyFactory;
import com.intellij.util.Base64;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RemoteAgentManagerImpl
extends RemoteAgentManager {
    private final RemoteAgentClassLoaderCache myClassLoaderCache = new RemoteAgentClassLoaderCache();

    public <T extends RemoteAgent> T createAgent(RemoteAgentProxyFactory agentProxyFactory, List<Path> instanceLibraries, List<Class<?>> commonJarClasses, String specificsRuntimeModuleName, String specificsBuildJarPath, Class<T> agentInterface, String agentClassName, Class<?> pluginClass) throws Exception {
        RemoteAgentManager.Builder builder = this.createAgentBuilder(agentProxyFactory, agentInterface, pluginClass).withRtDependencies(commonJarClasses).withInstanceLibraries(instanceLibraries).withModuleDependency(specificsRuntimeModuleName, specificsBuildJarPath);
        return (T)builder.buildAgent(agentClassName);
    }

    public <T extends RemoteAgent> RemoteAgentManager.Builder<T> createAgentBuilder(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
        if (agentProxyFactory == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(0);
        }
        if (agentInterface == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(1);
        }
        if (pluginClass == null) {
            RemoteAgentManagerImpl.$$$reportNull$$$0(2);
        }
        return new AgentBuilderImpl<T>(agentProxyFactory, agentInterface, pluginClass);
    }

    public RemoteAgentProxyFactory createReflectiveThreadProxyFactory(ClassLoader callerClassLoader) {
        return new RemoteAgentReflectiveThreadProxyFactory(this.myClassLoaderCache, callerClassLoader);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "agentProxyFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "agentInterface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "pluginClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl";
        objectArray[2] = "createAgentBuilder";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AgentBuilderImpl<T extends RemoteAgent>
    extends RemoteAgentManager.Builder<T> {
        private final List<Class<?>> myRtClasses;
        private final List<Path> myInstanceLibraries;
        private final List<Path> myModuleDependencies;
        private final RemoteAgentProxyFactory myAgentProxyFactory;
        private final Class<T> myAgentInterface;
        private final String myAllPluginsRoot;
        private final boolean myRunningFromSources;

        AgentBuilderImpl(@NotNull RemoteAgentProxyFactory agentProxyFactory, @NotNull Class<T> agentInterface, @NotNull Class<?> pluginClass) {
            if (agentProxyFactory == null) {
                AgentBuilderImpl.$$$reportNull$$$0(0);
            }
            if (agentInterface == null) {
                AgentBuilderImpl.$$$reportNull$$$0(1);
            }
            if (pluginClass == null) {
                AgentBuilderImpl.$$$reportNull$$$0(2);
            }
            this.myRtClasses = new ArrayList();
            this.myInstanceLibraries = new ArrayList<Path>();
            this.myModuleDependencies = new ArrayList<Path>();
            this.myAgentProxyFactory = agentProxyFactory;
            this.myAgentInterface = agentInterface;
            File plugin = new File(PathUtil.getJarPathForClass(pluginClass));
            this.myAllPluginsRoot = plugin.getParent();
            this.myRunningFromSources = plugin.isDirectory();
        }

        public T buildAgent(@NotNull String agentClassName) throws Exception {
            if (agentClassName == null) {
                AgentBuilderImpl.$$$reportNull$$$0(3);
            }
            @NotNull List<Path> libraries = this.listLibraryFiles();
            return (T)((RemoteAgent)this.myAgentProxyFactory.createProxy(libraries, this.myAgentInterface, agentClassName));
        }

        @NotNull
        private List<Path> listLibraryFiles() {
            ArrayList<Path> result = new ArrayList<Path>(this.myInstanceLibraries);
            ArrayList allRtClasses = new ArrayList(this.myRtClasses);
            allRtClasses.add(RemoteAgent.class);
            allRtClasses.add(Base64.class);
            allRtClasses.add(this.myAgentInterface);
            for (Class clazz : allRtClasses) {
                result.add(Path.of(PathUtil.getJarPathForClass((Class)clazz), new String[0]));
            }
            result.addAll(this.myModuleDependencies);
            ArrayList<Path> arrayList = result;
            if (arrayList == null) {
                AgentBuilderImpl.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        public RemoteAgentManager.Builder<T> withRtDependency(@NotNull Class<?> rtClass) {
            if (rtClass == null) {
                AgentBuilderImpl.$$$reportNull$$$0(5);
            }
            this.myRtClasses.add(rtClass);
            return this;
        }

        public RemoteAgentManager.Builder<T> withInstanceLibraries(List<Path> libraries) {
            this.myInstanceLibraries.addAll(libraries);
            return this;
        }

        public RemoteAgentManager.Builder<T> withModuleDependency(@NotNull String runtimeModuleName, @NotNull String buildPathToJar) {
            if (runtimeModuleName == null) {
                AgentBuilderImpl.$$$reportNull$$$0(6);
            }
            if (buildPathToJar == null) {
                AgentBuilderImpl.$$$reportNull$$$0(7);
            }
            if (this.myRunningFromSources) {
                Path specificsModule = Path.of(this.myAllPluginsRoot, new String[0]).resolve(runtimeModuleName);
                this.myModuleDependencies.add(specificsModule);
            } else {
                Path specificsDir = Path.of(this.myAllPluginsRoot, new String[0]).resolve(FileUtil.toSystemDependentName((String)buildPathToJar));
                this.myModuleDependencies.add(specificsDir);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentProxyFactory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentInterface";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "agentClassName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl$AgentBuilderImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rtClass";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtimeModuleName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildPathToJar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/agent/impl/RemoteAgentManagerImpl$AgentBuilderImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listLibraryFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildAgent";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "withRtDependency";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withModuleDependency";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

