/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerListConfigurable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerCombo<S extends ServerConfiguration>
extends ComboboxWithBrowseButton
implements UserActivityProviderComponent {
    private static final Comparator<RemoteServer<?>> SERVERS_COMPARATOR = Comparator.comparing(RemoteServer::getName, String.CASE_INSENSITIVE_ORDER);
    private final ServerType<S> myServerType;
    private final List<ChangeListener> myChangeListeners;
    private final CollectionComboBoxModel<ServerItem> myServerListModel;
    private String myServerNameReminder;

    public RemoteServerCombo(@NotNull ServerType<S> serverType) {
        if (serverType == null) {
            RemoteServerCombo.$$$reportNull$$$0(0);
        }
        this(serverType, (CollectionComboBoxModel<ServerItem>)new CollectionComboBoxModel());
    }

    private RemoteServerCombo(@NotNull ServerType<S> serverType, @NotNull CollectionComboBoxModel<ServerItem> model) {
        if (serverType == null) {
            RemoteServerCombo.$$$reportNull$$$0(1);
        }
        if (model == null) {
            RemoteServerCombo.$$$reportNull$$$0(2);
        }
        super((JComboBox)new ComboBox(model));
        this.myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myServerType = serverType;
        this.myServerListModel = model;
        this.refillModel(null);
        this.addActionListener(this::onBrowseServer);
        this.getComboBox().addActionListener(this::onItemChosen);
        this.getComboBox().addItemListener(this::onItemUnselected);
        this.getComboBox().setRenderer(new ColoredListCellRenderer<ServerItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ServerItem> list, ServerItem value, int index, boolean selected, boolean focused) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    return;
                }
                value.render((SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$1", "customizeCellRenderer"));
            }
        });
    }

    public ServerItem getSelectedItem() {
        return (ServerItem)this.myServerListModel.getSelectedItem();
    }

    @Nullable
    public RemoteServer<S> getSelectedServer() {
        ServerItem selected = this.getSelectedItem();
        return selected == null ? null : selected.findRemoteServer();
    }

    public void selectServerInCombo(@Nullable String serverName) {
        ServerItem item = this.findNonTransientItemForName(serverName);
        if (serverName != null && item == null && (item = this.getMissingServerItem(serverName)) != null) {
            this.myServerListModel.add(0, (Object)item);
        }
        this.getComboBox().setSelectedItem(item);
    }

    protected ServerType<S> getServerType() {
        return this.myServerType;
    }

    @NotNull
    protected List<TransientItem> getActionItems() {
        List<TransientItem> list = Collections.singletonList(new CreateNewServerItem());
        if (list == null) {
            RemoteServerCombo.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    protected ServerItem getMissingServerItem(@NotNull String serverName) {
        if (serverName == null) {
            RemoteServerCombo.$$$reportNull$$$0(4);
        }
        return new MissingServerItem(serverName);
    }

    @NotNull
    protected ServerItem getNoServersItem() {
        return new NoServersItem(this);
    }

    private ServerItem findNonTransientItemForName(@Nullable String serverName) {
        return this.myServerListModel.getItems().stream().filter(Objects::nonNull).filter(item -> !(item instanceof TransientItem)).filter(item -> Objects.equals(item.getServerName(), serverName)).findAny().orElse(null);
    }

    public void dispose() {
        super.dispose();
        this.myChangeListeners.clear();
    }

    protected final void fireStateChanged() {
        ChangeEvent event = new ChangeEvent((Object)this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    private void onBrowseServer(ActionEvent e) {
        ServerItem item = this.getSelectedItem();
        if (item != null) {
            item.onBrowseAction();
        } else {
            this.editServer(RemoteServerListConfigurable.createConfigurable(this.myServerType, null));
        }
    }

    private void onItemChosen(ActionEvent e) {
        RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, () -> {
            ServerItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                selectedItem.onItemChosen();
            }
            if (!(selectedItem instanceof TransientItem)) {
                this.fireStateChanged();
            }
            return null;
        });
    }

    private void onItemUnselected(ItemEvent e) {
        if (e.getStateChange() == 2) {
            ServerItem item = (ServerItem)e.getItem();
            this.myServerNameReminder = item == null ? null : item.getServerName();
        }
    }

    protected final boolean editServer(@NotNull RemoteServerListConfigurable configurable) {
        boolean isOk;
        if (configurable == null) {
            RemoteServerCombo.$$$reportNull$$$0(5);
        }
        if (isOk = ShowSettingsUtil.getInstance().editConfigurable((Component)((Object)this), (Configurable)configurable)) {
            RemoteServer<?> lastSelectedServer = configurable.getLastSelectedServer();
            this.refillModel(lastSelectedServer);
        }
        return isOk;
    }

    protected final void createAndEditNewServer() {
        String selectedBefore = this.myServerNameReminder;
        RemoteServersManager manager = RemoteServersManager.getInstance();
        RemoteServer newServer = manager.createServer(this.myServerType);
        manager.addServer(newServer);
        if (!this.editServer(RemoteServerListConfigurable.createConfigurable(this.myServerType, newServer.getName()))) {
            manager.removeServer(newServer);
            this.selectServerInCombo(selectedBefore);
        }
    }

    protected final void refillModel(@Nullable RemoteServer<?> newSelection) {
        String nameToSelect = newSelection != null ? newSelection.getName() : null;
        this.myServerListModel.removeAll();
        ServerItem itemToSelect = null;
        List<RemoteServer<S>> servers = this.getSortedServers();
        if (servers.isEmpty()) {
            ServerItem noServersItem = this.getNoServersItem();
            if (nameToSelect == null) {
                itemToSelect = noServersItem;
            }
            this.myServerListModel.add((Object)noServersItem);
        }
        for (RemoteServer<S> nextServer : this.getSortedServers()) {
            ServerItemImpl nextServerItem = new ServerItemImpl(nextServer.getName());
            if (itemToSelect == null && nextServer.getName().equals(nameToSelect)) {
                itemToSelect = nextServerItem;
            }
            this.myServerListModel.add((Object)nextServerItem);
        }
        for (TransientItem nextAction : this.getActionItems()) {
            this.myServerListModel.add((Object)nextAction);
        }
        this.setSelectedServerItem(newSelection, itemToSelect);
    }

    protected void setSelectedServerItem(@Nullable RemoteServer<?> newSelection, @Nullable ServerItem itemToSelect) {
        this.getComboBox().setSelectedItem(itemToSelect);
    }

    @NotNull
    protected List<RemoteServer<S>> getSortedServers() {
        ArrayList<RemoteServer<S>> result = new ArrayList<RemoteServer<S>>(RemoteServersManager.getInstance().getServers(this.myServerType));
        result.sort(SERVERS_COMPARATOR);
        ArrayList<RemoteServer<S>> arrayList = result;
        if (arrayList == null) {
            RemoteServerCombo.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            RemoteServerCombo.$$$reportNull$$$0(7);
        }
        this.myChangeListeners.add(changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            RemoteServerCombo.$$$reportNull$$$0(8);
        }
        this.myChangeListeners.remove(changeListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMissingServerItem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "editServer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    public static interface ServerItem {
        @Nullable
        public String getServerName();

        public void render(@NotNull SimpleColoredComponent var1);

        public void onItemChosen();

        public void onBrowseAction();

        @Nullable
        public RemoteServer<?> findRemoteServer();
    }

    private class CreateNewServerItem
    implements TransientItem {
        private CreateNewServerItem() {
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            if (ui == null) {
                CreateNewServerItem.$$$reportNull$$$0(0);
            }
            ui.setIcon((Icon)EmptyIcon.create((Icon)RemoteServerCombo.this.myServerType.getIcon()));
            ui.append(CloudBundle.message((String)"remote.server.combo.create.new.server", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Override
        public String getServerName() {
            return null;
        }

        @Override
        public void onItemChosen() {
            ((JComboBox)RemoteServerCombo.this.getChildComponent()).hidePopup();
            RemoteServerCombo.this.createAndEditNewServer();
        }

        @Override
        public void onBrowseAction() {
            RemoteServerCombo.this.createAndEditNewServer();
        }

        @Nullable
        public RemoteServer<S> findRemoteServer() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$CreateNewServerItem", "render"));
        }
    }

    protected class MissingServerItem
    extends ServerItemImpl {
        public MissingServerItem(String serverName) {
            if (serverName == null) {
                MissingServerItem.$$$reportNull$$$0(0);
            }
            super(serverName);
        }

        @Override
        @NotNull
        @NlsSafe
        public String getServerName() {
            String result = super.getServerName();
            assert (result != null);
            String string = result;
            if (string == null) {
                MissingServerItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            if (ui == null) {
                MissingServerItem.$$$reportNull$$$0(2);
            }
            ui.setIcon(RemoteServerCombo.this.myServerType.getIcon());
            ui.append(this.getServerName(), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$MissingServerItem";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$MissingServerItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected class NoServersItem
    extends ServerItemImpl {
        public NoServersItem(RemoteServerCombo this$0) {
            super(null);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            if (ui == null) {
                NoServersItem.$$$reportNull$$$0(0);
            }
            ui.setIcon(null);
            ui.append(CloudBundle.message((String)"remote.server.combo.no.servers", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$NoServersItem", "render"));
        }
    }

    public class ServerItemImpl
    implements ServerItem {
        @NlsSafe
        private final String myServerName;

        public ServerItemImpl(String serverName) {
            this.myServerName = serverName;
        }

        @Override
        @NlsSafe
        public String getServerName() {
            return this.myServerName;
        }

        @Override
        public void onItemChosen() {
        }

        @Override
        public void onBrowseAction() {
            RemoteServerCombo.this.editServer(RemoteServerListConfigurable.createConfigurable(RemoteServerCombo.this.myServerType, this.myServerName));
        }

        @Nullable
        public RemoteServer<S> findRemoteServer() {
            return this.myServerName == null ? null : RemoteServersManager.getInstance().findByName(this.myServerName, RemoteServerCombo.this.myServerType);
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            RemoteServer server;
            if (ui == null) {
                ServerItemImpl.$$$reportNull$$$0(0);
            }
            SimpleTextAttributes attributes = (server = this.findRemoteServer()) == null ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            ui.setIcon(server == null ? null : RemoteServerCombo.this.myServerType.getIcon());
            ui.append(StringUtil.notNullize((String)this.myServerName), attributes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerCombo$ServerItemImpl", "render"));
        }
    }

    public static interface TransientItem
    extends ServerItem {
    }
}

