/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerConnectionTester;
import com.intellij.remoteServer.impl.configuration.deployment.RemoteServerCombo;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerComboWithAutoDetect<S extends ServerConfiguration>
extends RemoteServerCombo<S> {
    private AutoDetectedItem myAutoDetectedItem;

    public RemoteServerComboWithAutoDetect(@NotNull ServerType<S> serverType) {
        if (serverType == null) {
            RemoteServerComboWithAutoDetect.$$$reportNull$$$0(0);
        }
        super(serverType);
    }

    @Override
    @NotNull
    protected RemoteServerCombo.ServerItem getNoServersItem() {
        RemoteServerCombo.ServerItem serverItem = this.getServerType().canAutoDetectConfiguration() ? this.findOrCreateAutoDetectedItem() : super.getNoServersItem();
        if (serverItem == null) {
            RemoteServerComboWithAutoDetect.$$$reportNull$$$0(1);
        }
        return serverItem;
    }

    protected AutoDetectedItem findOrCreateAutoDetectedItem() {
        if (this.myAutoDetectedItem == null) {
            this.myAutoDetectedItem = new AutoDetectedItem();
        }
        return this.myAutoDetectedItem;
    }

    public void validateAutoDetectedItem() throws RuntimeConfigurationException {
        if (this.myAutoDetectedItem != null && this.myAutoDetectedItem == this.getSelectedItem()) {
            this.myAutoDetectedItem.validateConnection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerComboWithAutoDetect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerComboWithAutoDetect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoServersItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class AutoDetectedItem
    extends RemoteServerCombo.ServerItemImpl {
        private final AtomicReference<TestConnectionState> myTestConnectionStateA;
        private volatile RemoteServer<S> myServerInstance;
        private volatile long myLastStartedTestConnectionMillis;

        AutoDetectedItem() {
            super(null);
            this.myTestConnectionStateA = new AtomicReference<TestConnectionState>(TestConnectionState.INITIAL);
            this.myLastStartedTestConnectionMillis = -1L;
        }

        @Override
        public void render(@NotNull SimpleColoredComponent ui) {
            if (ui == null) {
                AutoDetectedItem.$$$reportNull$$$0(0);
            }
            ui.setIcon(RemoteServerComboWithAutoDetect.this.getServerType().getIcon());
            boolean failed = this.myTestConnectionStateA.get() == TestConnectionState.FAILED;
            ui.append(CloudBundle.message((String)"remote.server.combo.auto.detected.server", (Object[])new Object[]{RemoteServerComboWithAutoDetect.this.getServerType().getPresentableName()}), failed ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        }

        public void validateConnection() throws RuntimeConfigurationException {
            this.myTestConnectionStateA.get().validateConnection();
        }

        @Override
        public void onBrowseAction() {
            RemoteServerComboWithAutoDetect.this.createAndEditNewServer();
        }

        @Override
        public void onItemChosen() {
            if (this.myServerInstance == null) {
                this.myServerInstance = RemoteServersManager.getInstance().createServer(RemoteServerComboWithAutoDetect.this.getServerType());
                RemoteServerConnectionTester tester = new RemoteServerConnectionTester(this.myServerInstance);
                this.setTestConnectionState(TestConnectionState.IN_PROGRESS);
                this.myLastStartedTestConnectionMillis = System.currentTimeMillis();
                tester.testConnection(this::connectionTested);
            }
        }

        @Override
        @Nullable
        public String getServerName() {
            return null;
        }

        @Override
        @Nullable
        public RemoteServer<S> findRemoteServer() {
            return this.myServerInstance;
        }

        private void setTestConnectionState(@NotNull TestConnectionState state) {
            boolean changed;
            if (state == null) {
                AutoDetectedItem.$$$reportNull$$$0(1);
            }
            boolean bl = changed = this.myTestConnectionStateA.getAndSet(state) != state;
            if (changed) {
                UIUtil.invokeLaterIfNeeded(RemoteServerComboWithAutoDetect.this::fireStateChanged);
            }
        }

        private void connectionTested(boolean wasConnected, String errorStatus) {
            assert (this.myLastStartedTestConnectionMillis > 0L);
            this.waitABit(2000L);
            if (wasConnected) {
                this.setTestConnectionState(TestConnectionState.SUCCESSFUL);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!Disposer.isDisposed((Disposable)RemoteServerComboWithAutoDetect.this)) {
                        assert (this.myServerInstance != null);
                        RemoteServersManager.getInstance().addServer(this.myServerInstance);
                        RemoteServerComboWithAutoDetect.this.refillModel(this.myServerInstance);
                    }
                    this.myServerInstance = null;
                });
            } else {
                this.setTestConnectionState(TestConnectionState.FAILED);
                this.myServerInstance = null;
            }
        }

        private void waitABit(long maxTotalDelayMillis) {
            long THRESHOLD_MS = 50L;
            long naturalDelay = System.currentTimeMillis() - this.myLastStartedTestConnectionMillis;
            if (naturalDelay > 0L && naturalDelay + 50L < maxTotalDelayMillis) {
                try {
                    Thread.sleep(maxTotalDelayMillis - naturalDelay - 50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.myLastStartedTestConnectionMillis = -1L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/RemoteServerComboWithAutoDetect$AutoDetectedItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "render";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTestConnectionState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum TestConnectionState {
        INITIAL{

            @Override
            public void validateConnection() throws RuntimeConfigurationException {
            }
        }
        ,
        IN_PROGRESS{

            @Override
            public void validateConnection() throws RuntimeConfigurationException {
                throw new RuntimeConfigurationWarning(CloudBundle.message((String)"remote.server.combo.message.test.connection.in.progress", (Object[])new Object[0]));
            }
        }
        ,
        SUCCESSFUL{

            @Override
            public void validateConnection() throws RuntimeConfigurationException {
            }
        }
        ,
        FAILED{

            @Override
            public void validateConnection() throws RuntimeConfigurationException {
                throw new RuntimeConfigurationError(CloudBundle.message((String)"remote.server.combo.message.test.connection.failed", (Object[])new Object[0]));
            }
        };


        public abstract void validateConnection() throws RuntimeConfigurationException;
    }
}

