/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerType<C extends ServerConfiguration> {
    public static final ExtensionPointName<ServerType<?>> EP_NAME = ExtensionPointName.create((String)"com.intellij.remoteServer.type");
    @NotNull
    @NonNls
    private final String myId;

    protected ServerType(@NotNull @NonNls String id) {
        if (id == null) {
            ServerType.$$$reportNull$$$0(0);
        }
        this.myId = id;
    }

    @NotNull
    @NonNls
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            ServerType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public abstract String getPresentableName();

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDeploymentConfigurationTypePresentableName() {
        String string = CloudBundle.message("server.type.deployment.configuration.typ.presentable.name.0.deployment", this.getPresentableName());
        if (string == null) {
            ServerType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDeploymentConfigurationFactoryId() {
        PluginException.reportDeprecatedDefault(this.getClass(), (String)"getDeploymentConfigurationFactoryId", (String)"The default implementation delegates to 'getDeploymentConfigurationTypePresentableName' which is supposed to be localized, but return value of this method must not be localized.");
        String string = this.getDeploymentConfigurationTypePresentableName();
        if (string == null) {
            ServerType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.settings.clouds";
    }

    @NotNull
    public abstract Icon getIcon();

    public boolean canAutoDetectConfiguration() {
        return false;
    }

    @NotNull
    public abstract C createDefaultConfiguration();

    @NotNull
    public RemoteServerConfigurable createServerConfigurable(@NotNull C configuration) {
        if (configuration == null) {
            ServerType.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public abstract DeploymentConfigurator<?, C> createDeploymentConfigurator(Project var1);

    public List<SingletonDeploymentSourceType> getSingletonDeploymentSourceTypes() {
        return Collections.emptyList();
    }

    public boolean mayHaveProjectSpecificDeploymentSources() {
        return true;
    }

    @NotNull
    public abstract ServerConnector<?> createConnector(@NotNull C var1, @NotNull ServerTaskExecutor var2);

    @NotNull
    public ServerConnector<?> createConnector(@NotNull RemoteServer<C> server, @NotNull ServerTaskExecutor asyncTasksExecutor) {
        if (server == null) {
            ServerType.$$$reportNull$$$0(5);
        }
        if (asyncTasksExecutor == null) {
            ServerType.$$$reportNull$$$0(6);
        }
        ServerConnector<?> serverConnector = this.createConnector(server.getConfiguration(), asyncTasksExecutor);
        if (serverConnector == null) {
            ServerType.$$$reportNull$$$0(7);
        }
        return serverConnector;
    }

    @Nullable
    public DebugConnector<?, ?> createDebugConnector() {
        return null;
    }

    @NotNull
    public Comparator<Deployment> getDeploymentComparator() {
        Comparator<Deployment> comparator = Comparator.comparing(Deployment::getName);
        if (comparator == null) {
            ServerType.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    @Nullable
    public String getCustomToolWindowId() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/ServerType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncTasksExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/ServerType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurationTypePresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurationFactoryId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createConnector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createServerConfigurable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConnector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 8 -> new IllegalStateException(string);
        };
    }
}

