/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.configurationStore.SettingsSavingComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.serviceContainer.ComponentManagerImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0000\u001a&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0080@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"getComponentManagerEx", "Lcom/intellij/openapi/components/ComponentManagerEx;", "Lcom/intellij/openapi/components/ComponentManager;", "checkCanceledIfNotInClassInit", "", "isUnderIndicatorOrJob", "", "throwAlreadyDisposedError", "serviceDescription", "", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "doNotUseConstructorInjectionsMessage", "where", "initializeComponentOrLightService", "component", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "(Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginId;Lcom/intellij/serviceContainer/ComponentManagerImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.serviceContainer"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\ncontainerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 containerUtil.kt\ncom/intellij/serviceContainer/ContainerUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,64:1\n12970#2,2:65\n*S KotlinDebug\n*F\n+ 1 containerUtil.kt\ncom/intellij/serviceContainer/ContainerUtilKt\n*L\n29#1:65,2\n*E\n"})
public final class ContainerUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final ComponentManagerEx getComponentManagerEx(@NotNull ComponentManager $this$getComponentManagerEx) {
        Intrinsics.checkNotNullParameter((Object)$this$getComponentManagerEx, (String)"<this>");
        ComponentManager componentManager = ((ComponentManagerEx)$this$getComponentManagerEx).getMutableComponentContainer();
        Intrinsics.checkNotNull((Object)componentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        return (ComponentManagerEx)componentManager;
    }

    public static final void checkCanceledIfNotInClassInit() {
        block4: {
            try {
                ProgressManager.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                boolean bl;
                block3: {
                    StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                    Object[] $this$any$iv = stackTraceElementArray;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        StackTraceElement it = (StackTraceElement)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getMethodName(), (Object)"<clinit>")) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (bl) break block4;
                throw e;
            }
        }
    }

    public static final boolean isUnderIndicatorOrJob() {
        ProgressManager progressManager = ProgressManager.getInstanceOrNull();
        return (progressManager != null ? progressManager.getProgressIndicator() : null) != null || Cancellation.currentJob() != null;
    }

    @ApiStatus.Internal
    public static final void throwAlreadyDisposedError(@NotNull String serviceDescription, @NotNull ComponentManagerImpl componentManager) {
        Intrinsics.checkNotNullParameter((Object)serviceDescription, (String)"serviceDescription");
        Intrinsics.checkNotNullParameter((Object)((Object)componentManager), (String)"componentManager");
        throw new AlreadyDisposedException("Cannot create " + serviceDescription + " because container is already disposed (container=" + componentManager + ")");
    }

    @NotNull
    public static final String doNotUseConstructorInjectionsMessage(@NotNull String where) {
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        return "Please, do not use constructor injection: it slows down initialization and may lead to performance problems (" + where + "). See https://plugins.jetbrains.com/docs/intellij/plugin-services.html for details.";
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object initializeComponentOrLightService(@NotNull Object component, @NotNull PluginId pluginId, @NotNull ComponentManagerImpl componentManager, @NotNull Continuation<? super Unit> $completion) {
        block5: {
            if (component instanceof Disposable) {
                Disposer.register((Disposable)componentManager.serviceParentDisposable, (Disposable)((Disposable)component));
            }
            if (!(component instanceof PersistentStateComponent) && !(component instanceof SettingsSavingComponent) && !(component instanceof JDOMExternalizable)) break block5;
            componentStore = componentManager.getComponentStore();
            if (componentStore.isStoreInitialized()) ** GOTO lbl-1000
            v0 = componentManager.getApplication();
            Intrinsics.checkNotNull((Object)v0);
            if (v0.isUnitTestMode()) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) {
                $i$a$-check-ContainerUtilKt$initializeComponentOrLightService$2 = false;
                var5_6 = "You cannot get " + component + " before component store is initialized";
                throw new IllegalStateException(var5_6.toString());
            }
            v2 = IComponentStore.initComponent$default((IComponentStore)componentStore, (Object)component, null, (PluginId)pluginId, null, $completion, (int)8, null);
            if (v2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return v2;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }
}

