/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11DisplayNameGetter;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.ApplyJschBasedOpenSshConfig;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.SmartFMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a5\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002\u00a2\u0006\u0002\u0010\f\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0004*\u00020\u0004H\u0002\"/\u0010\u0016\u001a#\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00140\u00140\u0017\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"applyJschBasedOpenSshConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "source", "config", "", "addDefaultPrivateKeysIfNeeded", "parseSeparatedMulti", "", "", "splitChar", "", "fallback", "([Ljava/lang/String;CLjava/util/List;)Ljava/util/List;", "parseSeparated", "yesNo", "", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "key", "(Lcom/intellij/ssh/config/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Boolean;", "strictHostKeyCheckingFromOpenSshConfigOption", "Lcom/intellij/remote/SshConnectionConfigPatch$HostKeyVerifier$StrictHostKeyChecking;", "strictHostKeyCheckingValue", "strictHostKeyCheckingMap", "Lcom/intellij/util/SmartFMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "unquoteSingleArgumentValue", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
@JvmName(name="ApplyJschBasedOpenSshConfig")
@SourceDebugExtension(value={"SMAP\nApplyJschBasedOpenSshConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,314:1\n1#2:315\n1#2:330\n1#2:348\n1#2:390\n19#3:316\n19#3:337\n774#4:317\n865#4,2:318\n1617#4,9:320\n1869#4:329\n1870#4:331\n1626#4:332\n1563#4:333\n1634#4,3:334\n1011#4,2:351\n1374#4:361\n1460#4,5:362\n1803#4,3:367\n1563#4:370\n1634#4,3:371\n1374#4:374\n1460#4,5:375\n1617#4,9:380\n1869#4:389\n1870#4:391\n1626#4:392\n1563#4:396\n1634#4,3:397\n774#4:400\n865#4,2:401\n11879#5,9:338\n13805#5:347\n13806#5:349\n11888#5:350\n11561#5:353\n11896#5,3:354\n11561#5:357\n11896#5,3:358\n13216#5,3:393\n13#6:403\n*S KotlinDebug\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n*L\n103#1:330\n131#1:348\n224#1:390\n92#1:316\n124#1:337\n102#1:317\n102#1:318,2\n103#1:320,9\n103#1:329\n103#1:331\n103#1:332\n105#1:333\n105#1:334,3\n189#1:351,2\n207#1:361\n207#1:362,5\n211#1:367,3\n218#1:370\n218#1:371,3\n220#1:374\n220#1:375,5\n224#1:380,9\n224#1:389\n224#1:391\n224#1:392\n282#1:396\n282#1:397,3\n282#1:400\n282#1:401,2\n131#1:338,9\n131#1:347\n131#1:349\n131#1:350\n199#1:353\n199#1:354,3\n203#1:357\n203#1:358,3\n265#1:393,3\n313#1:403\n*E\n"})
public final class ApplyJschBasedOpenSshConfig {
    @NotNull
    private static final SmartFMap<String, SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking> strictHostKeyCheckingMap;
    @NotNull
    private static final Logger LOG;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final SshConnectionConfig applyJschBasedOpenSshConfig(@NotNull SshConnectionConfig source, @NotNull String config) {
        block105: {
            block104: {
                block103: {
                    block102: {
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                        var3_2 = OpenSSHConfig.parse(config).getConfig(source.getHost());
                        Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"getConfig(...)");
                        parsed = var3_2;
                        var4_4 = parsed.getValue("HostName");
                        v0 = var4_4;
                        if (v0 == null) {
                            v0 = host = source.getHost();
                        }
                        if ((v1 = (var5_5 = parsed.getValue("User"))) == null) {
                            v1 = source.getUser();
                        }
                        user = v1;
                        var6_7 = parsed.getValue("Port");
                        v2 = var6_7;
                        port = v2 != null && (v2 = (var7_8 = StringsKt.toIntOrNull((String)v2))) != null ? v2.intValue() : source.getPort();
                        raw = var7_8 = parsed.getValue("ConnectTimeout");
                        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$connectTimeout$1 = false;
                        if (raw == null) ** GOTO lbl-1000
                        switch (raw.hashCode()) {
                            case 3387192: {
                                if (raw.equals("none")) {
                                    v3 = null;
                                    break;
                                }
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if ((v3 = raw) != null && (v3 = StringsKt.toLongOrNull((String)v3)) != null) {
                                    it = ((Number)v3).longValue();
                                    $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$connectTimeout$1$1 = false;
                                    v4 = Duration.ofSeconds(it);
                                    v3 = v4;
                                    if (v4 != null) break;
                                }
                                v3 = source.getConnectTimeout();
                            }
                        }
                        connectTimeout = v3;
                        v5 = raw = ApplyJschBasedOpenSshConfig.yesNo(parsed, "Compression");
                        compression = v5 != null ? v5.booleanValue() : source.getCompression();
                        kexAlgorithms = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("KexAlgorithms"), ',', source.getKexAlgorithms());
                        hostKeyAlgorithms = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("HostKeyAlgorithms"), ',', source.getHostKeyAlgorithms());
                        ciphers = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("Ciphers"), ',', source.getCiphers());
                        macs = ApplyJschBasedOpenSshConfig.parseSeparatedMulti(parsed.getValues("MACs"), ',', source.getMacs());
                        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1 = false;
                        v6 = parsed.getValue("ServerAliveInterval");
                        if (v6 == null || (v6 = StringsKt.toLongOrNull((String)v6)) == null) ** GOTO lbl-1000
                        var14_20 = v6;
                        it = ((Number)var14_20).longValue();
                        $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$1 = false;
                        v6 = it > 0L != false ? var14_20 : null;
                        if (v6 != null) {
                            it = ((Number)v6).longValue();
                            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2 = false;
                            v7 = Duration.ofSeconds(it);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = cfgInterval = null;
                        }
                        if ((v8 = parsed.getValue("ServerAliveCountMax")) != null && (v8 = StringsKt.toIntOrNull((String)v8)) != null) {
                            var14_20 = v8;
                            it = ((Number)var14_20).intValue();
                            $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgCountMax$1 = false;
                            v9 = it > 0 ? var14_20 : null;
                        } else {
                            v9 = null;
                        }
                        cfgCountMax = v9;
                        if (cfgInterval != null && cfgCountMax != null) {
                            v10 = new ServerAlive(cfgInterval, cfgCountMax);
                        } else if (cfgInterval != null) {
                            v11 = source.getServerAlive();
                            v10 = new ServerAlive(cfgInterval, v11 != null ? v11.getCountMax() : 3);
                        } else if (cfgCountMax != null) {
                            v12 = source.getServerAlive();
                            v10 = v12 != null ? ServerAlive.copy$default(v12, null, cfgCountMax, 1, null) : null;
                        } else {
                            v10 = source.getServerAlive();
                        }
                        serverAlive = v10;
                        if (!Registry.Companion.is("ssh.x11.forwarding")) ** GOTO lbl-1000
                        v13 = var14_20 = parsed.getValue("ForwardX11");
                        if (v13 != null) {
                            it = v13;
                            var16_43 = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)var16_43, (String)"getDefault(...)");
                            v14 = it.toLowerCase((Locale)var16_43);
                            v15 = v14;
                            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"toLowerCase(...)");
                        } else {
                            v15 = null;
                        }
                        if (!Intrinsics.areEqual(v15, (Object)"yes")) lbl-1000:
                        // 2 sources

                        {
                            v16 = null;
                        } else {
                            v17 = var14_20 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "ForwardX11Trusted");
                            if (v17 != null) {
                                v18 = v17.booleanValue();
                            } else {
                                v19 = var16_43 = source.getX11Forwarding();
                                v20 = it = v19 != null ? Boolean.valueOf(v19.getTrusted()) : null;
                                v18 = v20 != null ? v20 : false;
                            }
                            if ((v21 = (var14_20 = parsed.getValue("XAuthLocation"))) == null) {
                                v22 = var16_43 = source.getX11Forwarding();
                                it = v22 != null ? v22.getXAuthLocation() : null;
                                v21 = it;
                                if (v21 == null) {
                                    v21 = X11Forwarding.Companion.getDefaultXAuthLocation();
                                }
                            }
                            if ((v23 = (var14_20 = source.getX11Forwarding())) == null || (v23 = (it = v23.getDisplayName())) == null) {
                                v23 = X11DisplayNameGetter.Companion.getInstance().getDisplay();
                            }
                            v16 = x11Forwarding = new X11Forwarding(v18, (String)v21, (String)v23);
                        }
                        if (!Registry.Companion.is("ssh.agent.forwarding")) ** GOTO lbl-1000
                        v24 = it = parsed.getValue("ForwardAgent");
                        if (v24 != null) {
                            var16_43 = v24;
                            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2 = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2, (String)"getDefault(...)");
                            v25 = var16_43.toLowerCase($i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2);
                            v26 = v25;
                            Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"toLowerCase(...)");
                        } else {
                            v26 = null;
                        }
                        if (Intrinsics.areEqual(v26, (Object)"yes")) {
                            v27 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v27 = false;
                        }
                        forwardAgent = v27;
                        v28 = var16_43 = parsed.getValue("IdentityAgent");
                        if (v28 != null) {
                            p0 = $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$serverAlive$1$cfgInterval$2 = v28;
                            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$identityAgent$1 = false;
                            v29 = new IdentityAgent((String)p0);
                        } else {
                            v29 = null;
                        }
                        identityAgent = v29;
                        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1 = false;
                        $this$asSafely$iv = source.getHostKeyVerifier();
                        $i$f$asSafely = false;
                        v30 = $this$asSafely$iv;
                        if (!(v30 instanceof OpenSshLikeHostKeyVerifier)) {
                            v30 = null;
                        }
                        old = (OpenSshLikeHostKeyVerifier)v30;
                        v31 /* !! */  = parsed.getValue("StrictHostKeyChecking");
                        if (v31 /* !! */  == null) break block102;
                        it = v31 /* !! */ ;
                        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$strictHostKeyChecking$1 = false;
                        v32 = ApplyJschBasedOpenSshConfig.strictHostKeyCheckingFromOpenSshConfigOption((String)it);
                        v31 /* !! */  = v32;
                        if (v32 != null) break block103;
                    }
                    v33 = old;
                    v31 /* !! */  = v33 != null ? v33.getStrictHostKeyChecking() : (strictHostKeyChecking = SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK);
                }
                if ((var23_50 = parsed.getValue("UserKnownHostsFile")) == null) ** GOTO lbl-1000
                it = new char[1];
                it[0] = 32;
                var24_58 = StringsKt.split$default((CharSequence)var23_50, (char[])it, (boolean)false, (int)0, (int)6, null);
                if (var24_58 != null) {
                    $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$strictHostKeyChecking$1 = (Iterable)var24_58;
                    $i$f$filter = false;
                    var26_74 = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = false;
                        v34 = !StringsKt.isBlank((CharSequence)it);
                        if (!v34) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    it = (List)destination$iv$iv;
                    $i$f$filter = (Iterable)it;
                    $i$f$mapNotNull = false;
                    destination$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = $this$forEach$iv$iv$iv.iterator();
                    while ($i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1.hasNext()) {
                        element$iv$iv = element$iv$iv$iv = $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1.next();
                        $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                        it = (String)element$iv$iv;
                        $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2 = false;
                        try {
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = false;
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = Result.constructor-impl((Object)new File(OSAgnosticPathUtil.expandUserHome((String)StringsKt.trim((CharSequence)((CharSequence)it)).toString())));
                        }
                        catch (Throwable var39_144) {
                            $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var39_144));
                        }
                        if ((File)(Result.isFailure-impl((Object)$i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1) != false ? null : $i$a$-runCatching-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$2$1) == null) continue;
                        $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v35 = $this$filter$iv = (List)destination$iv$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v36 = old;
                    if (v36 != null) {
                        v35 = v36.getKnownHostsFiles();
                    } else {
                        $this$map$iv = OpenSSHConfigUtil.getDefaultKnownHostsFiles();
                        $i$f$map = false;
                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = 0;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            $i$a$-filter-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$1 = (Path)item$iv$iv;
                            var42_150 = destination$iv$iv;
                            $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$hostKeyVerifier$1$knownHostsFiles$3 = false;
                            var42_150.add(it.toFile());
                        }
                        v35 = (List)destination$iv$iv;
                    }
                }
                knownHostsFiles = v35;
                v37 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "HashKnownHosts");
                if (v37 != null) {
                    v38 = v37;
                } else {
                    v39 = old;
                    v40 = v39 != null ? Boolean.valueOf(v39.getHashKnownHosts()) : null;
                    v38 = hashKnownHosts = v40 != null ? v40 : false;
                }
                hostKeyVerifier = ((Collection)knownHostsFiles).isEmpty() == false ? (SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier((List)knownHostsFiles, (SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking)strictHostKeyChecking, hashKnownHosts, false, 8, null) : source.getHostKeyVerifier();
                strictHostKeyChecking = parsed.getValue("ProxyCommand");
                v41 = strictHostKeyChecking;
                if (v41 == null || (v41 = (knownHostsFiles = ApplyJschBasedOpenSshConfig.unquoteSingleArgumentValue((String)v41))) == null) break block104;
                it = it = v41;
                $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$1 = false;
                if (!(((CharSequence)it).length() > 0)) ** GOTO lbl-1000
                var24_58 = it;
                v42 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"getDefault(...)");
                v43 = var24_58.toLowerCase(v42);
                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)v43, (Object)"none")) {
                    v44 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v44 = false;
                }
                if ((v41 = (old = v44 != false ? it : null)) != null) break block105;
            }
            if ((v45 = (it = parsed.getValue("ProxyJump"))) == null) ** GOTO lbl-1000
            p0 = $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$1 = v45;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$2 = false;
            it = OpenSSHConfigUtil.parseJump((String)p0);
            v45 = it;
            if (v45 != null) {
                v41 = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)v45);
            } else lbl-1000:
            // 2 sources

            {
                $this$asSafely$iv = source.getProxyConfig();
                $i$f$asSafely = false;
                v46 = $this$asSafely$iv;
                if (!(v46 instanceof SshProxyConfig.Command)) {
                    v46 = null;
                }
                v47 = $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyCommand$1 = (SshProxyConfig.Command)v46;
                v41 = v47 != null ? v47.getCommand() : null;
            }
        }
        v48 = proxyCommand = v41;
        if (v48 != null) {
            it = knownHostsFiles = v48;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 = false;
            v49 = new SshProxyConfig.Command((String)it);
        } else {
            v49 = null;
        }
        proxyConfig = v49;
        $i$a$-run-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1 = false;
        $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 = parsed.getValues("IdentityFile");
        if ($i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1 != null) {
            it = $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$proxyConfig$1;
            $i$f$mapNotNull = false;
            $this$asSafely$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            $this$forEach$iv$iv$iv = ((void)$this$forEach$iv$iv$iv).length;
            for ($i$f$mapTo = 0; $i$f$mapTo < $this$forEach$iv$iv$iv; ++$i$f$mapTo) {
                element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[$i$f$mapTo];
                $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                it = element$iv$iv;
                $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$identityFiles$1 = false;
                try {
                    Intrinsics.checkNotNull((Object)it);
                    it = Paths.get(OSAgnosticPathUtil.expandUserHome((String)ApplyJschBasedOpenSshConfig.unquoteSingleArgumentValue((String)it)), new String[0]);
                }
                catch (InvalidPathException err) {
                    ApplyJschBasedOpenSshConfig.LOG.warn("Wrong IdentityFile " + (String)it);
                    it = null;
                }
                if (it == null) continue;
                $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            v50 = it$iv$iv = (List)destination$iv$iv;
        } else {
            v50 = CollectionsKt.emptyList();
        }
        identityFiles = v50;
        identitiesOnly = ApplyJschBasedOpenSshConfig.yesNo(parsed, "IdentitiesOnly");
        sourcePublicKey = SshConnectionConfigKt.findPublicKeyWithIndex(source.getAuthMethods());
        result = CollectionsKt.toMutableList((Collection)source.getAuthMethods());
        if (((Collection)identityFiles).isEmpty() == false && sourcePublicKey != null) {
            result.remove(((Number)sourcePublicKey.getFirst()).intValue());
        }
        v51 = sourcePublicKey;
        v52 = v51 != null ? ((Number)v51.getFirst()).intValue() : result.size();
        v53 = sourcePublicKey;
        v54 = v53 != null && (v53 = (AuthMethod.PublicKey)v53.getSecond()) != null ? v53.getAgent() : null;
        switch (v54 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v54.ordinal()]) {
            case 1: {
                v55 = AuthMethod.PublicKey.Agent.NO;
                break;
            }
            case 2: 
            case 3: {
                destination$iv$iv = identitiesOnly;
                if (Intrinsics.areEqual((Object)destination$iv$iv, (Object)true)) {
                    v55 = AuthMethod.PublicKey.Agent.ONLY_MENTIONED;
                    break;
                }
                if (Intrinsics.areEqual((Object)destination$iv$iv, (Object)false)) {
                    v55 = AuthMethod.PublicKey.Agent.ALL;
                    break;
                }
                if (destination$iv$iv == null) {
                    v55 = ((AuthMethod.PublicKey)sourcePublicKey.getSecond()).getAgent();
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            case -1: {
                v55 = AuthMethod.PublicKey.Agent.ALL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        result.add(v52, new AuthMethod.PublicKey(identityFiles, v55));
        ((Collection)result).add(AuthMethod.Password.INSTANCE);
        if (!Intrinsics.areEqual((Object)ApplyJschBasedOpenSshConfig.yesNo(parsed, "ChallengeResponseAuthentication"), (Object)false)) {
            ((Collection)result).add(AuthMethod.KeyboardInteractive.INSTANCE);
        }
        v56 = ApplyJschBasedOpenSshConfig.yesNo(parsed, "GSSAPIAuthentication");
        if (v56 != null) {
            it = v56;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$1 = false;
            if (it) {
                result.add(0, AuthMethod.GssApi.INSTANCE);
                v57 = Unit.INSTANCE;
            } else {
                v57 = result.remove(AuthMethod.GssApi.INSTANCE);
            }
        } else {
            v57 = null;
        }
        if ((v58 = parsed.getValue("PreferredAuthentications")) != null && (v58 = ApplyJschBasedOpenSshConfig.parseSeparated((String)v58, ',')) != null) {
            preferredAuthentications = v58;
            $i$a$-let-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$authMethods$1$2 = false;
            $this$sortBy$iv = result;
            $i$f$sortBy = 0;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator((List)preferredAuthentications){
                    final /* synthetic */ List $preferredAuthentications$inlined;
                    {
                        this.$preferredAuthentications$inlined = list;
                    }

                    public final int compare(T a, T b) {
                        AuthMethod it = (AuthMethod)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)) + Integer.MAX_VALUE + 1);
                        it = (AuthMethod)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(it)) + Integer.MAX_VALUE + 1));
                    }
                });
            }
            v59 = Unit.INSTANCE;
        } else {
            v59 = null;
        }
        authMethods = AuthMethods.Companion.create((Iterable)result);
        v60 = identitiesOnly = ApplyJschBasedOpenSshConfig.yesNo(parsed, "ClearAllForwardings");
        v61 = clearAllForwarding = v60 != null ? v60 : false;
        if (clearAllForwarding) {
            v62 = source.getInitialLocalTcpForwardings();
        } else {
            v63 = source.getInitialLocalTcpForwardings();
            if (result != null) {
                $this$mapNotNullTo$iv$iv = result = parsed.getValues("LocalForward");
                var44_151 = v63;
                $i$f$map = false;
                preferredAuthentications = $this$map$iv /* !! */ ;
                destination$iv$iv = new ArrayList<E>($this$map$iv /* !! */ .length);
                $i$f$mapTo = false;
                $this$forEach$iv$iv$iv = ((void)$this$mapTo$iv$iv).length;
                for ($i$f$sortBy = 0; $i$f$sortBy < $this$forEach$iv$iv$iv; ++$i$f$sortBy) {
                    element$iv$iv = item$iv$iv = $this$mapTo$iv$iv[$i$f$sortBy];
                    var45_152 = destination$iv$iv;
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialLocalTcpForwardings$1 = false;
                    var46_153 = OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)p0);
                    var45_152.add(var46_153);
                }
                var45_152 = (List)destination$iv$iv;
                v63 = var44_151;
                $i$f$mapNotNull = var45_152;
                v64 = $i$f$mapNotNull;
            } else {
                v64 = CollectionsKt.emptyList();
            }
            v62 = initialLocalTcpForwardings = CollectionsKt.plus((Collection)v63, (Iterable)v64);
        }
        if (clearAllForwarding) {
            v65 = source.getInitialRemoteTcpForwardings();
        } else {
            v66 = source.getInitialRemoteTcpForwardings();
            if ($i$f$mapNotNull != null) {
                $i$f$map = $i$f$mapNotNull = parsed.getValues("RemoteForward");
                var44_151 = v66;
                $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = 0;
                item$iv$iv = ((void)$this$mapTo$iv$iv).length;
                for ($this$forEach$iv$iv$iv = 0; $this$forEach$iv$iv$iv < item$iv$iv; ++$this$forEach$iv$iv$iv) {
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialLocalTcpForwardings$1 = item$iv$iv = $this$mapTo$iv$iv[$this$forEach$iv$iv$iv];
                    var45_152 = destination$iv$iv;
                    $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$initialRemoteTcpForwardings$1 = false;
                    var46_153 = OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)p0);
                    var45_152.add(var46_153);
                }
                var45_152 = (List)destination$iv$iv;
                v66 = var44_151;
                $this$map$iv /* !! */  = var45_152;
                v67 = (Iterable)$this$map$iv /* !! */ ;
            } else {
                v67 = CollectionsKt.emptyList();
            }
            v65 = CollectionsKt.plus((Collection)v66, (Iterable)v67);
        }
        initialRemoteTcpForwardings = v65;
        v68 /* !! */  = $this$map$iv /* !! */  = parsed.getValues("SendEnv");
        if ($this$map$iv /* !! */  == null || (v68 /* !! */  = ($this$map$iv = ArraysKt.toList((Object[])v68 /* !! */ ))) == null) {
            v68 /* !! */  = CollectionsKt.emptyList();
        }
        $this$map$iv /* !! */  = (Iterable)v68 /* !! */ ;
        $i$f$flatMap = false;
        $i$f$map = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            rawConcat = (String)element$iv$iv;
            $i$a$-flatMap-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$1 = false;
            Intrinsics.checkNotNull((Object)rawConcat);
            v69 = UtilKt.argvSplit(rawConcat, true);
            if (v69 == null) {
                v69 = CollectionsKt.emptyList();
            }
            list$iv$iv = v69;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = new LinkedHashSet<E>();
        $i$f$fold = false;
        accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            element$iv$iv = (String)element$iv;
            set = accumulator$iv;
            $i$a$-fold-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$2 = false;
            if (StringsKt.startsWith$default((String)raw, (String)"-", (boolean)false, (int)2, null)) {
                v70 = (Collection)set;
                v71 = raw.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)v71, (String)"substring(...)");
                v70.remove(v71);
            } else {
                ((Collection)set).add(raw);
            }
            accumulator$iv = set;
        }
        $this$fold$iv = (Iterable)accumulator$iv;
        $i$f$map = false;
        $i$f$fold = $this$map$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv /* !! */ , (int)10));
        $i$f$mapTo = false;
        for (E item$iv$iv : $this$mapTo$iv$iv) {
            set = (String)item$iv$iv;
            var44_151 = destination$iv$iv;
            $i$a$-map-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$3 = false;
            var45_152 = new EnvironmentVariable.Inherit((String)p0);
            var44_151.add(var45_152);
        }
        v72 = (List)destination$iv$iv;
        v73 /* !! */  = $this$map$iv /* !! */  = parsed.getValues("SetEnv");
        if ($this$map$iv /* !! */  == null || (v73 /* !! */  = ($i$f$map = ArraysKt.toList((Object[])v73 /* !! */ ))) == null) {
            v73 /* !! */  = CollectionsKt.emptyList();
        }
        $this$map$iv /* !! */  = (Iterable)v73 /* !! */ ;
        var44_151 = v72;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (E element$iv$iv : $this$flatMapTo$iv$iv) {
            rawConcat = (String)element$iv$iv;
            $i$a$-flatMap-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$4 = false;
            Intrinsics.checkNotNull((Object)rawConcat);
            v74 = UtilKt.argvSplit(rawConcat, true);
            if (v74 == null) {
                v74 = CollectionsKt.emptyList();
            }
            list$iv$iv = v74;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var45_152 = (List)destination$iv$iv;
        $this$flatMap$iv = (Iterable)var45_152;
        $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var31_118 = $this$forEach$iv$iv$iv.iterator();
        while (var31_118.hasNext()) {
            element$iv$iv = element$iv$iv$iv = var31_118.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            raw = (String)element$iv$iv;
            $i$a$-mapNotNull-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$5 = false;
            err /* !! */  = new char[]{'='};
            it = err /* !! */  = (char[])StringsKt.split$default((CharSequence)raw, (char[])err /* !! */ , (boolean)false, (int)2, (int)2, null);
            $i$a$-takeIf-ApplyJschBasedOpenSshConfig$applyJschBasedOpenSshConfig$environmentVariables$5$1 = false;
            if ((it.size() == 2 != false ? err /* !! */  : null) == null) {
                v75 = null;
            } else {
                var40_147 = var40_147;
                name = (String)var40_147.get(0);
                value = (String)var40_147.get(1);
                v75 = new EnvironmentVariable.Certain(name, value);
            }
            if (v75 == null) continue;
            it$iv$iv = v75;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        var45_152 = (List)destination$iv$iv;
        environmentVariables = CollectionsKt.plus((Collection)var44_151, (Iterable)((Iterable)var45_152));
        var24_58 = AuthMethods.Companion.create(authMethods);
        return new SshConnectionConfig((AuthMethods)var24_58, ciphers, compression, (Duration)connectTimeout, forwardAgent, environmentVariables, host, hostKeyAlgorithms, hostKeyVerifier, identityAgent, initialLocalTcpForwardings, initialRemoteTcpForwardings, kexAlgorithms, macs, port, proxyConfig, serverAlive, user, x11Forwarding);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public static final SshConnectionConfig addDefaultPrivateKeysIfNeeded(@NotNull SshConnectionConfig $this$addDefaultPrivateKeysIfNeeded) {
        SshConnectionConfig sshConnectionConfig;
        Intrinsics.checkNotNullParameter((Object)$this$addDefaultPrivateKeysIfNeeded, (String)"<this>");
        AuthMethod.PublicKey publicKey = SshConnectionConfigKt.findPublicKey($this$addDefaultPrivateKeysIfNeeded.getAuthMethods());
        if (publicKey != null) {
            AuthMethod.PublicKey it = publicKey;
            boolean bl = false;
            Object[] objectArray = new String[]{"id_rsa", "id_dsa", "id_ecdsa", "id_ed25519", "id_xmss"};
            Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
            File file = Ssh.getHomeSshDirectory().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            List defaultPrivateKeys2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<String, File>((Object)file){

                public final File invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return FilesKt.resolve((File)((File)this.receiver), (String)p0);
                }
            })), (Function1)addDefaultPrivateKeysIfNeeded.1.defaultPrivateKeys.2.INSTANCE));
            SshConnectionConfig sshConnectionConfig2 = SshConnectionConfig.copy$default($this$addDefaultPrivateKeysIfNeeded, $this$addDefaultPrivateKeysIfNeeded.getAuthMethods().plus(new AuthMethod.PublicKey(defaultPrivateKeys2, null, 2, null)), null, false, null, false, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, 524286, null);
            if (sshConnectionConfig2 != null) {
                sshConnectionConfig = sshConnectionConfig2;
                return sshConnectionConfig;
            }
        }
        sshConnectionConfig = $this$addDefaultPrivateKeysIfNeeded;
        return sshConnectionConfig;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> parseSeparatedMulti(String[] $this$parseSeparatedMulti, char splitChar, List<String> fallback) {
        void $this$fold$iv;
        String[] stringArray = $this$parseSeparatedMulti;
        if ($this$parseSeparatedMulti == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray;
        List<String> initial$iv = fallback;
        boolean $i$f$fold = false;
        List<String> accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void str;
            void element$iv;
            void var10_10 = element$iv = $this$fold$iv[i];
            List<String> acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ApplyJschBasedOpenSshConfig.parseSeparated((String)str, splitChar, acc);
        }
        return accumulator$iv;
    }

    private static final List<String> parseSeparated(String $this$parseSeparated, char splitChar, List<String> fallback) {
        List<String> list;
        Object object = $this$parseSeparated;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            list = fallback;
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"+", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list = CollectionsKt.plus((Collection)fallback, (Iterable)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"-", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list = CollectionsKt.minus((Iterable)fallback, (Iterable)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)$this$parseSeparated, (String)"^", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 94;
            list = CollectionsKt.plus((Collection)ApplyJschBasedOpenSshConfig.parseSeparated(StringsKt.trimStart((String)$this$parseSeparated, (char[])object), splitChar, CollectionsKt.emptyList()), (Iterable)fallback);
        } else {
            List<String> list2;
            List<String> it = list2 = ApplyJschBasedOpenSshConfig.parseSeparated($this$parseSeparated, splitChar);
            boolean bl = false;
            list = !((Collection)it).isEmpty() ? list2 : null;
            if (list == null) {
                list = fallback;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> parseSeparated(String $this$parseSeparated, char splitChar) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        char[] cArray = new char[]{splitChar};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$parseSeparated, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Boolean yesNo(ConfigRepository.Config $this$yesNo, String key) {
        String string;
        String string2 = $this$yesNo.getValue(key);
        if (string2 != null) {
            String string3 = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            v3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            v3 = string = null;
        }
        return Intrinsics.areEqual(string, (Object)"yes") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string, (Object)"no") ? Boolean.valueOf(false) : null);
    }

    private static final SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyCheckingFromOpenSshConfigOption(String strictHostKeyCheckingValue) {
        CharSequence charSequence = strictHostKeyCheckingValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking result;
            String string = strictHostKeyCheckingValue;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = result = (SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking)strictHostKeyCheckingMap.get((Object)string2);
            if (strictHostKeyChecking != null) {
                return strictHostKeyChecking;
            }
            Set set = strictHostKeyCheckingMap.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            LOG.warn("Unexpected StrictHostKeyChecking=" + strictHostKeyCheckingValue + ". Accepted values are: " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null) + ".");
        }
        return SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
    }

    private static final String unquoteSingleArgumentValue(String $this$unquoteSingleArgumentValue) {
        String string = StringUtil.unquoteString((String)$this$unquoteSingleArgumentValue, (char)'\"');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        return string;
    }

    static {
        SmartFMap smartFMap = SmartFMap.emptyMap().plus((Object)"yes", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES).plus((Object)"accept-new", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW).plus((Object)"no", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO).plus((Object)"off", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO).plus((Object)"ask", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK).plus((Object)"true", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES).plus((Object)"false", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO);
        Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"plus(...)");
        strictHostKeyCheckingMap = smartFMap;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthMethod.PublicKey.Agent.values().length];
            try {
                nArray[AuthMethod.PublicKey.Agent.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ONLY_MENTIONED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

