/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.util.proxy.NonStaticAuthenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ssh/SocksProxyAuthenticator;", "Lcom/intellij/util/proxy/NonStaticAuthenticator;", "user", "", "password", "proxy", "Ljava/net/Proxy;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/net/Proxy;)V", "getUser", "()Ljava/lang/String;", "getPassword", "getProxy", "()Ljava/net/Proxy;", "checkRequestor", "", "getPasswordAuthentication", "Ljava/net/PasswordAuthentication;", "intellij.platform.ssh"})
final class SocksProxyAuthenticator
extends NonStaticAuthenticator {
    @Nullable
    private final String user;
    @NotNull
    private final String password;
    @NotNull
    private final Proxy proxy;

    public SocksProxyAuthenticator(@Nullable String user, @NotNull String password, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        this.user = user;
        this.password = password;
        this.proxy = proxy;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @NotNull
    public final Proxy getProxy() {
        return this.proxy;
    }

    public final boolean checkRequestor() {
        if (this.getRequestingPrompt().equals("SOCKS authentication")) {
            SocketAddress socketAddress = this.proxy.address();
            Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            String proxyHostname = ((InetSocketAddress)socketAddress).getAddress().getHostName();
            SocketAddress socketAddress2 = this.proxy.address();
            Intrinsics.checkNotNull((Object)socketAddress2, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            String proxyIP = ((InetSocketAddress)socketAddress2).getAddress().getHostAddress();
            SocketAddress socketAddress3 = this.proxy.address();
            Intrinsics.checkNotNull((Object)socketAddress3, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            int proxyPort = ((InetSocketAddress)socketAddress3).getPort();
            String requestorHostname = this.getRequestingSite().getHostName();
            String requestorIP = this.getRequestingSite().getHostAddress();
            int requestorPort = this.getRequestingPort();
            return (proxyHostname.equals(requestorHostname) || proxyIP.equals(requestorIP)) && proxyPort == requestorPort;
        }
        return false;
    }

    @Nullable
    public PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication;
        if (this.checkRequestor()) {
            char[] cArray = this.password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            passwordAuthentication = new PasswordAuthentication(this.user, cArray);
        } else {
            passwordAuthentication = null;
        }
        return passwordAuthentication;
    }
}

