/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.Util;
import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class OpenSSHConfig
implements ConfigRepository {
    private final Map<String, List<String[]>> config = new HashMap<String, List<String[]>>();
    private final List<String> hosts = new ArrayList<String>();
    private static final Map<String, String> keymap = new HashMap<String, String>();

    public static OpenSSHConfig parse(String conf) throws IOException {
        try (StringReader r = new StringReader(conf);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(r);
            return openSSHConfig;
        }
    }

    public static OpenSSHConfig parseFile(String file) throws IOException {
        try (FileReader r = new FileReader(file);){
            OpenSSHConfig openSSHConfig = new OpenSSHConfig(r);
            return openSSHConfig;
        }
    }

    OpenSSHConfig(Reader r) throws IOException {
        this._parse(r);
    }

    private void _parse(Reader r) throws IOException {
        String l;
        BufferedReader br = new BufferedReader(r);
        String host = "";
        ArrayList<String[]> kv = new ArrayList<String[]>();
        while ((l = br.readLine()) != null) {
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            String[] key_value = l.split("[= \t]", 2);
            for (int i = 0; i < key_value.length; ++i) {
                key_value[i] = key_value[i].trim();
            }
            if (key_value.length <= 1) continue;
            if (key_value[0].equalsIgnoreCase("Host")) {
                this.config.put(host, kv);
                this.hosts.add(host);
                host = key_value[1];
                kv = new ArrayList();
                continue;
            }
            kv.add(key_value);
        }
        this.config.put(host, kv);
        this.hosts.add(host);
    }

    @Override
    public MyConfig getConfig(String host) {
        return new MyConfig(this, host);
    }

    static {
        keymap.put("kex", "KexAlgorithms");
        keymap.put("server_host_key", "HostKeyAlgorithms");
        keymap.put("cipher.c2s", "Ciphers");
        keymap.put("cipher.s2c", "Ciphers");
        keymap.put("mac.c2s", "Macs");
        keymap.put("mac.s2c", "Macs");
        keymap.put("compression.s2c", "Compression");
        keymap.put("compression.c2s", "Compression");
        keymap.put("compression_level", "CompressionLevel");
        keymap.put("MaxAuthTries", "NumberOfPasswordPrompts");
    }

    public class MyConfig
    implements ConfigRepository.Config {
        private final String host;
        private final List<List<String[]>> _configs = new ArrayList<List<String[]>>();

        MyConfig(OpenSSHConfig this$0, String host) {
            this.host = host;
            this._configs.add(this$0.config.get(""));
            byte[] _host = Util.str2byte(host);
            if (this$0.hosts.size() > 1) {
                for (int i = 1; i < this$0.hosts.size(); ++i) {
                    String[] patterns = this$0.hosts.get(i).split("[ \t]");
                    boolean matched = false;
                    for (String pattern : patterns) {
                        boolean negate = false;
                        String foo = pattern.trim();
                        if (foo.startsWith("!")) {
                            negate = true;
                            foo = foo.substring(1).trim();
                        }
                        if (!Util.glob(Util.str2byte(foo), _host)) continue;
                        if (!negate) {
                            matched = true;
                            continue;
                        }
                        matched = false;
                        break;
                    }
                    if (!matched) continue;
                    this._configs.add(this$0.config.get(this$0.hosts.get(i)));
                }
            }
        }

        private String find(String key) {
            if (keymap.get(key) != null) {
                key = keymap.get(key);
            }
            key = StringUtil.toUpperCase((String)key);
            String value = null;
            for (List<String[]> v : this._configs) {
                for (String[] kv : v) {
                    if (!StringUtil.toUpperCase((String)kv[0]).equals(key)) continue;
                    value = kv[1];
                    break;
                }
                if (value == null) continue;
                break;
            }
            return value;
        }

        private String[] multiFind(String key) {
            key = StringUtil.toUpperCase((String)key);
            ArrayList<String> value = new ArrayList<String>();
            for (List<String[]> v : this._configs) {
                for (String[] strings : v) {
                    String foo;
                    if (!StringUtil.toUpperCase((String)strings[0]).equals(key) || (foo = strings[1]) == null) continue;
                    value.remove(foo);
                    value.add(foo);
                }
            }
            return ArrayUtil.toStringArray(value);
        }

        @Override
        public String getHostname() {
            return this.find("Hostname");
        }

        @Override
        public String getUser() {
            return this.find("User");
        }

        @Override
        public int getPort() {
            String foo = this.find("Port");
            int port = -1;
            try {
                port = Integer.parseInt(foo);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return port;
        }

        @Override
        public String getValue(@Nullable String key) {
            if (key != null && (key.equals("compression.s2c") || key.equals("compression.c2s"))) {
                String foo = this.find(key);
                if (foo == null || foo.equals("no")) {
                    return "none,zlib@openssh.com,zlib";
                }
                return "zlib@openssh.com,zlib,none";
            }
            return this.find(key);
        }

        @Override
        public String[] getValues(String key) {
            return this.multiFind(key);
        }

        public Stream<String[]> stream() {
            return this._configs.stream().flatMap(Collection::stream).map(rec$ -> (String[])((String[])rec$).clone());
        }
    }
}

