/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.InetProxySocketFactory;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.OpenSshLikeHostKeyVerifierImpl;
import com.intellij.ssh.PromiscuousSshHostKeyVerifier;
import com.intellij.ssh.ProxyCommandSocketFactory;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshException;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.X11ForwardingKt;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.impl.sshj.AuthMethodGroup;
import com.intellij.ssh.impl.sshj.ConfigurableKeepAliveProvider;
import com.intellij.ssh.impl.sshj.DimmedLogger;
import com.intellij.ssh.impl.sshj.DisabledKeepAliveProvider;
import com.intellij.ssh.impl.sshj.NoPasswordCallbackHandler;
import com.intellij.ssh.impl.sshj.PlatformAgentProxy;
import com.intellij.ssh.impl.sshj.PlatformAuthAgent;
import com.intellij.ssh.impl.sshj.PlatformAuthGssApiWithMic;
import com.intellij.ssh.impl.sshj.PlatformAuthPublickey;
import com.intellij.ssh.impl.sshj.PlatformSSHClient;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.SshAgentForwardingChannelOpener;
import com.intellij.ssh.impl.sshj.tunnels.SingleTunnelBrokerKt;
import com.intellij.ssh.interaction.SshPasswordProvider;
import com.intellij.ssh.sockets.ItemHolder;
import com.intellij.ssh.sockets.SocketUtils;
import com.intellij.ssh.ui.SshConnectionStateListener;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.CompoundRuntimeException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PublicKey;
import java.security.Security;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.ForwardedChannelOpener;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.method.AbstractAuthMethod;
import net.schmizz.sshj.userauth.method.AuthKeyboardInteractive;
import net.schmizz.sshj.userauth.method.AuthNone;
import net.schmizz.sshj.userauth.method.AuthPassword;
import net.schmizz.sshj.userauth.method.ChallengeResponseProvider;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.ietf.jgss.Oid;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00dc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a/\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001aB\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\"0!H\u0002\u001aX\u0010$\u001a\u00020#2\u0006\u0010\u000f\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\r2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0.2\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a8\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0007000\r\"\u0004\b\u0000\u0010\u0007*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0007000\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020'02H\u0002\u001a8\u00106\u001a\u00020#*\u00020%2\u0006\u00107\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u000e\u00108\u001a\n\u0012\u0004\u0012\u00020:\u0018\u0001092\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002\u001a\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020>H\u0002\u001a\u000e\u0010?\u001a\u0004\u0018\u00010<*\u00020>H\u0002\u001a\u000e\u0010@\u001a\u0004\u0018\u00010<*\u00020AH\u0002\u001a(\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002\"\u0018\u00103\u001a\u00020'*\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\"\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020'0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L\u00b2\u0006\u001c\u0010M\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020>0N0\rX\u008a\u0084\u0002"}, d2={"setUpSessionForSshJ", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "sessionConfig", "Lcom/intellij/ssh/SessionConfig;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "get", "T", "Ljava/util/concurrent/CompletableFuture;", "timeoutMs", "", "(Ljava/util/concurrent/CompletableFuture;Lcom/intellij/openapi/progress/ProgressIndicator;J)Ljava/lang/Object;", "makePublicKeyAuthenticators", "", "Lnet/schmizz/sshj/userauth/method/AbstractAuthMethod;", "sshClient", "Lcom/intellij/ssh/impl/sshj/PlatformSSHClient;", "connectionConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "authMethod", "Lcom/intellij/ssh/config/AuthMethod$PublicKey;", "sshPasswordProvider", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "briefInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "makePasswordAuthenticator", "Lnet/schmizz/sshj/userauth/method/AuthPassword;", "makeKeyboardInteractiveAuthenticator", "Lnet/schmizz/sshj/userauth/method/AuthKeyboardInteractive;", "makeGssApiAuthenticator", "Lcom/intellij/ssh/impl/sshj/PlatformAuthGssApiWithMic;", "callFinally", "", "Lkotlin/Function0;", "", "authenticate", "Lnet/schmizz/sshj/SSHClient;", "username", "", "initialHost", "port", "", "possibleAuthMethods", "Lnet/schmizz/sshj/userauth/method/AuthMethod;", "preferredAuthentications", "", "reorganizeByName", "Lnet/schmizz/sshj/common/Factory$Named;", "names", "", "descriptiveName", "getDescriptiveName", "(Lnet/schmizz/sshj/userauth/method/AuthMethod;)Ljava/lang/String;", "connectPlatform", "hostname", "disconnectTrigger", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/ssh/ForceDisconnectListener;", "parsePublicKey", "Ljava/security/PublicKey;", "path", "Ljava/nio/file/Path;", "readPublicKeyFile", "decodePublicKey", "Lcom/jcraft/jsch/agentproxy/Identity;", "connectX11Display", "executor", "Ljava/util/concurrent/Executor;", "sshjTransport", "Lnet/schmizz/sshj/transport/Transport;", "x11forwarding", "Lcom/intellij/ssh/X11Forwarding;", "channel", "Lnet/schmizz/sshj/connection/channel/Channel$Forwarded;", "defaultPreferredAuthentications", "intellij.platform.ssh", "publicKeys", "Lkotlin/Pair;"})
@SourceDebugExtension(value={"SMAP\nSshjConnectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjConnectionUtil.kt\ncom/intellij/ssh/impl/sshj/SshjConnectionUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 util.kt\ncom/intellij/util/containers/UtilKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1113:1\n1#2:1114\n1#2:1157\n1#2:1188\n60#3,5:1115\n1374#4:1120\n1460#4,5:1121\n1634#4,3:1126\n1617#4,9:1147\n1869#4:1156\n1870#4:1158\n1626#4:1159\n1011#4,2:1160\n1563#4:1162\n1634#4,3:1163\n774#4:1166\n865#4,2:1167\n774#4:1171\n865#4,2:1172\n1056#4:1174\n1617#4,9:1178\n1869#4:1187\n1870#4:1189\n1626#4:1190\n174#5,18:1129\n183#6,2:1169\n11896#7,3:1175\n106#8:1191\n78#8,22:1192\n*S KotlinDebug\n*F\n+ 1 SshjConnectionUtil.kt\ncom/intellij/ssh/impl/sshj/SshjConnectionUtilKt\n*L\n371#1:1157\n286#1:1188\n106#1:1115,5\n146#1:1120\n146#1:1121,5\n209#1:1126,3\n371#1:1147,9\n371#1:1156\n371#1:1158\n371#1:1159\n396#1:1160,2\n397#1:1162\n397#1:1163,3\n525#1:1166\n525#1:1167,2\n639#1:1171\n639#1:1172,2\n640#1:1174\n286#1:1178,9\n286#1:1187\n286#1:1189\n286#1:1190\n258#1:1129,18\n562#1:1169,2\n855#1:1175,3\n1066#1:1191\n1066#1:1192,22\n*E\n"})
public final class SshjConnectionUtilKt {
    @NotNull
    private static final List<String> defaultPreferredAuthentications;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final SshjSshConnection setUpSessionForSshJ(@NotNull SessionConfig sessionConfig, @NotNull ProgressIndicator progressIndicator2) {
        void destination$iv;
        void $this$mapTo$iv;
        Object it;
        SocketFactory socketFactory;
        Object object;
        AuthMethod authMethod;
        void $this$flatMapTo$iv$iv;
        HostKeyVerifier hostKeyVerifier;
        KeepAliveProvider keepAliveProvider;
        SshConnectionConfig connectionConfig;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkNotNullParameter((Object)progressIndicator2, (String)"progressIndicator");
        DefaultConfig clientConfig2 = new DefaultConfig(){

            public void setLoggerFactory(LoggerFactory loggerFactory) {
                Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
                super.setLoggerFactory((LoggerFactory)DimmedLogger.Factory);
            }
        };
        boolean bl2 = bl = clientConfig2.getLoggerFactory() == DimmedLogger.Factory;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DefaultConfig defaultConfig = clientConfig2;
        boolean bl3 = false;
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        String sshjVersion = clientConfig2.getVersion();
        defaultConfig.setVersion("IntelliJ__" + productName + "_" + build + "__" + sshjVersion);
        SshConnectionConfig $this$setUpSessionForSshJ_u24lambda_u241 = connectionConfig = sessionConfig.getConnectionConfig();
        boolean bl4 = false;
        String string = "SSH connection to " + $this$setUpSessionForSshJ_u24lambda_u241.getUser() + "@" + $this$setUpSessionForSshJ_u24lambda_u241.getHost() + ":" + $this$setUpSessionForSshJ_u24lambda_u241.getPort();
        StringBuilder briefInfo = new StringBuilder(string);
        Object $this$debug_u24default$iv = UtilKt.getSSHJ_LOG();
        Throwable e$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            defaultConfig = $this$debug_u24default$iv;
            boolean bl5 = false;
            defaultConfig.debug("Full connection config:\n" + CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.toPairs(connectionConfig), (CharSequence)"\n", null, null, (int)0, null, SshjConnectionUtilKt::setUpSessionForSshJ$lambda$2$0, (int)30, null), e$iv);
        }
        briefInfo.append(CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(new SshConnectionConfig(connectionConfig.getHost()), connectionConfig), (CharSequence)"\n", (CharSequence)"\n * With altered connection settings:\n", null, (int)0, null, SshjConnectionUtilKt::setUpSessionForSshJ$lambda$3, (int)28, null));
        List list = clientConfig2.getKeyExchangeFactories();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeyExchangeFactories(...)");
        clientConfig2.setKeyExchangeFactories(SshjConnectionUtilKt.reorganizeByName(list, (Iterable<String>)connectionConfig.getKexAlgorithms()));
        List list2 = clientConfig2.getKeyAlgorithms();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getKeyAlgorithms(...)");
        clientConfig2.setKeyAlgorithms(SshjConnectionUtilKt.reorganizeByName(list2, (Iterable<String>)connectionConfig.getHostKeyAlgorithms()));
        List list3 = clientConfig2.getCipherFactories();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getCipherFactories(...)");
        clientConfig2.setCipherFactories(SshjConnectionUtilKt.reorganizeByName(list3, (Iterable<String>)connectionConfig.getCiphers()));
        List list4 = clientConfig2.getMACFactories();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getMACFactories(...)");
        clientConfig2.setMACFactories(SshjConnectionUtilKt.reorganizeByName(list4, (Iterable<String>)connectionConfig.getMacs()));
        DefaultConfig defaultConfig2 = clientConfig2;
        $this$debug_u24default$iv = connectionConfig.getServerAlive();
        if ($this$debug_u24default$iv != null) {
            void it2;
            Object bl5 = $this$debug_u24default$iv;
            defaultConfig = defaultConfig2;
            boolean bl6 = false;
            SshConnectionConfig $this$setUpSessionForSshJ_u24lambda_u244_u2412 = connectionConfig;
            int n = 0;
            int $this$setUpSessionForSshJ_u24lambda_u244_u2412 = 1;
            n = (int)it2.getInterval().toSeconds();
            Integer n2 = it2.getCountMax();
            int n3 = Math.max($this$setUpSessionForSshJ_u24lambda_u244_u2412, n);
            String string2 = "SSHJ keep-alive " + $this$setUpSessionForSshJ_u24lambda_u244_u2412.getUser() + "@" + $this$setUpSessionForSshJ_u24lambda_u244_u2412.getHost() + ":" + $this$setUpSessionForSshJ_u24lambda_u244_u2412.getPort();
            defaultConfig2 = defaultConfig;
            keepAliveProvider = new ConfigurableKeepAliveProvider(string2, n3, n2);
        } else {
            keepAliveProvider = new DisabledKeepAliveProvider();
        }
        defaultConfig2.setKeepAliveProvider(keepAliveProvider);
        PlatformSSHClient sshClient = new PlatformSSHClient((Config)clientConfig2);
        SshPasswordProvider sshPasswordProvider = sessionConfig.getFinalSshPasswordProvider$intellij_platform_ssh();
        SshHostKeyVerifier $i$f$debug22 = connectionConfig.getHostKeyVerifier();
        if ($i$f$debug22 instanceof OpenSshLikeHostKeyVerifier) {
            hostKeyVerifier = new OpenSshLikeHostKeyVerifierImpl((OpenSshLikeHostKeyVerifier)connectionConfig.getHostKeyVerifier());
        } else if ($i$f$debug22 instanceof PromiscuousSshHostKeyVerifier) {
            hostKeyVerifier = (HostKeyVerifier)new PromiscuousVerifier();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        sshClient.addHostKeyVerifier(hostKeyVerifier);
        List callFinally = new ArrayList();
        Iterable $this$flatMap$iv = connectionConfig.getAuthMethods();
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list5;
            authMethod = (AuthMethod)element$iv$iv;
            boolean bl7 = false;
            object = authMethod;
            if (object instanceof AuthMethod.PublicKey) {
                list5 = SshjConnectionUtilKt.makePublicKeyAuthenticators(sshClient, connectionConfig, (AuthMethod.PublicKey)authMethod, sshPasswordProvider, briefInfo, progressIndicator2);
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.Password.INSTANCE)) {
                list5 = CollectionsKt.listOf((Object)SshjConnectionUtilKt.makePasswordAuthenticator(sshPasswordProvider, progressIndicator2));
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.KeyboardInteractive.INSTANCE)) {
                list5 = CollectionsKt.listOf((Object)SshjConnectionUtilKt.makeKeyboardInteractiveAuthenticator(sshPasswordProvider, progressIndicator2));
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.GssApi.INSTANCE)) {
                list5 = CollectionsKt.listOfNotNull((Object)((Object)SshjConnectionUtilKt.makeGssApiAuthenticator(callFinally)));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list5;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List authMethods = (List)destination$iv$iv;
        Duration duration = connectionConfig.getConnectTimeout();
        if (duration != null) {
            int it3 = (int)duration.toMillis();
            boolean bl8 = false;
            sshClient.setConnectTimeout(it3);
        }
        SshProxyConfig proxyConfig = connectionConfig.getProxyConfig();
        if (proxyConfig instanceof SshProxyConfig.Command) {
            socketFactory = new ProxyCommandSocketFactory(((SshProxyConfig.Command)proxyConfig).getCommand());
        } else if (proxyConfig instanceof SshProxyConfig.HTTP) {
            if (Registry.Companion.is("ssh.over.proxy")) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(((SshProxyConfig.HTTP)proxyConfig).getHost(), ((SshProxyConfig.HTTP)proxyConfig).getPort()));
                InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(connectionConfig.getHost(), connectionConfig.getPort());
                Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"createUnresolved(...)");
                socketFactory = new InetProxySocketFactory(proxy, inetSocketAddress, ((SshProxyConfig.HTTP)proxyConfig).getAuthCredentials());
            } else {
                socketFactory = SocketFactory.getDefault();
            }
        } else if (proxyConfig instanceof SshProxyConfig.SOCKS) {
            if (Registry.Companion.is("ssh.over.proxy")) {
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(((SshProxyConfig.SOCKS)proxyConfig).getHost(), ((SshProxyConfig.SOCKS)proxyConfig).getPort()));
                InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(connectionConfig.getHost(), connectionConfig.getPort());
                Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"createUnresolved(...)");
                socketFactory = new InetProxySocketFactory(proxy, inetSocketAddress, ((SshProxyConfig.SOCKS)proxyConfig).getAuthCredentials());
            } else {
                socketFactory = SocketFactory.getDefault();
            }
        } else if (proxyConfig == null) {
            socketFactory = SocketFactory.getDefault();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        sshClient.setSocketFactory(socketFactory);
        if (connectionConfig.getCompression()) {
            sshClient.useCompression();
        }
        ExecutorService threadPoolExecutor = Executors.newCachedThreadPool();
        X11Forwarding x11Forwarding = connectionConfig.getX11Forwarding();
        if (x11Forwarding != null) {
            it = x11Forwarding;
            boolean bl9 = false;
            sshClient.registerX11Forwarder(arg_0 -> SshjConnectionUtilKt.setUpSessionForSshJ$lambda$7$0(threadPoolExecutor, sshClient, (X11Forwarding)it, arg_0));
        }
        if (connectionConfig.getForwardAgent()) {
            void $this$setUpSessionForSshJ_u24lambda_u248;
            Connection connection = sshClient.getConnection();
            SSHClient sSHClient = sshClient;
            Intrinsics.checkNotNull((Object)threadPoolExecutor);
            SshConnectionConfig proxy = connectionConfig;
            ExecutorService executorService = threadPoolExecutor;
            SSHClient sSHClient2 = sSHClient;
            defaultConfig = connection;
            boolean bl10 = false;
            String string3 = $this$setUpSessionForSshJ_u24lambda_u248.getUser() + "@" + $this$setUpSessionForSshJ_u24lambda_u248.getHost() + ":" + $this$setUpSessionForSshJ_u24lambda_u248.getPort();
            String string4 = string3;
            ExecutorService executorService2 = executorService;
            SSHClient sSHClient3 = sSHClient2;
            defaultConfig.attach((ForwardedChannelOpener)new SshAgentForwardingChannelOpener(sSHClient3, executorService2, string4));
        }
        Iterable bl10 = connectionConfig.getAuthMethods();
        it = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string5;
            void it4;
            authMethod = (AuthMethod)item$iv;
            defaultConfig = destination$iv;
            boolean bl11 = false;
            object = it4;
            if (object instanceof AuthMethod.PublicKey) {
                string5 = "publickey";
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.Password.INSTANCE)) {
                string5 = "password";
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.KeyboardInteractive.INSTANCE)) {
                string5 = "keyboard-interactive";
            } else if (Intrinsics.areEqual((Object)object, (Object)AuthMethod.GssApi.INSTANCE)) {
                string5 = "gssapi-with-mic";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            defaultConfig.add(string5);
        }
        void preferredAuthentications = destination$iv;
        try {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> SshjConnectionUtilKt.setUpSessionForSshJ$lambda$10(sshClient, connectionConfig, sessionConfig, briefInfo, authMethods, (Collection)preferredAuthentications, progressIndicator2), ProcessIOExecutorService.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
            SshjConnectionUtilKt.get$default(completableFuture, progressIndicator2, 0L, 2, null);
            UtilKt.getSSHJ_LOG().info("Authentication log: " + briefInfo);
            SSHClient sSHClient = sshClient;
            String string6 = connectionConfig.getUser();
            Intrinsics.checkNotNull((Object)threadPoolExecutor);
            object2 = new SshjSshConnection(connectionConfig, sSHClient, string6, threadPoolExecutor);
            return object2;
        }
        catch (Exception initException) {
            Throwable throwable;
            UtilKt.getSSHJ_LOG().warn("Failed to connect. Brief info: " + briefInfo, (Throwable)(initException instanceof ControlFlowException ? (Exception)new RuntimeException(initException) : initException));
            try {
                sshClient.disconnect();
            }
            catch (Exception disconnectException) {
                ExceptionsKt.addSuppressed((Throwable)initException, (Throwable)disconnectException);
            }
            Exception disconnectException = initException;
            if (disconnectException instanceof ControlFlowException) {
                throwable = initException;
            } else if (disconnectException instanceof UserAuthException || disconnectException instanceof AuthFailSshTransportException) {
                String string7 = initException.getMessage();
                if (string7 == null) {
                    string7 = "Authentication failed.";
                }
                $this$forEachGuaranteed$iv$iv = new Attachment[]{new Attachment("connection_info.txt", briefInfo.toString())};
                throwable = (Throwable)((Object)new AuthFailSshTransportException(string7, initException, (Attachment[])$this$forEachGuaranteed$iv$iv));
            } else {
                ((SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC())).authenticationFinished(connectionConfig.getUser(), connectionConfig.getHost(), connectionConfig.getPort());
                $this$forEachGuaranteed$iv$iv = new Attachment[]{new Attachment("connection_info.txt", briefInfo.toString())};
                throwable = (Throwable)((Object)new SshException(initException, (Attachment[])$this$forEachGuaranteed$iv$iv));
            }
            throw throwable;
        }
        finally {
            Collection $this$forEachGuaranteed$iv = CollectionsKt.asReversedMutable((List)callFinally);
            boolean $i$f$forEachGuaranteed = false;
            Iterator $this$forEachGuaranteed$iv$iv = $this$forEachGuaranteed$iv.iterator();
            boolean $i$f$forEachGuaranteed2 = false;
            List errors$iv$iv = null;
            object = $this$forEachGuaranteed$iv$iv;
            while (object.hasNext()) {
                Object element$iv$iv = object.next();
                try {
                    Function0 it5 = (Function0)element$iv$iv;
                    boolean bl12 = false;
                    it5.invoke();
                }
                catch (Throwable e$iv$iv) {
                    if (errors$iv$iv == null) {
                        errors$iv$iv = (List)new SmartList();
                    }
                    errors$iv$iv.add(e$iv$iv);
                }
            }
            CompoundRuntimeException.throwIfNotEmpty(errors$iv$iv);
        }
    }

    private static final <T> T get(CompletableFuture<T> $this$get, ProgressIndicator progressIndicator2, long timeoutMs) {
        while (true) {
            progressIndicator2.checkCanceled();
            try {
                return $this$get.get(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (ExecutionException err) {
                Throwable throwable = err.getCause();
                if (throwable == null) {
                    throwable = err;
                }
                throw throwable;
            }
            break;
        }
    }

    static /* synthetic */ Object get$default(CompletableFuture completableFuture, ProgressIndicator progressIndicator2, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 1000L;
        }
        return SshjConnectionUtilKt.get(completableFuture, progressIndicator2, l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final List<AbstractAuthMethod> makePublicKeyAuthenticators(PlatformSSHClient sshClient, SshConnectionConfig connectionConfig, AuthMethod.PublicKey authMethod, SshPasswordProvider sshPasswordProvider, StringBuilder briefInfo, ProgressIndicator progressIndicator2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Pair<Connector, String> pair;
        List sshjAgentAuthMethodsWithOrderNumber;
        List privateKeys;
        block31: {
            Lazy publicKeys$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SshjConnectionUtilKt.makePublicKeyAuthenticators$lambda$0(authMethod));
            Function1 agentIdentityFilter = switch (WhenMappings.$EnumSwitchMapping$0[authMethod.getAgent().ordinal()]) {
                case 1 -> null;
                case 2 -> arg_0 -> SshjConnectionUtilKt.makePublicKeyAuthenticators$lambda$3(publicKeys$delegate, arg_0);
                case 3 -> arg_0 -> SshjConnectionUtilKt.makePublicKeyAuthenticators$lambda$4(publicKeys$delegate, arg_0);
                default -> throw new NoWhenBranchMatchedException();
            };
            privateKeys = CollectionsKt.toMutableList((Collection)authMethod.getPrivateKeys());
            sshjAgentAuthMethodsWithOrderNumber = new ArrayList();
            if (agentIdentityFilter != null) {
                Pair<Connector, String> connectorAndLabel;
                IdentityAgent identityAgent;
                IdentityAgent identityAgent2 = identityAgent = connectionConfig.getIdentityAgent();
                IdentityAgent.Type type = identityAgent2 != null ? identityAgent2.getType() : null;
                Pair<Connector, String> pair2 = connectorAndLabel = (switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                    case -1 -> SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory().get();
                    case 1 -> null;
                    case 2 -> SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory().get(identityAgent.getArgument());
                    case 3 -> {
                        UtilKt.getSSHJ_LOG().debug("Getting path to ssh agent socket from environment variable " + identityAgent.getArgument());
                        String path = EnvironmentUtil.getValue((String)identityAgent.getArgument());
                        CharSequence var15_13 = path;
                        if (var15_13 == null || var15_13.length() == 0) {
                            UtilKt.getSSHJ_LOG().warn("Unable to resolve environment variable " + identityAgent.getArgument());
                            yield null;
                        }
                        yield SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory().get(path);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                });
                if (pair2 != null) {
                    pair = pair2;
                    boolean bl = false;
                    Connector connector = (Connector)pair.component1();
                    String agentLabel = (String)pair.component2();
                    try {
                        briefInfo.append("\n * With auth agent " + agentLabel);
                        PlatformAgentProxy agent = new PlatformAgentProxy(connector);
                        progressIndicator2.checkCanceled();
                        Pair pair3 = agent.getIdentities();
                        Intrinsics.checkNotNullExpressionValue((Object)pair3, (String)"getIdentities(...)");
                        for (Identity identity : pair3) {
                            int privateKeyIndex;
                            Intrinsics.checkNotNull((Object)identity);
                            Pair pair4 = (Pair)agentIdentityFilter.invoke((Object)identity);
                            boolean canUse = (Boolean)pair4.component1();
                            Path privateKeyPath = (Path)pair4.component2();
                            if (privateKeyPath != null) {
                                Path p0;
                                boolean bl2 = false;
                                v6 = privateKeys.indexOf(p0);
                            } else {
                                v6 = privateKeyIndex = -1;
                            }
                            if (privateKeyIndex >= 0) {
                                privateKeys.set(privateKeyIndex, null);
                            }
                            if (canUse) {
                                ((Collection)sshjAgentAuthMethodsWithOrderNumber).add(TuplesKt.to((Object)((Object)new PlatformAuthAgent(agent, identity)), (Object)(privateKeyIndex + Integer.MAX_VALUE + 1)));
                                continue;
                            }
                            byte[] byArray = identity.getComment();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getComment(...)");
                            briefInfo.append("\n * Skipping a key from the agent: " + UtilKt.escapeLikeStrace$default(byArray, 0, 0, 3, null));
                        }
                    }
                    catch (Throwable err) {
                        if (err instanceof ControlFlowException) {
                            throw err;
                        }
                        UtilKt.getSSHJ_LOG().error("Got an error trying to retrieve keys from " + agentLabel, err);
                        if (!(err instanceof Error)) break block31;
                        throw err;
                    }
                }
            }
        }
        Pair<Connector, String> $this$mapNotNull$iv = (Pair<Connector, String>)CollectionsKt.filterNotNull((Iterable)privateKeys);
        boolean $i$f$mapNotNull = false;
        pair = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair5 = $this$forEach$iv$iv$iv.iterator();
        while (pair5.hasNext()) {
            PlatformAuthPublickey it$iv$iv;
            PlatformAuthPublickey platformAuthPublickey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair5.next();
            boolean bl = false;
            Path key = (Path)element$iv$iv;
            boolean bl3 = false;
            try {
                platformAuthPublickey = new PlatformAuthPublickey((SSHClient)sshClient, key, (Function0<String>)((Function0)() -> SshjConnectionUtilKt.makePublicKeyAuthenticators$lambda$6$0(progressIndicator2, sshPasswordProvider, key)));
            }
            catch (Throwable err) {
                Object v8;
                Throwable throwable = err;
                if (throwable instanceof FileNotFoundException) {
                    UtilKt.getSSHJ_LOG().debug("Failed to initialize key " + key + ": " + err);
                    v8 = null;
                } else {
                    if (!(throwable instanceof IOException) && !(throwable instanceof SSHRuntimeException)) {
                        throw err;
                    }
                    UtilKt.getSSHJ_LOG().warn("Failed to initialize key " + key, err);
                    v8 = null;
                }
                platformAuthPublickey = v8;
            }
            if (platformAuthPublickey == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List sshjPrivateKeyAuthMethods = (List)destination$iv$iv;
        List $this$sortBy$iv = sshjAgentAuthMethodsWithOrderNumber;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
        }
        Iterable $this$map$iv = sshjAgentAuthMethodsWithOrderNumber;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            pair5 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((AuthAgent)it.getFirst());
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)sshjPrivateKeyAuthMethods);
    }

    private static final AuthPassword makePasswordAuthenticator(SshPasswordProvider sshPasswordProvider, ProgressIndicator progressIndicator2) {
        return new AuthPassword(new PasswordFinder(progressIndicator2, sshPasswordProvider){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ SshPasswordProvider $sshPasswordProvider;
            {
                this.$progressIndicator = $progressIndicator;
                this.$sshPasswordProvider = $sshPasswordProvider;
            }

            public char[] reqPassword(Resource<?> resource) {
                Object object;
                block3: {
                    block2: {
                        this.$progressIndicator.checkCanceled();
                        object = this.$sshPasswordProvider.getUnixPassword(this.$progressIndicator);
                        if (object == null) break block2;
                        char[] cArray = ((String)object).toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                        object = cArray;
                        if (cArray != null) break block3;
                    }
                    object = new char[0];
                }
                return object;
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        });
    }

    private static final AuthKeyboardInteractive makeKeyboardInteractiveAuthenticator(SshPasswordProvider sshPasswordProvider, ProgressIndicator progressIndicator2) {
        return new AuthKeyboardInteractive(new ChallengeResponseProvider(progressIndicator2, sshPasswordProvider){
            private String name;
            private String instruction;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ SshPasswordProvider $sshPasswordProvider;
            {
                this.$progressIndicator = $progressIndicator;
                this.$sshPasswordProvider = $sshPasswordProvider;
                this.name = "";
                this.instruction = "";
            }

            public List<String> getSubmethods() {
                return new ArrayList<E>();
            }

            public void init(Resource<?> resource, String name, String instruction) {
                Intrinsics.checkNotNullParameter(resource, (String)"resource");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                this.name = name;
                this.instruction = instruction;
            }

            /*
             * Enabled aggressive block sorting
             */
            public char[] getResponse(String prompt, boolean echo) {
                char[] cArray;
                String string;
                Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
                this.$progressIndicator.checkCanceled();
                String[] stringArray = new String[]{prompt};
                int n = 0;
                boolean[] blArray = new boolean[1];
                String[] stringArray2 = stringArray;
                String string2 = this.instruction;
                String string3 = this.name;
                SshPasswordProvider sshPasswordProvider = this.$sshPasswordProvider;
                while (n < 1) {
                    int n2 = n++;
                    blArray[n2] = echo;
                }
                Object[] objectArray = sshPasswordProvider.getKeyboardInteractive(string3, string2, stringArray2, blArray, this.$progressIndicator);
                if (objectArray != null && (string = (String)ArraysKt.firstOrNull((Object[])objectArray)) != null) {
                    char[] cArray2 = string.toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
                    char[] cArray3 = cArray2;
                    if (cArray3 != null) {
                        cArray = cArray3;
                        return cArray;
                    }
                }
                cArray = new char[]{};
                return cArray;
            }

            public boolean shouldRetry() {
                return false;
            }
        });
    }

    private static final PlatformAuthGssApiWithMic makeGssApiAuthenticator(List<Function0<Unit>> callFinally) {
        LoginContext loginContext;
        String string;
        String useSubjectCredsOnlyProp = "javax.security.auth.useSubjectCredsOnly";
        String defaultCallbackHandlerProp = "auth.login.defaultCallbackHandler";
        String authLoginConfigProp = "java.security.auth.login.config";
        String initialUseSubjectCredsOnly = System.getProperty(useSubjectCredsOnlyProp);
        String string2 = System.getProperty(defaultCallbackHandlerProp);
        if (string2 == null) {
            string2 = "";
        }
        String initialDefaultCallbackHandlerProp = string2;
        String it = System.getProperty(authLoginConfigProp);
        boolean bl = false;
        if (it != null) {
            UtilKt.getSSHJ_LOG().info("Already set custom GSSAPI configuration file to " + it + ". It may alter GSSAPI authentication.");
            string = null;
        } else {
            URL uRL = PlatformSSHClient.class.getResource("/com/intellij/ssh/SshjJaas.conf");
            Intrinsics.checkNotNull((Object)uRL);
            string = uRL.toExternalForm();
        }
        String temporaryAuthLoginConf = string;
        System.setProperty(useSubjectCredsOnlyProp, "false");
        Security.setProperty(defaultCallbackHandlerProp, NoPasswordCallbackHandler.class.getCanonicalName());
        String string3 = temporaryAuthLoginConf;
        if (string3 != null) {
            it = string3;
            boolean bl2 = false;
            System.setProperty(authLoginConfigProp, it);
        }
        ((Collection)callFinally).add(() -> SshjConnectionUtilKt.makeGssApiAuthenticator$lambda$2(useSubjectCredsOnlyProp, initialUseSubjectCredsOnly, temporaryAuthLoginConf, authLoginConfigProp, defaultCallbackHandlerProp, initialDefaultCallbackHandlerProp));
        try {
            loginContext = new LoginContext("SshjJaas", null, null, AccessController.doPrivileged(SshjConnectionUtilKt::makeGssApiAuthenticator$lambda$3));
        }
        catch (LoginException err) {
            UtilKt.getSSHJ_LOG().warn("Failed to initialize login context", (Throwable)err);
            return null;
        }
        LoginContext loginContext2 = loginContext;
        return new PlatformAuthGssApiWithMic(loginContext2, CollectionsKt.listOf((Object)new Oid("1.2.840.113554.1.2.2")));
    }

    /*
     * WARNING - void declaration
     */
    private static final void authenticate(SSHClient sshClient, String username, String initialHost, int port, List<? extends net.schmizz.sshj.userauth.method.AuthMethod> possibleAuthMethods, Collection<String> preferredAuthentications, StringBuilder briefInfo, ProgressIndicator progressIndicator2) {
        Object it;
        Object element$iv$iv;
        Iterator<? extends net.schmizz.sshj.userauth.method.AuthMethod> $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = defaultPreferredAuthentications;
        Collection collection = preferredAuthentications;
        boolean $i$f$filter = false;
        void var11_12 = $this$filter$iv;
        Collection pair = new ArrayList();
        boolean $i$f$filterTo = false;
        Object object = $this$filterTo$iv$iv.iterator();
        while (object.hasNext()) {
            element$iv$iv = object.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!preferredAuthentications.contains(it))) continue;
            pair.add(element$iv$iv);
        }
        List authMethodNamesOrder = CollectionsKt.plus((Collection)collection, (Iterable)((List)pair));
        Set expectedByServerAuthMethods = new LinkedHashSet();
        HashMap<Object, AuthMethodGroup> possibleAuthMethodGroupByName = new HashMap<Object, AuthMethodGroup>();
        AuthNone authNone = new AuthNone();
        boolean bl42 = false;
        object = possibleAuthMethodGroupByName;
        element$iv$iv = authNone.getName();
        Object $this$authenticate_u24lambda_u241_u240 = it = new AuthMethodGroup(false);
        boolean bl2 = false;
        ((AuthMethodGroup)$this$authenticate_u24lambda_u241_u240).add((net.schmizz.sshj.userauth.method.AuthMethod)authNone);
        object.put(element$iv$iv, it);
        String string = authNone.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        expectedByServerAuthMethods.add(string);
        ((Map)possibleAuthMethodGroupByName).put("publickey", new AuthMethodGroup(true));
        for (net.schmizz.sshj.userauth.method.AuthMethod authMethod : possibleAuthMethods) {
            possibleAuthMethodGroupByName.computeIfAbsent(authMethod.getName(), arg_0 -> SshjConnectionUtilKt.authenticate$lambda$3(SshjConnectionUtilKt::authenticate$lambda$2, arg_0)).add(authMethod);
        }
        briefInfo.append("\n * Starting authentication");
        SshConnectionStateListener publisher = (SshConnectionStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(SshConnectionStateListener.Companion.getAUTH_TOPIC());
        do {
            Object v1;
            Pair $this$firstOrNull$iv;
            block9: {
                object = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)authMethodNamesOrder), arg_0 -> SshjConnectionUtilKt.authenticate$lambda$4(expectedByServerAuthMethods, arg_0)), arg_0 -> SshjConnectionUtilKt.authenticate$lambda$5(possibleAuthMethodGroupByName, arg_0));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it3 = (Pair)element$iv;
                    boolean bl3 = false;
                    if (!(it3.getSecond() != null)) continue;
                    v1 = element$iv;
                    break block9;
                }
                v1 = null;
            }
            Pair bl42 = v1;
            if (bl42 == null) break;
            it = bl42;
            boolean bl5 = false;
            Object object2 = it.getFirst();
            Object object3 = it.getSecond();
            Intrinsics.checkNotNull((Object)object3);
            $this$firstOrNull$iv = TuplesKt.to((Object)object2, (Object)object3);
            if ($this$firstOrNull$iv == null) break;
            Pair pair2 = $this$firstOrNull$iv;
            String methodName = (String)pair2.component1();
            AuthMethodGroup methodQueue = (AuthMethodGroup)pair2.component2();
            progressIndicator2.checkCanceled();
            AuthMethodGroup.AuthResult authResult = methodQueue.authenticate(briefInfo, sshClient, username);
            switch (WhenMappings.$EnumSwitchMapping$2[authResult.ordinal()]) {
                case 1: {
                    publisher.authenticationFinished(username, initialHost, port);
                    return;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    possibleAuthMethodGroupByName.remove(methodName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (authResult != AuthMethodGroup.AuthResult.PARTIAL_SUCCESS && authResult != AuthMethodGroup.AuthResult.FAILURE) continue;
            Collection collection2 = sshClient.getUserAuth().getAllowedMethods();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getAllowedMethods(...)");
            List it4 = CollectionsKt.toList((Iterable)collection2);
            boolean bl6 = false;
            Collection methodNames = it4.isEmpty() ? preferredAuthentications : (Collection)it4;
            expectedByServerAuthMethods.clear();
            expectedByServerAuthMethods.addAll(methodNames);
        } while (!((Map)possibleAuthMethodGroupByName).isEmpty());
        publisher.authenticationFinished(username, initialHost, port);
        throw new UserAuthException("Authentication failed.");
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> List<Factory.Named<T>> reorganizeByName(List<? extends Factory.Named<T>> $this$reorganizeByName, Iterable<String> names) {
        void $this$filterTo$iv$iv;
        HashMap positions = new HashMap();
        for (IndexedValue it : CollectionsKt.withIndex(names)) {
            ((Map)positions).put(it.getValue(), it.getIndex());
        }
        Iterable $this$filter$iv = $this$reorganizeByName;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Factory.Named it = (Factory.Named)element$iv$iv;
            boolean bl = false;
            if (!positions.containsKey(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.toList((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(positions){
            final /* synthetic */ HashMap $positions$inlined;
            {
                this.$positions$inlined = hashMap;
            }

            public final int compare(T a, T b) {
                Factory.Named it = (Factory.Named)a;
                boolean bl = false;
                Comparable comparable = (Integer)this.$positions$inlined.get(it.getName());
                it = (Factory.Named)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$positions$inlined.get(it.getName())));
            }
        }));
    }

    private static final String getDescriptiveName(net.schmizz.sshj.userauth.method.AuthMethod $this$descriptiveName) {
        Object object;
        net.schmizz.sshj.userauth.method.AuthMethod authMethod = $this$descriptiveName;
        if (authMethod instanceof PlatformAuthPublickey) {
            object = ((PlatformAuthPublickey)$this$descriptiveName).getName() + " " + ((PlatformAuthPublickey)$this$descriptiveName).getPrivateKey();
        } else if (authMethod instanceof PlatformAuthAgent) {
            object = ((PlatformAuthAgent)$this$descriptiveName).toString();
        } else {
            String string = $this$descriptiveName.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void connectPlatform(SSHClient $this$connectPlatform, String hostname, int port, EventDispatcher<ForceDisconnectListener> disconnectTrigger, StringBuilder briefInfo) {
        if (!Intrinsics.areEqual((Object)$this$connectPlatform.getSocketFactory(), (Object)SocketFactory.getDefault())) {
            UtilKt.getSSHJ_LOG().debug("Delegating connection to non-default socket factory " + $this$connectPlatform.getSocketFactory());
            $this$connectPlatform.connect(hostname, port);
        } else {
            void destination$iv;
            void $this$mapTo$iv;
            InetAddress[] inetAddressArray = InetAddress.getAllByName(hostname);
            Intrinsics.checkNotNullExpressionValue((Object)inetAddressArray, (String)"getAllByName(...)");
            Object[] objectArray = inetAddressArray;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapTo = false;
            for (void item$iv : $this$mapTo$iv) {
                void initialAddress;
                InetAddress inetAddress = (InetAddress)item$iv;
                void var16_17 = destination$iv;
                boolean bl = false;
                InetAddress inetAddress2 = SocketUtils.getProperAddressIfNeeded((InetAddress)initialAddress);
                if (inetAddress2 == null) {
                    inetAddress2 = initialAddress;
                }
                InetAddress patchedAddress = inetAddress2;
                var16_17.add(InetAddress.getByAddress(hostname, patchedAddress.getAddress()));
            }
            Iterator iterator = ((LinkedHashSet)destination$iv).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator addresses = iterator;
            if (!addresses.hasNext()) {
                throw new UnknownHostException(hostname);
            }
            iterator = addresses;
            while (iterator.hasNext()) {
                InetAddress address = (InetAddress)iterator.next();
                try {
                    $this$connectPlatform.connect(address, port);
                    break;
                }
                catch (UnknownHostException err) {
                    throw err;
                }
                catch (IOException err) {
                    briefInfo.append("\n * Failed to connect to " + address + " port " + port);
                    try {
                        $this$connectPlatform.getTransport().getRemoteHost();
                        throw err;
                    }
                    catch (NullPointerException nullPointerException) {
                        if (addresses.hasNext()) continue;
                        throw err;
                    }
                }
            }
        }
        Socket socket = $this$connectPlatform.getSocket();
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        briefInfo.append("\n * Connected: " + socket2);
        if (disconnectTrigger != null) {
            ItemHolder<Socket> holder = ItemHolder.createDefaultSocketHolder();
            holder.add(socket2);
            disconnectTrigger.addListener((EventListener)holder);
        }
    }

    private static final PublicKey parsePublicKey(Path path) {
        PublicKey publicKey;
        if (StringsKt.endsWith$default((String)((Object)path.getFileName()).toString(), (String)".pub", (boolean)false, (int)2, null)) {
            publicKey = SshjConnectionUtilKt.readPublicKeyFile(path);
        } else {
            KeyFormat keyFormat = KeyProviderUtil.detectKeyFileFormat((File)path.toFile());
            switch (keyFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$3[keyFormat.ordinal()]) {
                case 1: 
                case 2: {
                    Path path2 = path.resolveSibling(path.getFileName() + ".pub");
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolveSibling(...)");
                    publicKey = SshjConnectionUtilKt.readPublicKeyFile(path2);
                    break;
                }
                default: {
                    publicKey = null;
                }
            }
        }
        return publicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PublicKey readPublicKeyFile(Path $this$readPublicKeyFile) {
        PublicKey publicKey;
        File file = $this$readPublicKeyFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            BufferedReader reader = (BufferedReader)object;
            boolean bl = false;
            publicKey = (PublicKey)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)TextStreamsKt.lineSequence((BufferedReader)reader), SshjConnectionUtilKt::readPublicKeyFile$lambda$0$0)), SshjConnectionUtilKt::readPublicKeyFile$lambda$0$1));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return publicKey;
    }

    private static final PublicKey decodePublicKey(Identity $this$decodePublicKey) {
        PublicKey publicKey;
        try {
            Buffer.PlainBuffer it = new Buffer.PlainBuffer($this$decodePublicKey.getBlob());
            boolean bl = false;
            publicKey = KeyType.fromString((String)it.readString()).readPubKeyFromBuffer((Buffer)it);
        }
        catch (Throwable err) {
            UtilKt.getSSHJ_LOG().warn("Failed to decode an agent key " + UtilKt.getUtf8ReplacingDecoder().decode(ByteBuffer.wrap($this$decodePublicKey.getComment())), err);
            publicKey = null;
        }
        return publicKey;
    }

    private static final void connectX11Display(Executor executor, Transport sshjTransport, X11Forwarding x11forwarding, Channel.Forwarded channel2) {
        Socket socket;
        try {
            socket = X11ForwardingKt.tryConnect(x11forwarding);
        }
        catch (IOException e) {
            UtilKt.getSSHJ_LOG().warn("Failed to connect to " + x11forwarding, (Throwable)e);
            socket = null;
        }
        Socket socket2 = socket;
        if (socket2 != null) {
            executor.execute(() -> SshjConnectionUtilKt.connectX11Display$lambda$0(x11forwarding, channel2, sshjTransport, socket2));
            channel2.confirm();
        } else {
            channel2.reject(OpenFailException.Reason.CONNECT_FAILED, ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() + " failed to create X11 forwarding");
        }
    }

    private static final CharSequence setUpSessionForSshJ$lambda$2$0(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String key = (String)pair.component1();
        Object value = pair.component2();
        return "  " + key + ": " + value;
    }

    private static final CharSequence setUpSessionForSshJ$lambda$3(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String key = (String)triple.component1();
        Object value = triple.component3();
        return "  - " + key + ": " + value;
    }

    private static final void setUpSessionForSshJ$lambda$7$0(ExecutorService $threadPoolExecutor, PlatformSSHClient $sshClient, X11Forwarding $it, Channel.Forwarded channel2) {
        Intrinsics.checkNotNull((Object)$threadPoolExecutor);
        Executor executor = $threadPoolExecutor;
        Transport transport = $sshClient.getTransport();
        Intrinsics.checkNotNullExpressionValue((Object)transport, (String)"getTransport(...)");
        Intrinsics.checkNotNull((Object)channel2);
        SshjConnectionUtilKt.connectX11Display(executor, transport, $it, channel2);
    }

    private static final void setUpSessionForSshJ$lambda$10(PlatformSSHClient $sshClient, SshConnectionConfig $connectionConfig, SessionConfig $sessionConfig, StringBuilder $briefInfo, List $authMethods, Collection $preferredAuthentications, ProgressIndicator $progressIndicator) {
        SshjConnectionUtilKt.connectPlatform($sshClient, $connectionConfig.getHost(), $connectionConfig.getPort(), $sessionConfig.getDisconnectTrigger(), $briefInfo);
        SshjConnectionUtilKt.authenticate($sshClient, $connectionConfig.getUser(), $sessionConfig.getInitialHost(), $connectionConfig.getPort(), $authMethods, $preferredAuthentications, $briefInfo, $progressIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List makePublicKeyAuthenticators$lambda$0(AuthMethod.PublicKey $authMethod) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $authMethod.getPrivateKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path privateKey = (Path)element$iv$iv;
            boolean bl2 = false;
            try {
                PublicKey publicKey = SshjConnectionUtilKt.parsePublicKey(privateKey);
                pair = publicKey != null ? TuplesKt.to((Object)publicKey, (Object)privateKey) : null;
            }
            catch (FileNotFoundException err) {
                UtilKt.getSSHJ_LOG().debug("Got error in reading a public key of " + privateKey + ": " + err);
                pair = null;
            }
            catch (Throwable err) {
                UtilKt.getSSHJ_LOG().warn("Got error in reading a public key of " + privateKey, err);
                pair = null;
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<Pair<PublicKey, Path>> makePublicKeyAuthenticators$lambda$1(Lazy<? extends List<? extends Pair<? extends PublicKey, ? extends Path>>> $publicKeys$delegate) {
        Lazy<? extends List<? extends Pair<? extends PublicKey, ? extends Path>>> lazy = $publicKeys$delegate;
        return (List)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Path makePublicKeyAuthenticators$findPrivateKeyPath(Lazy<? extends List<? extends Pair<? extends PublicKey, ? extends Path>>> publicKeys$delegate, Identity identity) {
        Pair pair;
        Object v0;
        block1: {
            PublicKey publicKey = SshjConnectionUtilKt.decodePublicKey(identity);
            if (publicKey == null) return null;
            PublicKey publicKey2 = publicKey;
            boolean bl = false;
            Iterable iterable = SshjConnectionUtilKt.makePublicKeyAuthenticators$lambda$1(publicKeys$delegate);
            for (Object t : iterable) {
                Pair pair2 = (Pair)t;
                boolean bl2 = false;
                PublicKey k = (PublicKey)pair2.component1();
                if (!Intrinsics.areEqual((Object)publicKey2, (Object)k)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        if ((pair = (Pair)v0) == null) return null;
        Path path = (Path)pair.getSecond();
        return path;
    }

    private static final Pair makePublicKeyAuthenticators$lambda$3(Lazy $publicKeys$delegate, Identity identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Path it = SshjConnectionUtilKt.makePublicKeyAuthenticators$findPrivateKeyPath((Lazy<? extends List<? extends Pair<? extends PublicKey, ? extends Path>>>)$publicKeys$delegate, identity);
        boolean bl = false;
        return TuplesKt.to((Object)(it != null ? 1 : 0), (Object)it);
    }

    private static final Pair makePublicKeyAuthenticators$lambda$4(Lazy $publicKeys$delegate, Identity identity) {
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return TuplesKt.to((Object)true, (Object)SshjConnectionUtilKt.makePublicKeyAuthenticators$findPrivateKeyPath((Lazy<? extends List<? extends Pair<? extends PublicKey, ? extends Path>>>)$publicKeys$delegate, identity));
    }

    private static final String makePublicKeyAuthenticators$lambda$6$0(ProgressIndicator $progressIndicator, SshPasswordProvider $sshPasswordProvider, Path $key) {
        $progressIndicator.checkCanceled();
        return $sshPasswordProvider.getKeyPassphrase($key, $progressIndicator);
    }

    private static final Unit makeGssApiAuthenticator$lambda$2(String $useSubjectCredsOnlyProp, String $initialUseSubjectCredsOnly, String $temporaryAuthLoginConf, String $authLoginConfigProp, String $defaultCallbackHandlerProp, String $initialDefaultCallbackHandlerProp) {
        SystemProperties.setProperty((String)$useSubjectCredsOnlyProp, (String)$initialUseSubjectCredsOnly);
        if ($temporaryAuthLoginConf != null) {
            System.clearProperty($authLoginConfigProp);
        }
        Security.setProperty($defaultCallbackHandlerProp, $initialDefaultCallbackHandlerProp);
        return Unit.INSTANCE;
    }

    private static final Configuration makeGssApiAuthenticator$lambda$3() {
        return Configuration.getConfiguration();
    }

    private static final AuthMethodGroup authenticate$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AuthMethodGroup(false);
    }

    private static final AuthMethodGroup authenticate$lambda$3(Function1 $tmp0, Object p0) {
        return (AuthMethodGroup)$tmp0.invoke(p0);
    }

    private static final boolean authenticate$lambda$4(Set $expectedByServerAuthMethods, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $expectedByServerAuthMethods.contains(it);
    }

    private static final Pair authenticate$lambda$5(HashMap $possibleAuthMethodGroupByName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)it, $possibleAuthMethodGroupByName.get(it));
    }

    private static final String readPublicKeyFile$lambda$0$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String $this$trim$iv = line;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        CharSequence charSequence = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Regex regex = new Regex("\\s+");
        int n = 0;
        return (String)CollectionsKt.getOrNull((List)regex.split(charSequence, n), (int)1);
    }

    private static final PublicKey readPublicKeyFile$lambda$0$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Buffer.PlainBuffer(Base64.getDecoder().decode(it)).readPublicKey();
    }

    private static final void connectX11Display$lambda$0(X11Forwarding $x11forwarding, Channel.Forwarded $channel, Transport $sshjTransport, Socket $socket) {
        SingleTunnelBrokerKt.singleTunnelBroker($x11forwarding + " " + $channel, $sshjTransport, (Function0<? extends Socket>)((Function0)() -> SshjConnectionUtilKt.connectX11Display$lambda$0$0($socket)), (Function0<? extends Channel>)((Function0)() -> SshjConnectionUtilKt.connectX11Display$lambda$0$1($channel)), 0);
    }

    private static final Socket connectX11Display$lambda$0$0(Socket $socket) {
        return $socket;
    }

    private static final Channel connectX11Display$lambda$0$1(Channel.Forwarded $channel) {
        return (Channel)$channel;
    }

    public static final /* synthetic */ String access$getDescriptiveName(net.schmizz.sshj.userauth.method.AuthMethod $receiver) {
        return SshjConnectionUtilKt.getDescriptiveName($receiver);
    }

    static {
        Object[] objectArray = new String[]{"gssapi-with-mic", "hostbased", "publickey", "keyboard-interactive", "password", "none"};
        defaultPreferredAuthentications = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[AuthMethod.PublicKey.Agent.values().length];
            try {
                nArray[AuthMethod.PublicKey.Agent.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ONLY_MENTIONED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IdentityAgent.Type.values().length];
            try {
                nArray[IdentityAgent.Type.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdentityAgent.Type.PATH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdentityAgent.Type.ENVIRONMENT_VARIABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[AuthMethodGroup.AuthResult.values().length];
            try {
                nArray[AuthMethodGroup.AuthResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethodGroup.AuthResult.PARTIAL_SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethodGroup.AuthResult.FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethodGroup.AuthResult.WASTED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[KeyFormat.values().length];
            try {
                nArray[KeyFormat.OpenSSH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyFormat.OpenSSHv1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

