/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.logical.impl;

import com.intellij.ide.TypePresentationService;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.structureView.StructureViewEventsCollector;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.logical.ContainerElementsProvider;
import com.intellij.ide.structureView.logical.ExternalElementsProvider;
import com.intellij.ide.structureView.logical.LogicalStructureElementsProvider;
import com.intellij.ide.structureView.logical.LogicalStructureTreeElementProvider;
import com.intellij.ide.structureView.logical.PropertyElementProvider;
import com.intellij.ide.structureView.logical.impl.LogicalStructureViewTreeElement;
import com.intellij.ide.structureView.logical.model.LogicalContainer;
import com.intellij.ide.structureView.logical.model.LogicalContainerPresentationProvider;
import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.structureView.logical.model.LogicalStructureAssembledModel;
import com.intellij.ide.structureView.logical.model.ProvidedLogicalContainer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\tJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0001J \u0010\u0017\u001a\u00020\u00162\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0006\u0010\u0014\u001a\u00020\u0001H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0007\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012 \u0012\u001e\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u0012\f\u0012\n\u0012\u0002\b\u00030\u000bR\u00020\u00000\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;", "", "<init>", "()V", "typePresentationService", "Lcom/intellij/ide/TypePresentationService;", "kotlin.jvm.PlatformType", "groupElements", "", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "Lcom/intellij/ide/structureView/logical/ExternalElementsProvider;", "Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$LogicalGroupStructureElement;", "createViewTreeElement", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "T", "assembledModel", "getChildrenNodes", "", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "model", "getPresentationData", "Lcom/intellij/ide/projectView/PresentationData;", "getPropertyPresentationData", "propertyProvider", "Lcom/intellij/ide/structureView/logical/PropertyElementProvider;", "PsiElementStructureElement", "OtherStructureElement", "LogicalGroupStructureElement", "PropertyPsiElementStructureElement", "PropertyStructureElement", "EmptyChildrenElement", "intellij.platform.structureView.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLogicalStructureViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,387:1\n382#2,7:388\n382#2,7:395\n*S KotlinDebug\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder\n*L\n151#1:388,7\n153#1:395,7\n*E\n"})
public final class ElementsBuilder {
    private final TypePresentationService typePresentationService = TypePresentationService.getService();
    @NotNull
    private final Map<LogicalStructureAssembledModel<?>, Map<ExternalElementsProvider<?, ?>, LogicalGroupStructureElement<?>>> groupElements = new ConcurrentHashMap();

    @NotNull
    public final <T> StructureViewTreeElement createViewTreeElement(@NotNull LogicalStructureAssembledModel<T> assembledModel) {
        Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
        T model = assembledModel.getModel();
        StructureViewTreeElement explicitElement = LogicalStructureTreeElementProvider.Companion.getTreeElement(model);
        if (explicitElement != null) {
            return explicitElement;
        }
        PsiElement psiElement = this.getPsiElement(model);
        return psiElement != null ? (StructureViewTreeElement)new PsiElementStructureElement<T>(assembledModel, psiElement) : (model instanceof ProvidedLogicalContainer ? (StructureViewTreeElement)new LogicalGroupStructureElement<T>(assembledModel, ((ProvidedLogicalContainer)model).getProvider(), () -> ElementsBuilder.createViewTreeElement$lambda$0(assembledModel)) : (StructureViewTreeElement)new OtherStructureElement<T>(assembledModel));
    }

    private final Collection<StructureViewTreeElement> getChildrenNodes(LogicalStructureAssembledModel<?> assembledModel) {
        if (assembledModel.hasSameModelParent$intellij_platform_structureView_impl()) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        for (LogicalStructureAssembledModel<?> child : assembledModel.getChildren()) {
            Object logicalModel = child.getModel();
            if (!(logicalModel instanceof LogicalContainer)) {
                result.add(this.createViewTreeElement(child));
                continue;
            }
            if (!(logicalModel instanceof ProvidedLogicalContainer)) {
                result.add(new LogicalGroupStructureElement(assembledModel, logicalModel, () -> ElementsBuilder.getChildrenNodes$lambda$0(child)));
                continue;
            }
            LogicalStructureElementsProvider provider = ((ProvidedLogicalContainer)logicalModel).getProvider();
            if (provider instanceof ContainerElementsProvider) {
                LogicalContainerPresentationProvider<ContainerElementsProvider> logicalContainerPresentationProvider = LogicalContainerPresentationProvider.Companion.getForObject((ContainerElementsProvider)provider);
                boolean bl = logicalContainerPresentationProvider != null ? logicalContainerPresentationProvider.isFlatElements(logicalModel) : false;
                if (bl) {
                    for (LogicalStructureAssembledModel<?> subChild : child.getChildren()) {
                        result.add(this.createViewTreeElement(subChild));
                    }
                    continue;
                }
            }
            if (provider instanceof PropertyElementProvider) {
                for (LogicalStructureAssembledModel<?> subChild : child.getChildren()) {
                    PsiElement psiElement = this.getPsiElement(subChild.getModel());
                    boolean bl = psiElement != null ? result.add(new PropertyPsiElementStructureElement((PropertyElementProvider)provider, subChild, psiElement)) : result.add(new PropertyStructureElement((PropertyElementProvider)provider, subChild));
                }
                continue;
            }
            if (provider instanceof ExternalElementsProvider) {
                Object object;
                Object object2;
                Object answer$iv;
                Map $this$getOrPut$iv;
                LogicalStructureAssembledModel<?> subChild;
                subChild = this.groupElements;
                Object key$iv = assembledModel;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new ConcurrentHashMap(MapsKt.mapOf((Pair)TuplesKt.to(provider, new LogicalGroupStructureElement(assembledModel, provider, () -> ElementsBuilder.getChildrenNodes$lambda$1$0(child)))));
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                $this$getOrPut$iv = (Map)object2;
                key$iv = provider;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LogicalGroupStructureElement(assembledModel, provider, () -> ElementsBuilder.getChildrenNodes$lambda$2$0(child));
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                LogicalGroupStructureElement groupElement = (LogicalGroupStructureElement)object;
                result.add(groupElement);
                continue;
            }
            result.add(new LogicalGroupStructureElement(assembledModel, provider, () -> ElementsBuilder.getChildrenNodes$lambda$3(child)));
        }
        return result;
    }

    private final PsiElement getPsiElement(Object model) {
        return model instanceof PsiElement ? (PsiElement)model : (model instanceof PsiTarget && ((PsiTarget)model).isValid() ? ((PsiTarget)model).getNavigationElement() : null);
    }

    @NotNull
    public final PresentationData getPresentationData(@NotNull Object model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        LogicalModelPresentationProvider<Object> presentationProvider = LogicalModelPresentationProvider.Companion.getForObject(model);
        if (presentationProvider == null) {
            return new PresentationData(this.typePresentationService.getObjectName(model), this.typePresentationService.getTypeName(model), this.typePresentationService.getIcon(model), null);
        }
        PresentationData presentationData = new PresentationData();
        List<PresentableNodeDescriptor.ColoredFragment> coloredText = presentationProvider.getColoredText(model);
        if (coloredText.isEmpty()) {
            presentationData.setPresentableText(presentationProvider.getName(model));
            presentationData.setLocationString(presentationProvider.getTypeName(model));
        }
        for (PresentableNodeDescriptor.ColoredFragment item : coloredText) {
            presentationData.addText(item);
        }
        presentationData.setIcon(presentationProvider.getIcon(model));
        presentationData.setTooltip(presentationProvider.getTooltipText(model));
        return presentationData;
    }

    private final PresentationData getPropertyPresentationData(PropertyElementProvider<?, ?> propertyProvider, Object model) {
        PresentationData presentationData = new PresentationData();
        String value = model instanceof String ? (String)model : this.typePresentationService.getObjectName(model);
        presentationData.addText(propertyProvider.getPropertyName() + ": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        presentationData.addText(value + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        return presentationData;
    }

    private static final List createViewTreeElement$lambda$0(LogicalStructureAssembledModel $assembledModel) {
        return $assembledModel.getChildren();
    }

    private static final List getChildrenNodes$lambda$0(LogicalStructureAssembledModel $child) {
        return $child.getChildren();
    }

    private static final List getChildrenNodes$lambda$1$0(LogicalStructureAssembledModel $child) {
        return $child.getChildren();
    }

    private static final List getChildrenNodes$lambda$2$0(LogicalStructureAssembledModel $child) {
        return $child.getChildren();
    }

    private static final List getChildrenNodes$lambda$3(LogicalStructureAssembledModel $child) {
        return $child.getChildren();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0017\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$EmptyChildrenElement;", "T", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewTreeElement;", "parentAssembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "<init>", "(Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;)V", "getParentAssembledModel", "()Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getValue", "", "getLogicalAssembledModel", "isHasNoOwnLogicalModel", "", "intellij.platform.structureView.impl"})
    public static final class EmptyChildrenElement<T>
    implements LogicalStructureViewTreeElement<T> {
        @NotNull
        private final LogicalStructureAssembledModel<T> parentAssembledModel;

        public EmptyChildrenElement(@NotNull LogicalStructureAssembledModel<T> parentAssembledModel) {
            Intrinsics.checkNotNullParameter(parentAssembledModel, (String)"parentAssembledModel");
            this.parentAssembledModel = parentAssembledModel;
        }

        @NotNull
        public final LogicalStructureAssembledModel<T> getParentAssembledModel() {
            return this.parentAssembledModel;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData;
            PresentationData $this$getPresentation_u24lambda_u240 = presentationData = new PresentationData(null, null, null, null);
            boolean bl = false;
            $this$getPresentation_u24lambda_u240.addText(StructureViewBundle.message("node.structureview.empty", new Object[0]), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
            return (ItemPresentation)presentationData;
        }

        @NotNull
        public TreeElement[] getChildren() {
            return new TreeElement[0];
        }

        @Nullable
        public Object getValue() {
            return new Object();
        }

        @Override
        @NotNull
        public LogicalStructureAssembledModel<T> getLogicalAssembledModel() {
            return this.parentAssembledModel;
        }

        @Override
        public boolean isHasNoOwnLogicalModel() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B5\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$LogicalGroupStructureElement;", "T", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewTreeElement;", "parentAssembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "grouper", "", "childrenModelsProvider", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "getParentAssembledModel", "()Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "getGrouper", "()Ljava/lang/Object;", "cashedChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getCashedChildren", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "cashedChildren$delegate", "Lkotlin/Lazy;", "getValue", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getChildren", "calculateChildren", "getLogicalAssembledModel", "isHasNoOwnLogicalModel", "", "equals", "other", "hashCode", "", "intellij.platform.structureView.impl"})
    @SourceDebugExtension(value={"SMAP\nLogicalStructureViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder$LogicalGroupStructureElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n1869#2,2:388\n1563#2:390\n1634#2,3:391\n37#3,2:394\n*S KotlinDebug\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder$LogicalGroupStructureElement\n*L\n285#1:388,2\n302#1:390\n302#1:391,3\n302#1:394,2\n*E\n"})
    public final class LogicalGroupStructureElement<T>
    implements LogicalStructureViewTreeElement<T> {
        @NotNull
        private final LogicalStructureAssembledModel<T> parentAssembledModel;
        @NotNull
        private final Object grouper;
        @NotNull
        private final Function0<List<LogicalStructureAssembledModel<?>>> childrenModelsProvider;
        @NotNull
        private final Lazy cashedChildren$delegate;

        public LogicalGroupStructureElement(@NotNull LogicalStructureAssembledModel<T> parentAssembledModel, @NotNull Object grouper, Function0<? extends List<? extends LogicalStructureAssembledModel<?>>> childrenModelsProvider) {
            Intrinsics.checkNotNullParameter(parentAssembledModel, (String)"parentAssembledModel");
            Intrinsics.checkNotNullParameter((Object)grouper, (String)"grouper");
            Intrinsics.checkNotNullParameter(childrenModelsProvider, (String)"childrenModelsProvider");
            this.parentAssembledModel = parentAssembledModel;
            this.grouper = grouper;
            this.childrenModelsProvider = childrenModelsProvider;
            this.cashedChildren$delegate = LazyKt.lazy(() -> LogicalGroupStructureElement.cashedChildren_delegate$lambda$0(this));
        }

        @NotNull
        public final LogicalStructureAssembledModel<T> getParentAssembledModel() {
            return this.parentAssembledModel;
        }

        @NotNull
        public final Object getGrouper() {
            return this.grouper;
        }

        private final TreeElement[] getCashedChildren() {
            Lazy lazy = this.cashedChildren$delegate;
            return (TreeElement[])lazy.getValue();
        }

        @NotNull
        public Object getValue() {
            return this.grouper;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            LogicalContainerPresentationProvider<ContainerElementsProvider> presentationProvider;
            if (this.grouper instanceof ContainerElementsProvider && (presentationProvider = LogicalContainerPresentationProvider.Companion.getForObject((ContainerElementsProvider)this.grouper)) != null) {
                T t = this.parentAssembledModel.getModel();
                Intrinsics.checkNotNull(t);
                List<PresentableNodeDescriptor.ColoredFragment> coloredText = presentationProvider.getColoredText(t);
                PresentationData presentationData = new PresentationData();
                if (!((Collection)coloredText).isEmpty()) {
                    Iterable $this$forEach$iv = coloredText;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PresentableNodeDescriptor.ColoredFragment p0 = (PresentableNodeDescriptor.ColoredFragment)element$iv;
                        boolean bl = false;
                        presentationData.addText(p0);
                    }
                    presentationData.setIcon(presentationProvider.getIcon(this.grouper));
                    return (ItemPresentation)presentationData;
                }
            }
            return (ItemPresentation)ElementsBuilder.this.getPresentationData(this.grouper);
        }

        @NotNull
        public TreeElement[] getChildren() {
            if (this.grouper instanceof ExternalElementsProvider) {
                return this.getCashedChildren();
            }
            return this.calculateChildren();
        }

        /*
         * WARNING - void declaration
         */
        private final TreeElement[] calculateChildren() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)this.childrenModelsProvider.invoke();
            ElementsBuilder elementsBuilder = ElementsBuilder.this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LogicalStructureAssembledModel logicalStructureAssembledModel = (LogicalStructureAssembledModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(elementsBuilder.createViewTreeElement(it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TreeElement[0]);
        }

        @Override
        @NotNull
        public LogicalStructureAssembledModel<T> getLogicalAssembledModel() {
            return this.parentAssembledModel;
        }

        @Override
        public boolean isHasNoOwnLogicalModel() {
            return true;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof LogicalGroupStructureElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.parentAssembledModel, ((LogicalGroupStructureElement)other).parentAssembledModel) && Intrinsics.areEqual((Object)this.grouper, (Object)((LogicalGroupStructureElement)other).grouper);
        }

        public int hashCode() {
            return this.parentAssembledModel.hashCode() * 11 + this.grouper.hashCode();
        }

        private static final TreeElement[] cashedChildren_delegate$lambda$0(LogicalGroupStructureElement this$0) {
            TreeElement[] result = this$0.calculateChildren();
            if (result.length == 0) {
                TreeElement[] treeElementArray = new TreeElement[]{new EmptyChildrenElement(this$0.parentAssembledModel)};
                return treeElementArray;
            }
            return result;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$OtherStructureElement;", "T", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewTreeElement;", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "<init>", "(Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;)V", "getValue", "", "getLogicalAssembledModel", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "equals", "", "other", "hashCode", "", "intellij.platform.structureView.impl"})
    @SourceDebugExtension(value={"SMAP\nLogicalStructureViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder$OtherStructureElement\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,387:1\n37#2,2:388\n*S KotlinDebug\n*F\n+ 1 LogicalStructureViewModel.kt\ncom/intellij/ide/structureView/logical/impl/ElementsBuilder$OtherStructureElement\n*L\n251#1:388,2\n*E\n"})
    public final class OtherStructureElement<T>
    implements StructureViewTreeElement,
    LogicalStructureViewTreeElement<T> {
        @NotNull
        private final LogicalStructureAssembledModel<T> assembledModel;

        public OtherStructureElement(LogicalStructureAssembledModel<T> assembledModel) {
            Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
            this.assembledModel = assembledModel;
        }

        @NotNull
        public Object getValue() {
            Object object = this.assembledModel.getModel();
            if (object == null) {
                object = "";
            }
            return object;
        }

        @Override
        @NotNull
        public LogicalStructureAssembledModel<T> getLogicalAssembledModel() {
            return this.assembledModel;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            T t = this.assembledModel.getModel();
            Intrinsics.checkNotNull(t);
            return (ItemPresentation)ElementsBuilder.this.getPresentationData(t);
        }

        @NotNull
        public TreeElement[] getChildren() {
            Collection $this$toTypedArray$iv = ElementsBuilder.this.getChildrenNodes(this.assembledModel);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new TreeElement[0]);
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof OtherStructureElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.assembledModel, ((OtherStructureElement)other).assembledModel);
        }

        public int hashCode() {
            return this.assembledModel.hashCode();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B-\u0012\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0013\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$PropertyPsiElementStructureElement;", "T", "Lcom/intellij/ide/structureView/impl/common/PsiTreeElementBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewTreeElement;", "grouper", "Lcom/intellij/ide/structureView/logical/PropertyElementProvider;", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "psiElement", "<init>", "(Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;Lcom/intellij/ide/structureView/logical/PropertyElementProvider;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;Lcom/intellij/psi/PsiElement;)V", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getPresentableText", "", "getLocationString", "getIcon", "Ljavax/swing/Icon;", "open", "", "getChildrenBase", "", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "isAllowExtensions", "getLogicalAssembledModel", "equals", "other", "", "hashCode", "", "intellij.platform.structureView.impl"})
    public final class PropertyPsiElementStructureElement<T>
    extends PsiTreeElementBase<PsiElement>
    implements LogicalStructureViewTreeElement<T> {
        @NotNull
        private final PropertyElementProvider<?, ?> grouper;
        @NotNull
        private final LogicalStructureAssembledModel<T> assembledModel;

        public PropertyPsiElementStructureElement(@NotNull PropertyElementProvider<?, ?> grouper, @NotNull LogicalStructureAssembledModel<T> assembledModel, PsiElement psiElement) {
            Intrinsics.checkNotNullParameter(grouper, (String)"grouper");
            Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            super(psiElement);
            this.grouper = grouper;
            this.assembledModel = assembledModel;
        }

        @Override
        @NotNull
        public ItemPresentation getPresentation() {
            T t = this.assembledModel.getModel();
            Intrinsics.checkNotNull(t);
            return (ItemPresentation)ElementsBuilder.this.getPropertyPresentationData(this.grouper, t);
        }

        @Nullable
        public String getPresentableText() {
            return this.getPresentation().getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return this.getPresentation().getLocationString();
        }

        @Override
        @Nullable
        public Icon getIcon(boolean open) {
            return this.getPresentation().getIcon(open);
        }

        @Override
        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return ElementsBuilder.this.getChildrenNodes(this.assembledModel);
        }

        @Override
        public boolean isAllowExtensions() {
            return false;
        }

        @Override
        @NotNull
        public LogicalStructureAssembledModel<T> getLogicalAssembledModel() {
            return this.assembledModel;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof PropertyPsiElementStructureElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.assembledModel, ((PropertyPsiElementStructureElement)other).assembledModel);
        }

        @Override
        public int hashCode() {
            return this.assembledModel.hashCode();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$PropertyStructureElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "grouper", "Lcom/intellij/ide/structureView/logical/PropertyElementProvider;", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "<init>", "(Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;Lcom/intellij/ide/structureView/logical/PropertyElementProvider;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;)V", "getValue", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getChildren", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "()[Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "equals", "", "other", "hashCode", "", "intellij.platform.structureView.impl"})
    public final class PropertyStructureElement
    implements StructureViewTreeElement {
        @NotNull
        private final PropertyElementProvider<?, ?> grouper;
        @NotNull
        private final LogicalStructureAssembledModel<?> assembledModel;

        public PropertyStructureElement(@NotNull PropertyElementProvider<?, ?> grouper, LogicalStructureAssembledModel<?> assembledModel) {
            Intrinsics.checkNotNullParameter(grouper, (String)"grouper");
            Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
            this.grouper = grouper;
            this.assembledModel = assembledModel;
        }

        @NotNull
        public Object getValue() {
            return this.grouper;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            Object obj = this.assembledModel.getModel();
            Intrinsics.checkNotNull(obj);
            return (ItemPresentation)ElementsBuilder.this.getPropertyPresentationData(this.grouper, obj);
        }

        @NotNull
        public TreeElement[] getChildren() {
            return new TreeElement[0];
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof PropertyStructureElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.assembledModel, ((PropertyStructureElement)other).assembledModel);
        }

        public int hashCode() {
            return this.assembledModel.hashCode();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0013\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder$PsiElementStructureElement;", "T", "Lcom/intellij/ide/structureView/impl/common/PsiTreeElementBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewTreeElement;", "assembledModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "psiElement", "<init>", "(Lcom/intellij/ide/structureView/logical/impl/ElementsBuilder;Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;Lcom/intellij/psi/PsiElement;)V", "getPresentableText", "", "getLocationString", "getIcon", "Ljavax/swing/Icon;", "open", "", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getChildrenBase", "", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "isAllowExtensions", "getLogicalAssembledModel", "navigate", "", "requestFocus", "equals", "other", "", "hashCode", "", "intellij.platform.structureView.impl"})
    public final class PsiElementStructureElement<T>
    extends PsiTreeElementBase<PsiElement>
    implements LogicalStructureViewTreeElement<T> {
        @NotNull
        private final LogicalStructureAssembledModel<T> assembledModel;

        public PsiElementStructureElement(@NotNull LogicalStructureAssembledModel<T> assembledModel, PsiElement psiElement) {
            Intrinsics.checkNotNullParameter(assembledModel, (String)"assembledModel");
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            super(psiElement);
            this.assembledModel = assembledModel;
        }

        @Nullable
        public String getPresentableText() {
            return this.getPresentation().getPresentableText();
        }

        @Nullable
        public String getLocationString() {
            return this.getPresentation().getLocationString();
        }

        @Override
        @Nullable
        public Icon getIcon(boolean open) {
            return this.getPresentation().getIcon(open);
        }

        @Override
        @NotNull
        public ItemPresentation getPresentation() {
            T t = this.assembledModel.getModel();
            Intrinsics.checkNotNull(t);
            return (ItemPresentation)ElementsBuilder.this.getPresentationData(t);
        }

        @Override
        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            return ElementsBuilder.this.getChildrenNodes(this.assembledModel);
        }

        @Override
        public boolean isAllowExtensions() {
            return false;
        }

        @Override
        @NotNull
        public LogicalStructureAssembledModel<T> getLogicalAssembledModel() {
            return this.assembledModel;
        }

        @Override
        public void navigate(boolean requestFocus) {
            T t = this.assembledModel.getModel();
            Intrinsics.checkNotNull(t);
            StructureViewEventsCollector.INSTANCE.logNavigate(t.getClass());
            super.navigate(requestFocus);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof PsiElementStructureElement)) {
                return false;
            }
            return Intrinsics.areEqual(this.assembledModel, ((PsiElementStructureElement)other).assembledModel);
        }

        @Override
        public int hashCode() {
            return this.assembledModel.hashCode();
        }
    }
}

