/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.lexer.TokenListUtil;
import com.intellij.platform.syntax.psi.impl.CompositeNode;
import com.intellij.platform.syntax.psi.impl.CompositeOptionalData;
import com.intellij.platform.syntax.psi.impl.ErrorNode;
import com.intellij.platform.syntax.psi.impl.LazyParseableToken;
import com.intellij.platform.syntax.psi.impl.NodeBase;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImplKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000e\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u0005J\u000e\u0010>\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0005J\u001e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005J\u000e\u0010D\u001a\u00020@2\u0006\u0010E\u001a\u00020FJ\u0018\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020F2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0016\u0010J\u001a\u00020K2\u0006\u0010E\u001a\u00020F2\u0006\u0010L\u001a\u00020HJ \u0010M\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00052\u0006\u0010O\u001a\u00020\u00052\u0006\u0010P\u001a\u00020HH\u0002J\u0018\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020H2\u0006\u0010S\u001a\u00020FH\u0002J\u0016\u0010T\u001a\u00020\t2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005J$\u0010U\u001a\u00020V2\u0006\u0010A\u001a\u00020W2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010)\u001a\u0004\b'\u0010(R\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020908\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006X"}, d2={"Lcom/intellij/platform/syntax/psi/impl/NodeData;", "", "lexStarts", "", "offset", "", "optionalData", "Lcom/intellij/platform/syntax/psi/impl/CompositeOptionalData;", "text", "", "whitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "lexemeCount", "convertedLexTypes", "", "Lcom/intellij/psi/tree/IElementType;", "lexTypes", "Lcom/intellij/platform/syntax/SyntaxElementType;", "charTable", "Lcom/intellij/util/CharTable;", "astFactory", "Lcom/intellij/lang/ASTFactory;", "textArray", "", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "([IILcom/intellij/platform/syntax/psi/impl/CompositeOptionalData;Ljava/lang/CharSequence;Lcom/intellij/psi/tree/TokenSet;I[Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/platform/syntax/SyntaxElementType;Lcom/intellij/util/CharTable;Lcom/intellij/lang/ASTFactory;[CLcom/intellij/psi/PsiFile;)V", "getLexStarts", "()[I", "getOffset", "()I", "getOptionalData", "()Lcom/intellij/platform/syntax/psi/impl/CompositeOptionalData;", "getText", "()Ljava/lang/CharSequence;", "getWhitespaceTokens", "()Lcom/intellij/psi/tree/TokenSet;", "getLexemeCount", "getConvertedLexTypes", "()[Lcom/intellij/psi/tree/IElementType;", "[Lcom/intellij/psi/tree/IElementType;", "getLexTypes", "()[Lcom/intellij/platform/syntax/SyntaxElementType;", "[Lcom/intellij/platform/syntax/SyntaxElementType;", "getCharTable", "()Lcom/intellij/util/CharTable;", "setCharTable", "(Lcom/intellij/util/CharTable;)V", "getAstFactory", "()Lcom/intellij/lang/ASTFactory;", "getTextArray", "()[C", "getFile", "()Lcom/intellij/psi/PsiFile;", "chameleonCache", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/platform/syntax/psi/impl/LazyParseableToken;", "getChameleonCache", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "getLexemeType", "index", "getLexemeStart", "createLeaf", "Lcom/intellij/psi/impl/source/tree/TreeElement;", "type", "start", "end", "createRootAST", "rootMarker", "Lcom/intellij/platform/syntax/psi/impl/CompositeNode;", "createComposite", "Lcom/intellij/psi/impl/source/tree/CompositeElement;", "marker", "bind", "", "rootNode", "insertLeaves", "curToken", "lastIdx", "curNode", "collapseLeaves", "ast", "compositeNode", "getInternedText", "createLazy", "Lcom/intellij/psi/impl/source/tree/LazyParseableElement;", "Lcom/intellij/psi/tree/ILazyParseableElementType;", "intellij.platform.syntax.psi"})
public final class NodeData {
    @NotNull
    private final int[] lexStarts;
    private final int offset;
    @NotNull
    private final CompositeOptionalData optionalData;
    @NotNull
    private final CharSequence text;
    @NotNull
    private final TokenSet whitespaceTokens;
    private final int lexemeCount;
    @NotNull
    private final IElementType[] convertedLexTypes;
    @NotNull
    private final SyntaxElementType[] lexTypes;
    @Nullable
    private CharTable charTable;
    @Nullable
    private final ASTFactory astFactory;
    @Nullable
    private final char[] textArray;
    @Nullable
    private final PsiFile file;
    @NotNull
    private final Int2ObjectOpenHashMap<LazyParseableToken> chameleonCache;

    public NodeData(@NotNull int[] lexStarts, int offset, @NotNull CompositeOptionalData optionalData, @NotNull CharSequence text, @NotNull TokenSet whitespaceTokens, int lexemeCount, @NotNull IElementType[] convertedLexTypes, @NotNull SyntaxElementType[] lexTypes, @Nullable CharTable charTable, @Nullable ASTFactory astFactory, @Nullable char[] textArray, @Nullable PsiFile file) {
        this.lexStarts = lexStarts;
        this.offset = offset;
        this.optionalData = optionalData;
        this.text = text;
        this.whitespaceTokens = whitespaceTokens;
        this.lexemeCount = lexemeCount;
        this.convertedLexTypes = convertedLexTypes;
        this.lexTypes = lexTypes;
        this.charTable = charTable;
        this.astFactory = astFactory;
        this.textArray = textArray;
        this.file = file;
        this.chameleonCache = new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final int[] getLexStarts() {
        return this.lexStarts;
    }

    public final int getOffset() {
        return this.offset;
    }

    @NotNull
    public final CompositeOptionalData getOptionalData() {
        return this.optionalData;
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    @NotNull
    public final TokenSet getWhitespaceTokens() {
        return this.whitespaceTokens;
    }

    public final int getLexemeCount() {
        return this.lexemeCount;
    }

    @NotNull
    public final IElementType[] getConvertedLexTypes() {
        return this.convertedLexTypes;
    }

    @NotNull
    public final SyntaxElementType[] getLexTypes() {
        return this.lexTypes;
    }

    @Nullable
    public final CharTable getCharTable() {
        return this.charTable;
    }

    public final void setCharTable(@Nullable CharTable charTable) {
        this.charTable = charTable;
    }

    @Nullable
    public final ASTFactory getAstFactory() {
        return this.astFactory;
    }

    @Nullable
    public final char[] getTextArray() {
        return this.textArray;
    }

    @Nullable
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final Int2ObjectOpenHashMap<LazyParseableToken> getChameleonCache() {
        return this.chameleonCache;
    }

    @NotNull
    public final IElementType getLexemeType(int index) {
        return this.convertedLexTypes[index];
    }

    public final int getLexemeStart(int index) {
        return this.lexStarts[index];
    }

    @NotNull
    public final TreeElement createLeaf(@NotNull IElementType type, int start, int end) {
        TreeElement element;
        CharSequence text = this.getInternedText(start, end);
        if (this.whitespaceTokens.contains(type)) {
            return (TreeElement)new PsiWhiteSpaceImpl(text);
        }
        if (type instanceof ICustomParsingType) {
            ICustomParsingType iCustomParsingType = (ICustomParsingType)type;
            CharTable charTable = this.charTable;
            Intrinsics.checkNotNull((Object)charTable);
            ASTNode aSTNode = iCustomParsingType.parse(text, charTable);
            Intrinsics.checkNotNull((Object)aSTNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.TreeElement");
            return (TreeElement)aSTNode;
        }
        if (type instanceof ILazyParseableElementType) {
            return (TreeElement)this.createLazy((ILazyParseableElementType)type, text, this.astFactory);
        }
        if (this.astFactory != null && (element = (TreeElement)this.astFactory.createLeaf(type, text)) != null) {
            return element;
        }
        return (TreeElement)ASTFactory.leaf((IElementType)type, (CharSequence)text);
    }

    @NotNull
    public final TreeElement createRootAST(@NotNull CompositeNode rootMarker) {
        TreeElement rootNode;
        IElementType type = rootMarker.getTokenType();
        TreeElement treeElement = rootNode = type instanceof ILazyParseableElementType ? (TreeElement)this.createLazy((ILazyParseableElementType)type, null, this.astFactory) : (TreeElement)this.createComposite(rootMarker, this.astFactory);
        if (this.charTable == null) {
            CharTable charTable = this.charTable = rootNode instanceof FileElement ? ((FileElement)rootNode).getCharTable() : (CharTable)new CharTableImpl();
        }
        if (!(rootNode instanceof FileElement)) {
            rootNode.putUserData(CharTable.CHAR_TABLE_KEY, (Object)this.charTable);
        }
        return rootNode;
    }

    @NotNull
    public final CompositeElement createComposite(@NotNull CompositeNode marker, @Nullable ASTFactory astFactory) {
        IElementType type = marker.getTokenType();
        if (Intrinsics.areEqual((Object)type, (Object)TokenType.ERROR_ELEMENT)) {
            String string = marker.getErrorMessage();
            Intrinsics.checkNotNull((Object)string);
            String error = string;
            return Factory.createErrorElement((String)error);
        }
        if (type == null) {
            throw new RuntimeException("Unbalanced tree. Most probably caused by unbalanced markers. Try calling setDebugMode(true) against PsiBuilder passed to identify exact location of the problem");
        }
        if (astFactory != null) {
            IElementType iElementType = marker.getTokenType();
            Intrinsics.checkNotNull((Object)iElementType);
            CompositeElement composite = astFactory.createComposite(iElementType);
            if (composite != null) {
                return composite;
            }
        }
        return ASTFactory.composite((IElementType)type);
    }

    public final void bind(@NotNull CompositeNode rootMarker, @NotNull CompositeElement rootNode) {
        ASTFactory astFactory = this.astFactory;
        CompositeNode curMarker = rootMarker;
        CompositeElement curNode = rootNode;
        int lexIndex = rootMarker._getIndex();
        NodeBase item = rootMarker.getMyFirstChild() != null ? rootMarker.getMyFirstChild() : (NodeBase)rootMarker;
        boolean itemDone = rootMarker.getMyFirstChild() == null;
        while (true) {
            NodeBase nodeBase = item;
            Intrinsics.checkNotNull((Object)nodeBase);
            lexIndex = this.insertLeaves(lexIndex, nodeBase.getLexemeIndex(itemDone), curNode);
            if (item == rootMarker && itemDone) break;
            if (item instanceof CompositeNode) {
                NodeBase marker = item;
                if (itemDone) {
                    curMarker = (CompositeNode)((CompositeNode)marker).getParent();
                    curNode = curNode.getTreeParent();
                    item = ((CompositeNode)marker).getNext();
                    itemDone = false;
                } else {
                    if (!((CompositeNode)marker).isCollapsed()) {
                        curMarker = (CompositeNode)marker;
                        CompositeElement childNode = this.createComposite((CompositeNode)marker, astFactory);
                        curNode.rawAddChildrenWithoutNotifications((TreeElement)childNode);
                        curNode = childNode;
                        item = ((CompositeNode)marker).getMyFirstChild() != null ? ((CompositeNode)marker).getMyFirstChild() : marker;
                        itemDone = ((CompositeNode)marker).getMyFirstChild() == null;
                        continue;
                    }
                    lexIndex = this.collapseLeaves(curNode, (CompositeNode)marker);
                    item = ((CompositeNode)marker).getNext();
                }
            } else if (item instanceof ErrorNode) {
                String string = ((ErrorNode)item).getErrorMessage();
                Intrinsics.checkNotNull((Object)string);
                CompositeElement errorElement = Factory.createErrorElement((String)string);
                curNode.rawAddChildrenWithoutNotifications((TreeElement)errorElement);
                item = ((ErrorNode)item).getNext();
            }
            if (item != null) continue;
            item = curMarker;
            itemDone = true;
        }
    }

    private final int insertLeaves(int curToken, int lastIdx, CompositeElement curNode) {
        int curToken2;
        int lastIdx2 = lastIdx;
        lastIdx2 = Math.min(lastIdx2, this.lexemeCount);
        for (curToken2 = curToken; curToken2 < lastIdx2; ++curToken2) {
            int end;
            int start;
            if ((curToken2 & 0xFF) == 0) {
                ProgressIndicatorProvider.checkCanceled();
            }
            if ((start = this.getLexemeStart(curToken2)) >= (end = this.getLexemeStart(curToken2 + 1)) && !(this.getLexemeType(curToken2) instanceof ILeafElementType)) continue;
            IElementType type = this.getLexemeType(curToken2);
            TreeElement leaf = this.createLeaf(type, start, end);
            curNode.rawAddChildrenWithoutNotifications(leaf);
        }
        return curToken2;
    }

    private final int collapseLeaves(CompositeElement ast, CompositeNode compositeNode) {
        int start = this.getLexemeStart(compositeNode._getIndex());
        int end = this.getLexemeStart(compositeNode.getEndIndex());
        IElementType iElementType = compositeNode.getTokenType();
        Intrinsics.checkNotNull((Object)iElementType);
        IElementType markerType = iElementType;
        TreeElement leaf = this.createLeaf(markerType, start, end);
        if (PsiSyntaxBuilderImplKt.shouldReuseCollapsedTokens(markerType) && compositeNode._getIndex() < compositeNode.getEndIndex()) {
            int length = compositeNode.getEndIndex() - compositeNode._getIndex();
            int[] relativeStarts = new int[length + 1];
            SyntaxElementType[] types = new SyntaxElementType[length + 1];
            int n = compositeNode.getEndIndex();
            for (int i = compositeNode._getIndex(); i < n; ++i) {
                relativeStarts[i - compositeNode._getIndex()] = this.lexStarts[i] - start;
                types[i - compositeNode._getIndex()] = this.lexTypes[i];
            }
            relativeStarts[length] = end - start;
            TokenList tokenList = TokenListUtil.TokenList((int[])relativeStarts, (SyntaxElementType[])types, (int)length, (CharSequence)leaf.getChars());
            leaf.putUserData(PsiSyntaxBuilderImplKt.getLAZY_PARSEABLE_TOKENS(), (Object)tokenList);
        }
        ast.rawAddChildrenWithoutNotifications(leaf);
        return compositeNode.getEndIndex();
    }

    @NotNull
    public final CharSequence getInternedText(int start, int end) {
        CharTable charTable = this.charTable;
        Intrinsics.checkNotNull((Object)charTable);
        return charTable.intern(this.text, start, end);
    }

    private final LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text, ASTFactory astFactory) {
        ASTFactory aSTFactory = astFactory;
        if (aSTFactory == null || (aSTFactory = aSTFactory.createLazy(type, text)) == null) {
            aSTFactory = ASTFactory.lazy((ILazyParseableElementType)type, (CharSequence)text);
        }
        return aSTFactory;
    }
}

