/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TokenWrapper;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.platform.syntax.psi.ExtraWhitespaces;
import com.intellij.platform.syntax.psi.impl.MyTreeStructure;
import com.intellij.platform.syntax.psi.impl.Node;
import com.intellij.platform.syntax.psi.impl.PsiSyntaxBuilderImpl;
import com.intellij.platform.syntax.psi.impl.Token;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.CustomLanguageASTComparator;
import com.intellij.psi.tree.ICustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILightLazyParseableElementType;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\u0018BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012&\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/syntax/psi/impl/MyComparator;", "Lcom/intellij/util/diff/ShallowNodeComparator;", "Lcom/intellij/lang/ASTNode;", "Lcom/intellij/lang/LighterASTNode;", "treeStructure", "Lcom/intellij/platform/syntax/psi/impl/MyTreeStructure;", "customLanguageASTComparators", "", "Lcom/intellij/psi/tree/CustomLanguageASTComparator;", "custom", "Lcom/intellij/util/TripleFunction;", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/util/ThreeState;", "<init>", "(Lcom/intellij/platform/syntax/psi/impl/MyTreeStructure;Ljava/util/List;Lcom/intellij/util/TripleFunction;)V", "deepEqual", "oldNode", "newNode", "customCompare", "typesEqual", "", "n1", "n2", "hashCodesEqual", "Companion", "intellij.platform.syntax.psi"})
public final class MyComparator
implements ShallowNodeComparator<ASTNode, LighterASTNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MyTreeStructure treeStructure;
    @NotNull
    private final List<? extends CustomLanguageASTComparator> customLanguageASTComparators;
    @Nullable
    private final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom;

    public MyComparator(@NotNull MyTreeStructure treeStructure, @NotNull List<? extends CustomLanguageASTComparator> customLanguageASTComparators, @Nullable TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> custom) {
        this.treeStructure = treeStructure;
        this.customLanguageASTComparators = customLanguageASTComparators;
        this.custom = custom;
    }

    @NotNull
    public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
        boolean newIsErrorElement;
        ProgressIndicatorProvider.checkCanceled();
        boolean oldIsErrorElement = oldNode instanceof PsiErrorElement && oldNode.getElementType() == TokenType.ERROR_ELEMENT;
        boolean bl = newIsErrorElement = newNode.getTokenType() == TokenType.ERROR_ELEMENT;
        if (oldIsErrorElement != newIsErrorElement) {
            return ThreeState.NO;
        }
        if (oldIsErrorElement) {
            Intrinsics.checkNotNull((Object)oldNode, (String)"null cannot be cast to non-null type com.intellij.psi.PsiErrorElement");
            PsiErrorElement e1 = (PsiErrorElement)oldNode;
            return Intrinsics.areEqual((Object)e1.getErrorDescription(), (Object)PsiSyntaxBuilderImpl.Companion.getErrorMessage(newNode)) ? ThreeState.UNSURE : ThreeState.NO;
        }
        ThreeState customResult = this.customCompare(oldNode, newNode);
        if (customResult != ThreeState.UNSURE) {
            return customResult;
        }
        if (newNode instanceof Token) {
            IElementType type = newNode.getTokenType();
            LighterASTNode token = newNode;
            if (oldNode instanceof ForeignLeafPsiElement) {
                return type instanceof ForeignLeafType && Intrinsics.areEqual((Object)((ForeignLeafType)type).getText(), (Object)((ForeignLeafPsiElement)oldNode).getText()) ? ThreeState.YES : ThreeState.NO;
            }
            if (oldNode instanceof LeafElement) {
                if (type instanceof ForeignLeafType) {
                    return ThreeState.NO;
                }
                return ((LeafElement)oldNode).textMatches(((Token)token).getText()) ? ThreeState.YES : ThreeState.NO;
            }
            if (type instanceof ILightLazyParseableElementType) {
                Intrinsics.checkNotNull((Object)oldNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.TreeElement");
                if (((TreeElement)oldNode).textMatches(((Token)token).getText())) {
                    return PsiDocumentManagerBase.isFullReparseInProgress() ? ThreeState.UNSURE : ThreeState.YES;
                }
                return TreeUtil.isCollapsedChameleon((ASTNode)oldNode) ? ThreeState.NO : ThreeState.UNSURE;
            }
            if (oldNode.getElementType() instanceof ILazyParseableElementType && type instanceof ILazyParseableElementType || oldNode.getElementType() instanceof ICustomParsingType && type instanceof ICustomParsingType) {
                Intrinsics.checkNotNull((Object)oldNode, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.TreeElement");
                return ((TreeElement)oldNode).textMatches(((Token)token).getText()) ? ThreeState.YES : ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }

    @NotNull
    public final ThreeState customCompare(@NotNull ASTNode oldNode, @NotNull LighterASTNode newNode) {
        for (CustomLanguageASTComparator customLanguageASTComparator : this.customLanguageASTComparators) {
            ThreeState customComparatorResult = customLanguageASTComparator.compareAST(oldNode, newNode, (FlyweightCapableTreeStructure)this.treeStructure);
            if (customComparatorResult == ThreeState.UNSURE) continue;
            return customComparatorResult;
        }
        if (this.custom != null) {
            return (ThreeState)this.custom.fun((Object)oldNode, (Object)newNode, (Object)this.treeStructure);
        }
        return ThreeState.UNSURE;
    }

    public boolean typesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
        if (n1 instanceof PsiWhiteSpaceImpl) {
            return ExtraWhitespaces.getWhitespaces$intellij_platform_syntax_psi().contains(n2.getTokenType()) || n2 instanceof Token && ((Token)n2).getNodeData().getWhitespaceTokens().contains(n2.getTokenType());
        }
        IElementType n1t = null;
        IElementType n2t = null;
        if (n1 instanceof ForeignLeafPsiElement) {
            n1t = (IElementType)((ForeignLeafPsiElement)n1).getForeignType();
            n2t = n2.getTokenType();
        } else {
            n1t = MyComparator.Companion.dereferenceToken(n1.getElementType());
            n2t = MyComparator.Companion.dereferenceToken(n2.getTokenType());
        }
        return Comparing.equal((Object)n1t, (Object)n2t);
    }

    public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull LighterASTNode n2) {
        PsiErrorElement e1;
        if (n1 instanceof LeafElement && n2 instanceof Token) {
            boolean isForeign1 = n1 instanceof ForeignLeafPsiElement;
            boolean isForeign2 = n2.getTokenType() instanceof ForeignLeafType;
            if (isForeign1 != isForeign2) {
                return false;
            }
            if (isForeign1) {
                String string = ((ForeignLeafPsiElement)n1).getText();
                IElementType iElementType = n2.getTokenType();
                Intrinsics.checkNotNull((Object)iElementType, (String)"null cannot be cast to non-null type com.intellij.lang.ForeignLeafType");
                return Intrinsics.areEqual((Object)string, (Object)((ForeignLeafType)iElementType).getText());
            }
            return ((LeafElement)n1).textMatches(((Token)n2).getText());
        }
        if (n1 instanceof PsiErrorElement && n2.getTokenType() == TokenType.ERROR_ELEMENT && !Intrinsics.areEqual((Object)(e1 = (PsiErrorElement)n1).getErrorDescription(), (Object)PsiSyntaxBuilderImpl.Companion.getErrorMessage(n2))) {
            return false;
        }
        Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.psi.impl.Node");
        return ((Node)n2).tokenTextMatches(n1.getChars());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/syntax/psi/impl/MyComparator$Companion;", "", "<init>", "()V", "dereferenceToken", "Lcom/intellij/psi/tree/IElementType;", "probablyWrapper", "intellij.platform.syntax.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final IElementType dereferenceToken(IElementType probablyWrapper) {
            if (probablyWrapper instanceof TokenWrapper) {
                return this.dereferenceToken(((TokenWrapper)probablyWrapper).getDelegate());
            }
            return probablyWrapper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

