/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.util.lexer;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.util.text.CharArrayUtilKmp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/platform/syntax/util/lexer/PrefixSuffixStripperLexer;", "Lcom/intellij/platform/syntax/util/lexer/LexerBase;", "prefix", "", "prefixType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "suffix", "suffixType", "middleTokenType", "<init>", "(Ljava/lang/String;Lcom/intellij/platform/syntax/SyntaxElementType;Ljava/lang/String;Lcom/intellij/platform/syntax/SyntaxElementType;Lcom/intellij/platform/syntax/SyntaxElementType;)V", "buffer", "", "bufferArray", "", "tokenStart", "", "tokenEnd", "tokenType", "state", "bufferEnd", "start", "", "startOffset", "endOffset", "initialState", "getTokenType", "getTokenStart", "getTokenEnd", "getState", "getBufferEnd", "getBufferSequence", "advance", "locateToken", "intellij.platform.syntax.util"})
@ApiStatus.Experimental
public final class PrefixSuffixStripperLexer
extends LexerBase {
    @NotNull
    private final String prefix;
    @Nullable
    private final SyntaxElementType prefixType;
    @NotNull
    private final String suffix;
    @Nullable
    private final SyntaxElementType suffixType;
    @Nullable
    private final SyntaxElementType middleTokenType;
    private CharSequence buffer;
    @Nullable
    private char[] bufferArray;
    private int tokenStart;
    private int tokenEnd;
    @Nullable
    private SyntaxElementType tokenType;
    private int state;
    private int bufferEnd;

    public PrefixSuffixStripperLexer(@NotNull String prefix, @Nullable SyntaxElementType prefixType, @NotNull String suffix, @Nullable SyntaxElementType suffixType, @Nullable SyntaxElementType middleTokenType) {
        this.prefix = prefix;
        this.prefixType = prefixType;
        this.suffix = suffix;
        this.suffixType = suffixType;
        this.middleTokenType = middleTokenType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.buffer = buffer;
        this.bufferArray = CharArrayUtilKmp.fromSequenceWithoutCopying((CharSequence)buffer);
        this.tokenStart = startOffset;
        this.tokenEnd = startOffset;
        this.tokenType = null;
        this.state = initialState;
        this.bufferEnd = endOffset;
    }

    @Nullable
    public SyntaxElementType getTokenType() {
        this.locateToken();
        return this.tokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.tokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.tokenEnd;
    }

    public int getState() {
        return this.state;
    }

    public int getBufferEnd() {
        return this.bufferEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
            charSequence = null;
        }
        return charSequence;
    }

    public void advance() {
        this.tokenType = null;
    }

    private final void locateToken() {
        if (this.tokenType != null) {
            return;
        }
        switch (this.state) {
            case 0: {
                this.tokenEnd = this.tokenStart + this.prefix.length();
                this.tokenType = this.prefixType;
                this.state = this.tokenEnd < this.bufferEnd ? 1 : 3;
                break;
            }
            case 1: {
                boolean bufferMatches;
                boolean bl;
                this.tokenStart = this.tokenEnd;
                int suffixStart = this.bufferEnd - this.suffix.length();
                this.tokenType = this.middleTokenType;
                char[] bufferArray = this.bufferArray;
                if (bufferArray == null) {
                    CharSequence charSequence = this.buffer;
                    if (charSequence == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"buffer");
                        charSequence = null;
                    }
                    bl = CharArrayUtilKmp.regionMatches((CharSequence)charSequence, (int)suffixStart, (int)this.bufferEnd, (CharSequence)this.suffix);
                } else {
                    bl = bufferMatches = CharArrayUtilKmp.regionMatches((char[])bufferArray, (int)suffixStart, (int)this.bufferEnd, (CharSequence)this.suffix);
                }
                if (bufferMatches) {
                    this.tokenEnd = suffixStart;
                    if (this.tokenStart < this.tokenEnd) {
                        this.state = 2;
                        break;
                    }
                    this.state = 3;
                    this.tokenType = this.suffixType;
                    this.tokenEnd = this.bufferEnd;
                    break;
                }
                this.tokenEnd = this.bufferEnd;
                this.state = 3;
                break;
            }
            case 2: {
                this.tokenStart = this.tokenEnd;
                this.tokenEnd = this.bufferEnd;
                this.tokenType = this.suffixType;
                this.state = 3;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state: " + this.state);
            }
        }
    }
}

