/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.lexer;

import com.intellij.platform.syntax.CancellationProvider;
import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementTypeSet;
import com.intellij.platform.syntax.impl.builder.SyntaxBuildingDiagnostics;
import com.intellij.platform.syntax.impl.builder.SyntaxBuildingDiagnosticsKt;
import com.intellij.platform.syntax.lexer.Builder;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.lexer.TokenListImpl;
import com.intellij.platform.syntax.lexer.TokenListImplKt;
import com.intellij.platform.syntax.lexer.TokenListLexerImpl;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a1\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0013\u001a\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f\u001a/\u0010\u0016\u001a\u00020\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u001b\u001a\u001a\u0010\u0016\u001a\u00020\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001c\u001a\"\u0010\u001d\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f\u001a\u001a\u0010 \u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u001c\u001a\u001a\u0010\"\u001a\u00020\u0011*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u001c\u00a8\u0006#"}, d2={"performLexing", "Lcom/intellij/platform/syntax/lexer/TokenList;", "text", "", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "cancellationProvider", "Lcom/intellij/platform/syntax/CancellationProvider;", "logger", "Lcom/intellij/platform/syntax/Logger;", "TokenList", "lexStarts", "", "lexTypes", "", "Lcom/intellij/platform/syntax/SyntaxElementType;", "tokenCount", "", "tokenizedText", "([I[Lcom/intellij/platform/syntax/SyntaxElementType;ILjava/lang/CharSequence;)Lcom/intellij/platform/syntax/lexer/TokenList;", "tokenListLexer", "tokenList", "hasType", "", "index", "type", "types", "(Lcom/intellij/platform/syntax/lexer/TokenList;I[Lcom/intellij/platform/syntax/SyntaxElementType;)Z", "Lcom/intellij/platform/syntax/SyntaxElementTypeSet;", "backWithBraceMatching", "opening", "closing", "backWhile", "toSkip", "forwardWhile", "intellij.platform.syntax"})
@ApiStatus.Experimental
@JvmName(name="TokenListUtil")
public final class TokenListUtil {
    @NotNull
    public static final TokenList performLexing(@NotNull CharSequence text, @NotNull Lexer lexer, @Nullable CancellationProvider cancellationProvider, @Nullable Logger logger) {
        TokenListImpl sequence;
        block1: {
            TokenList existing;
            if (lexer instanceof TokenListLexerImpl && (existing = ((TokenListLexerImpl)lexer).getTokens()) instanceof TokenListImpl && TokenListImplKt.equal(text, ((TokenListImpl)existing).getTokenizedText())) {
                int[] nArray = ((TokenListImpl)existing).getLexStarts();
                SyntaxElementType[] syntaxElementTypeArray = ((TokenListImpl)existing).getLexTypes();
                SyntaxElementType[] syntaxElementTypeArray2 = Arrays.copyOf(syntaxElementTypeArray, syntaxElementTypeArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)syntaxElementTypeArray2, (String)"copyOf(...)");
                return new TokenListImpl(nArray, syntaxElementTypeArray2, ((TokenListImpl)existing).getTokenCount(), text, 0, 16, null);
            }
            sequence = new Builder(text, lexer, cancellationProvider, logger).performLexing();
            SyntaxBuildingDiagnostics syntaxBuildingDiagnostics = SyntaxBuildingDiagnosticsKt.getDIAGNOSTICS();
            if (syntaxBuildingDiagnostics == null) break block1;
            syntaxBuildingDiagnostics.registerPass(text.length(), sequence.getTokenCount());
        }
        return sequence;
    }

    @NotNull
    public static final TokenList TokenList(@NotNull int[] lexStarts, @NotNull SyntaxElementType[] lexTypes, int tokenCount, @NotNull CharSequence tokenizedText) {
        return new TokenListImpl(lexStarts, lexTypes, tokenCount, tokenizedText, 0, 16, null);
    }

    @NotNull
    public static final Lexer tokenListLexer(@NotNull TokenList tokenList, @Nullable Logger logger) {
        return new TokenListLexerImpl(tokenList, logger);
    }

    public static /* synthetic */ Lexer tokenListLexer$default(TokenList tokenList, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = null;
        }
        return TokenListUtil.tokenListLexer(tokenList, logger);
    }

    public static final boolean hasType(@NotNull TokenList $this$hasType, int index, @NotNull SyntaxElementType type) {
        return $this$hasType.getTokenType(index) == type;
    }

    public static final boolean hasType(@NotNull TokenList $this$hasType, int index, SyntaxElementType ... types) {
        return ArraysKt.contains((Object[])types, (Object)$this$hasType.getTokenType(index));
    }

    public static final boolean hasType(@NotNull TokenList $this$hasType, int index, @NotNull SyntaxElementTypeSet types) {
        return CollectionsKt.contains((Iterable)types, (Object)$this$hasType.getTokenType(index));
    }

    public static final int backWithBraceMatching(@NotNull TokenList $this$backWithBraceMatching, int index, @NotNull SyntaxElementType opening, @NotNull SyntaxElementType closing) {
        int index2 = index;
        if ($this$backWithBraceMatching.getTokenType(index2) == closing) {
            int nesting = 1;
            while (nesting > 0 && index2 > 0) {
                SyntaxElementType type;
                if ((type = $this$backWithBraceMatching.getTokenType(--index2)) == closing) {
                    ++nesting;
                    continue;
                }
                if (type != opening) continue;
                --nesting;
            }
        }
        return index2 - 1;
    }

    public static final int backWhile(@NotNull TokenList $this$backWhile, int index, @NotNull SyntaxElementTypeSet toSkip) {
        int index2 = index;
        while (TokenListUtil.hasType($this$backWhile, index2, toSkip)) {
            --index2;
        }
        return index2;
    }

    public static final int forwardWhile(@NotNull TokenList $this$forwardWhile, int index, @NotNull SyntaxElementTypeSet toSkip) {
        int index2 = index;
        while (TokenListUtil.hasType($this$forwardWhile, index2, toSkip)) {
            ++index2;
        }
        return index2;
    }
}

