/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.lexer;

import com.intellij.platform.syntax.Logger;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.platform.syntax.lexer.LexerPositionImpl;
import com.intellij.platform.syntax.lexer.TokenList;
import com.intellij.platform.syntax.lexer.TokenListImplKt;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\rH\u0016J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rJ \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/platform/syntax/lexer/TokenListLexerImpl;", "Lcom/intellij/platform/syntax/lexer/Lexer;", "tokens", "Lcom/intellij/platform/syntax/lexer/TokenList;", "logger", "Lcom/intellij/platform/syntax/Logger;", "<init>", "(Lcom/intellij/platform/syntax/lexer/TokenList;Lcom/intellij/platform/syntax/Logger;)V", "getTokens", "()Lcom/intellij/platform/syntax/lexer/TokenList;", "getLogger", "()Lcom/intellij/platform/syntax/Logger;", "state", "", "getState", "startMeasured", "", "buffer", "", "startOffset", "endOffset", "initialState", "start", "buf", "end", "getTokenType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "getTokenStart", "getTokenEnd", "advance", "getBufferSequence", "getBufferEnd", "getCurrentPosition", "Lcom/intellij/platform/syntax/lexer/LexerPosition;", "restore", "position", "intellij.platform.syntax"})
@SourceDebugExtension(value={"SMAP\nTokenListImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenListImpl.kt\ncom/intellij/platform/syntax/lexer/TokenListLexerImpl\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,263:1\n24#2:264\n63#2,3:265\n*S KotlinDebug\n*F\n+ 1 TokenListImpl.kt\ncom/intellij/platform/syntax/lexer/TokenListLexerImpl\n*L\n103#1:264\n103#1:265,3\n*E\n"})
public final class TokenListLexerImpl
implements Lexer {
    @NotNull
    private final TokenList tokens;
    @Nullable
    private final Logger logger;
    private int state;

    public TokenListLexerImpl(@NotNull TokenList tokens, @Nullable Logger logger) {
        this.tokens = tokens;
        this.logger = logger;
    }

    @NotNull
    public final TokenList getTokens() {
        return this.tokens;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getState() {
        return this.state;
    }

    public final void startMeasured(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Logger logger = this.logger;
        if (!(logger != null ? logger.isDebugEnabled() : false)) {
            this.start(buffer, startOffset, endOffset, initialState);
            return;
        }
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.start(buffer, startOffset, endOffset, initialState);
        long startDuration = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        if (Duration.getInWholeMilliseconds-impl((long)startDuration) > 500L) {
            Logger.debug$default(this.logger, "Starting lexer took: " + Duration.toString-impl((long)startDuration) + "; at " + startOffset + " - " + endOffset + "; state: " + initialState + "; text: " + TokenListImplKt.access$shortenTextWithEllipsis(buffer, 1024, 500), null, 2, null);
        }
    }

    @Override
    public void start(@NotNull CharSequence buf, int start, int end) {
        this.startMeasured(buf, start, end, 0);
    }

    @Override
    public void start(@NotNull CharSequence buf) {
        this.startMeasured(buf, 0, buf.length(), 0);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (!TokenListImplKt.equal(buffer, this.tokens.getTokenizedText())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(startOffset == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(endOffset == buffer.length())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(initialState == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.state = 0;
    }

    @Override
    @Nullable
    public SyntaxElementType getTokenType() {
        return this.tokens.getTokenType(this.getState());
    }

    @Override
    public int getTokenStart() {
        return this.tokens.getTokenStart(this.getState());
    }

    @Override
    public int getTokenEnd() {
        return this.tokens.getTokenEnd(this.getState());
    }

    @Override
    public void advance() {
        int n = this.state;
        this.state = n + 1;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        return this.tokens.getTokenizedText();
    }

    @Override
    public int getBufferEnd() {
        return this.tokens.getTokenizedText().length();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        int offset = this.getTokenStart();
        int intState = this.getState();
        return new LexerPositionImpl(offset, intState);
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }
}

