/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.tree;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.tree.ASTMarkers;
import com.intellij.platform.syntax.tree.ChameleonRef;
import com.intellij.platform.syntax.tree.MarkerKind;
import com.intellij.util.fastutil.ints.Int2IntOpenHashMap;
import com.intellij.util.fastutil.ints.Int2ObjectOpenHashMap;
import com.intellij.util.fastutil.ints.IntArrayList;
import com.intellij.util.fastutil.ints.IntEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0003JKLBM\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B\t\b\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0000J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000eJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u001a\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0&0%H\u0016J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0018\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0000H\u0002J \u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020\u0000H\u0002J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/H\u0002J \u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eH\u0002J \u00105\u001a\u00020(2\u0006\u0010-\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u0000H\u0002J\u0018\u00107\u001a\u00020(2\u0006\u0010-\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eH\u0002J\u0018\u00108\u001a\u00020(2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0016\u00109\u001a\u00020(2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\fJ\u0016\u0010;\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000eJ\u001e\u0010=\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eJ\u0006\u0010?\u001a\u00020\u000eJ:\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\b\u0010B\u001a\u00020\nH\u0016J!\u0010C\u001a\u00020\u00002\u0017\u0010D\u001a\u0013\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020(0E\u00a2\u0006\u0002\bGH\u0016J\"\u0010H\u001a\u00020\u00002\u0018\u0010I\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0&0%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006M"}, d2={"Lcom/intellij/platform/syntax/tree/ASTMarkersImpl;", "Lcom/intellij/platform/syntax/tree/ASTMarkers;", "packer", "Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer;", "elementTypes", "Ljava/util/ArrayList;", "Lcom/intellij/platform/syntax/SyntaxElementType;", "Lkotlin/collections/ArrayList;", "errorMessages", "Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;", "", "chameleonsMap", "Lcom/intellij/platform/syntax/tree/ChameleonRef;", "nextId", "", "<init>", "(Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer;Ljava/util/ArrayList;Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;Lcom/intellij/util/fastutil/ints/Int2ObjectOpenHashMap;I)V", "()V", "copy", "size", "getSize", "()I", "kind", "Lcom/intellij/platform/syntax/tree/MarkerKind;", "i", "errorMessage", "hasError", "", "id", "lexemeCount", "lexemeRelOffset", "collapsed", "markersCount", "elementType", "chameleonAt", "lexemeIndex", "chameleons", "", "Lkotlin/Pair;", "substituteImpl", "", "astMarkers", "copyNewChameleons", "startLexeme", "renumberNewMarkers", "start", "oldId2newId", "Lcom/intellij/util/fastutil/ints/Int2IntOpenHashMap;", "computeIdsForNewMarkers", "renumberIfNeeded", "nextNewId", "insertedStart", "insertedEnd", "copyNewAstMarkers", "end", "removeMarkersFromMaps", "renumber", "setChameleon", "reference", "setMarkersCount", "descCount", "setLexemeInfo", "relOffset", "pushBack", "setMarker", "index", "toString", "mutate", "mutator", "Lkotlin/Function1;", "Lcom/intellij/platform/syntax/tree/ASTMarkers$MutableContext;", "Lkotlin/ExtensionFunctionType;", "withChameleons", "pairs", "LexemeInfo", "Packer", "MutableContextImpl", "intellij.platform.syntax"})
@SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\ncom/intellij/platform/syntax/tree/ASTMarkersImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 IntIteratorExtensions.kt\ncom/intellij/util/fastutil/ints/IntIteratorExtensionsKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n1#2:457\n8#3,2:458\n32#4,2:460\n1869#5,2:462\n1869#5,2:464\n1869#5,2:466\n1869#5,2:468\n1878#5,3:470\n1869#5,2:473\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\ncom/intellij/platform/syntax/tree/ASTMarkersImpl\n*L\n115#1:458,2\n120#1:460,2\n129#1:462,2\n144#1:464,2\n173#1:466,2\n183#1:468,2\n245#1:470,3\n447#1:473,2\n*E\n"})
public final class ASTMarkersImpl
implements ASTMarkers {
    @NotNull
    private final Packer packer;
    @NotNull
    private final ArrayList<SyntaxElementType> elementTypes;
    @NotNull
    private final Int2ObjectOpenHashMap<String> errorMessages;
    @NotNull
    private final Int2ObjectOpenHashMap<ChameleonRef> chameleonsMap;
    private int nextId;

    private ASTMarkersImpl(Packer packer, ArrayList<SyntaxElementType> elementTypes, Int2ObjectOpenHashMap<String> errorMessages, Int2ObjectOpenHashMap<ChameleonRef> chameleonsMap, int nextId) {
        this.packer = packer;
        this.elementTypes = elementTypes;
        this.errorMessages = errorMessages;
        this.chameleonsMap = chameleonsMap;
        this.nextId = nextId;
    }

    public ASTMarkersImpl() {
        this(new Packer(), new ArrayList<SyntaxElementType>(256), (Int2ObjectOpenHashMap<String>)new Int2ObjectOpenHashMap(), (Int2ObjectOpenHashMap<ChameleonRef>)new Int2ObjectOpenHashMap(), 0);
    }

    @NotNull
    public final ASTMarkersImpl copy() {
        return new ASTMarkersImpl(this.packer.copy(), new ArrayList<SyntaxElementType>((Collection)this.elementTypes), (Int2ObjectOpenHashMap<String>)new Int2ObjectOpenHashMap(this.errorMessages, 0.0f, 2, null), (Int2ObjectOpenHashMap<ChameleonRef>)new Int2ObjectOpenHashMap(this.chameleonsMap, 0.0f, 2, null), this.nextId);
    }

    @Override
    public int getSize() {
        return this.packer.getSize();
    }

    @Override
    @NotNull
    public MarkerKind kind(int i) {
        return this.packer.kind(i);
    }

    @Override
    @Nullable
    public String errorMessage(int i) {
        return this.hasError(i) ? (String)this.errorMessages.get(this.id(i)) : null;
    }

    public final boolean hasError(int i) {
        return this.packer.hasErrors(i);
    }

    public final int id(int i) {
        return this.packer.id(i);
    }

    @Override
    public int lexemeCount(int i) {
        return this.packer.lexemeInfo(i).getCount();
    }

    @Override
    public int lexemeRelOffset(int i) {
        return this.packer.lexemeInfo(i).getRelOffset();
    }

    @Override
    public boolean collapsed(int i) {
        return this.packer.collapsed(i);
    }

    @Override
    public int markersCount(int i) {
        return this.packer.markersCount(i);
    }

    @Override
    @NotNull
    public SyntaxElementType elementType(int i) {
        return this.elementTypes.get(i);
    }

    @Override
    @NotNull
    public ChameleonRef chameleonAt(int lexemeIndex) {
        Object object = this.chameleonsMap.get(lexemeIndex);
        Intrinsics.checkNotNull((Object)object);
        return (ChameleonRef)object;
    }

    @Override
    @NotNull
    public List<Pair<Integer, ChameleonRef>> chameleons() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)this.chameleonsMap.getEntries()), ASTMarkersImpl::chameleons$lambda$0));
    }

    private final void substituteImpl(ASTMarkers astMarkers, int i, int lexemeIndex) {
        if (!(astMarkers instanceof ASTMarkersImpl)) {
            boolean $i$a$-check-ASTMarkersImpl$substituteImpl$22 = false;
            String $i$a$-check-ASTMarkersImpl$substituteImpl$22 = "unexpected class: " + Reflection.getOrCreateKotlinClass(astMarkers.getClass());
            throw new IllegalStateException($i$a$-check-ASTMarkersImpl$substituteImpl$22.toString());
        }
        if (!(this.kind(i) == MarkerKind.Start)) {
            throw new IllegalStateException("Check failed.");
        }
        int start = i;
        int end = i + this.markersCount(i);
        int relOffset = this.lexemeRelOffset(i);
        Int2IntOpenHashMap oldId2newId = new Int2IntOpenHashMap();
        this.copyNewChameleons(lexemeIndex, (ASTMarkersImpl)astMarkers);
        this.removeMarkersFromMaps(start, end);
        int newNextId = this.computeIdsForNewMarkers((ASTMarkersImpl)astMarkers, oldId2newId);
        this.copyNewAstMarkers(start, end, (ASTMarkersImpl)astMarkers);
        this.renumberIfNeeded(newNextId, start, start + ((ASTMarkersImpl)astMarkers).getSize());
        this.renumberNewMarkers(start, oldId2newId, (ASTMarkersImpl)astMarkers);
        int count = this.lexemeCount(i);
        this.setLexemeInfo(i, count, relOffset);
        this.setLexemeInfo(i + ((ASTMarkersImpl)astMarkers).getSize() - 1, count, relOffset);
        this.nextId += newNextId;
    }

    private final void copyNewChameleons(int startLexeme, ASTMarkersImpl astMarkers) {
        Object $this$forEach$iv = this.chameleonsMap.getKeys();
        boolean $i$f$forEach = false;
        while ($this$forEach$iv.hasNext()) {
            int it = $this$forEach$iv.next();
            boolean bl = false;
            if (startLexeme > it || it >= startLexeme + astMarkers.lexemeCount(0)) continue;
            this.chameleonsMap.remove(it);
        }
        $this$forEach$iv = astMarkers.chameleonsMap.getEntries();
        $i$f$forEach = false;
        Object object = $this$forEach$iv;
        while (object.hasNext()) {
            Object element$iv = object.next();
            IntEntry intEntry = (IntEntry)element$iv;
            boolean bl = false;
            int k = intEntry.component1();
            ChameleonRef v = (ChameleonRef)intEntry.component2();
            this.chameleonsMap.set(k + startLexeme, (Object)v);
        }
    }

    private final void renumberNewMarkers(int start, Int2IntOpenHashMap oldId2newId, ASTMarkersImpl astMarkers) {
        int offset = this.nextId;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)start, (int)(start + astMarkers.getSize()));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int oldId = this.id(index);
            int newId = oldId2newId.get(oldId) + offset;
            if (this.hasError(index)) {
                Object object = astMarkers.errorMessages.get(oldId);
                Intrinsics.checkNotNull((Object)object);
                this.errorMessages.set(newId, object);
            }
            this.packer.setId(index, newId);
        }
    }

    private final int computeIdsForNewMarkers(ASTMarkersImpl astMarkers, Int2IntOpenHashMap oldId2newId) {
        Ref.IntRef nextNewId = new Ref.IntRef();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)astMarkers.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            oldId2newId.computeIfAbsent(astMarkers.id(index), arg_0 -> ASTMarkersImpl.computeIdsForNewMarkers$lambda$0$0(nextNewId, arg_0));
        }
        return nextNewId.element;
    }

    private final void renumberIfNeeded(int nextNewId, int insertedStart, int insertedEnd) {
        if (this.packer.getShortMode() && this.nextId + nextNewId > 65535) {
            this.nextId = 0;
            this.renumber(insertedStart, insertedEnd);
        }
    }

    private final void copyNewAstMarkers(int start, int end, ASTMarkersImpl astMarkers) {
        this.elementTypes.subList(start, end + 1).clear();
        this.elementTypes.addAll(start, (Collection<SyntaxElementType>)astMarkers.elementTypes);
        this.packer.replace(start, end + 1, astMarkers.packer);
    }

    private final void removeMarkersFromMaps(int start, int end) {
        Iterable $this$forEach$iv = (Iterable)new IntRange(start, end);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int currentId = this.id(index);
            if (!this.hasError(index)) continue;
            this.errorMessages.remove(currentId);
        }
    }

    private final void renumber(int insertedStart, int insertedEnd) {
        Int2IntOpenHashMap renumberMap = new Int2IntOpenHashMap();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.getSize());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int index = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (insertedStart <= index ? index < insertedEnd : false) continue;
            int newId = renumberMap.computeIfAbsent(this.id(index), arg_0 -> ASTMarkersImpl.renumber$lambda$0$0(this, index, arg_0));
            this.packer.setId(index, newId);
        }
    }

    public final void setChameleon(int lexemeIndex, @NotNull ChameleonRef reference) {
        this.chameleonsMap.set(lexemeIndex, (Object)reference);
    }

    public final void setMarkersCount(int i, int descCount) {
        this.packer.setMarkersCount(i, descCount);
    }

    public final void setLexemeInfo(int i, int lexemeCount, int relOffset) {
        this.packer.setLexemeInfo(i, lexemeCount, relOffset);
    }

    public final int pushBack() {
        int i = this.getSize();
        this.packer.pushBack();
        this.elementTypes.add(i, SyntaxTokenTypes.getERROR_ELEMENT());
        return i;
    }

    public final void setMarker(int index, int id, @NotNull MarkerKind kind, boolean collapsed, @Nullable String errorMessage, @Nullable SyntaxElementType elementType) {
        if (this.kind(index) != MarkerKind.Undone) {
            throw new AssertionError();
        }
        if (id + 1 > this.nextId) {
            this.nextId = id + 1;
        }
        this.packer.setInitialInfo(index, id, kind, collapsed, errorMessage != null);
        if (errorMessage != null) {
            this.errorMessages.put(id, (Object)errorMessage);
        }
        if (elementType != null) {
            this.elementTypes.set(index, elementType);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int depth = 0;
        Iterable $this$forEachIndexed$iv = this.elementTypes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void type;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SyntaxElementType syntaxElementType = (SyntaxElementType)item$iv;
            int index = n;
            boolean bl2 = false;
            if (this.kind(index) == MarkerKind.End) {
                depth += -1;
            }
            $this$toString_u24lambda_u240.append(StringsKt.repeat((CharSequence)"  ", (int)depth) + type + ' ' + (Object)((Object)this.kind(index)) + ' ');
            $this$toString_u24lambda_u240.append("e=" + this.hasError(index) + ' ');
            $this$toString_u24lambda_u240.append("c=" + this.collapsed(index) + ' ');
            $this$toString_u24lambda_u240.append("lo=" + this.lexemeRelOffset(index) + ' ');
            $this$toString_u24lambda_u240.append("lc" + this.lexemeCount(index) + ' ');
            $this$toString_u24lambda_u240.append("mc=" + this.markersCount(index)).append('\n');
            if (this.kind(index) != MarkerKind.Start) continue;
            ++depth;
        }
        $this$toString_u24lambda_u240.append("{").append('\n');
        Iterator iterator = this.chameleonsMap.getEntries();
        while (iterator.hasNext()) {
            IntEntry intEntry = (IntEntry)iterator.next();
            int t = intEntry.component1();
            ChameleonRef u = (ChameleonRef)intEntry.component2();
            $this$toString_u24lambda_u240.append(t + " -> " + u).append('\n');
        }
        $this$toString_u24lambda_u240.append("}").append('\n');
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public ASTMarkersImpl mutate(@NotNull Function1<? super ASTMarkers.MutableContext, Unit> mutator) {
        MutableContextImpl mutableContextImpl = new MutableContextImpl();
        mutator.invoke((Object)mutableContextImpl);
        return mutableContextImpl.getAst();
    }

    /*
     * WARNING - void declaration
     */
    private final ASTMarkersImpl withChameleons(List<? extends Pair<Integer, ? extends ChameleonRef>> pairs) {
        Int2ObjectOpenHashMap int2ObjectOpenHashMap;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap2 = int2ObjectOpenHashMap = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap<String> int2ObjectOpenHashMap3 = this.errorMessages;
        ArrayList<SyntaxElementType> arrayList = this.elementTypes;
        Packer packer = this.packer;
        boolean bl = false;
        Iterable $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$withChameleons_u24lambda_u240;
            Pair pair = (Pair)element$iv;
            boolean bl2 = false;
            int i = ((Number)pair.component1()).intValue();
            ChameleonRef ref = (ChameleonRef)pair.component2();
            $this$withChameleons_u24lambda_u240.put(i, (Object)ref);
        }
        Unit unit = Unit.INSTANCE;
        int n = this.nextId;
        Int2ObjectOpenHashMap int2ObjectOpenHashMap4 = int2ObjectOpenHashMap;
        Int2ObjectOpenHashMap<String> int2ObjectOpenHashMap5 = int2ObjectOpenHashMap3;
        ArrayList<SyntaxElementType> arrayList2 = arrayList;
        Packer packer2 = packer;
        return new ASTMarkersImpl(packer2, arrayList2, int2ObjectOpenHashMap5, (Int2ObjectOpenHashMap<ChameleonRef>)int2ObjectOpenHashMap4, n);
    }

    private static final Pair chameleons$lambda$0(IntEntry intEntry) {
        int key = intEntry.component1();
        ChameleonRef value = (ChameleonRef)intEntry.component2();
        return TuplesKt.to((Object)key, (Object)value);
    }

    private static final int computeIdsForNewMarkers$lambda$0$0(Ref.IntRef $nextNewId, int it) {
        int n = $nextNewId.element;
        $nextNewId.element = n + 1;
        return n;
    }

    private static final int renumber$lambda$0$0(ASTMarkersImpl this$0, int $index, int oldId) {
        int n = this$0.nextId;
        this$0.nextId = n + 1;
        int currentId = n;
        if (this$0.hasError($index)) {
            Int2ObjectOpenHashMap<String> int2ObjectOpenHashMap = this$0.errorMessages;
            Object object = this$0.errorMessages.remove(oldId);
            Intrinsics.checkNotNull((Object)object);
            int2ObjectOpenHashMap.set(currentId, object);
        }
        return currentId;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$LexemeInfo;", "", "relOffset", "", "count", "<init>", "(II)V", "getRelOffset", "()I", "getCount", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.syntax"})
    private static final class LexemeInfo {
        private final int relOffset;
        private final int count;

        public LexemeInfo(int relOffset, int count) {
            this.relOffset = relOffset;
            this.count = count;
        }

        public final int getRelOffset() {
            return this.relOffset;
        }

        public final int getCount() {
            return this.count;
        }

        public final int component1() {
            return this.relOffset;
        }

        public final int component2() {
            return this.count;
        }

        @NotNull
        public final LexemeInfo copy(int relOffset, int count) {
            return new LexemeInfo(relOffset, count);
        }

        public static /* synthetic */ LexemeInfo copy$default(LexemeInfo lexemeInfo, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = lexemeInfo.relOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = lexemeInfo.count;
            }
            return lexemeInfo.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "LexemeInfo(relOffset=" + this.relOffset + ", count=" + this.count + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.relOffset);
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LexemeInfo)) {
                return false;
            }
            LexemeInfo lexemeInfo = (LexemeInfo)other;
            if (this.relOffset != lexemeInfo.relOffset) {
                return false;
            }
            return this.count == lexemeInfo.count;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u00020\u00102\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0016J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0003\u00a8\u0006\""}, d2={"Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$MutableContextImpl;", "Lcom/intellij/platform/syntax/tree/ASTMarkers$MutableContext;", "<init>", "(Lcom/intellij/platform/syntax/tree/ASTMarkersImpl;)V", "astChanged", "", "getAstChanged", "()Z", "setAstChanged", "(Z)V", "ast", "Lcom/intellij/platform/syntax/tree/ASTMarkersImpl;", "getAst", "()Lcom/intellij/platform/syntax/tree/ASTMarkersImpl;", "setAst", "copyIfNeeded", "", "substitute", "i", "", "lexemeIndex", "astMarkers", "Lcom/intellij/platform/syntax/tree/ASTMarkers;", "changeChameleons", "pairs", "", "Lkotlin/Pair;", "Lcom/intellij/platform/syntax/tree/ChameleonRef;", "changeLexCount", "startMarker", "endMarker", "lexCount", "changeMarkerCount", "markerCount", "intellij.platform.syntax"})
    private final class MutableContextImpl
    implements ASTMarkers.MutableContext {
        private boolean astChanged;
        @NotNull
        private ASTMarkersImpl ast;

        public MutableContextImpl() {
            this.ast = ASTMarkersImpl.this;
        }

        public final boolean getAstChanged() {
            return this.astChanged;
        }

        public final void setAstChanged(boolean bl) {
            this.astChanged = bl;
        }

        @NotNull
        public final ASTMarkersImpl getAst() {
            return this.ast;
        }

        public final void setAst(@NotNull ASTMarkersImpl aSTMarkersImpl) {
            this.ast = aSTMarkersImpl;
        }

        public final void copyIfNeeded() {
            if (!this.astChanged) {
                this.ast = this.ast.copy();
                this.astChanged = true;
            }
        }

        @Override
        public void substitute(int i, int lexemeIndex, @NotNull ASTMarkers astMarkers) {
            this.copyIfNeeded();
            this.ast.substituteImpl(astMarkers, i, lexemeIndex);
        }

        @Override
        public void changeChameleons(@NotNull List<? extends Pair<Integer, ? extends ChameleonRef>> pairs) {
            this.ast = this.ast.withChameleons(pairs);
        }

        @Override
        public void changeLexCount(int startMarker, int endMarker, int lexCount) {
            this.copyIfNeeded();
            int relOffset = this.ast.lexemeRelOffset(startMarker);
            this.ast.setLexemeInfo(startMarker, lexCount, relOffset);
            this.ast.setLexemeInfo(endMarker, lexCount, relOffset);
        }

        @Override
        public void changeMarkerCount(int startMarker, int endMarker, int markerCount) {
            this.copyIfNeeded();
            this.ast.setMarkersCount(startMarker, markerCount);
            this.ast.setMarkersCount(endMarker, markerCount);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010J\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010J.\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J\u001e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u001eH\u0002J\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer;", "", "<init>", "()V", "origin", "(Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer;)V", "ints", "Lcom/intellij/util/fastutil/ints/IntArrayList;", "value", "", "longMode", "getLongMode", "()Z", "shortMode", "getShortMode", "index", "", "i", "kind", "Lcom/intellij/platform/syntax/tree/MarkerKind;", "lexemeInfo", "Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$LexemeInfo;", "collapsed", "hasErrors", "id", "markersCount", "size", "getSize", "()I", "setLexemeInfo", "", "count", "relOffset", "setMarkersCount", "setInitialInfo", "setId", "replace", "start", "end", "packer", "grow", "pushBack", "copy", "Companion", "intellij.platform.syntax"})
    @SourceDebugExtension(value={"SMAP\nASTMarkersImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASTMarkersImpl.kt\ncom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,456:1\n1#2:457\n1869#3,2:458\n*S KotlinDebug\n*F\n+ 1 ASTMarkersImpl.kt\ncom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer\n*L\n376#1:458,2\n*E\n"})
    private static final class Packer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IntArrayList ints;
        private boolean longMode;
        private static final int KIND_MASK = 3;
        private static final int MAX_SHORT_ID_VALUE = 65535;
        private static final int MAX_SHORT_LEXEME_VALUE = 65535;
        private static final int MAX_SHORT_MARKERS_COUNT = 4095;
        private static final int MAX_LONG_MARKERS_COUNT = 0xFFFFFFF;

        public Packer() {
            this.ints = new IntArrayList(256);
        }

        private Packer(Packer origin) {
            this.longMode = origin.longMode;
            this.ints = origin.ints.clone();
        }

        public final boolean getLongMode() {
            return this.longMode;
        }

        public final boolean getShortMode() {
            return !this.longMode;
        }

        private final int index(int i) {
            return this.longMode ? i * 4 : i * 2;
        }

        @NotNull
        public final MarkerKind kind(int i) {
            return (MarkerKind)((Object)MarkerKind.getEntries().get(this.ints.get(this.index(i)) & 3));
        }

        @NotNull
        public final LexemeInfo lexemeInfo(int i) {
            LexemeInfo lexemeInfo;
            int index = this.index(i);
            if (this.longMode) {
                lexemeInfo = new LexemeInfo(this.ints.get(index + 2), this.ints.get(index + 3));
            } else {
                int packed = this.ints.get(index + 1);
                lexemeInfo = new LexemeInfo(packed & 0xFFFF, packed >>> 16);
            }
            return lexemeInfo;
        }

        public final boolean collapsed(int i) {
            return (this.ints.get(this.index(i)) & 4) == 4;
        }

        public final boolean hasErrors(int i) {
            return (this.ints.get(this.index(i)) & 8) == 8;
        }

        public final int id(int i) {
            int index = this.index(i);
            return this.longMode ? this.ints.get(index + 1) : this.ints.get(index) >>> 16;
        }

        public final int markersCount(int i) {
            return this.ints.get(this.index(i)) >>> 4 & (this.longMode ? 0xFFFFFFF : 4095);
        }

        public final int getSize() {
            return this.ints.getSize() / (this.longMode ? 4 : 2);
        }

        public final void setLexemeInfo(int i, int count, int relOffset) {
            if (this.getShortMode() && (relOffset > 65535 || count > 65535)) {
                this.grow();
            }
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 2, relOffset);
                this.ints.set(index + 3, count);
            } else {
                this.ints.set(index + 1, relOffset | count << 16);
            }
        }

        public final void setMarkersCount(int i, int count) {
            if (this.getShortMode() && count > 4095) {
                this.grow();
            }
            if (!(count <= 0xFFFFFFF)) {
                boolean bl = false;
                String string = "markers count " + count + " is bigger than 268435455";
                throw new IllegalStateException(string.toString());
            }
            int index = this.index(i);
            this.ints.set(index, this.ints.get(index) & 0xFFFF000F | count << 4);
        }

        public final void setInitialInfo(int i, int id, @NotNull MarkerKind kind, boolean collapsed, boolean hasErrors) {
            int hasErrorInt;
            int collapsedInt = collapsed ? 4 : 0;
            int n = hasErrorInt = hasErrors ? 8 : 0;
            if (this.getShortMode() && id > 65535) {
                this.grow();
            }
            int index = this.index(i);
            this.ints.set(index, kind.ordinal() + collapsedInt + hasErrorInt);
            this.setId(i, id);
        }

        public final void setId(int i, int id) {
            int index = this.index(i);
            if (this.longMode) {
                this.ints.set(index + 1, id);
            } else {
                this.ints.set(index, this.ints.get(index) & 0xFFFF | id << 16);
            }
        }

        public final void replace(int start, int end, @NotNull Packer packer) {
            if (this.longMode && !packer.longMode) {
                packer.grow();
            }
            if (!this.longMode && packer.longMode) {
                this.grow();
            }
            this.ints.removeElements(this.index(start), this.index(end));
            this.ints.addElements(this.index(start), packer.ints.elements(), 0, packer.ints.getSize());
        }

        private final void grow() {
            if (!this.getShortMode()) {
                boolean $i$a$-check-ASTMarkersImpl$Packer$grow$22 = false;
                String $i$a$-check-ASTMarkersImpl$Packer$grow$22 = "Already in long mode";
                throw new IllegalStateException($i$a$-check-ASTMarkersImpl$Packer$grow$22.toString());
            }
            int end = this.getSize() - 1;
            int $i$a$-check-ASTMarkersImpl$Packer$grow$22 = this.ints.getSize();
            int n = 0;
            while (n < $i$a$-check-ASTMarkersImpl$Packer$grow$22) {
                int it = n++;
                boolean bl = false;
                this.ints.add(0);
            }
            this.longMode = true;
            Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)end, (int)0);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int firstInt = this.ints.get(i * 2);
                int secondInt = this.ints.get(i * 2 + 1);
                this.setInitialInfo(i, firstInt >>> 16, (MarkerKind)((Object)MarkerKind.getEntries().get(firstInt & 3)), (firstInt & 4) == 4, (firstInt & 8) == 8);
                this.setMarkersCount(i, firstInt >>> 4 & 0xFFF);
                this.setLexemeInfo(i, secondInt >>> 16, secondInt & 0xFFFF);
            }
        }

        public final void pushBack() {
            int n = this.longMode ? 4 : 2;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.ints.add(0);
            }
        }

        @NotNull
        public final Packer copy() {
            return new Packer(this);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/syntax/tree/ASTMarkersImpl$Packer$Companion;", "", "<init>", "()V", "KIND_MASK", "", "MAX_SHORT_ID_VALUE", "MAX_SHORT_LEXEME_VALUE", "MAX_SHORT_MARKERS_COUNT", "MAX_LONG_MARKERS_COUNT", "intellij.platform.syntax"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

