/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.common;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.prefs.Preferences;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.io.NettyUtil;

@TestOnly
@ApiStatus.Internal
public final class ThreadLeakTracker {
    private static final MethodHandle getThreads = ThreadLeakTracker.getThreadsMethodHandle();
    private static final Set<String> wellKnownOffenders;

    private ThreadLeakTracker() {
    }

    @NotNull
    public static Map<String, Thread> getThreads() {
        Thread[] threads;
        try {
            threads = getThreads.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (threads.length == 0) {
            Map<String, Thread> map = Collections.emptyMap();
            if (map == null) {
                ThreadLeakTracker.$$$reportNull$$$0(0);
            }
            return map;
        }
        HashMap<String, Thread> map = new HashMap<String, Thread>(threads.length);
        for (Thread thread : threads) {
            map.put(thread.getName(), thread);
        }
        HashMap<String, Thread> hashMap = map;
        if (hashMap == null) {
            ThreadLeakTracker.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    public static void longRunningThreadCreated(@NotNull Disposable parentDisposable, String ... threadNamePrefixes) {
        if (parentDisposable == null) {
            ThreadLeakTracker.$$$reportNull$$$0(2);
        }
        if (threadNamePrefixes == null) {
            ThreadLeakTracker.$$$reportNull$$$0(3);
        }
        ContainerUtil.addAll(wellKnownOffenders, (Object[])threadNamePrefixes);
        Disposer.register((Disposable)parentDisposable, () -> ContainerUtil.removeAll(wellKnownOffenders, (Object[])threadNamePrefixes));
    }

    public static void awaitQuiescence() {
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor((long)100L, (TimeUnit)TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
    }

    public static void checkLeak(@NotNull Map<String, Thread> threadsBefore) throws AssertionError {
        if (threadsBefore == null) {
            ThreadLeakTracker.$$$reportNull$$$0(4);
        }
        Map<String, Thread> all = ThreadLeakTracker.getThreads();
        HashMap<String, Thread> after = new HashMap<String, Thread>(all);
        after.keySet().removeAll(threadsBefore.keySet());
        Map stackTraces = ContainerUtil.map2Map(after.values(), thread -> new Pair(thread, (Object)thread.getStackTrace()));
        for (Thread thread2 : after.values()) {
            ThreadLeakTracker.waitForThread(thread2, stackTraces, all, after);
        }
    }

    private static void waitForThread(Thread thread, @Unmodifiable Map<Thread, StackTraceElement[]> stackTraces, Map<String, Thread> all, Map<String, Thread> after) {
        if (!ThreadLeakTracker.shouldWaitForThread(thread)) {
            return;
        }
        long start = System.currentTimeMillis();
        StackTraceElement[] traceBeforeWait = thread.getStackTrace();
        if (ThreadLeakTracker.shouldIgnore(thread, traceBeforeWait)) {
            return;
        }
        int WAIT_SEC = 10;
        long deadlineMs = start + TimeUnit.SECONDS.toMillis(WAIT_SEC);
        StackTraceElement[] stackTrace = traceBeforeWait;
        while (System.currentTimeMillis() < deadlineMs) {
            if (EDT.isCurrentThreadEdt()) {
                TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(() -> {
                    UIUtil.dispatchAllInvocationEvents();
                    return Unit.INSTANCE;
                });
            } else {
                UIUtil.pump();
            }
            stackTrace = thread.getStackTrace();
            if (ThreadLeakTracker.shouldIgnore(thread, stackTrace)) break;
            LockSupport.parkNanos(10000000L);
        }
        if (ThreadLeakTracker.shouldIgnore(thread, stackTrace)) {
            return;
        }
        all.keySet().removeAll(after.keySet());
        Map otherStackTraces = ContainerUtil.map2Map(all.values(), t -> Pair.create((Object)t, (Object)t.getStackTrace()));
        String trace = PerformanceWatcher.printStacktrace((String)"", (Thread)thread, (StackTraceElement[])stackTrace);
        String traceBefore = PerformanceWatcher.printStacktrace((String)"", (Thread)thread, (StackTraceElement[])traceBeforeWait);
        String internalDiagnostic = ThreadLeakTracker.internalDiagnostic(stackTrace);
        HashMap<Thread, StackTraceElement[]> newStackTraces = new HashMap<Thread, StackTraceElement[]>(stackTraces);
        newStackTraces.put(thread, stackTrace);
        throw new AssertionError((Object)("Thread leaked: " + traceBefore + (String)(trace.equals(traceBefore) ? "" : "(its trace after " + WAIT_SEC + " seconds wait:) " + trace) + internalDiagnostic + "\n\nLeaking threads dump:\n" + String.valueOf(ThreadLeakTracker.dumpThreadsToString(after, newStackTraces)) + "\n----\nAll other threads dump:\n" + String.valueOf(ThreadLeakTracker.dumpThreadsToString(all, otherStackTraces))));
    }

    private static boolean shouldWaitForThread(Thread thread) {
        if (thread == Thread.currentThread()) {
            return false;
        }
        ThreadGroup group = thread.getThreadGroup();
        return (group == null || !"system".equals(group.getName())) && thread.isAlive();
    }

    private static boolean shouldIgnore(Thread thread, StackTraceElement[] stackTrace) {
        if (!thread.isAlive()) {
            return true;
        }
        if (stackTrace.length == 0) {
            return true;
        }
        if (ThreadLeakTracker.isWellKnownOffender(thread.getName())) {
            return true;
        }
        return ThreadLeakTracker.isIdleApplicationPoolThread(stackTrace) || ThreadLeakTracker.isIdleCommonPoolThread(thread, stackTrace) || ThreadLeakTracker.isIdleDelaySchedulerThread(thread, stackTrace) || ThreadLeakTracker.isFutureTaskAboutToFinish(stackTrace) || ThreadLeakTracker.isIdleDefaultCoroutineExecutorThread(thread, stackTrace) || ThreadLeakTracker.isCoroutineSchedulerPoolThread(thread, stackTrace) || ThreadLeakTracker.isKotlinCIOSelector(stackTrace) || ThreadLeakTracker.isStarterTestFramework(stackTrace) || ThreadLeakTracker.isJMXRemoteCall(stackTrace) || ThreadLeakTracker.isBuildLogCall(stackTrace) || ThreadLeakTracker.isIjentMediatorThread(stackTrace) || ThreadLeakTracker.windowsCompletionPortLeakForDocker(stackTrace) || ThreadLeakTracker.isSwingAccessibilityThread(stackTrace);
    }

    private static boolean windowsCompletionPortLeakForDocker(StackTraceElement[] trace) {
        return trace[0].getClassName().equals("sun.nio.ch.Iocp");
    }

    private static boolean isSwingAccessibilityThread(StackTraceElement[] trace) {
        return trace.length > 0 && trace[0].getClassName().equals("com.sun.java.accessibility.internal.AccessBridge") && trace[0].getMethodName().equals("runDLL");
    }

    private static boolean isWellKnownOffender(String threadName) {
        for (String t : wellKnownOffenders) {
            if (!threadName.contains(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIdleApplicationPoolThread(StackTraceElement[] stackTrace) {
        return ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("getTask") && element.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
    }

    private static boolean isKotlinCIOSelector(StackTraceElement[] stackTrace) {
        return ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("select") && element.getClassName().equals("io.ktor.network.selector.ActorSelectorManager"));
    }

    private static boolean isIdleCommonPoolThread(Thread thread, StackTraceElement[] stackTrace) {
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean insideAwaitWork = ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("awaitWork") && element.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        if (insideAwaitWork) {
            return true;
        }
        return stackTrace.length > 2 && stackTrace[0].getClassName().endsWith(".Unsafe") && stackTrace[0].getMethodName().equals("park") && stackTrace[1].getClassName().equals("java.util.concurrent.locks.LockSupport") && stackTrace[1].getMethodName().equals("park") && stackTrace[2].getClassName().equals("java.util.concurrent.ForkJoinPool") && stackTrace[2].getMethodName().equals("runWorker");
    }

    private static boolean isIdleDelaySchedulerThread(Thread thread, StackTraceElement[] stackTrace) {
        return thread.getClass().getName().equals("java.util.concurrent.DelayScheduler") && stackTrace.length > 1 && stackTrace[0].getClassName().endsWith(".Unsafe") && stackTrace[0].getMethodName().equals("park") && stackTrace[1].getClassName().equals("java.util.concurrent.DelayScheduler") && stackTrace[1].getMethodName().equals("loop");
    }

    private static boolean isFutureTaskAboutToFinish(StackTraceElement[] stackTrace) {
        if (stackTrace.length < 5) {
            return false;
        }
        return stackTrace[0].getClassName().equals("sun.misc.Unsafe") && stackTrace[0].getMethodName().equals("unpark") && stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") && stackTrace[2].getMethodName().equals("finishCompletion");
    }

    private static boolean isIdleDefaultCoroutineExecutorThread(Thread thread, StackTraceElement[] stackTrace) {
        if (stackTrace.length != 4) {
            return false;
        }
        return "kotlinx.coroutines.DefaultExecutor".equals(thread.getName()) && (stackTrace[0].getClassName().equals("sun.misc.Unsafe") || stackTrace[0].getClassName().equals("jdk.internal.misc.Unsafe")) && stackTrace[0].getMethodName().equals("park") && stackTrace[2].getClassName().equals("kotlinx.coroutines.DefaultExecutor") && stackTrace[2].getMethodName().equals("run");
    }

    private static boolean isCoroutineSchedulerPoolThread(Thread thread, StackTraceElement[] stackTrace) {
        if (!"kotlinx.coroutines.scheduling.CoroutineScheduler$Worker".equals(thread.getClass().getName())) {
            return false;
        }
        boolean insideCpuWorkerIdle = ContainerUtil.exists((Object[])stackTrace, element -> element.getMethodName().equals("park") && element.getClassName().equals("kotlinx.coroutines.scheduling.CoroutineScheduler$Worker"));
        return insideCpuWorkerIdle;
    }

    private static boolean isStarterTestFramework(StackTraceElement[] stackTrace) {
        return ContainerUtil.exists((Object[])stackTrace, element -> element.getClassName().contains("com.intellij.ide.starter"));
    }

    private static boolean isJMXRemoteCall(StackTraceElement[] stackTrace) {
        return ContainerUtil.exists((Object[])stackTrace, element -> element.getClassName().contains("com.sun.jmx.remote"));
    }

    private static boolean isBuildLogCall(StackTraceElement[] stackTrace) {
        return ContainerUtil.exists((Object[])stackTrace, element -> element.getClassName().contains("org.jetbrains.intellij.build.ConsoleSpanExporter"));
    }

    private static boolean isIjentMediatorThread(StackTraceElement[] stackTrace) {
        if (System.getProperty("ide.testFramework.share.ijent.application.wide", "false").equals("true")) {
            return ContainerUtil.exists((Object[])stackTrace, element -> element.getClassName().contains("com.intellij.platform.ijent.spi.IjentSessionMediatorKt") || element.getClassName().contains("com.intellij.platform.ijent.spi.IjentThreadPool$IjentThreadFactory") || element.getClassName().contains("com.intellij.platform.ijent.impl.hyperv.HyperV"));
        }
        return false;
    }

    private static CharSequence dumpThreadsToString(Map<String, Thread> after, Map<Thread, StackTraceElement[]> stackTraces) {
        StringBuilder f = new StringBuilder();
        for (Map.Entry<String, Thread> entry : after.entrySet()) {
            Thread t = entry.getValue();
            f.append('\"').append(entry.getKey()).append("\" (").append(t.isAlive() ? "alive" : "dead").append(") ").append((Object)t.getState()).append('\n');
            for (StackTraceElement element : stackTraces.get(t)) {
                f.append("\tat ").append(element).append('\n');
            }
            f.append('\n');
        }
        return f;
    }

    private static String internalDiagnostic(StackTraceElement[] stackTrace) {
        return stackTrace.length < 5 ? "stackTrace.length: " + stackTrace.length : "(diagnostic: 0: " + stackTrace[0].getClassName() + " : " + stackTrace[0].getClassName().equals("sun.misc.Unsafe") + " . " + stackTrace[0].getMethodName() + " : " + stackTrace[0].getMethodName().equals("unpark") + " 2: " + stackTrace[2].getClassName() + " : " + stackTrace[2].getClassName().equals("java.util.concurrent.FutureTask") + " . " + stackTrace[2].getMethodName() + " : " + stackTrace[2].getMethodName().equals("finishCompletion") + ")";
    }

    private static MethodHandle getThreadsMethodHandle() {
        try {
            return MethodHandles.privateLookupIn(Thread.class, MethodHandles.lookup()).findStatic(Thread.class, "getThreads", MethodType.methodType(Thread[].class));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to access the Thread#getThreads method", e);
        }
    }

    private static void validateWhitelistedThreads(List<String> offenders) {
        ArrayList<String> sorted = new ArrayList<String>(offenders);
        sorted.sort(String::compareToIgnoreCase);
        if (offenders.equals(sorted)) {
            return;
        }
        String proper = String.join((CharSequence)",\n", ContainerUtil.map(sorted, s -> "\"" + s + "\"")).replaceAll("\"Flushing Daemon\"", "FlushingDaemon.NAME").replaceAll("\"I/O pool \"", "ProcessIOExecutorService.POOLED_THREAD_PREFIX");
        throw new AssertionError((Object)("Thread names must be sorted (for ease of maintenance). Something like this will do:\n" + proper));
    }

    static {
        List<String> offenders = List.of("ApplicationImpl pooled thread ", "AWT-EventQueue-", "AWT-Shutdown", "AWT-Windows", "BaseDataReader: error stream of embeddings-server", "BaseDataReader: output stream of embeddings-server", "BatchSpanProcessor_WorkerThread", "Batik CleanerThread", "BC Entropy Daemon", "CefBgThread", "CefHandlers-", "Cidr Symbol Building Thread", "Cleaner-0", "CompilerThread0", "Coroutines Debugger Cleaner", "dockerjava-netty", "embeddings-server", "EventQueueMonitor-ComponentEvtDispatch", "External compiler", "FilePageCache housekeeper", "Finalizer", "Flushing Daemon", "grpc-default-worker-", "grpc-nio-worker-", "HttpClient-", "I/O pool ", "IDEA Test Case Thread", "IjentThreadPool-", "Image Fetcher ", "InnocuousThreadGroup", "Java2D Disposer", "JNA Cleaner", "JobScheduler FJ pool ", "JPS thread pool", "JVMResponsivenessMonitor", "Keep-Alive-SocketCleaner", "Keep-Alive-Timer", "main", "Monitor Ctrl-Break", "Netty ", "ObjectCleanerThread", "OkHttp ", "Okio Watchdog", "org.apache.commons.vfs2.cache.SoftRefFilesCache$ReleaseThread", "Periodic tasks thread", "process reaper", "qtp", "rd throttler", "Reference Handler", "RMI GC Daemon", "RMI TCP ", "Save classpath indexes for file loader", "Shared Index Hash Index Flushing Queue", "Signal Dispatcher", "SystemPropertyWatcher", "tc-okhttp-stream", "testcontainers", "timer-int", "timer-sys", "TimerQueue", "UserActivityMonitor thread", "VM Periodic Task Thread", "VM Thread", "YJPAgent-Telemetry");
        ThreadLeakTracker.validateWhitelistedThreads(offenders);
        wellKnownOffenders = new HashSet<String>(offenders);
        try {
            Preferences.userRoot().flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/common/ThreadLeakTracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefixes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadsBefore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/common/ThreadLeakTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "longRunningThreadCreated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

