/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.InlayDumpUtil;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsSinkImpl;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.util.containers.UtilKt;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\b\b\u0002\u0010\r\u001a\u0002H\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010JA\u0010\u0011\u001a\u00020\t\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f2\b\b\u0002\u0010\r\u001a\u0002H\u00062\b\b\u0002\u0010\u0013\u001a\u00020\u000fH\u0005\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "<init>", "()V", "doTestProvider", "", "T", "", "fileName", "", "expectedText", "provider", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "settings", "verifyHintPresence", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;Z)V", "dumpInlayHints", "sourceText", "renderBelowLineBlockInlaysBelowTheLine", "(Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;Z)Ljava/lang/String;", "Companion", "intellij.platform.testFramework"})
public abstract class InlayHintsProviderTestCase
extends BasePlatformTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String NO_HINTS_PREFIX = "// NO_HINTS";

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings, boolean verifyHintPresence) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        String sourceText = InlayDumpUtil.INSTANCE.removeInlays(expectedText);
        this.myFixture.configureByText(fileName, sourceText);
        String actualText = InlayHintsProviderTestCase.dumpInlayHints$default(this, sourceText, provider, settings, false, 8, null);
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
        if (verifyHintPresence) {
            Companion.verifyHintsPresence(expectedText);
        }
    }

    public static /* synthetic */ void doTestProvider$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTestProvider");
        }
        if ((n & 8) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        inlayHintsProviderTestCase.doTestProvider(string, string2, inlayHintsProvider, object, bl);
    }

    @JvmOverloads
    @NotNull
    protected final <T> String dumpInlayHints(@NotNull String sourceText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings, boolean renderBelowLineBlockInlaysBelowTheLine) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        PsiFile psiFile = this.myFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file = psiFile;
        Editor editor = this.myFixture.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        InlayHintsSinkImpl sink = new InlayHintsSinkImpl(editor);
        InlayHintsCollector inlayHintsCollector = provider.getCollectorFor(file, editor, settings, (InlayHintsSink)sink);
        if (inlayHintsCollector == null) {
            throw new IllegalStateException("Collector is expected".toString());
        }
        InlayHintsCollector collector = inlayHintsCollector;
        SettingsKey settingsKey = provider.getKey();
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        CollectorWithSettings collectorWithSettings = new CollectorWithSettings(collector, settingsKey, language, sink);
        collectorWithSettings.collectTraversingAndApply(editor, file, true);
        InlayDumpUtil inlayDumpUtil = InlayDumpUtil.INSTANCE;
        Editor editor2 = this.myFixture.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        return InlayDumpUtil.dumpInlays$default((InlayDumpUtil)inlayDumpUtil, (String)sourceText, (Editor)editor3, null, InlayHintsProviderTestCase::dumpInlayHints$lambda$0, (int)0, (boolean)renderBelowLineBlockInlaysBelowTheLine, (boolean)false, (int)84, null);
    }

    public static /* synthetic */ String dumpInlayHints$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, InlayHintsProvider inlayHintsProvider, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dumpInlayHints");
        }
        if ((n & 4) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return inlayHintsProviderTestCase.dumpInlayHints(string, inlayHintsProvider, object, bl);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, settings, false, 16, null);
    }

    @JvmOverloads
    public final <T> void doTestProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        InlayHintsProviderTestCase.doTestProvider$default(this, fileName, expectedText, provider, null, false, 24, null);
    }

    @JvmOverloads
    @NotNull
    protected final <T> String dumpInlayHints(@NotNull String sourceText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        return InlayHintsProviderTestCase.dumpInlayHints$default(this, sourceText, provider, settings, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    protected final <T> String dumpInlayHints(@NotNull String sourceText, @NotNull InlayHintsProvider<T> provider) {
        Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        return InlayHintsProviderTestCase.dumpInlayHints$default(this, sourceText, provider, null, false, 12, null);
    }

    private static final String dumpInlayHints$lambda$0(EditorCustomElementRenderer renderer, Inlay inlay) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)inlay, (String)"<unused var>");
        if (!(renderer instanceof PresentationRenderer) && !(renderer instanceof LinearOrderInlayRenderer)) {
            throw new IllegalStateException("renderer not supported".toString());
        }
        return renderer.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion;", "", "<init>", "()V", "NO_HINTS_PREFIX", "", "verifyHintsPresence", "", "expectedText", "HintPresence", "intellij.platform.testFramework"})
    @SourceDebugExtension(value={"SMAP\nInlayHintsProviderTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlayHintsProviderTestCase.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,60:1\n1255#2,2:61\n*S KotlinDebug\n*F\n+ 1 InlayHintsProviderTestCase.kt\ncom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion\n*L\n16#1:61,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void verifyHintsPresence(@NotNull String expectedText) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
                Sequence $this$any$iv = StringsKt.lineSequence((CharSequence)expectedText);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)InlayHintsProviderTestCase.NO_HINTS_PREFIX, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            HintPresence expectedHintPresence = bl ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            HintPresence actualHintPresence = UtilKt.isEmpty(InlayDumpUtil.INSTANCE.getInlayPattern().matcher(expectedText).results()) ? HintPresence.NO_HINTS : HintPresence.SOME_HINTS;
            BasePlatformTestCase.assertEquals((String)"Hint presence should match the use of the // NO_HINTS directive.", (Object)((Object)expectedHintPresence), (Object)((Object)actualHintPresence));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$Companion$HintPresence;", "", "<init>", "(Ljava/lang/String;I)V", "NO_HINTS", "SOME_HINTS", "intellij.platform.testFramework"})
        private static final class HintPresence
        extends Enum<HintPresence> {
            public static final /* enum */ HintPresence NO_HINTS = new HintPresence();
            public static final /* enum */ HintPresence SOME_HINTS = new HintPresence();
            private static final /* synthetic */ HintPresence[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static HintPresence[] values() {
                return (HintPresence[])$VALUES.clone();
            }

            public static HintPresence valueOf(String value) {
                return Enum.valueOf(HintPresence.class, value);
            }

            @NotNull
            public static EnumEntries<HintPresence> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = hintPresenceArray = new HintPresence[]{HintPresence.NO_HINTS, HintPresence.SOME_HINTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

