/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public final class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final Lazy<VirtualFile> mySourceRoot;

    public LightTempDirTestFixtureImpl() {
        this(false);
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.mySourceRoot = usePlatformSourceRoot ? LazyKt.lazyOf(null) : LazyKt.lazy(() -> {
            VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
            Assert.assertNotNull((Object)fsRoot);
            try {
                return (VirtualFile)WriteAction.computeAndWait(() -> fsRoot.createChildDirectory((Object)this, "root"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String path) {
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                VirtualFile childDir = this.findOrCreateChildDir(this.getSourceRoot(), path);
                IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
                return childDir;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        if (targetDir == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)("Cannot find testdata directory " + dataDir), (Object)from);
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (!targetDir.isEmpty()) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        return virtualFile;
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.isEmpty()) {
            return root;
        }
        List dirs = StringUtil.split((String)StringUtil.trimStart((String)relativePath, (String)"/"), (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            root = root.createChildDirectory((Object)this, dirName);
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        VirtualFile sourceRoot;
        VirtualFile result;
        if (path == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        if ((result = (sourceRoot = this.getSourceRoot()).findFileByRelativePath(path)) == null) {
            sourceRoot.refresh(false, true);
            result = sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        VirtualFile virtualFile;
        if (targetPath == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> this.doCreateFile(targetPath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    private VirtualFile doCreateFile(@NotNull String targetPath) throws IOException {
        if (targetPath == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        String path = PathUtil.getParentPath((String)targetPath);
        String name = PathUtil.getFileName((String)targetPath);
        VirtualFile targetDir = this.findOrCreateDir(path);
        VirtualFile virtualFile = targetDir.createChildData((Object)this, name);
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text) throws IOException {
        if (name == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        if (text == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            VirtualFile file = this.doCreateFile(name);
            VfsUtil.saveText((VirtualFile)file, (String)text);
            return file;
        });
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    public void deleteAll() {
        if (!this.mySourceRoot.isInitialized()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile[] toDelete;
            VirtualFile[] virtualFileArray;
            VirtualFile sourceRoot = (VirtualFile)this.mySourceRoot.getValue();
            if (sourceRoot == null) {
                virtualFileArray = this.getSourceRoot().getChildren();
            } else {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = sourceRoot;
            }
            for (VirtualFile file : toDelete = virtualFileArray) {
                try {
                    file.delete((Object)this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        VirtualFile sourceRoot = (VirtualFile)this.mySourceRoot.getValue();
        VirtualFile virtualFile = sourceRoot == null ? LightPlatformTestCase.getSourceRoot() : sourceRoot;
        if (virtualFile == null) {
            LightTempDirTestFixtureImpl.$$$reportNull$$$0(17);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8, 11, 13, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8, 11, 13, 16, 17 -> new IllegalStateException(string);
        };
    }
}

