/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public final class ParsingTestUtil {
    private static final String SEPARATOR = "---------------";
    private static final String NL_SEPARATOR_NL = "\n---------------\n";

    private ParsingTestUtil() {
    }

    public static void assertNoPsiErrorElementsInAllSubTrees(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestUtil.$$$reportNull$$$0(0);
        }
        for (PsiFile subTree : file.getViewProvider().getAllFiles()) {
            ParsingTestUtil.assertNoPsiErrorElements(subTree);
        }
    }

    public static void assertNoPsiErrorElements(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestUtil.$$$reportNull$$$0(1);
        }
        final ArrayList errors = new ArrayList();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitErrorElement(@NotNull PsiErrorElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                errors.add(element.getTextOffset() + ": " + element.getErrorDescription());
                super.visitErrorElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestUtil$1", "visitErrorElement"));
            }
        });
        if (!errors.isEmpty()) {
            Assert.fail((String)("Found PsiElement errors at offsets:\n" + String.join((CharSequence)"\n", errors)));
        }
    }

    @NotNull
    public static String psiFileToString(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(2);
        }
        StringBuilder result = new StringBuilder();
        for (PsiFile subTree : psiFile.getViewProvider().getAllFiles()) {
            result.append("Language: ").append(subTree.getLanguage()).append("\n").append(DebugUtil.psiToString((PsiElement)subTree, (boolean)true, (boolean)false));
        }
        String string = result.toString();
        if (string == null) {
            ParsingTestUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void testIncrementalParsing(@NotNull PsiFile psiFile, @NotNull CharSequence newFileText, @NotNull String answersFilePath, boolean checkInitialTreeForErrors, boolean checkFinalTreeForErrors) {
        if (psiFile == null) {
            ParsingTestUtil.$$$reportNull$$$0(4);
        }
        if (newFileText == null) {
            ParsingTestUtil.$$$reportNull$$$0(5);
        }
        if (answersFilePath == null) {
            ParsingTestUtil.$$$reportNull$$$0(6);
        }
        if (checkInitialTreeForErrors) {
            ParsingTestUtil.assertNoPsiErrorElements(psiFile);
        }
        Project project = psiFile.getProject();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document fileDocument = psiDocumentManager.getDocument(psiFile);
        TestCase.assertNotNull((Object)fileDocument);
        psiDocumentManager.commitDocument(fileDocument);
        CharSequence originalText = fileDocument.getCharsSequence();
        StringBuilder result = new StringBuilder("Original text:").append(NL_SEPARATOR_NL).append(originalText).append(NL_SEPARATOR_NL);
        List allFiles = psiFile.getViewProvider().getAllFiles();
        for (PsiFile subTree : ContainerUtil.sorted((Collection)allFiles, Comparator.comparing(it -> it.getLanguage().getID()))) {
            UsefulTestCase.assertInstanceOf(subTree, PsiFileImpl.class);
            PsiFileImpl subTreeFile = (PsiFileImpl)subTree;
            TextRange changedRange = ChangedPsiRangeUtil.getChangedPsiRange((PsiFile)subTreeFile, (FileElement)Objects.requireNonNull(subTreeFile.getTreeElement()), (CharSequence)newFileText);
            TestCase.assertNotNull((String)"No changes found", (Object)changedRange);
            Couple reparseableRoots = BlockSupportImpl.findReparseableNodeAndReparseIt((PsiFileImpl)subTreeFile, (FileASTNode)subTree.getNode(), (TextRange)changedRange, (CharSequence)newFileText);
            result.append("Subtree: ").append(subTree.getLanguage()).append(NL_SEPARATOR_NL);
            ParsingTestUtil.serializeReparseableRoots((Couple<ASTNode>)reparseableRoots, result, newFileText);
            result.append(NL_SEPARATOR_NL);
        }
        WriteAction.run(() -> fileDocument.setText(newFileText));
        psiDocumentManager.commitDocument(fileDocument);
        String psiBeforeCommit = ParsingTestUtil.psiFileToString(psiFile);
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            fileDocument.setText((CharSequence)"");
            psiDocumentManager.commitDocument(fileDocument);
            fileDocument.setText(newFileText);
            psiDocumentManager.commitDocument(fileDocument);
        });
        TestCase.assertEquals((String)"Reparsing error", (String)ParsingTestUtil.psiFileToString(psiFile), (String)psiBeforeCommit);
        if (checkFinalTreeForErrors) {
            ParsingTestUtil.assertNoPsiErrorElementsInAllSubTrees(psiFile);
        }
        UsefulTestCase.assertSameLinesWithFile(answersFilePath, result.toString(), false);
    }

    private static void serializeReparseableRoots(@Nullable Couple<ASTNode> reparseableRoots, @NotNull StringBuilder result, @NotNull CharSequence newText) {
        if (result == null) {
            ParsingTestUtil.$$$reportNull$$$0(7);
        }
        if (newText == null) {
            ParsingTestUtil.$$$reportNull$$$0(8);
        }
        TextRange reparsedRange = reparseableRoots == null ? TextRange.create((int)0, (int)newText.length()) : TextRange.from((int)((ASTNode)reparseableRoots.first).getStartOffset(), (int)((ASTNode)reparseableRoots.second).getTextLength());
        result.append(newText, 0, reparsedRange.getStartOffset());
        result.append("<reparse>");
        result.append(newText, reparsedRange.getStartOffset(), reparsedRange.getEndOffset());
        result.append("</reparse>");
        result.append(newText, reparsedRange.getEndOffset(), newText.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answersFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "psiFileToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertNoPsiErrorElementsInAllSubTrees";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertNoPsiErrorElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "psiFileToString";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "testIncrementalParsing";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "serializeReparseableRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

