/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private Path myTempDir;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(0);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(1);
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir, @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(3);
        }
        if (targetDir == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(5);
        }
        this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            try {
                VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTempDir.toString());
                Assert.assertNotNull((Object)tempDir);
                if (!targetDir.isEmpty()) {
                    tempDir = VfsUtil.createDirectoryIfMissing((VirtualFile)tempDir, (String)targetDir.replace('\\', '/'));
                }
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                Assert.assertNotNull((String)(dataDir + " not found"), (Object)from);
                VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                return tempDir;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.createTempDirectory().toString();
        if (string == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public Path createTempFile(@NotNull String path) throws IOException {
        Object prefix;
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(8);
        }
        if (((String)(prefix = StringUtil.getPackageName((String)path))).length() < 3) {
            prefix = (String)prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)path);
        Path file = FileUtil.createTempFile((File)this.createTempDirectory().toFile(), (String)prefix, (String)suffix, (boolean)true).toPath();
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file.toString()});
        return file;
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(9);
        }
        String fullPath = this.myTempDir.toString() + "/" + path;
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{fullPath});
        VirtualFile vFile = (VirtualFile)WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath));
        IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
        return vFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name) {
        Path file;
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(10);
        }
        try {
            file = TempDirTestFixtureImpl.createEmptyTempFile(this.createTempDirectory(), name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{file.toString()});
        VirtualFile createdVFile = (VirtualFile)WriteAction.computeAndWait(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString())));
        IndexingTestUtil.waitUntilIndexesAreReadyInAllOpenedProjects();
        VirtualFile virtualFile = createdVFile;
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public static Path createEmptyTempFile(@NotNull Path parent, @NotNull String name) throws IOException {
        if (parent == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(12);
        }
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(13);
        }
        Path file = TempDirTestFixtureImpl.resolvePath(parent, name);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Files.newByteChannel(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE).close();
        Path path = file;
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(14);
        }
        return path;
    }

    @NotNull
    private static Path resolvePath(@NotNull Path parent, @NotNull String name) {
        if (parent == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(15);
        }
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(16);
        }
        Path path = parent.resolve(name.startsWith("/") ? name.substring(1) : name).normalize();
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(17);
        }
        return path;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(18);
        }
        String path = TempDirTestFixtureImpl.resolvePath(this.createTempDirectory(), name).toString();
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{path});
        VirtualFile virtualFile = VfsUtil.createDirectories((String)path);
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(19);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, @NotNull String text) throws IOException {
        if (name == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(20);
        }
        if (text == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(21);
        }
        VirtualFile file = this.createFile(name);
        WriteAction.runAndWait(() -> VfsUtil.saveText((VirtualFile)file, (String)text));
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(22);
        }
        return virtualFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myTempDir == null) {
            return;
        }
        try {
            VirtualFile virtualFile;
            if (this.deleteOnTearDown() && (virtualFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)this.myTempDir.toString()))) != null) {
                WriteAction.runAndWait(() -> virtualFile.delete((Object)this));
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean deleteOnTearDown() {
        return true;
    }

    @Nullable
    protected Path getTempHome() {
        return null;
    }

    @NotNull
    private Path createTempDirectory() {
        if (this.myTempDir == null) {
            this.myTempDir = this.doCreateTempDirectory();
        }
        Path path = this.myTempDir;
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(23);
        }
        return path;
    }

    @NotNull
    protected Path doCreateTempDirectory() {
        Path path = HeavyTestHelper.createTempDirectoryForTempDirTestFixture(this.getTempHome(), "unitTest");
        if (path == null) {
            TempDirTestFixtureImpl.$$$reportNull$$$0(24);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 11, 14, 17, 19, 22, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 11: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTempFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateTempDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 10: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTempFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 11, 14, 17, 19, 22, 23, 24 -> new IllegalStateException(string);
        };
    }
}

