// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.testFramework;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies the path to testdata for the current test case class.
 * May use the variable $CONTENT_ROOT to specify the module content root or
 * $PROJECT_ROOT to use the project base directory.
 * Affects only navigation to testdata inside the IDE, not actual test execution.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface TestDataPath {
  String value();
}
