/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestDataProvider
implements DataProvider {
    private final Project myProject;
    private final boolean myWithRules;
    private final TestDataProvider myDelegateWithoutRules;

    public TestDataProvider(@NotNull Project project) {
        if (project == null) {
            TestDataProvider.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    private TestDataProvider(@NotNull Project project, boolean withRules) {
        if (project == null) {
            TestDataProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myWithRules = withRules;
        this.myDelegateWithoutRules = this.myWithRules ? new TestDataProvider(project, false) : this;
    }

    public static TestDataProvider withRules(Project project) {
        return new TestDataProvider(project, true);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            TestDataProvider.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            throw new RuntimeException("TestDataProvider is already disposed for " + String.valueOf(this.myProject) + "\nIf you closed a project in test, please reset TestApplicationManager.setDataProvider.");
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)this.myProject);
        if (CommonDataKeys.EDITOR.is(dataId) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
            return manager.getSelectedTextEditor(true);
        }
        if (PlatformCoreDataKeys.FILE_EDITOR.is(dataId)) {
            Editor editor = manager.getSelectedTextEditor();
            return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
        }
        if (this.myWithRules) {
            return DataManager.getInstance().getCustomizedData(dataId, DataContext.EMPTY_CONTEXT, (DataProvider)this.myDelegateWithoutRules);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/TestDataProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

