/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0003\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\bH\u0003\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\bH\u0003\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000b"}, d2={"ASYNC_BATCH_SIZE", "Lcom/intellij/openapi/util/registry/RegistryValue;", "getASYNC_BATCH_SIZE", "()Lcom/intellij/openapi/util/registry/RegistryValue;", "ASYNC_BATCH_SIZE$delegate", "Lkotlin/Lazy;", "collectFiles", "", "Lcom/intellij/ide/todo/TodoTreeBuilder;", "validateCacheAndUpdateTree", "updateVisibleTree", "intellij.platform.todo"})
public final class TodoTreeBuilderCoroutineHelperKt {
    @NotNull
    private static final Lazy ASYNC_BATCH_SIZE$delegate = LazyKt.lazy(TodoTreeBuilderCoroutineHelperKt::ASYNC_BATCH_SIZE_delegate$lambda$0);

    private static final RegistryValue getASYNC_BATCH_SIZE() {
        Lazy lazy = ASYNC_BATCH_SIZE$delegate;
        return (RegistryValue)lazy.getValue();
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void collectFiles(TodoTreeBuilder $this$collectFiles) {
        ProgressManager.checkCanceled();
        $this$collectFiles.clearCache();
        $this$collectFiles.collectFiles(arg_0 -> TodoTreeBuilderCoroutineHelperKt.collectFiles$lambda$1(arg_0 -> TodoTreeBuilderCoroutineHelperKt.collectFiles$lambda$0($this$collectFiles, arg_0), arg_0));
        TodoTreeBuilderCoroutineHelperKt.validateCacheAndUpdateTree($this$collectFiles);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void validateCacheAndUpdateTree(TodoTreeBuilder $this$validateCacheAndUpdateTree) {
        ProgressManager.checkCanceled();
        $this$validateCacheAndUpdateTree.getTodoTreeStructure().validateCache();
        TodoTreeBuilderCoroutineHelperKt.updateVisibleTree($this$validateCacheAndUpdateTree);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    private static final void updateVisibleTree(TodoTreeBuilder $this$updateVisibleTree) {
        if ($this$updateVisibleTree.isUpdatable()) {
            if ($this$updateVisibleTree.hasDirtyFiles()) {
                $this$updateVisibleTree.getTodoTreeStructure().validateCache();
            }
            $this$updateVisibleTree.getModel().invalidateAsync();
        }
    }

    private static final RegistryValue ASYNC_BATCH_SIZE_delegate$lambda$0() {
        return RegistryManager.Companion.getInstance().get("ide.tree.ui.async.batch.size");
    }

    private static final Unit collectFiles$lambda$0(TodoTreeBuilder $this_collectFiles, PsiFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_collectFiles.myFileTree.add(it.getVirtualFile());
        if ($this_collectFiles.myFileTree.size() % TodoTreeBuilderCoroutineHelperKt.getASYNC_BATCH_SIZE().asInteger() == 0) {
            TodoTreeBuilderCoroutineHelperKt.validateCacheAndUpdateTree($this_collectFiles);
        }
        return Unit.INSTANCE;
    }

    private static final void collectFiles$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$collectFiles(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.collectFiles($receiver);
    }

    public static final /* synthetic */ void access$validateCacheAndUpdateTree(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.validateCacheAndUpdateTree($receiver);
    }

    public static final /* synthetic */ void access$updateVisibleTree(TodoTreeBuilder $receiver) {
        TodoTreeBuilderCoroutineHelperKt.updateVisibleTree($receiver);
    }
}

