/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import one.util.streamex.StreamEx;

final class FiltersTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] myColumnNames = new String[]{IdeBundle.message((String)"column.todo.filters.name", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.filter.patterns", (Object[])new Object[0])};
    private final List<TodoFilter> myFilters;

    FiltersTableModel(List<TodoFilter> filters) {
        this.myFilters = filters;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.myFilters.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoFilter filter = this.myFilters.get(row);
        return switch (column) {
            case 0 -> filter.getName();
            case 1 -> StreamEx.of((Iterator)filter.iterator()).map(TodoPattern::getPatternString).joining((CharSequence)" | ");
            default -> throw new IllegalArgumentException();
        };
    }

    public void removeRow(int index) {
        this.myFilters.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

