/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.cef.handler.CefKeyboardHandler;

final class JBCefEventUtils {
    private static final Map<Integer, Integer> CEF_2_JAVA_KEYCODES = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> CEF_2_JAVA_MODIFIERS = new HashMap<Integer, Integer>();

    JBCefEventUtils() {
    }

    public static KeyEvent convertCefKeyEvent(CefKeyboardHandler.CefKeyEvent cefKeyEvent, Component source) {
        return new KeyEvent(source, JBCefEventUtils.convertCefKeyEventType(cefKeyEvent), System.currentTimeMillis(), JBCefEventUtils.convertCefKeyEventModifiers(cefKeyEvent), JBCefEventUtils.convertCefKeyEventKeyCode(cefKeyEvent), cefKeyEvent.character, 0);
    }

    public static KeyEvent javaKeyEventWithID(KeyEvent javaKeyEvent, int id) {
        return new KeyEvent(javaKeyEvent.getComponent(), id, javaKeyEvent.getWhen(), javaKeyEvent.getModifiers(), javaKeyEvent.getKeyCode(), javaKeyEvent.getKeyChar(), javaKeyEvent.getKeyLocation());
    }

    public static int convertCefKeyEventType(CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        return switch (cefKeyEvent.type) {
            default -> throw new MatchException(null, null);
            case CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_RAWKEYDOWN, CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYDOWN -> 401;
            case CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_KEYUP -> 402;
            case CefKeyboardHandler.CefKeyEvent.EventType.KEYEVENT_CHAR -> 400;
        };
    }

    public static int convertCefKeyEventKeyCode(CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        Integer value = CEF_2_JAVA_KEYCODES.get(cefKeyEvent.windows_key_code);
        if (value != null) {
            return value;
        }
        return cefKeyEvent.windows_key_code;
    }

    public static int convertCefKeyEventModifiers(CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        int javaModifiers = 0;
        for (Map.Entry<Integer, Integer> entry : CEF_2_JAVA_MODIFIERS.entrySet()) {
            if ((cefKeyEvent.modifiers & entry.getKey()) == 0) continue;
            javaModifiers |= entry.getValue().intValue();
        }
        return javaModifiers;
    }

    public static boolean isUpDownKeyEvent(CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
        return cefKeyEvent.windows_key_code == 38 || cefKeyEvent.windows_key_code == 40;
    }

    static {
        CEF_2_JAVA_KEYCODES.put(13, 10);
        CEF_2_JAVA_KEYCODES.put(8, 8);
        CEF_2_JAVA_KEYCODES.put(9, 9);
        CEF_2_JAVA_MODIFIERS.put(4, 128);
        CEF_2_JAVA_MODIFIERS.put(2, 64);
        CEF_2_JAVA_MODIFIERS.put(8, 512);
        CEF_2_JAVA_MODIFIERS.put(16, 1024);
        CEF_2_JAVA_MODIFIERS.put(32, 2048);
        CEF_2_JAVA_MODIFIERS.put(64, 4096);
    }
}

